/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.actions.TextComponentEditorAction;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIntHashMap;
import org.jetbrains.annotations.NotNull;

public class DeleteToWordStartAction
extends TextComponentEditorAction {
    private static final TIntHashSet QUOTE_SYMBOLS = new TIntHashSet();
    private static final int[] QUOTE_SYMBOLS_ARRAY;

    public DeleteToWordStartAction() {
        super((EditorActionHandler)new Handler(false));
    }

    private static void countQuotes(@NotNull TIntIntHashMap holder, @NotNull CharSequence text2, int start2, int end) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/openapi/editor/actions/DeleteToWordStartAction", "countQuotes"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/actions/DeleteToWordStartAction", "countQuotes"));
        }
        for (int i2 = end - 1; i2 >= start2; --i2) {
            char c2 = text2.charAt(i2);
            if (!holder.containsKey((int)c2)) continue;
            holder.put((int)c2, holder.get((int)c2) + 1);
        }
    }

    static {
        QUOTE_SYMBOLS.add(39);
        QUOTE_SYMBOLS.add(34);
        QUOTE_SYMBOLS_ARRAY = QUOTE_SYMBOLS.toArray();
    }

    static class Handler
    extends EditorWriteActionHandler {
        @NotNull
        private final TIntIntHashMap myQuotesNumber = new TIntIntHashMap();
        private final boolean myNegateCamelMode;

        Handler(boolean negateCamelMode) {
            super(true);
            this.myNegateCamelMode = negateCamelMode;
        }

        public void executeWriteAction(Editor editor, Caret caret, DataContext dataContext) {
            CommandProcessor.getInstance().setCurrentCommandGroupId(EditorActionUtil.DELETE_COMMAND_GROUP);
            if (editor.getSelectionModel().hasSelection()) {
                EditorModificationUtil.deleteSelectedText((Editor)editor);
                return;
            }
            this.deleteToWordStart(editor);
        }

        private void deleteToWordStart(Editor editor) {
            boolean camel = editor.getSettings().isCamelWords();
            if (this.myNegateCamelMode) {
                camel = !camel;
            }
            CharSequence text2 = editor.getDocument().getCharsSequence();
            CaretModel caretModel = editor.getCaretModel();
            int endOffset = caretModel.getOffset();
            int minOffset = editor.getDocument().getLineStartOffset(caretModel.getLogicalPosition().line);
            this.myQuotesNumber.clear();
            for (int i2 : QUOTE_SYMBOLS_ARRAY) {
                this.myQuotesNumber.put(i2, 0);
            }
            DeleteToWordStartAction.countQuotes(this.myQuotesNumber, text2, minOffset, endOffset);
            EditorActionUtil.moveCaretToPreviousWord(editor, false, camel);
            int offset = caretModel.getOffset();
            while (offset > minOffset) {
                char previous = text2.charAt(offset - 1);
                char current = text2.charAt(offset);
                if (QUOTE_SYMBOLS.contains((int)current)) {
                    if (Character.isWhitespace(previous)) break;
                    if (offset < endOffset - 1 && !Character.isJavaIdentifierPart(text2.charAt(offset + 1))) {
                        editor.getCaretModel().moveToOffset(offset + 1);
                        break;
                    }
                    if (this.myQuotesNumber.get((int)current) % 2 != 0) break;
                } else {
                    if (!QUOTE_SYMBOLS.contains((int)previous) || this.myQuotesNumber.get((int)previous) % 2 != 0) break;
                    editor.getCaretModel().moveToOffset(offset - 1);
                    break;
                }
                EditorActionUtil.moveCaretToPreviousWord(editor, false, camel);
                offset = caretModel.getOffset();
            }
            int startOffset = caretModel.getOffset();
            Document document = editor.getDocument();
            document.deleteString(startOffset, endOffset);
        }
    }
}

