/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.ide.KillRingTransferable;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.datatransfer.Transferable;
import org.jetbrains.annotations.NotNull;

public class KillRingUtil {
    private KillRingUtil() {
    }

    public static void cut(@NotNull Editor editor, int start2, int end) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/KillRingUtil", "cut"));
        }
        KillRingUtil.copyToKillRing(editor, start2, end, true);
        editor.getDocument().deleteString(start2, end);
    }

    public static void copyToKillRing(@NotNull Editor editor, int startOffset, int endOffset, boolean cut) {
        EditorEx ex;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/KillRingUtil", "copyToKillRing"));
        }
        Document document = editor.getDocument();
        String s2 = document.getCharsSequence().subSequence(startOffset, endOffset).toString();
        s2 = StringUtil.convertLineSeparators((String)s2);
        CopyPasteManager.getInstance().setContents((Transferable)new KillRingTransferable(s2, document, startOffset, endOffset, cut));
        if (editor instanceof EditorEx && (ex = (EditorEx)editor).isStickySelection()) {
            ex.setStickySelection(false);
        }
    }
}

