/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.DumbAware;
import java.util.List;

public class ToggleColumnModeAction
extends ToggleAction
implements DumbAware {
    public ToggleColumnModeAction() {
        this.setEnabledInModalContext(true);
    }

    public void setSelected(AnActionEvent e2, boolean state) {
        EditorEx editor = ToggleColumnModeAction.getEditor(e2);
        SelectionModel selectionModel = editor.getSelectionModel();
        CaretModel caretModel = editor.getCaretModel();
        if (state) {
            LogicalPosition blockEnd;
            LogicalPosition blockStart;
            caretModel.removeSecondaryCarets();
            boolean hasSelection = selectionModel.hasSelection();
            int selStart = selectionModel.getSelectionStart();
            int selEnd = selectionModel.getSelectionEnd();
            if (caretModel.supportsMultipleCarets()) {
                LogicalPosition logicalSelStart = editor.offsetToLogicalPosition(selStart);
                LogicalPosition logicalSelEnd = editor.offsetToLogicalPosition(selEnd);
                int caretOffset = caretModel.getOffset();
                blockStart = selStart == caretOffset ? logicalSelEnd : logicalSelStart;
                blockEnd = selStart == caretOffset ? logicalSelStart : logicalSelEnd;
            } else {
                blockStart = selStart == caretModel.getOffset() ? caretModel.getLogicalPosition() : editor.offsetToLogicalPosition(selStart);
                blockEnd = selEnd == caretModel.getOffset() ? caretModel.getLogicalPosition() : editor.offsetToLogicalPosition(selEnd);
            }
            editor.setColumnMode(true);
            if (hasSelection) {
                selectionModel.setBlockSelection(blockStart, blockEnd);
            } else {
                selectionModel.removeSelection();
            }
        } else {
            boolean hasSelection = false;
            int selStart = 0;
            int selEnd = 0;
            if (caretModel.supportsMultipleCarets()) {
                hasSelection = true;
                List allCarets = caretModel.getAllCarets();
                Caret fromCaret = (Caret)allCarets.get(0);
                Caret toCaret = (Caret)allCarets.get(allCarets.size() - 1);
                if (fromCaret == caretModel.getPrimaryCaret()) {
                    Caret tmp = fromCaret;
                    fromCaret = toCaret;
                    toCaret = tmp;
                }
                selStart = fromCaret.getLeadSelectionOffset();
                selEnd = toCaret.getSelectionStart() == toCaret.getLeadSelectionOffset() ? toCaret.getSelectionEnd() : toCaret.getSelectionStart();
            }
            editor.setColumnMode(false);
            caretModel.removeSecondaryCarets();
            if (hasSelection) {
                selectionModel.setSelection(selStart, selEnd);
            } else {
                selectionModel.removeSelection();
            }
        }
    }

    public boolean isSelected(AnActionEvent e2) {
        EditorEx ex = ToggleColumnModeAction.getEditor(e2);
        return ex != null && ex.isColumnMode();
    }

    private static EditorEx getEditor(AnActionEvent e2) {
        return (EditorEx)CommonDataKeys.EDITOR.getData(e2.getDataContext());
    }

    public void update(AnActionEvent e2) {
        EditorEx editor = ToggleColumnModeAction.getEditor(e2);
        if (editor == null || editor.isOneLineMode()) {
            e2.getPresentation().setEnabled(false);
            e2.getPresentation().setVisible(false);
        } else {
            e2.getPresentation().setEnabled(true);
            e2.getPresentation().setVisible(true);
            super.update(e2);
        }
    }
}

