/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToggleShowImportPopupsAction
extends ToggleAction {
    public boolean isSelected(AnActionEvent e2) {
        PsiFile file2 = ToggleShowImportPopupsAction.getFile(e2);
        return file2 != null && DaemonCodeAnalyzer.getInstance((Project)file2.getProject()).isImportHintsEnabled(file2);
    }

    public void setSelected(AnActionEvent e2, boolean state) {
        PsiFile file2 = ToggleShowImportPopupsAction.getFile(e2);
        if (file2 != null) {
            DaemonCodeAnalyzer.getInstance((Project)file2.getProject()).setImportHintsEnabled(file2, state);
        }
    }

    public void update(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/actions/ToggleShowImportPopupsAction", "update"));
        }
        boolean works = ToggleShowImportPopupsAction.getFile(e2) != null;
        e2.getPresentation().setEnabled(works);
        e2.getPresentation().setVisible(works);
        super.update(e2);
    }

    @Nullable
    private static PsiFile getFile(AnActionEvent e2) {
        Editor editor = (Editor)e2.getData(CommonDataKeys.EDITOR);
        return editor == null ? null : (PsiFile)e2.getData(CommonDataKeys.PSI_FILE);
    }
}

