/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.impl;

import com.intellij.application.options.EditorFontsConstants;
import com.intellij.configurationStore.SerializableScheme;
import com.intellij.ide.ui.ColorBlindness;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.ex.DefaultColorSchemesManager;
import com.intellij.openapi.editor.colors.impl.DefaultColorsScheme;
import com.intellij.openapi.editor.colors.impl.EditorColorsSchemeImpl;
import com.intellij.openapi.editor.colors.impl.EmptyColorScheme;
import com.intellij.openapi.editor.colors.impl.ReadOnlyColorsScheme;
import com.intellij.openapi.editor.colors.impl.TextAttributesReader;
import com.intellij.openapi.editor.colors.impl.ValueElementReader;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.options.FontSize;
import com.intellij.openapi.options.SchemeState;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.ui.ColorUtil;
import com.intellij.util.JdomKt;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.HashMap;
import gnu.trove.THashMap;
import java.awt.Color;
import java.awt.Font;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractColorsScheme
implements EditorColorsScheme,
SerializableScheme {
    private static final int CURR_VERSION = 142;
    private static final FontSize DEFAULT_FONT_SIZE = FontSize.SMALL;
    protected EditorColorsScheme myParentScheme;
    protected FontSize myQuickDocFontSize = DEFAULT_FONT_SIZE;
    protected float myLineSpacing;
    @NotNull
    private final Map<EditorFontType, Font> myFonts = new EnumMap<EditorFontType, Font>(EditorFontType.class);
    @NotNull
    private final FontPreferences myFontPreferences = new FontPreferences();
    @NotNull
    private final FontPreferences myConsoleFontPreferences = new FontPreferences();
    private final ValueElementReader myValueReader = new TextAttributesReader();
    private String myFallbackFontName;
    private String mySchemeName;
    private float myConsoleLineSpacing = -1.0f;
    private boolean myIsSaveNeeded;
    private boolean myCanBeDeleted = true;
    private int myVersion = 142;
    protected Map<ColorKey, Color> myColorsMap = ContainerUtilRt.newHashMap();
    protected Map<TextAttributesKey, TextAttributes> myAttributesMap = new THashMap();
    @NonNls
    private static final String EDITOR_FONT = "font";
    @NonNls
    private static final String CONSOLE_FONT = "console-font";
    @NonNls
    private static final String EDITOR_FONT_NAME = "EDITOR_FONT_NAME";
    @NonNls
    private static final String CONSOLE_FONT_NAME = "CONSOLE_FONT_NAME";
    private Color myDeprecatedBackgroundColor = null;
    @NonNls
    private static final String SCHEME_ELEMENT = "scheme";
    @NonNls
    public static final String NAME_ATTR = "name";
    @NonNls
    private static final String VERSION_ATTR = "version";
    @NonNls
    private static final String BASE_ATTRIBUTES_ATTR = "baseAttributes";
    @NonNls
    private static final String DEFAULT_SCHEME_ATTR = "default_scheme";
    @NonNls
    private static final String PARENT_SCHEME_ATTR = "parent_scheme";
    @NonNls
    private static final String OPTION_ELEMENT = "option";
    @NonNls
    private static final String COLORS_ELEMENT = "colors";
    @NonNls
    private static final String ATTRIBUTES_ELEMENT = "attributes";
    @NonNls
    private static final String VALUE_ELEMENT = "value";
    @NonNls
    private static final String BACKGROUND_COLOR_NAME = "BACKGROUND";
    @NonNls
    private static final String LINE_SPACING = "LINE_SPACING";
    @NonNls
    private static final String CONSOLE_LINE_SPACING = "CONSOLE_LINE_SPACING";
    @NonNls
    private static final String FONT_SCALE = "FONT_SCALE";
    @NonNls
    private static final String EDITOR_FONT_SIZE = "EDITOR_FONT_SIZE";
    @NonNls
    private static final String CONSOLE_FONT_SIZE = "CONSOLE_FONT_SIZE";
    @NonNls
    private static final String EDITOR_LIGATURES = "EDITOR_LIGATURES";
    @NonNls
    private static final String CONSOLE_LIGATURES = "CONSOLE_LIGATURES";
    @NonNls
    private static final String EDITOR_QUICK_JAVADOC_FONT_SIZE = "EDITOR_QUICK_DOC_FONT_SIZE";
    private final Properties myMetaInfo = new Properties();
    private static final SimpleDateFormat META_INFO_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    @NonNls
    private static final String META_INFO_ELEMENT = "metaInfo";
    @NonNls
    private static final String PROPERTY_ELEMENT = "property";
    @NonNls
    private static final String PROPERTY_NAME_ATTR = "name";
    @NonNls
    private static final String META_INFO_CREATION_TIME = "created";
    @NonNls
    private static final String META_INFO_MODIFIED_TIME = "modified";
    @NonNls
    private static final String META_INFO_IDE = "ide";
    @NonNls
    private static final String META_INFO_IDE_VERSION = "ideVersion";
    @NonNls
    private static final String META_INFO_ORIGINAL = "originalScheme";
    private static final Map<String, Couple<Color>> DEFAULT_STRIPE_COLORS = new THashMap<String, Couple<Color>>(){
        {
            this.put(CodeInsightColors.ERRORS_ATTRIBUTES.getExternalName(), Couple.of((Object)Color.red, (Object)ColorUtil.fromHex((String)"CF5B56")));
            this.put(CodeInsightColors.WARNINGS_ATTRIBUTES.getExternalName(), Couple.of((Object)Color.yellow, (Object)ColorUtil.fromHex((String)"EBC700")));
            this.put("EXECUTIONPOINT_ATTRIBUTES", Couple.of((Object)Color.blue, (Object)ColorUtil.fromHex((String)"3763b0")));
            this.put(EditorColors.IDENTIFIER_UNDER_CARET_ATTRIBUTES.getExternalName(), Couple.of((Object)ColorUtil.fromHex((String)"CCCFFF"), (Object)ColorUtil.fromHex((String)"BAA8FF")));
            this.put(EditorColors.WRITE_IDENTIFIER_UNDER_CARET_ATTRIBUTES.getExternalName(), Couple.of((Object)ColorUtil.fromHex((String)"FFCCE5"), (Object)ColorUtil.fromHex((String)"F0ADF0")));
            this.put(EditorColors.TEXT_SEARCH_RESULT_ATTRIBUTES.getExternalName(), Couple.of((Object)ColorUtil.fromHex((String)"586E75"), (Object)ColorUtil.fromHex((String)"71B362")));
            this.put(CodeInsightColors.TODO_DEFAULT_ATTRIBUTES.getExternalName(), Couple.of((Object)ColorUtil.fromHex((String)"268BD2"), (Object)ColorUtil.fromHex((String)"54AAE3")));
        }
    };

    protected AbstractColorsScheme(EditorColorsScheme parentScheme) {
        this.myParentScheme = parentScheme;
        this.myFontPreferences.setChangeListener(() -> this.initFonts());
    }

    public AbstractColorsScheme() {
    }

    public void setDefaultMetaInfo(@Nullable AbstractColorsScheme parentScheme) {
        this.myMetaInfo.setProperty(META_INFO_CREATION_TIME, META_INFO_DATE_FORMAT.format(new Date()));
        this.myMetaInfo.setProperty(META_INFO_IDE, PlatformUtils.getPlatformPrefix());
        this.myMetaInfo.setProperty(META_INFO_IDE_VERSION, ApplicationInfoEx.getInstanceEx().getStrictVersion());
        if (parentScheme != null && parentScheme != EmptyColorScheme.INSTANCE) {
            this.myMetaInfo.setProperty(META_INFO_ORIGINAL, parentScheme.getName());
        }
    }

    @NotNull
    public Color getDefaultBackground() {
        Color c2 = this.getAttributes(HighlighterColors.TEXT).getBackgroundColor();
        Color color = c2 != null ? c2 : Color.white;
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "getDefaultBackground"));
        }
        return color;
    }

    @NotNull
    public Color getDefaultForeground() {
        Color c2 = this.getAttributes(HighlighterColors.TEXT).getForegroundColor();
        Color color = c2 != null ? c2 : Color.black;
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "getDefaultForeground"));
        }
        return color;
    }

    @NotNull
    public String getName() {
        String string2 = this.mySchemeName;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "getName"));
        }
        return string2;
    }

    public void setFont(EditorFontType key, Font font) {
        this.myFonts.put(key, font);
    }

    public abstract Object clone();

    public void copyTo(AbstractColorsScheme newScheme) {
        this.myFontPreferences.copyTo(newScheme.myFontPreferences);
        newScheme.myLineSpacing = this.myLineSpacing;
        newScheme.myQuickDocFontSize = this.myQuickDocFontSize;
        this.myConsoleFontPreferences.copyTo(newScheme.myConsoleFontPreferences);
        newScheme.myConsoleLineSpacing = this.myConsoleLineSpacing;
        Set<EditorFontType> types = this.myFonts.keySet();
        for (EditorFontType type : types) {
            Font font = this.myFonts.get(type);
            newScheme.setFont(type, font);
        }
        newScheme.myAttributesMap = new THashMap(this.myAttributesMap);
        newScheme.myColorsMap = new HashMap(this.myColorsMap);
        newScheme.myVersion = this.myVersion;
    }

    public void setEditorFontName(String fontName) {
        int editorFontSize = this.getEditorFontSize();
        this.myFontPreferences.clear();
        this.myFontPreferences.register(fontName, editorFontSize);
        this.initFonts();
    }

    public void setEditorFontSize(int fontSize) {
        fontSize = EditorFontsConstants.checkAndFixEditorFontSize(fontSize);
        this.myFontPreferences.register(this.getEditorFontName(), fontSize);
        this.initFonts();
    }

    public void setQuickDocFontSize(@NotNull FontSize fontSize) {
        if (fontSize == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontSize", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "setQuickDocFontSize"));
        }
        if (this.myQuickDocFontSize != fontSize) {
            this.myQuickDocFontSize = fontSize;
            this.myIsSaveNeeded = true;
        }
    }

    public void setLineSpacing(float lineSpacing) {
        this.myLineSpacing = EditorFontsConstants.checkAndFixEditorLineSpacing(lineSpacing);
    }

    public Font getFont(EditorFontType key) {
        UISettings uiSettings = UISettings.getInstance();
        if (uiSettings.getPresentationMode()) {
            Font font = this.myFonts.get(key);
            return new Font(font.getName(), font.getStyle(), uiSettings.getPresentationModeFontSize());
        }
        return this.myFonts.get(key);
    }

    public void setName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "setName"));
        }
        this.mySchemeName = name;
    }

    @NotNull
    public FontPreferences getFontPreferences() {
        FontPreferences fontPreferences = this.myFontPreferences;
        if (fontPreferences == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "getFontPreferences"));
        }
        return fontPreferences;
    }

    public void setFontPreferences(@NotNull FontPreferences preferences) {
        if (preferences == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preferences", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "setFontPreferences"));
        }
        preferences.copyTo(this.myFontPreferences);
        this.initFonts();
    }

    public String getEditorFontName() {
        if (this.myFallbackFontName != null) {
            return this.myFallbackFontName;
        }
        return this.myFontPreferences.getFontFamily();
    }

    public int getEditorFontSize() {
        return this.myFontPreferences.getSize(this.getEditorFontName());
    }

    @NotNull
    public FontSize getQuickDocFontSize() {
        FontSize fontSize = this.myQuickDocFontSize;
        if (fontSize == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "getQuickDocFontSize"));
        }
        return fontSize;
    }

    public float getLineSpacing() {
        float spacing = this.myLineSpacing;
        return spacing <= 0.0f ? 1.0f : spacing;
    }

    protected void initFonts() {
        String editorFontName = this.getEditorFontName();
        int editorFontSize = this.getEditorFontSize();
        this.myFallbackFontName = FontPreferences.getFallbackName((String)editorFontName, (int)editorFontSize, (EditorColorsScheme)this.myParentScheme);
        if (this.myFallbackFontName != null) {
            editorFontName = this.myFallbackFontName;
        }
        Font plainFont = new Font(editorFontName, 0, editorFontSize);
        Font boldFont2 = new Font(editorFontName, 1, editorFontSize);
        Font italicFont = new Font(editorFontName, 2, editorFontSize);
        Font boldItalicFont = new Font(editorFontName, 3, editorFontSize);
        this.myFonts.put(EditorFontType.PLAIN, plainFont);
        this.myFonts.put(EditorFontType.BOLD, boldFont2);
        this.myFonts.put(EditorFontType.ITALIC, italicFont);
        this.myFonts.put(EditorFontType.BOLD_ITALIC, boldItalicFont);
        String consoleFontName = this.getConsoleFontName();
        int consoleFontSize = this.getConsoleFontSize();
        Font consolePlainFont = new Font(consoleFontName, 0, consoleFontSize);
        Font consoleBoldFont = new Font(consoleFontName, 1, consoleFontSize);
        Font consoleItalicFont = new Font(consoleFontName, 2, consoleFontSize);
        Font consoleBoldItalicFont = new Font(consoleFontName, 3, consoleFontSize);
        this.myFonts.put(EditorFontType.CONSOLE_PLAIN, consolePlainFont);
        this.myFonts.put(EditorFontType.CONSOLE_BOLD, consoleBoldFont);
        this.myFonts.put(EditorFontType.CONSOLE_ITALIC, consoleItalicFont);
        this.myFonts.put(EditorFontType.CONSOLE_BOLD_ITALIC, consoleBoldItalicFont);
    }

    public String toString() {
        return this.getName();
    }

    public void readExternal(@NotNull Element parentNode) {
        if (parentNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentNode", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "readExternal"));
        }
        UISettings settings = UISettings.getInstanceOrNull();
        ColorBlindness blindness = settings == null ? null : settings.getColorBlindness();
        this.myValueReader.setAttribute(blindness == null ? null : blindness.name());
        if (SCHEME_ELEMENT.equals(parentNode.getName())) {
            this.readScheme(parentNode);
        } else {
            List children2 = parentNode.getChildren(SCHEME_ELEMENT);
            if (children2.isEmpty()) {
                throw new InvalidDataException("Scheme is not valid");
            }
            for (Element element : children2) {
                this.readScheme(element);
            }
        }
        this.initFonts();
        this.myVersion = 142;
    }

    private void readScheme(Element node) {
        boolean isDefault;
        this.myDeprecatedBackgroundColor = null;
        if (!SCHEME_ELEMENT.equals(node.getName())) {
            return;
        }
        this.setName(node.getAttributeValue("name"));
        int readVersion = Integer.parseInt(node.getAttributeValue(VERSION_ATTR, "0"));
        if (readVersion > 142) {
            throw new IllegalStateException("Unsupported color scheme version: " + readVersion);
        }
        this.myVersion = readVersion;
        String isDefaultScheme = node.getAttributeValue(DEFAULT_SCHEME_ATTR);
        boolean bl = isDefault = isDefaultScheme != null && Boolean.parseBoolean(isDefaultScheme);
        if (!isDefault) {
            this.myParentScheme = AbstractColorsScheme.getDefaultScheme(node.getAttributeValue(PARENT_SCHEME_ATTR, "Empty"));
        }
        this.myMetaInfo.clear();
        Ref fontScale = Ref.create();
        for (Element childNode : node.getChildren()) {
            String childName;
            switch (childName = childNode.getName()) {
                case "option": {
                    this.readSettings(childNode, isDefault, (Ref<Float>)fontScale);
                    break;
                }
                case "font": {
                    this.readFontSettings(childNode, this.myFontPreferences, isDefault, (Float)fontScale.get());
                    break;
                }
                case "console-font": {
                    this.readFontSettings(childNode, this.myConsoleFontPreferences, isDefault, (Float)fontScale.get());
                    break;
                }
                case "colors": {
                    this.readColors(childNode);
                    break;
                }
                case "attributes": {
                    this.readAttributes(childNode);
                    break;
                }
                case "metaInfo": {
                    this.readMetaInfo(childNode);
                }
            }
        }
        if (this.myDeprecatedBackgroundColor != null) {
            TextAttributes textAttributes = this.myAttributesMap.get(HighlighterColors.TEXT);
            if (textAttributes == null) {
                textAttributes = new TextAttributes(Color.black, this.myDeprecatedBackgroundColor, null, EffectType.BOXED, 0);
                this.myAttributesMap.put(HighlighterColors.TEXT, textAttributes);
            } else {
                textAttributes.setBackgroundColor(this.myDeprecatedBackgroundColor);
            }
        }
        if (this.myConsoleFontPreferences.getEffectiveFontFamilies().isEmpty()) {
            this.myFontPreferences.copyTo(this.myConsoleFontPreferences);
        }
        this.initFonts();
    }

    @NotNull
    private static EditorColorsScheme getDefaultScheme(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "getDefaultScheme"));
        }
        DefaultColorSchemesManager manager = DefaultColorSchemesManager.getInstance();
        EditorColorsScheme defaultScheme = manager.getScheme(name);
        if (defaultScheme == null) {
            defaultScheme = new TemporaryParent(name);
        }
        EditorColorsScheme editorColorsScheme = defaultScheme;
        if (editorColorsScheme == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "getDefaultScheme"));
        }
        return editorColorsScheme;
    }

    private void readMetaInfo(@NotNull Element metaInfoElement) {
        if (metaInfoElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metaInfoElement", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "readMetaInfo"));
        }
        this.myMetaInfo.clear();
        for (Element e2 : metaInfoElement.getChildren()) {
            String propertyName;
            if (!PROPERTY_ELEMENT.equals(e2.getName()) || (propertyName = e2.getAttributeValue("name")) == null) continue;
            this.myMetaInfo.setProperty(propertyName, e2.getText());
        }
    }

    public void readAttributes(@NotNull Element childNode) {
        if (childNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childNode", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "readAttributes"));
        }
        for (Element e2 : childNode.getChildren(OPTION_ELEMENT)) {
            Element valueElement = e2.getChild(VALUE_ELEMENT);
            TextAttributesKey key = TextAttributesKey.find((String)e2.getAttributeValue("name"));
            if (valueElement == null) {
                String baseAttributes = e2.getAttributeValue(BASE_ATTRIBUTES_ATTR);
                if (baseAttributes == null) continue;
                if (key.getFallbackAttributeKey() == null) {
                    TextAttributesKey fallbackAttributeKey = TextAttributesKey.find((String)baseAttributes);
                    key.setFallbackAttributeKey(fallbackAttributeKey);
                }
                this.myAttributesMap.put(key, TextAttributes.USE_INHERITED_MARKER);
                continue;
            }
            TextAttributes attr = this.myValueReader.read(TextAttributes.class, valueElement);
            this.myAttributesMap.put(key, attr);
            this.migrateErrorStripeColorFrom14(key, attr);
        }
    }

    private void migrateErrorStripeColorFrom14(@NotNull TextAttributesKey name, @NotNull TextAttributes attr) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "migrateErrorStripeColorFrom14"));
        }
        if (attr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attr", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "migrateErrorStripeColorFrom14"));
        }
        if (this.myVersion >= 141 || this.myParentScheme == null) {
            return;
        }
        Couple<Color> m2 = DEFAULT_STRIPE_COLORS.get(name.getExternalName());
        if (m2 != null && Comparing.equal((Object)m2.first, (Object)attr.getErrorStripeColor())) {
            attr.setErrorStripeColor((Color)m2.second);
        }
    }

    private void readColors(Element childNode) {
        for (Element colorElement : childNode.getChildren(OPTION_ELEMENT)) {
            Color valueColor = this.myValueReader.read(Color.class, colorElement);
            String colorName = colorElement.getAttributeValue("name");
            if (BACKGROUND_COLOR_NAME.equals(colorName)) {
                this.myDeprecatedBackgroundColor = valueColor;
            }
            ColorKey name = ColorKey.find((String)colorName);
            this.myColorsMap.put(name, valueColor);
        }
    }

    private void readSettings(@NotNull Element childNode, boolean isDefault, @NotNull Ref<Float> fontScale) {
        if (childNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childNode", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "readSettings"));
        }
        if (fontScale == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontScale", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "readSettings"));
        }
        switch (childNode.getAttributeValue("name")) {
            case "FONT_SCALE": {
                fontScale.set((Object)this.myValueReader.read(Float.class, childNode));
                break;
            }
            case "LINE_SPACING": {
                Float value2 = this.myValueReader.read(Float.class, childNode);
                if (value2 == null) break;
                this.myLineSpacing = value2.floatValue();
                break;
            }
            case "EDITOR_FONT_SIZE": {
                int value3 = this.readFontSize(childNode, isDefault, (Float)fontScale.get());
                if (value3 <= 0) break;
                this.setEditorFontSize(value3);
                break;
            }
            case "EDITOR_FONT_NAME": {
                String value4 = this.myValueReader.read(String.class, childNode);
                if (value4 == null) break;
                this.setEditorFontName(value4);
                break;
            }
            case "CONSOLE_LINE_SPACING": {
                Float value5 = this.myValueReader.read(Float.class, childNode);
                if (value5 == null) break;
                this.setConsoleLineSpacing(value5.floatValue());
                break;
            }
            case "CONSOLE_FONT_SIZE": {
                int value6 = this.readFontSize(childNode, isDefault, (Float)fontScale.get());
                if (value6 <= 0) break;
                this.setConsoleFontSize(value6);
                break;
            }
            case "CONSOLE_FONT_NAME": {
                String value7 = this.myValueReader.read(String.class, childNode);
                if (value7 == null) break;
                this.setConsoleFontName(value7);
                break;
            }
            case "EDITOR_QUICK_DOC_FONT_SIZE": {
                FontSize value8 = this.myValueReader.read(FontSize.class, childNode);
                if (value8 == null) break;
                this.myQuickDocFontSize = value8;
                break;
            }
            case "EDITOR_LIGATURES": {
                Boolean value9 = this.myValueReader.read(Boolean.class, childNode);
                if (value9 == null) break;
                this.myFontPreferences.setUseLigatures(value9.booleanValue());
                break;
            }
            case "CONSOLE_LIGATURES": {
                Boolean value10 = this.myValueReader.read(Boolean.class, childNode);
                if (value10 == null) break;
                this.myConsoleFontPreferences.setUseLigatures(value10.booleanValue());
                break;
            }
        }
    }

    private int readFontSize(Element element, boolean isDefault, Float fontScale) {
        if (isDefault) {
            return (int)(UISettings.getNormalizingScale() * (float)DEFAULT_FONT_SIZE.getSize());
        }
        Integer intSize = this.myValueReader.read(Integer.class, element);
        if (intSize == null) {
            return -1;
        }
        return UISettings.restoreFontSize((int)intSize, (Float)fontScale);
    }

    private void readFontSettings(@NotNull Element element, @NotNull FontPreferences preferences, boolean isDefaultScheme, @Nullable Float fontScale) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "readFontSettings"));
        }
        if (preferences == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preferences", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "readFontSettings"));
        }
        List children2 = element.getChildren(OPTION_ELEMENT);
        String fontFamily = null;
        int size = -1;
        for (Object child : children2) {
            Element e2 = (Element)child;
            if (EDITOR_FONT_NAME.equals(e2.getAttributeValue("name"))) {
                fontFamily = this.myValueReader.read(String.class, e2);
                continue;
            }
            if (!EDITOR_FONT_SIZE.equals(e2.getAttributeValue("name"))) continue;
            size = this.readFontSize(e2, isDefaultScheme, fontScale);
        }
        if (fontFamily != null && size > 1) {
            preferences.register(fontFamily, size);
        } else if (fontFamily != null) {
            preferences.addFontFamily(fontFamily);
        }
    }

    public void writeExternal(Element parentNode) {
        boolean useOldFontFormat;
        parentNode.setAttribute("name", this.getName());
        parentNode.setAttribute(VERSION_ATTR, Integer.toString(this.myVersion));
        JdomKt.addOptionTag((Element)parentNode, (String)FONT_SCALE, (String)String.valueOf(UISettings.getNormalizingScale()));
        if (this.myParentScheme != null && this.myParentScheme != EmptyColorScheme.INSTANCE) {
            parentNode.setAttribute(PARENT_SCHEME_ATTR, this.myParentScheme.getName());
        }
        if (!this.myMetaInfo.isEmpty()) {
            parentNode.addContent(this.metaInfoToElement());
        }
        if (this.getLineSpacing() != 1.0f) {
            JdomKt.addOptionTag((Element)parentNode, (String)LINE_SPACING, (String)String.valueOf(this.getLineSpacing()));
        }
        boolean bl = useOldFontFormat = this.myFontPreferences.getEffectiveFontFamilies().size() <= 1;
        if (useOldFontFormat) {
            JdomKt.addOptionTag((Element)parentNode, (String)EDITOR_FONT_SIZE, (String)String.valueOf(this.getEditorFontSize()));
        } else {
            AbstractColorsScheme.writeFontPreferences(EDITOR_FONT, parentNode, this.myFontPreferences);
        }
        AbstractColorsScheme.writeLigaturesPreferences(parentNode, this.myFontPreferences, EDITOR_LIGATURES);
        if (!this.myFontPreferences.equals((Object)this.myConsoleFontPreferences)) {
            if (this.myConsoleFontPreferences.getEffectiveFontFamilies().size() <= 1) {
                JdomKt.addOptionTag((Element)parentNode, (String)CONSOLE_FONT_NAME, (String)this.getConsoleFontName());
                if (this.getConsoleFontSize() != this.getEditorFontSize()) {
                    JdomKt.addOptionTag((Element)parentNode, (String)CONSOLE_FONT_SIZE, (String)Integer.toString(this.getConsoleFontSize()));
                }
            } else {
                AbstractColorsScheme.writeFontPreferences(CONSOLE_FONT, parentNode, this.myConsoleFontPreferences);
            }
            AbstractColorsScheme.writeLigaturesPreferences(parentNode, this.myConsoleFontPreferences, CONSOLE_LIGATURES);
        }
        if (this.getConsoleLineSpacing() != this.getLineSpacing()) {
            JdomKt.addOptionTag((Element)parentNode, (String)CONSOLE_LINE_SPACING, (String)Float.toString(this.getConsoleLineSpacing()));
        }
        if (DEFAULT_FONT_SIZE != this.getQuickDocFontSize()) {
            JdomKt.addOptionTag((Element)parentNode, (String)EDITOR_QUICK_JAVADOC_FONT_SIZE, (String)this.getQuickDocFontSize().toString());
        }
        if (useOldFontFormat) {
            JdomKt.addOptionTag((Element)parentNode, (String)EDITOR_FONT_NAME, (String)this.getEditorFontName());
        }
        Element colorElements = new Element(COLORS_ELEMENT);
        Element attrElements = new Element(ATTRIBUTES_ELEMENT);
        this.writeColors(colorElements);
        this.writeAttributes(attrElements);
        if (!colorElements.getChildren().isEmpty()) {
            parentNode.addContent(colorElements);
        }
        if (!attrElements.getChildren().isEmpty()) {
            parentNode.addContent(attrElements);
        }
        this.myIsSaveNeeded = false;
    }

    private static void writeLigaturesPreferences(Element parentNode, FontPreferences preferences, String optionName) {
        if (preferences.useLigatures()) {
            JdomKt.addOptionTag((Element)parentNode, (String)optionName, (String)String.valueOf(true));
        }
    }

    private static void writeFontPreferences(@NotNull String key, @NotNull Element parent, @NotNull FontPreferences preferences) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "writeFontPreferences"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "writeFontPreferences"));
        }
        if (preferences == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preferences", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "writeFontPreferences"));
        }
        for (String fontFamily : preferences.getRealFontFamilies()) {
            Element element = new Element(key);
            JdomKt.addOptionTag((Element)element, (String)EDITOR_FONT_NAME, (String)fontFamily);
            JdomKt.addOptionTag((Element)element, (String)EDITOR_FONT_SIZE, (String)String.valueOf(preferences.getSize(fontFamily)));
            parent.addContent(element);
        }
    }

    private boolean isParentOverwritingInheritance(@NotNull TextAttributesKey key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "isParentOverwritingInheritance"));
        }
        TextAttributes parentAttributes = this.myParentScheme instanceof AbstractColorsScheme ? ((AbstractColorsScheme)this.myParentScheme).getDirectlyDefinedAttributes(key) : null;
        return parentAttributes != null && parentAttributes != TextAttributes.USE_INHERITED_MARKER;
    }

    private void writeAttributes(@NotNull Element attrElements) throws WriteExternalException {
        if (attrElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrElements", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "writeAttributes"));
        }
        ArrayList<TextAttributesKey> list2 = new ArrayList<TextAttributesKey>(this.myAttributesMap.keySet());
        list2.sort(null);
        for (TextAttributesKey key : list2) {
            TextAttributes attributes = this.myAttributesMap.get(key);
            TextAttributesKey baseKey = key.getFallbackAttributeKey();
            if (attributes == TextAttributes.USE_INHERITED_MARKER) {
                if (baseKey == null || !this.isParentOverwritingInheritance(key)) continue;
                attrElements.addContent(new Element(OPTION_ELEMENT).setAttribute("name", key.getExternalName()).setAttribute(BASE_ATTRIBUTES_ATTR, baseKey.getExternalName()));
                continue;
            }
            if (this.myParentScheme != null) {
                TextAttributes parentAttributes;
                TextAttributes textAttributes = parentAttributes = this.myParentScheme instanceof AbstractColorsScheme ? ((AbstractColorsScheme)this.myParentScheme).getDirectlyDefinedAttributes(key) : this.myParentScheme.getAttributes(key);
                if (parentAttributes != null && attributes.equals((Object)parentAttributes)) continue;
            }
            Element valueElement = new Element(VALUE_ELEMENT);
            attributes.writeExternal(valueElement);
            attrElements.addContent(new Element(OPTION_ELEMENT).setAttribute("name", key.getExternalName()).addContent(valueElement));
        }
    }

    public void optimizeAttributeMap() {
        EditorColorsScheme parentScheme = this.myParentScheme;
        if (parentScheme == null) {
            return;
        }
        for (TextAttributesKey key : new ArrayList<TextAttributesKey>(this.myAttributesMap.keySet())) {
            TextAttributes attributes = this.myAttributesMap.get(key);
            if (attributes == TextAttributes.USE_INHERITED_MARKER) {
                if (key.getFallbackAttributeKey() != null) continue;
                this.myAttributesMap.remove(key);
                continue;
            }
            TextAttributes parentAttributes = parentScheme instanceof DefaultColorsScheme ? ((DefaultColorsScheme)parentScheme).getAttributes(key, false) : parentScheme.getAttributes(key);
            if (!Comparing.equal((Object)parentAttributes, (Object)attributes)) continue;
            this.myAttributesMap.remove(key);
        }
    }

    @NotNull
    private Element metaInfoToElement() {
        Element metaInfoElement = new Element(META_INFO_ELEMENT);
        this.myMetaInfo.setProperty(META_INFO_MODIFIED_TIME, META_INFO_DATE_FORMAT.format(new Date()));
        ArrayList<String> sortedPropertyNames = new ArrayList<String>(this.myMetaInfo.stringPropertyNames());
        sortedPropertyNames.sort(null);
        for (String propertyName : sortedPropertyNames) {
            String value2 = this.myMetaInfo.getProperty(propertyName);
            Element propertyInfo = new Element(PROPERTY_ELEMENT);
            propertyInfo.setAttribute("name", propertyName);
            propertyInfo.setText(value2);
            metaInfoElement.addContent(propertyInfo);
        }
        Element element = metaInfoElement;
        if (element == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "metaInfoToElement"));
        }
        return element;
    }

    protected Color getOwnColor(ColorKey key) {
        return this.myColorsMap.get(key);
    }

    private void writeColors(Element colorElements) {
        ArrayList<ColorKey> list2 = new ArrayList<ColorKey>(this.myColorsMap.keySet());
        list2.sort(null);
        for (ColorKey key : list2) {
            if (!this.haveToWrite(key)) continue;
            Color value2 = this.myColorsMap.get(key);
            String value1 = value2 == null ? "" : Integer.toString(value2.getRGB() & 0xFFFFFF, 16);
            JdomKt.addOptionTag((Element)colorElements, (String)key.getExternalName(), (String)value1);
        }
    }

    private boolean haveToWrite(@NotNull ColorKey key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "haveToWrite"));
        }
        Color value2 = this.myColorsMap.get(key);
        return this.myParentScheme == null || !(this.myParentScheme instanceof AbstractColorsScheme ? Comparing.equal((Object)((AbstractColorsScheme)this.myParentScheme).getOwnColor(key), (Object)value2) && ((AbstractColorsScheme)this.myParentScheme).myColorsMap.containsKey(key) : Comparing.equal((Object)this.myParentScheme.getColor(key), (Object)value2));
    }

    @NotNull
    public FontPreferences getConsoleFontPreferences() {
        FontPreferences fontPreferences = this.myConsoleFontPreferences;
        if (fontPreferences == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "getConsoleFontPreferences"));
        }
        return fontPreferences;
    }

    public void setConsoleFontPreferences(@NotNull FontPreferences preferences) {
        if (preferences == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preferences", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "setConsoleFontPreferences"));
        }
        preferences.copyTo(this.myConsoleFontPreferences);
        this.initFonts();
    }

    public String getConsoleFontName() {
        return this.myConsoleFontPreferences.getFontFamily();
    }

    public void setConsoleFontName(String fontName) {
        int consoleFontSize = this.getConsoleFontSize();
        this.myConsoleFontPreferences.clear();
        this.myConsoleFontPreferences.register(fontName, consoleFontSize);
    }

    public int getConsoleFontSize() {
        String font = this.getConsoleFontName();
        UISettings uiSettings = UISettings.getInstanceOrNull();
        if ((uiSettings == null || !uiSettings.getPresentationMode()) && this.myConsoleFontPreferences.hasSize(font)) {
            return this.myConsoleFontPreferences.getSize(font);
        }
        return this.getEditorFontSize();
    }

    public void setConsoleFontSize(int fontSize) {
        fontSize = EditorFontsConstants.checkAndFixEditorFontSize(fontSize);
        this.myConsoleFontPreferences.register(this.getConsoleFontName(), fontSize);
        this.initFonts();
    }

    public float getConsoleLineSpacing() {
        float consoleLineSpacing = this.myConsoleLineSpacing;
        if (consoleLineSpacing == -1.0f) {
            return this.getLineSpacing();
        }
        return consoleLineSpacing;
    }

    public void setConsoleLineSpacing(float lineSpacing) {
        this.myConsoleLineSpacing = lineSpacing;
    }

    protected TextAttributes getFallbackAttributes(@NotNull TextAttributesKey fallbackKey) {
        if (fallbackKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fallbackKey", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "getFallbackAttributes"));
        }
        TextAttributes fallbackAttributes = this.getDirectlyDefinedAttributes(fallbackKey);
        TextAttributesKey fallbackKeyFallbackKey = fallbackKey.getFallbackAttributeKey();
        if (fallbackAttributes != null && (fallbackAttributes != TextAttributes.USE_INHERITED_MARKER || fallbackKeyFallbackKey == null)) {
            return fallbackAttributes;
        }
        return fallbackKeyFallbackKey == null ? null : this.getFallbackAttributes(fallbackKeyFallbackKey);
    }

    @Nullable
    public TextAttributes getDirectlyDefinedAttributes(@NotNull TextAttributesKey key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "getDirectlyDefinedAttributes"));
        }
        TextAttributes attributes = this.myAttributesMap.get(key);
        if (attributes != null) {
            return attributes;
        }
        return this.myParentScheme instanceof AbstractColorsScheme ? ((AbstractColorsScheme)this.myParentScheme).getDirectlyDefinedAttributes(key) : null;
    }

    @Override
    @NotNull
    public SchemeState getSchemeState() {
        SchemeState schemeState = this.myIsSaveNeeded ? SchemeState.POSSIBLY_CHANGED : SchemeState.UNCHANGED;
        if (schemeState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "getSchemeState"));
        }
        return schemeState;
    }

    public void setSaveNeeded(boolean value2) {
        this.myIsSaveNeeded = value2;
    }

    public boolean isReadOnly() {
        return false;
    }

    @NotNull
    public Properties getMetaProperties() {
        Properties properties = this.myMetaInfo;
        if (properties == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "getMetaProperties"));
        }
        return properties;
    }

    public boolean canBeDeleted() {
        return this.myCanBeDeleted;
    }

    public void setCanBeDeleted(boolean canBeDeleted) {
        this.myCanBeDeleted = canBeDeleted;
    }

    public boolean isVisible() {
        return true;
    }

    public static boolean isVisible(@NotNull EditorColorsScheme scheme2) {
        if (scheme2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", SCHEME_ELEMENT, "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "isVisible"));
        }
        return !(scheme2 instanceof AbstractColorsScheme) || ((AbstractColorsScheme)scheme2).isVisible();
    }

    @Nullable
    public AbstractColorsScheme getOriginal() {
        EditorColorsScheme originalScheme;
        String originalSchemeName = this.getMetaProperties().getProperty(META_INFO_ORIGINAL);
        if (originalSchemeName != null && (originalScheme = EditorColorsManager.getInstance().getScheme(originalSchemeName)) instanceof AbstractColorsScheme) {
            return (AbstractColorsScheme)originalScheme;
        }
        return null;
    }

    @Override
    @NotNull
    public Element writeScheme() {
        Element root = new Element(SCHEME_ELEMENT);
        this.writeExternal(root);
        Element element = root;
        if (element == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "writeScheme"));
        }
        return element;
    }

    public boolean settingsEqual(Object other) {
        if (!(other instanceof AbstractColorsScheme)) {
            return false;
        }
        AbstractColorsScheme otherScheme = (AbstractColorsScheme)other;
        if (AbstractColorsScheme.getBaseDefaultScheme(this) != AbstractColorsScheme.getBaseDefaultScheme(otherScheme)) {
            return false;
        }
        for (String propertyName : this.myMetaInfo.stringPropertyNames()) {
            if (propertyName.equals(META_INFO_CREATION_TIME) || propertyName.equals(META_INFO_MODIFIED_TIME) || propertyName.equals(META_INFO_IDE) || propertyName.equals(META_INFO_IDE_VERSION) || propertyName.equals(META_INFO_ORIGINAL) || Comparing.equal((String)this.myMetaInfo.getProperty(propertyName), (String)otherScheme.myMetaInfo.getProperty(propertyName))) continue;
            return false;
        }
        return this.getLineSpacing() == otherScheme.getLineSpacing() && this.getConsoleLineSpacing() == otherScheme.getConsoleLineSpacing() && this.myFontPreferences.equals((Object)otherScheme.getFontPreferences()) && this.myConsoleFontPreferences.equals((Object)otherScheme.getConsoleFontPreferences()) && this.attributesEqual(otherScheme) && this.colorsEqual(otherScheme) && this.myFontPreferences.equals((Object)otherScheme.myFontPreferences);
    }

    protected boolean attributesEqual(AbstractColorsScheme otherScheme) {
        return this.myAttributesMap.equals(otherScheme.myAttributesMap);
    }

    protected boolean colorsEqual(AbstractColorsScheme otherScheme) {
        return this.myColorsMap.equals(otherScheme.myColorsMap);
    }

    @Nullable
    private static EditorColorsScheme getBaseDefaultScheme(@NotNull EditorColorsScheme scheme2) {
        if (scheme2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", SCHEME_ELEMENT, "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "getBaseDefaultScheme"));
        }
        if (!(scheme2 instanceof AbstractColorsScheme)) {
            return null;
        }
        if (scheme2 instanceof DefaultColorsScheme) {
            return scheme2;
        }
        EditorColorsScheme parent = ((AbstractColorsScheme)scheme2).myParentScheme;
        return parent != null ? AbstractColorsScheme.getBaseDefaultScheme(parent) : null;
    }

    public void setParent(@NotNull EditorColorsScheme newParent) {
        if (newParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newParent", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "setParent"));
        }
        assert (newParent instanceof ReadOnlyColorsScheme) : "New parent scheme must be read-only";
        this.myParentScheme = newParent;
    }

    void resolveParent(@NotNull Function<String, EditorColorsScheme> nameResolver) {
        if (nameResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameResolver", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "resolveParent"));
        }
        if (this.myParentScheme instanceof TemporaryParent) {
            String parentName = ((TemporaryParent)this.myParentScheme).getParentName();
            EditorColorsScheme newParent = nameResolver.apply(parentName);
            assert (newParent != null) : "Can not resolve '" + parentName + "' color scheme.";
            assert (newParent instanceof ReadOnlyColorsScheme) : "Resolved parent color scheme must be read-only.";
            this.myParentScheme = newParent;
        }
    }

    private static class TemporaryParent
    extends EditorColorsSchemeImpl {
        private static Logger LOG = Logger.getInstance((String)("#" + TemporaryParent.class.getName()));
        private String myParentName;
        private boolean isErrorReported;

        public TemporaryParent(@NotNull String parentName) {
            if (parentName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentName", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme$TemporaryParent", "<init>"));
            }
            super(EmptyColorScheme.INSTANCE);
            this.myParentName = parentName;
        }

        public String getParentName() {
            return this.myParentName;
        }

        @Override
        public TextAttributes getAttributes(@Nullable TextAttributesKey key) {
            this.reportError();
            return super.getAttributes(key);
        }

        @Override
        @Nullable
        public Color getColor(ColorKey key) {
            this.reportError();
            return super.getColor(key);
        }

        private void reportError() {
            if (!this.isErrorReported) {
                LOG.error("Unresolved link to " + this.myParentName);
                this.isErrorReported = true;
            }
        }
    }
}

