/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.impl;

import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.options.ExternalizableScheme;
import com.intellij.openapi.util.Comparing;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorColorsSchemeImpl
extends AbstractColorsScheme
implements ExternalizableScheme {
    public EditorColorsSchemeImpl(EditorColorsScheme parentScheme) {
        super(parentScheme);
    }

    public void setAttributes(@NotNull TextAttributesKey key, @NotNull TextAttributes attributes) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/editor/colors/impl/EditorColorsSchemeImpl", "setAttributes"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/openapi/editor/colors/impl/EditorColorsSchemeImpl", "setAttributes"));
        }
        if (attributes == TextAttributes.USE_INHERITED_MARKER || attributes != this.getAttributes(key)) {
            this.myAttributesMap.put(key, attributes);
        }
    }

    public void setColor(ColorKey key, Color color) {
        if (!Comparing.equal((Object)color, (Object)this.getColor(key))) {
            this.myColorsMap.put(key, color);
        }
    }

    public TextAttributes getAttributes(@Nullable TextAttributesKey key) {
        if (key != null) {
            TextAttributes attributes = this.getDirectlyDefinedAttributes(key);
            if (attributes != null && attributes != TextAttributes.USE_INHERITED_MARKER) {
                return attributes;
            }
            TextAttributesKey fallbackKey = key.getFallbackAttributeKey();
            if (fallbackKey != null && (attributes = this.getFallbackAttributes(fallbackKey)) != null) {
                return attributes;
            }
        }
        return this.myParentScheme.getAttributes(key);
    }

    @Nullable
    public Color getColor(ColorKey key) {
        if (this.myColorsMap.containsKey(key)) {
            return (Color)this.myColorsMap.get(key);
        }
        return this.myParentScheme.getColor(key);
    }

    @Override
    public Object clone() {
        EditorColorsSchemeImpl newScheme = new EditorColorsSchemeImpl(this.myParentScheme);
        this.copyTo(newScheme);
        newScheme.setName(this.getName());
        newScheme.setDefaultMetaInfo(this);
        return newScheme;
    }

    @Override
    protected boolean attributesEqual(AbstractColorsScheme otherScheme) {
        return this.compareAttributes(otherScheme, new ArrayList<Function<TextAttributesKey, Boolean>>());
    }

    @Override
    protected boolean colorsEqual(AbstractColorsScheme otherScheme) {
        return this.compareColors(otherScheme, new ArrayList<Function<ColorKey, Boolean>>());
    }

    private boolean compareAttributes(@NotNull AbstractColorsScheme otherScheme, @NotNull Collection<Function<TextAttributesKey, Boolean>> filters2) {
        if (otherScheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "otherScheme", "com/intellij/openapi/editor/colors/impl/EditorColorsSchemeImpl", "compareAttributes"));
        }
        if (filters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filters", "com/intellij/openapi/editor/colors/impl/EditorColorsSchemeImpl", "compareAttributes"));
        }
        for (TextAttributesKey key2 : this.myAttributesMap.keySet()) {
            if (EditorColorsSchemeImpl.isTextAttributeKeyIgnored(filters2, key2) || this.getAttributes(key2).equals((Object)otherScheme.getAttributes(key2))) continue;
            return false;
        }
        filters2.add(key -> this.myAttributesMap.containsKey(key));
        return !(this.myParentScheme instanceof EditorColorsSchemeImpl) || ((EditorColorsSchemeImpl)this.myParentScheme).compareAttributes(otherScheme, filters2);
    }

    private static boolean isTextAttributeKeyIgnored(@NotNull Collection<Function<TextAttributesKey, Boolean>> filters2, TextAttributesKey key) {
        if (filters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filters", "com/intellij/openapi/editor/colors/impl/EditorColorsSchemeImpl", "isTextAttributeKeyIgnored"));
        }
        for (Function<TextAttributesKey, Boolean> filter2 : filters2) {
            if (!filter2.apply(key).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private boolean compareColors(@NotNull AbstractColorsScheme otherScheme, @NotNull Collection<Function<ColorKey, Boolean>> filters2) {
        if (otherScheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "otherScheme", "com/intellij/openapi/editor/colors/impl/EditorColorsSchemeImpl", "compareColors"));
        }
        if (filters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filters", "com/intellij/openapi/editor/colors/impl/EditorColorsSchemeImpl", "compareColors"));
        }
        for (ColorKey key2 : this.myColorsMap.keySet()) {
            Color thisColor = this.getColor(key2);
            Color otherColor = otherScheme.getColor(key2);
            if (thisColor == null) {
                return otherColor == null;
            }
            if (EditorColorsSchemeImpl.isColorKeyIgnored(filters2, key2) || thisColor.equals(otherColor)) continue;
            return false;
        }
        filters2.add(key -> this.myColorsMap.containsKey(key));
        return !(this.myParentScheme instanceof EditorColorsSchemeImpl) || ((EditorColorsSchemeImpl)this.myParentScheme).compareColors(otherScheme, filters2);
    }

    private static boolean isColorKeyIgnored(@NotNull Collection<Function<ColorKey, Boolean>> filters2, ColorKey key) {
        if (filters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filters", "com/intellij/openapi/editor/colors/impl/EditorColorsSchemeImpl", "isColorKeyIgnored"));
        }
        for (Function<ColorKey, Boolean> filter2 : filters2) {
            if (!filter2.apply(key).booleanValue()) continue;
            return false;
        }
        return true;
    }
}

