/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.ex.util;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ScrollingModel;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class CaretVisualPositionKeeper {
    private final Map<Editor, Integer> myCaretRelativeVerticalPositions;

    public CaretVisualPositionKeeper(@Nullable Editor editor) {
        Editor[] editorArray;
        if (editor == null) {
            editorArray = Editor.EMPTY_ARRAY;
        } else {
            Editor[] editorArray2 = new Editor[1];
            editorArray = editorArray2;
            editorArray2[0] = editor;
        }
        this(editorArray);
    }

    public CaretVisualPositionKeeper(@Nullable Document document) {
        this(document == null ? Editor.EMPTY_ARRAY : EditorFactory.getInstance().getEditors(document));
    }

    private CaretVisualPositionKeeper(Editor[] editors) {
        this.myCaretRelativeVerticalPositions = new HashMap<Editor, Integer>();
        for (Editor editor : editors) {
            Rectangle visibleArea = editor.getScrollingModel().getVisibleAreaOnScrollingFinished();
            Point pos = editor.visualPositionToXY(editor.getCaretModel().getVisualPosition());
            int relativePosition = pos.y - visibleArea.y;
            this.myCaretRelativeVerticalPositions.put(editor, relativePosition);
        }
    }

    public void restoreOriginalLocation() {
        for (Map.Entry<Editor, Integer> e2 : this.myCaretRelativeVerticalPositions.entrySet()) {
            boolean useAnimation;
            Editor editor = e2.getKey();
            int relativePosition = e2.getValue();
            Point caretLocation = editor.visualPositionToXY(editor.getCaretModel().getVisualPosition());
            int scrollOffset = caretLocation.y - relativePosition;
            ScrollingModel scrollingModel = editor.getScrollingModel();
            Rectangle targetArea = scrollingModel.getVisibleAreaOnScrollingFinished();
            boolean bl = useAnimation = !targetArea.equals(scrollingModel.getVisibleArea());
            if (!useAnimation) {
                scrollingModel.disableAnimation();
            }
            scrollingModel.scroll(targetArea.x, scrollOffset);
            if (useAnimation) continue;
            scrollingModel.enableAnimation();
        }
    }
}

