/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.ex.util;

import com.intellij.diagnostic.Dumpable;
import com.intellij.diagnostic.LogMessageEx;
import com.intellij.ide.ui.UISettings;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.EditorFactoryAdapter;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.ex.DocumentBulkUpdateListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.ComplementaryFontsRegistry;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.impl.view.IterationState;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.editor.textarea.TextComponentEditor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPasswordField;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EditorUtil {
    private static final Logger LOG = Logger.getInstance(EditorUtil.class);

    private EditorUtil() {
    }

    public static boolean isRealFileEditor(@Nullable Editor editor) {
        return editor != null && TextEditorProvider.getInstance().getTextEditor(editor) instanceof TextEditorImpl;
    }

    public static boolean isPasswordEditor(@Nullable Editor editor) {
        return editor != null && editor.getContentComponent() instanceof JPasswordField;
    }

    @Nullable
    public static EditorEx getEditorEx(@Nullable FileEditor fileEditor) {
        Editor editor = fileEditor instanceof TextEditor ? ((TextEditor)fileEditor).getEditor() : null;
        return editor instanceof EditorEx ? (EditorEx)editor : null;
    }

    public static int getLastVisualLineColumnNumber(@NotNull Editor editor, int line) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/ex/util/EditorUtil", "getLastVisualLineColumnNumber"));
        }
        if (editor instanceof EditorImpl) {
            LogicalPosition lineEndPosition = editor.visualToLogicalPosition(new VisualPosition(line, Integer.MAX_VALUE));
            int lineEndOffset = editor.logicalPositionToOffset(lineEndPosition);
            return editor.offsetToVisualPosition((int)lineEndOffset, (boolean)true, (boolean)true).column;
        }
        Document document = editor.getDocument();
        int lastLine = document.getLineCount() - 1;
        if (lastLine < 0) {
            return 0;
        }
        VisualPosition visStart = new VisualPosition(line, 0);
        LogicalPosition logStart = editor.visualToLogicalPosition(visStart);
        int lastLogLine = logStart.line;
        while (lastLogLine < document.getLineCount() - 1) {
            logStart = new LogicalPosition(logStart.line + 1, logStart.column);
            VisualPosition tryVisible = editor.logicalToVisualPosition(logStart);
            if (tryVisible.line != visStart.line) break;
            lastLogLine = logStart.line;
        }
        int resultLogLine = Math.min(lastLogLine, lastLine);
        VisualPosition resVisStart = editor.offsetToVisualPosition(document.getLineStartOffset(resultLogLine));
        VisualPosition resVisEnd = editor.offsetToVisualPosition(document.getLineEndOffset(resultLogLine));
        if (resVisStart.line == resVisEnd.line) {
            return resVisEnd.column;
        }
        int visualLinesToSkip = line - resVisStart.line;
        List softWraps = editor.getSoftWrapModel().getSoftWrapsForLine(resultLogLine);
        for (int i2 = 0; i2 < softWraps.size(); ++i2) {
            SoftWrap softWrap = (SoftWrap)softWraps.get(i2);
            CharSequence text2 = document.getCharsSequence();
            if (visualLinesToSkip <= 0) {
                VisualPosition visual = editor.offsetToVisualPosition(softWrap.getStart() - 1);
                int result2 = visual.column;
                int x2 = editor.visualPositionToXY((VisualPosition)visual).x;
                return result2 + EditorUtil.textWidthInColumns(editor, text2, softWrap.getStart() - 1, softWrap.getStart(), x2);
            }
            int softWrapLineFeeds = StringUtil.countNewLines((CharSequence)softWrap.getText());
            if (softWrapLineFeeds < visualLinesToSkip) {
                visualLinesToSkip -= softWrapLineFeeds;
                continue;
            }
            if (softWrapLineFeeds == visualLinesToSkip) {
                if (i2 >= softWraps.size() - 1) {
                    return resVisEnd.column;
                }
                SoftWrap nextSoftWrap = (SoftWrap)softWraps.get(i2 + 1);
                VisualPosition visual = editor.offsetToVisualPosition(nextSoftWrap.getStart() - 1);
                int result3 = visual.column;
                int x3 = editor.visualPositionToXY((VisualPosition)visual).x;
                result3 += EditorUtil.textWidthInColumns(editor, text2, nextSoftWrap.getStart() - 1, nextSoftWrap.getStart(), x3);
                int lineFeedIndex = StringUtil.indexOf((CharSequence)nextSoftWrap.getText(), (char)'\n');
                return result3 += EditorUtil.textWidthInColumns(editor, nextSoftWrap.getText(), 0, lineFeedIndex, 0);
            }
            int softWrapStartOffset = 0;
            int softWrapEndOffset = 0;
            int softWrapTextLength = softWrap.getText().length();
            while (visualLinesToSkip-- > 0) {
                softWrapStartOffset = softWrapEndOffset + 1;
                if (softWrapStartOffset >= softWrapTextLength) {
                    assert (false);
                    return resVisEnd.column;
                }
                softWrapEndOffset = StringUtil.indexOf((CharSequence)softWrap.getText(), (char)'\n', (int)softWrapStartOffset, (int)softWrapTextLength);
                if (softWrapEndOffset >= 0) continue;
                assert (false);
                return resVisEnd.column;
            }
            VisualPosition visual = editor.offsetToVisualPosition(softWrap.getStart() - 1);
            int result4 = visual.column;
            int x4 = editor.visualPositionToXY((VisualPosition)visual).x;
            result4 += EditorUtil.textWidthInColumns(editor, text2, softWrap.getStart() - 1, softWrap.getStart(), x4);
            return result4 += EditorUtil.calcColumnNumber(editor, softWrap.getText(), softWrapStartOffset, softWrapEndOffset);
        }
        String editorInfo = "editor's class: " + editor.getClass() + ", all soft wraps: " + editor.getSoftWrapModel().getSoftWrapsForRange(0, document.getTextLength()) + ", fold regions: " + Arrays.toString(editor.getFoldingModel().getAllFoldRegions());
        LogMessageEx.error(LOG, "Can't calculate last visual column", String.format("Target visual line: %d, mapped logical line: %d, visual lines range for the mapped logical line: [%s]-[%s], soft wraps for the target logical line: %s. Editor info: %s", line, resultLogLine, resVisStart, resVisEnd, softWraps, editorInfo));
        return resVisEnd.column;
    }

    public static int getVisualLineEndOffset(@NotNull Editor editor, int line) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/ex/util/EditorUtil", "getVisualLineEndOffset"));
        }
        VisualPosition endLineVisualPosition = new VisualPosition(line, EditorUtil.getLastVisualLineColumnNumber(editor, line));
        LogicalPosition endLineLogicalPosition = editor.visualToLogicalPosition(endLineVisualPosition);
        return editor.logicalPositionToOffset(endLineLogicalPosition);
    }

    public static float calcVerticalScrollProportion(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/ex/util/EditorUtil", "calcVerticalScrollProportion"));
        }
        Rectangle viewArea = editor.getScrollingModel().getVisibleAreaOnScrollingFinished();
        if (viewArea.height == 0) {
            return 0.0f;
        }
        LogicalPosition pos = editor.getCaretModel().getLogicalPosition();
        Point location = editor.logicalPositionToXY(pos);
        return (float)(location.y - viewArea.y) / (float)viewArea.height;
    }

    public static void setVerticalScrollProportion(@NotNull Editor editor, float proportion) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/ex/util/EditorUtil", "setVerticalScrollProportion"));
        }
        Rectangle viewArea = editor.getScrollingModel().getVisibleArea();
        LogicalPosition caretPosition = editor.getCaretModel().getLogicalPosition();
        Point caretLocation = editor.logicalPositionToXY(caretPosition);
        int yPos = caretLocation.y;
        yPos = (int)((float)yPos - (float)viewArea.height * proportion);
        editor.getScrollingModel().scrollVertically(yPos);
    }

    public static int calcRelativeCaretPosition(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/ex/util/EditorUtil", "calcRelativeCaretPosition"));
        }
        int caretY = editor.getCaretModel().getVisualPosition().line * editor.getLineHeight();
        int viewAreaPosition = editor.getScrollingModel().getVisibleAreaOnScrollingFinished().y;
        return caretY - viewAreaPosition;
    }

    public static void setRelativeCaretPosition(@NotNull Editor editor, int position) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/ex/util/EditorUtil", "setRelativeCaretPosition"));
        }
        int caretY = editor.getCaretModel().getVisualPosition().line * editor.getLineHeight();
        editor.getScrollingModel().scrollVertically(caretY - position);
    }

    public static void fillVirtualSpaceUntilCaret(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/ex/util/EditorUtil", "fillVirtualSpaceUntilCaret"));
        }
        LogicalPosition position = editor.getCaretModel().getLogicalPosition();
        EditorUtil.fillVirtualSpaceUntil(editor, position.column, position.line);
    }

    public static void fillVirtualSpaceUntil(final @NotNull Editor editor, int columnNumber, int lineNumber) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/ex/util/EditorUtil", "fillVirtualSpaceUntil"));
        }
        final int offset = editor.logicalPositionToOffset(new LogicalPosition(lineNumber, columnNumber));
        final String filler = EditorModificationUtil.calcStringToFillVirtualSpace((Editor)editor);
        if (!filler.isEmpty()) {
            new WriteAction(){

                protected void run(@NotNull Result result2) throws Throwable {
                    if (result2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/editor/ex/util/EditorUtil$1", "run"));
                    }
                    editor.getDocument().insertString(offset, (CharSequence)filler);
                    editor.getCaretModel().moveToOffset(offset + filler.length());
                }
            }.execute();
        }
    }

    public static int calcSoftWrapUnawareOffset(@NotNull Editor editor, @NotNull CharSequence text2, int start2, int end, int columnNumber, int tabSize, int x2, @NotNull int[] currentColumn, @Nullable StringBuilder debugBuffer) {
        int offset;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/ex/util/EditorUtil", "calcSoftWrapUnawareOffset"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/ex/util/EditorUtil", "calcSoftWrapUnawareOffset"));
        }
        if (currentColumn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentColumn", "com/intellij/openapi/editor/ex/util/EditorUtil", "calcSoftWrapUnawareOffset"));
        }
        if (debugBuffer != null) {
            debugBuffer.append(String.format("Starting calcSoftWrapUnawareOffset(). Target range: [%d; %d), target column number to map: %d, tab size: %d, x: %d, current column: %d%n", start2, end, columnNumber, tabSize, x2, currentColumn[0]));
        }
        boolean useOptimization = true;
        boolean hasTabs = false;
        int scanEndOffset = Math.min(end, start2 + columnNumber - currentColumn[0] + 1);
        boolean hasNonTabs = false;
        for (int i2 = start2; i2 < scanEndOffset; ++i2) {
            char c2 = text2.charAt(i2);
            if (debugBuffer != null) {
                debugBuffer.append(String.format("Found symbol '%c' at the offset %d%n", Character.valueOf(c2), i2));
            }
            if (c2 == '\t') {
                hasTabs = true;
                if (!hasNonTabs) continue;
                useOptimization = false;
                break;
            }
            hasNonTabs = true;
        }
        if (debugBuffer != null) {
            debugBuffer.append(String.format("Has tabs: %b, use optimisation: %b%n", hasTabs, useOptimization));
        }
        if (useOptimization) {
            if (!hasTabs) {
                int result2 = start2 + columnNumber - currentColumn[0];
                if (result2 < end) {
                    return result2;
                }
                currentColumn[0] = currentColumn[0] + (end - start2);
                if (debugBuffer != null) {
                    debugBuffer.append(String.format("Incrementing 'current column' by %d (new value is %d)%n", end - start2, currentColumn[0]));
                }
                return -1;
            }
            int shift = 0;
            offset = start2;
            int prevX = x2;
            if (debugBuffer != null) {
                debugBuffer.append("Processing a string that contains only tabs\n");
            }
            while (offset < end && offset + shift + currentColumn[0] < start2 + columnNumber) {
                char c3 = text2.charAt(offset);
                if (c3 == '\t') {
                    int nextX = EditorUtil.nextTabStop(prevX, editor, tabSize);
                    int columnsShift = EditorUtil.columnsNumber(nextX - prevX, EditorUtil.getSpaceWidth(0, editor)) - 1;
                    if (debugBuffer != null) {
                        debugBuffer.append(String.format("Processing tabulation symbol at the offset %d. Current X: %d, new X: %d, current columns shift: %d, new column shift: %d%n", offset, prevX, nextX, shift, shift + columnsShift));
                    }
                    shift += columnsShift;
                    prevX = nextX;
                }
                ++offset;
            }
            int diff = start2 + columnNumber - offset - shift - currentColumn[0];
            if (debugBuffer != null) {
                debugBuffer.append(String.format("Resulting diff: %d%n", diff));
            }
            if (diff < 0) {
                return offset - 1;
            }
            if (diff == 0) {
                return offset;
            }
            int inc = offset - start2 + shift;
            if (debugBuffer != null) {
                debugBuffer.append(String.format("Incrementing 'current column' by %d (new value is %d)%n", inc, currentColumn[0] + inc));
            }
            currentColumn[0] = currentColumn[0] + inc;
            return -1;
        }
        EditorEx editorImpl = (EditorEx)editor;
        IterationState state = new IterationState(editorImpl, start2, end, null, false, false, true, false);
        int fontType = state.getMergedAttributes().getFontType();
        int column = currentColumn[0];
        int plainSpaceSize = EditorUtil.getSpaceWidth(0, editorImpl);
        for (offset = start2; column < columnNumber && offset < end; ++offset) {
            char c4;
            if (offset >= state.getEndOffset()) {
                state.advance();
                fontType = state.getMergedAttributes().getFontType();
            }
            if ((c4 = text2.charAt(offset)) == '\t') {
                int newX = EditorUtil.nextTabStop(x2, editorImpl);
                int columns = EditorUtil.columnsNumber(newX - x2, plainSpaceSize);
                if (debugBuffer != null) {
                    debugBuffer.append(String.format("Processing tabulation at the offset %d. Current X: %d, new X: %d, current column: %d, new column: %d%n", offset, x2, newX, column, column + columns));
                }
                x2 = newX;
                column += columns;
                continue;
            }
            int width = EditorUtil.charWidth(c4, fontType, editorImpl);
            if (debugBuffer != null) {
                debugBuffer.append(String.format("Processing symbol '%c' at the offset %d. Current X: %d, new X: %d%n", Character.valueOf(c4), offset, x2, x2 + width));
            }
            x2 += width;
            ++column;
        }
        if (column == columnNumber) {
            return offset;
        }
        if (column > columnNumber && offset > 0 && text2.charAt(offset - 1) == '\t') {
            return offset - 1;
        }
        currentColumn[0] = column;
        return -1;
    }

    private static int getTabLength(int colNumber, int tabSize) {
        if (tabSize <= 0) {
            tabSize = 1;
        }
        return tabSize - colNumber % tabSize;
    }

    public static int calcColumnNumber(@NotNull Editor editor, @NotNull CharSequence text2, int start2, int offset) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/ex/util/EditorUtil", "calcColumnNumber"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/ex/util/EditorUtil", "calcColumnNumber"));
        }
        return EditorUtil.calcColumnNumber(editor, text2, start2, offset, EditorUtil.getTabSize(editor));
    }

    public static int calcColumnNumber(@Nullable Editor editor, @NotNull CharSequence text2, int start2, int offset, int tabSize) {
        int i2;
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/ex/util/EditorUtil", "calcColumnNumber"));
        }
        if (editor instanceof TextComponentEditor) {
            return offset - start2;
        }
        boolean useOptimization = true;
        if (editor != null) {
            SoftWrap softWrap = editor.getSoftWrapModel().getSoftWrap(start2);
            boolean bl = useOptimization = softWrap == null;
        }
        if (useOptimization) {
            boolean hasNonTabs = false;
            for (i2 = start2; i2 < offset; ++i2) {
                if (text2.charAt(i2) == '\t') {
                    if (!hasNonTabs) continue;
                    useOptimization = false;
                    break;
                }
                hasNonTabs = true;
            }
        }
        if (editor != null && useOptimization) {
            Document document = editor.getDocument();
            if (start2 < offset - 1 && document.getLineNumber(start2) != document.getLineNumber(offset - 1)) {
                String editorInfo = editor instanceof EditorImpl ? ". Editor info: " + ((EditorImpl)editor).dumpState() : "";
                String documentInfo = text2 instanceof Dumpable ? ((Dumpable)text2).dumpState() : "Text holder class: " + text2.getClass();
                LogMessageEx.error(LOG, "detected incorrect offset -> column number calculation", "start: " + start2 + ", given offset: " + offset + ", given tab size: " + tabSize + ". " + documentInfo + editorInfo);
            }
        }
        int shift = 0;
        for (i2 = start2; i2 < offset; ++i2) {
            char c2 = text2.charAt(i2);
            if (c2 != '\t') continue;
            shift += EditorUtil.getTabLength(i2 + shift - start2, tabSize) - 1;
        }
        return offset - start2 + shift;
    }

    public static void setHandCursor(@NotNull Editor view2) {
        if (view2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/openapi/editor/ex/util/EditorUtil", "setHandCursor"));
        }
        Cursor c2 = Cursor.getPredefinedCursor(12);
        if (view2.getContentComponent().getCursor() != c2) {
            view2.getContentComponent().setCursor(c2);
        }
    }

    @NotNull
    public static FontInfo fontForChar(char c2, @JdkConstants.FontStyle int style, @NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/ex/util/EditorUtil", "fontForChar"));
        }
        EditorColorsScheme colorsScheme = editor.getColorsScheme();
        FontInfo fontInfo = ComplementaryFontsRegistry.getFontAbleToDisplay((int)c2, style, colorsScheme.getFontPreferences(), FontInfo.getFontRenderContext(editor.getContentComponent()));
        if (fontInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/ex/util/EditorUtil", "fontForChar"));
        }
        return fontInfo;
    }

    public static Icon scaleIconAccordingEditorFont(Icon icon, Editor editor) {
        float scale;
        if (Registry.is((String)"editor.scale.gutter.icons") && editor instanceof EditorImpl && icon instanceof ScalableIcon && Math.abs(1.0f - (scale = ((EditorImpl)editor).getScale())) > 0.1f) {
            return ((ScalableIcon)icon).scale(scale);
        }
        return icon;
    }

    public static int charWidth(char c2, @JdkConstants.FontStyle int fontType, @NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/ex/util/EditorUtil", "charWidth"));
        }
        return EditorUtil.fontForChar(c2, fontType, editor).charWidth(c2);
    }

    public static int getSpaceWidth(@JdkConstants.FontStyle int fontType, @NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/ex/util/EditorUtil", "getSpaceWidth"));
        }
        int width = EditorUtil.charWidth(' ', fontType, editor);
        return width > 0 ? width : 1;
    }

    public static int getPlainSpaceWidth(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/ex/util/EditorUtil", "getPlainSpaceWidth"));
        }
        return EditorUtil.getSpaceWidth(0, editor);
    }

    public static int getTabSize(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/ex/util/EditorUtil", "getTabSize"));
        }
        return editor.getSettings().getTabSize(editor.getProject());
    }

    public static int nextTabStop(int x2, @NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/ex/util/EditorUtil", "nextTabStop"));
        }
        int tabSize = EditorUtil.getTabSize(editor);
        if (tabSize <= 0) {
            tabSize = 1;
        }
        return EditorUtil.nextTabStop(x2, editor, tabSize);
    }

    public static int nextTabStop(int x2, @NotNull Editor editor, int tabSize) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/ex/util/EditorUtil", "nextTabStop"));
        }
        return EditorUtil.nextTabStop(x2, EditorUtil.getSpaceWidth(0, editor), tabSize);
    }

    public static int nextTabStop(int x2, int plainSpaceWidth, int tabSize) {
        if (tabSize <= 0) {
            return x2 + plainSpaceWidth;
        }
        int nTabs = x2 / (tabSize *= plainSpaceWidth);
        return (nTabs + 1) * tabSize;
    }

    public static int textWidthInColumns(@NotNull Editor editor, @NotNull CharSequence text2, int start2, int end, int x2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/ex/util/EditorUtil", "textWidthInColumns"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/ex/util/EditorUtil", "textWidthInColumns"));
        }
        int startToUse = start2;
        int lastTabSymbolIndex = -1;
        block8: for (int i2 = end - 1; i2 >= start2; --i2) {
            switch (text2.charAt(i2)) {
                case '\n': {
                    startToUse = i2 + 1;
                    break block8;
                }
                case '\t': {
                    if (lastTabSymbolIndex < 0) {
                        lastTabSymbolIndex = i2;
                    }
                }
                default: {
                    continue block8;
                }
            }
        }
        if (lastTabSymbolIndex < 0) {
            return end - startToUse;
        }
        int result2 = 0;
        int spaceSize = EditorUtil.getSpaceWidth(0, editor);
        block9: for (int i3 = startToUse; i3 <= lastTabSymbolIndex; ++i3) {
            SoftWrap softWrap = editor.getSoftWrapModel().getSoftWrap(i3);
            if (softWrap != null) {
                x2 = softWrap.getIndentInPixels();
            }
            char c2 = text2.charAt(i3);
            int prevX = x2;
            switch (c2) {
                case '\t': {
                    x2 = EditorUtil.nextTabStop(x2, editor);
                    result2 += EditorUtil.columnsNumber(x2 - prevX, spaceSize);
                    continue block9;
                }
                case '\n': {
                    result2 = 0;
                    x2 = 0;
                    continue block9;
                }
                default: {
                    x2 += EditorUtil.charWidth(c2, 0, editor);
                    ++result2;
                }
            }
        }
        return result2 += end - lastTabSymbolIndex - 1;
    }

    public static int columnsNumber(char c2, int x2, int prevX, int plainSpaceSize) {
        if (c2 != '\t') {
            return 1;
        }
        int result2 = (x2 - prevX) / plainSpaceSize;
        if ((x2 - prevX) % plainSpaceSize > 0) {
            ++result2;
        }
        return result2;
    }

    public static int columnsNumber(int width, int plainSpaceSize) {
        int result2 = width / plainSpaceSize;
        if (width % plainSpaceSize > 0) {
            ++result2;
        }
        return result2;
    }

    public static int textWidth(@NotNull Editor editor, @NotNull CharSequence text2, int start2, int end, @JdkConstants.FontStyle int fontType, int x2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/ex/util/EditorUtil", "textWidth"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/ex/util/EditorUtil", "textWidth"));
        }
        int result2 = 0;
        for (int i2 = start2; i2 < end; ++i2) {
            char c2 = text2.charAt(i2);
            if (c2 != '\t') {
                FontInfo font = EditorUtil.fontForChar(c2, fontType, editor);
                result2 += font.charWidth(c2);
                continue;
            }
            result2 += EditorUtil.nextTabStop(x2 + result2, editor) - result2 - x2;
        }
        return result2;
    }

    public static Pair<LogicalPosition, LogicalPosition> calcCaretLineRange(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/ex/util/EditorUtil", "calcCaretLineRange"));
        }
        return EditorUtil.calcSurroundingRange(editor, editor.getCaretModel().getVisualPosition(), editor.getCaretModel().getVisualPosition());
    }

    public static Pair<LogicalPosition, LogicalPosition> calcCaretLineRange(@NotNull Caret caret) {
        if (caret == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caret", "com/intellij/openapi/editor/ex/util/EditorUtil", "calcCaretLineRange"));
        }
        return EditorUtil.calcSurroundingRange(caret.getEditor(), caret.getVisualPosition(), caret.getVisualPosition());
    }

    public static Pair<LogicalPosition, LogicalPosition> calcSurroundingRange(@NotNull Editor editor, @NotNull VisualPosition start2, @NotNull VisualPosition end) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/ex/util/EditorUtil", "calcSurroundingRange"));
        }
        if (start2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "start", "com/intellij/openapi/editor/ex/util/EditorUtil", "calcSurroundingRange"));
        }
        if (end == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "end", "com/intellij/openapi/editor/ex/util/EditorUtil", "calcSurroundingRange"));
        }
        Document document = editor.getDocument();
        FoldingModel foldingModel = editor.getFoldingModel();
        LogicalPosition first = editor.visualToLogicalPosition(new VisualPosition(start2.line, 0));
        int line = first.line;
        int offset = document.getLineStartOffset(line);
        while (offset >= 0) {
            FoldRegion foldRegion = foldingModel.getCollapsedRegionAtOffset(offset);
            if (foldRegion == null) {
                first = new LogicalPosition(line, 0);
                break;
            }
            int foldEndLine = document.getLineNumber(foldRegion.getStartOffset());
            if (foldEndLine <= line) {
                first = new LogicalPosition(line, 0);
                break;
            }
            line = foldEndLine;
            offset = document.getLineStartOffset(line);
        }
        LogicalPosition second = editor.visualToLogicalPosition(new VisualPosition(end.line, 0));
        int line2 = second.line;
        int offset2 = document.getLineEndOffset(line2);
        while (offset2 <= document.getTextLength()) {
            FoldRegion foldRegion = foldingModel.getCollapsedRegionAtOffset(offset2);
            if (foldRegion == null) {
                second = new LogicalPosition(line2 + 1, 0);
                break;
            }
            int foldEndLine = document.getLineNumber(foldRegion.getEndOffset());
            if (foldEndLine <= line2) {
                second = new LogicalPosition(line2 + 1, 0);
                break;
            }
            line2 = foldEndLine;
            offset2 = document.getLineEndOffset(line2);
        }
        if (second.line >= document.getLineCount()) {
            second = editor.offsetToLogicalPosition(document.getTextLength());
        }
        return Pair.create((Object)first, (Object)second);
    }

    public static int getNotFoldedLineStartOffset(@NotNull Editor editor, int offset) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/ex/util/EditorUtil", "getNotFoldedLineStartOffset"));
        }
        while (true) {
            offset = DocumentUtil.getLineStartOffset(offset, editor.getDocument());
            FoldRegion foldRegion = editor.getFoldingModel().getCollapsedRegionAtOffset(offset - 1);
            if (foldRegion == null || foldRegion.getStartOffset() >= offset) break;
            offset = foldRegion.getStartOffset();
        }
        return offset;
    }

    public static int getNotFoldedLineEndOffset(@NotNull Editor editor, int offset) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/ex/util/EditorUtil", "getNotFoldedLineEndOffset"));
        }
        while (true) {
            offset = EditorUtil.getLineEndOffset(offset, editor.getDocument());
            FoldRegion foldRegion = editor.getFoldingModel().getCollapsedRegionAtOffset(offset);
            if (foldRegion == null || foldRegion.getEndOffset() <= offset) break;
            offset = foldRegion.getEndOffset();
        }
        return offset;
    }

    private static int getLineEndOffset(int offset, Document document) {
        if (offset >= document.getTextLength()) {
            return offset;
        }
        int lineNumber = document.getLineNumber(offset);
        return document.getLineEndOffset(lineNumber);
    }

    public static void scrollToTheEnd(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/ex/util/EditorUtil", "scrollToTheEnd"));
        }
        editor.getSelectionModel().removeSelection();
        int lastLine = Math.max(0, editor.getDocument().getLineCount() - 1);
        if (editor.getCaretModel().getLogicalPosition().line == lastLine) {
            editor.getCaretModel().moveToOffset(editor.getDocument().getTextLength());
        } else {
            editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(lastLine, 0));
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
    }

    public static boolean isChangeFontSize(@NotNull MouseWheelEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/ex/util/EditorUtil", "isChangeFontSize"));
        }
        if (e2.getWheelRotation() == 0) {
            return false;
        }
        return SystemInfo.isMac ? !e2.isControlDown() && e2.isMetaDown() && !e2.isAltDown() && !e2.isShiftDown() : e2.isControlDown() && !e2.isMetaDown() && !e2.isAltDown() && !e2.isShiftDown();
    }

    public static boolean inVirtualSpace(@NotNull Editor editor, @NotNull LogicalPosition logicalPosition) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/ex/util/EditorUtil", "inVirtualSpace"));
        }
        if (logicalPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logicalPosition", "com/intellij/openapi/editor/ex/util/EditorUtil", "inVirtualSpace"));
        }
        return !editor.offsetToLogicalPosition(editor.logicalPositionToOffset(logicalPosition)).equals((Object)logicalPosition);
    }

    public static void reinitSettings() {
        EditorFactory.getInstance().refreshAllEditors();
    }

    @NotNull
    public static TextRange getSelectionInAnyMode(Editor editor) {
        SelectionModel selection = editor.getSelectionModel();
        int[] starts = selection.getBlockSelectionStarts();
        int[] ends = selection.getBlockSelectionEnds();
        int start2 = starts.length > 0 ? starts[0] : selection.getSelectionStart();
        int end = ends.length > 0 ? ends[ends.length - 1] : selection.getSelectionEnd();
        TextRange textRange = TextRange.create((int)start2, (int)end);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/ex/util/EditorUtil", "getSelectionInAnyMode"));
        }
        return textRange;
    }

    public static int yPositionToLogicalLine(@NotNull Editor editor, @NotNull MouseEvent event) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/ex/util/EditorUtil", "yPositionToLogicalLine"));
        }
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/editor/ex/util/EditorUtil", "yPositionToLogicalLine"));
        }
        return EditorUtil.yPositionToLogicalLine(editor, event.getY());
    }

    public static int yPositionToLogicalLine(@NotNull Editor editor, @NotNull Point point) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/ex/util/EditorUtil", "yPositionToLogicalLine"));
        }
        if (point == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "point", "com/intellij/openapi/editor/ex/util/EditorUtil", "yPositionToLogicalLine"));
        }
        return EditorUtil.yPositionToLogicalLine(editor, point.y);
    }

    public static int yPositionToLogicalLine(@NotNull Editor editor, int y2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/ex/util/EditorUtil", "yPositionToLogicalLine"));
        }
        int line = editor instanceof EditorImpl ? ((EditorImpl)editor).yToVisibleLine(y2) : y2 / editor.getLineHeight();
        return line > 0 ? editor.visualToLogicalPosition((VisualPosition)new VisualPosition((int)line, (int)0)).line : 0;
    }

    public static boolean isAtLineEnd(@NotNull Editor editor, int offset) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/ex/util/EditorUtil", "isAtLineEnd"));
        }
        Document document = editor.getDocument();
        if (offset < 0 || offset > document.getTextLength()) {
            return false;
        }
        int line = document.getLineNumber(offset);
        return offset == document.getLineEndOffset(line);
    }

    public static void setSelectionExpandingFoldedRegionsIfNeeded(@NotNull Editor editor, int startOffset, int endOffset) {
        FoldRegion endFoldRegion;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/ex/util/EditorUtil", "setSelectionExpandingFoldedRegionsIfNeeded"));
        }
        FoldingModel foldingModel = editor.getFoldingModel();
        FoldRegion startFoldRegion = foldingModel.getCollapsedRegionAtOffset(startOffset);
        if (startFoldRegion != null && (startFoldRegion.getStartOffset() == startOffset || startFoldRegion.isExpanded())) {
            startFoldRegion = null;
        }
        if ((endFoldRegion = foldingModel.getCollapsedRegionAtOffset(endOffset)) != null && (endFoldRegion.getStartOffset() == endOffset || endFoldRegion.isExpanded())) {
            endFoldRegion = null;
        }
        if (startFoldRegion != null || endFoldRegion != null) {
            FoldRegion finalStartFoldRegion = startFoldRegion;
            FoldRegion finalEndFoldRegion = endFoldRegion;
            foldingModel.runBatchFoldingOperation(() -> {
                if (finalStartFoldRegion != null) {
                    finalStartFoldRegion.setExpanded(true);
                }
                if (finalEndFoldRegion != null) {
                    finalEndFoldRegion.setExpanded(true);
                }
            });
        }
        editor.getSelectionModel().setSelection(startOffset, endOffset);
    }

    public static Font getEditorFont() {
        EditorColorsScheme scheme2 = EditorColorsManager.getInstance().getGlobalScheme();
        int size = UISettings.getInstance().getPresentationMode() ? UISettings.getInstance().getPresentationModeFontSize() - 4 : scheme2.getEditorFontSize();
        return new Font(scheme2.getEditorFontName(), 0, size);
    }

    public static int getSoftWrapCountAfterLineStart(@NotNull Editor editor, @NotNull LogicalPosition position) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/ex/util/EditorUtil", "getSoftWrapCountAfterLineStart"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/openapi/editor/ex/util/EditorUtil", "getSoftWrapCountAfterLineStart"));
        }
        if (position.visualPositionAware) {
            return position.softWrapLinesOnCurrentLogicalLine;
        }
        int startOffset = editor.getDocument().getLineStartOffset(position.line);
        int endOffset = editor.logicalPositionToOffset(position);
        return editor.getSoftWrapModel().getSoftWrapsForRange(startOffset, endOffset).size();
    }

    public static boolean attributesImpactFontStyleOrColor(@Nullable TextAttributes attributes) {
        return attributes == TextAttributes.ERASE_MARKER || attributes != null && (attributes.getFontType() != 0 || attributes.getForegroundColor() != null);
    }

    public static boolean isCurrentCaretPrimary(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/ex/util/EditorUtil", "isCurrentCaretPrimary"));
        }
        return editor.getCaretModel().getCurrentCaret() == editor.getCaretModel().getPrimaryCaret();
    }

    public static void disposeWithEditor(@NotNull Editor editor, final @NotNull Disposable disposable) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/ex/util/EditorUtil", "disposeWithEditor"));
        }
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/openapi/editor/ex/util/EditorUtil", "disposeWithEditor"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (Disposer.isDisposed((Disposable)disposable)) {
            return;
        }
        if (editor.isDisposed()) {
            Disposer.dispose((Disposable)disposable);
            return;
        }
        final Editor hostEditor = editor instanceof EditorWindow ? ((EditorWindow)editor).getDelegate() : editor;
        EditorFactory.getInstance().addEditorFactoryListener((EditorFactoryListener)new EditorFactoryAdapter(){

            public void editorReleased(@NotNull EditorFactoryEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/editor/ex/util/EditorUtil$2", "editorReleased"));
                }
                if (event.getEditor() == hostEditor) {
                    Disposer.dispose((Disposable)disposable);
                }
            }
        }, disposable);
    }

    public static void runBatchFoldingOperationOutsideOfBulkUpdate(final @NotNull Editor editor, final @NotNull Runnable operation) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/ex/util/EditorUtil", "runBatchFoldingOperationOutsideOfBulkUpdate"));
        }
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "com/intellij/openapi/editor/ex/util/EditorUtil", "runBatchFoldingOperationOutsideOfBulkUpdate"));
        }
        DocumentEx document = (DocumentEx)ObjectUtils.tryCast((Object)editor.getDocument(), DocumentEx.class);
        if (document != null && document.isInBulkUpdate()) {
            final MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
            EditorUtil.disposeWithEditor(editor, (Disposable)connection);
            connection.subscribe(DocumentBulkUpdateListener.TOPIC, (Object)new DocumentBulkUpdateListener.Adapter(){

                @Override
                public void updateFinished(@NotNull Document doc) {
                    if (doc == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doc", "com/intellij/openapi/editor/ex/util/EditorUtil$3", "updateFinished"));
                    }
                    if (doc == editor.getDocument()) {
                        editor.getFoldingModel().runBatchFoldingOperation(operation);
                        connection.disconnect();
                    }
                }
            });
        } else {
            editor.getFoldingModel().runBatchFoldingOperation(operation);
        }
    }
}

