/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.ex.util;

import com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.annotations.NotNull;

public class SegmentArray {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.ex.util.SegmentArray");
    protected int[] myStarts = new int[64];
    protected int[] myEnds = new int[64];
    protected int mySegmentCount;
    protected static final int INITIAL_SIZE = 64;

    protected SegmentArray() {
    }

    protected void setElementAt(int i2, int startOffset, int endOffset) {
        if (startOffset < 0) {
            LOG.error("Invalid startOffset:" + startOffset);
        }
        if (endOffset < 0) {
            LOG.error("Invalid endOffset:" + endOffset);
        }
        if (i2 >= this.mySegmentCount) {
            this.mySegmentCount = i2 + 1;
        }
        this.myStarts = SegmentArray.reallocateArray(this.myStarts, i2);
        this.myStarts[i2] = startOffset;
        this.myEnds = SegmentArray.reallocateArray(this.myEnds, i2);
        this.myEnds[i2] = endOffset;
    }

    protected void replace(int startOffset, @NotNull SegmentArray data, int len) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/openapi/editor/ex/util/SegmentArray", "replace"));
        }
        System.arraycopy(data.myStarts, 0, this.myStarts, startOffset, len);
        System.arraycopy(data.myEnds, 0, this.myEnds, startOffset, len);
    }

    static int calcCapacity(int currentArraySize, int index) {
        currentArraySize = currentArraySize == 0 ? 16 : (currentArraySize += currentArraySize / 5);
        if (index >= currentArraySize) {
            currentArraySize = index + index / 5;
        }
        return currentArraySize;
    }

    @NotNull
    private static int[] reallocateArray(@NotNull int[] array2, int index) {
        if (array2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/openapi/editor/ex/util/SegmentArray", "reallocateArray"));
        }
        if (index < array2.length) {
            if (array2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/ex/util/SegmentArray", "reallocateArray"));
            }
            return array2;
        }
        int[] newArray = new int[SegmentArray.calcCapacity(array2.length, index)];
        System.arraycopy(array2, 0, newArray, 0, array2.length);
        if (newArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/ex/util/SegmentArray", "reallocateArray"));
        }
        return newArray;
    }

    protected int noSegmentsAvailable(int offset) {
        throw new IllegalStateException("no segments available. offset = " + offset);
    }

    protected int offsetOutOfRange(int offset, int lastValidOffset) {
        throw new IndexOutOfBoundsException("Wrong offset: " + offset + ". Should be in range: [0, " + lastValidOffset + "]");
    }

    public final int findSegmentIndex(int offset) {
        if (this.mySegmentCount <= 0) {
            return offset == 0 ? 0 : this.noSegmentsAvailable(offset);
        }
        int lastValidOffset = this.getLastValidOffset();
        if (offset > lastValidOffset || offset < 0) {
            return this.offsetOutOfRange(offset, lastValidOffset);
        }
        int end = this.mySegmentCount - 1;
        if (offset == lastValidOffset) {
            return end;
        }
        int start2 = 0;
        while (start2 <= end) {
            int i2 = start2 + end >>> 1;
            if (offset < this.myStarts[i2]) {
                end = i2 - 1;
                continue;
            }
            if (offset >= this.myEnds[i2]) {
                start2 = i2 + 1;
                continue;
            }
            return i2;
        }
        return this.segmentNotFound(offset, start2);
    }

    protected int segmentNotFound(int offset, int start2) {
        if (offset < this.myStarts[start2] || offset >= this.myEnds[start2]) {
            throw new IllegalStateException("Gap at offset " + offset + " near segment " + start2);
        }
        return start2;
    }

    public int getLastValidOffset() {
        return this.mySegmentCount == 0 ? 0 : this.myEnds[this.mySegmentCount - 1];
    }

    public final void changeSegmentLength(int startIndex, int change) {
        if (startIndex >= 0 && startIndex < this.mySegmentCount) {
            int n2 = startIndex;
            this.myEnds[n2] = this.myEnds[n2] + change;
        }
        this.shiftSegments(startIndex + 1, change);
    }

    public final void shiftSegments(int startIndex, int shift) {
        for (int i2 = startIndex; i2 < this.mySegmentCount; ++i2) {
            int n2 = i2;
            this.myStarts[n2] = this.myStarts[n2] + shift;
            int n3 = i2;
            this.myEnds[n3] = this.myEnds[n3] + shift;
            if (this.myStarts[i2] >= 0 && this.myEnds[i2] >= 0) continue;
            LOG.error("Error shifting segments: myStarts[" + i2 + "] = " + this.myStarts[i2] + ", myEnds[" + i2 + "] = " + this.myEnds[i2]);
        }
    }

    public void removeAll() {
        this.mySegmentCount = 0;
    }

    public void remove(int startIndex, int endIndex) {
        this.myStarts = this.remove(this.myStarts, startIndex, endIndex);
        this.myEnds = this.remove(this.myEnds, startIndex, endIndex);
        this.mySegmentCount -= endIndex - startIndex;
    }

    @NotNull
    protected int[] remove(@NotNull int[] array2, int startIndex, int endIndex) {
        if (array2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/openapi/editor/ex/util/SegmentArray", "remove"));
        }
        if (endIndex < this.mySegmentCount) {
            System.arraycopy(array2, endIndex, array2, startIndex, this.mySegmentCount - endIndex);
        }
        if (array2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/ex/util/SegmentArray", "remove"));
        }
        return array2;
    }

    protected void insert(@NotNull SegmentArray segmentArray, int startIndex) {
        if (segmentArray == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "segmentArray", "com/intellij/openapi/editor/ex/util/SegmentArray", "insert"));
        }
        this.myStarts = this.insert(this.myStarts, segmentArray.myStarts, startIndex, segmentArray.getSegmentCount());
        this.myEnds = this.insert(this.myEnds, segmentArray.myEnds, startIndex, segmentArray.getSegmentCount());
        this.mySegmentCount += segmentArray.getSegmentCount();
    }

    @NotNull
    protected int[] insert(@NotNull int[] array2, @NotNull int[] insertArray, int startIndex, int insertLength) {
        if (array2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/openapi/editor/ex/util/SegmentArray", "insert"));
        }
        if (insertArray == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insertArray", "com/intellij/openapi/editor/ex/util/SegmentArray", "insert"));
        }
        int[] newArray = SegmentArray.reallocateArray(array2, this.mySegmentCount + insertLength);
        if (startIndex < this.mySegmentCount) {
            System.arraycopy(newArray, startIndex, newArray, startIndex + insertLength, this.mySegmentCount - startIndex);
        }
        System.arraycopy(insertArray, 0, newArray, startIndex, insertLength);
        if (newArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/ex/util/SegmentArray", "insert"));
        }
        return newArray;
    }

    public int getSegmentStart(int index) {
        if (index < 0 || index >= this.mySegmentCount) {
            throw new IndexOutOfBoundsException("Wrong line: " + index + ". Available lines count: " + this.mySegmentCount);
        }
        return this.myStarts[index];
    }

    public int getSegmentEnd(int index) {
        if (index < 0 || index >= this.mySegmentCount) {
            throw new IndexOutOfBoundsException("Wrong line: " + index + ". Available lines count: " + this.mySegmentCount);
        }
        return this.myEnds[index];
    }

    public int getSegmentCount() {
        return this.mySegmentCount;
    }
}

