/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.impl.ColorProvider;
import com.intellij.openapi.util.Computable;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Graphics;
import org.jetbrains.annotations.NotNull;

public class ArrowPainter {
    private final ColorProvider myColorHolder;
    private final Computable<Integer> myWidthProvider;
    private final Computable<Integer> myHeightProvider;

    public ArrowPainter(@NotNull ColorProvider colorHolder, @NotNull Computable<Integer> widthProvider, @NotNull Computable<Integer> heightProvider) {
        if (colorHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorHolder", "com/intellij/openapi/editor/impl/ArrowPainter", "<init>"));
        }
        if (widthProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "widthProvider", "com/intellij/openapi/editor/impl/ArrowPainter", "<init>"));
        }
        if (heightProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "heightProvider", "com/intellij/openapi/editor/impl/ArrowPainter", "<init>"));
        }
        this.myColorHolder = colorHolder;
        this.myWidthProvider = widthProvider;
        this.myHeightProvider = heightProvider;
    }

    public void paint(Graphics g2, int y2, int start2, int stop2) {
        stop2 -= (Integer)this.myWidthProvider.compute() / 4;
        Color oldColor = g2.getColor();
        g2.setColor(this.myColorHolder.getColor());
        int height = (Integer)this.myHeightProvider.compute();
        int halfHeight = height / 2;
        int mid = y2 - halfHeight;
        int top = y2 - height;
        UIUtil.drawLine((Graphics)g2, (int)start2, (int)mid, (int)stop2, (int)mid);
        UIUtil.drawLine((Graphics)g2, (int)stop2, (int)y2, (int)stop2, (int)top);
        g2.fillPolygon(new int[]{stop2 - halfHeight, stop2 - halfHeight, stop2}, new int[]{y2, y2 - height, y2 - halfHeight}, 3);
        g2.setColor(oldColor);
    }
}

