/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import java.awt.Point;
import java.awt.Rectangle;
import org.jetbrains.annotations.NotNull;

public class ClipDetector {
    private final EditorImpl myEditor;
    private final Rectangle myClipRectangle;
    private int myVisualLineStartOffset;
    private int myVisualLineEndOffset;
    private int myVisualLineClipStartOffset;
    private int myVisualLineClipEndOffset;

    public ClipDetector(@NotNull EditorImpl editor, Rectangle clipRectangle) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/impl/ClipDetector", "<init>"));
        }
        this.myVisualLineStartOffset = -1;
        this.myVisualLineEndOffset = -1;
        this.myEditor = editor;
        this.myClipRectangle = clipRectangle;
    }

    public boolean rangeCanBeVisible(int startOffset, int endOffset) {
        assert (startOffset >= 0);
        assert (startOffset <= endOffset);
        assert (endOffset <= this.myEditor.getDocument().getTextLength());
        if (this.myEditor.getSettings().isUseSoftWraps()) {
            return true;
        }
        if (startOffset < this.myVisualLineStartOffset || startOffset > this.myVisualLineEndOffset) {
            this.myVisualLineStartOffset = EditorUtil.getNotFoldedLineStartOffset(this.myEditor, startOffset);
            this.myVisualLineEndOffset = EditorUtil.getNotFoldedLineEndOffset(this.myEditor, startOffset);
            int visualLine = this.myEditor.offsetToVisualLine(startOffset);
            int y2 = this.myEditor.visibleLineToY(visualLine);
            this.myVisualLineClipStartOffset = this.myEditor.logicalPositionToOffset(this.myEditor.xyToLogicalPosition(new Point(this.myClipRectangle.x, y2)));
            this.myVisualLineClipEndOffset = this.myEditor.logicalPositionToOffset(this.myEditor.xyToLogicalPosition(new Point(this.myClipRectangle.x + this.myClipRectangle.width, y2)));
        }
        return endOffset > this.myVisualLineEndOffset || startOffset <= this.myVisualLineClipEndOffset && endOffset >= this.myVisualLineClipStartOffset;
    }
}

