/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.ActionPlan;
import com.intellij.util.text.ImmutableCharSequence;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class EditorActionPlan
implements ActionPlan {
    private ImmutableCharSequence myText;
    private final Editor myEditor;
    private int myCaretOffset;
    private final List<Replacement> myReplacements;

    EditorActionPlan(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/impl/EditorActionPlan", "<init>"));
        }
        this.myReplacements = new ArrayList<Replacement>();
        this.myEditor = editor;
        this.myText = (ImmutableCharSequence)editor.getDocument().getImmutableCharSequence();
        this.myCaretOffset = editor.getCaretModel().getOffset();
    }

    @NotNull
    public ImmutableCharSequence getText() {
        ImmutableCharSequence immutableCharSequence = this.myText;
        if (immutableCharSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorActionPlan", "getText"));
        }
        return immutableCharSequence;
    }

    public void replace(int begin, int end, String s2) {
        this.myText = this.myText.delete(begin, end).insert(begin, (CharSequence)s2);
        this.myReplacements.add(new Replacement(begin, end, s2));
        if (this.myCaretOffset == end) {
            this.myCaretOffset += s2.length() - (end - begin);
        }
    }

    public int getCaretOffset() {
        return this.myCaretOffset;
    }

    public void setCaretOffset(int offset) {
        this.myCaretOffset = offset;
    }

    public List<Replacement> getReplacements() {
        return Collections.unmodifiableList(this.myReplacements);
    }

    public int getCaretShift() {
        return this.myCaretOffset - this.myEditor.getCaretModel().getOffset();
    }

    static class Replacement {
        private final int myBegin;
        private final int myEnd;
        private final String myText;

        Replacement(int begin, int end, String text2) {
            this.myBegin = begin;
            this.myEnd = end;
            this.myText = text2;
        }

        public int getBegin() {
            return this.myBegin;
        }

        public int getEnd() {
            return this.myEnd;
        }

        public String getText() {
            return this.myText;
        }
    }
}

