/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityStateListener;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.components.ApplicationComponentAdapter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.actionSystem.ActionPlan;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.TypedAction;
import com.intellij.openapi.editor.actionSystem.TypedActionHandler;
import com.intellij.openapi.editor.actionSystem.TypedActionHandlerEx;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.event.EditorEventMulticasterImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.impl.ProjectLifecycleListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.text.CharArrayCharSequence;
import java.util.EventListener;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class EditorFactoryImpl
extends EditorFactory
implements ApplicationComponentAdapter {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.impl.EditorFactoryImpl");
    private final EditorEventMulticasterImpl myEditorEventMulticaster = new EditorEventMulticasterImpl();
    private final EventDispatcher<EditorFactoryListener> myEditorFactoryEventDispatcher = EventDispatcher.create(EditorFactoryListener.class);
    private final List<Editor> myEditors = ContainerUtil.createLockFreeCopyOnWriteList();

    public EditorFactoryImpl(EditorActionManager editorActionManager) {
        Application application = ApplicationManager.getApplication();
        MessageBus bus = application.getMessageBus();
        MessageBusConnection connect = bus.connect();
        connect.subscribe(ProjectLifecycleListener.TOPIC, (Object)new ProjectLifecycleListener(){

            public void beforeProjectLoaded(@NotNull Project project2) {
                if (project2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/editor/impl/EditorFactoryImpl$1", "beforeProjectLoaded"));
                }
                Disposer.register((Disposable)project2, () -> {
                    if (project2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/editor/impl/EditorFactoryImpl$1", "lambda$beforeProjectLoaded$0"));
                    }
                    Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
                    boolean isLastProjectClosed = openProjects.length == 0;
                    EditorFactoryImpl.this.validateEditorsAreReleased(project2, isLastProjectClosed);
                });
            }
        });
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(EditorColorsManager.TOPIC, (Object)new EditorColorsListener(){

            public void globalSchemeChange(EditorColorsScheme scheme2) {
                EditorFactoryImpl.this.refreshAllEditors();
            }
        });
        TypedAction typedAction = editorActionManager.getTypedAction();
        TypedActionHandler originalHandler = typedAction.getRawHandler();
        typedAction.setupRawHandler((TypedActionHandler)new MyTypedHandler(originalHandler));
    }

    public void initComponent() {
        ModalityStateListener myModalityStateListener = entering -> {
            for (Editor editor : this.myEditors) {
                ((EditorImpl)editor).beforeModalityStateChanged();
            }
        };
        LaterInvocator.addModalityStateListener(myModalityStateListener, (Disposable)ApplicationManager.getApplication());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateEditorsAreReleased(Project project2, boolean isLastProjectClosed) {
        for (Editor editor : this.myEditors) {
            if (editor.getProject() != project2 && (editor.getProject() != null || !isLastProjectClosed)) continue;
            try {
                EditorFactoryImpl.throwNotReleasedError(editor);
            }
            finally {
                this.releaseEditor(editor);
            }
        }
    }

    @NonNls
    public static void throwNotReleasedError(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/impl/EditorFactoryImpl", "throwNotReleasedError"));
        }
        if (!(editor instanceof EditorImpl)) {
            throw new RuntimeException("Editor of " + editor.getClass() + " and the following text hasn't been released:\n" + editor.getDocument().getText());
        }
        ((EditorImpl)editor).throwEditorNotDisposedError("Editor of " + editor.getClass() + " hasn't been released:");
    }

    @NotNull
    public Document createDocument(@NotNull char[] text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/impl/EditorFactoryImpl", "createDocument"));
        }
        Document document = this.createDocument((CharSequence)new CharArrayCharSequence(text2));
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorFactoryImpl", "createDocument"));
        }
        return document;
    }

    @NotNull
    public Document createDocument(@NotNull CharSequence text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/impl/EditorFactoryImpl", "createDocument"));
        }
        DocumentImpl document = new DocumentImpl(text2);
        this.myEditorEventMulticaster.registerDocument(document);
        DocumentImpl documentImpl = document;
        if (documentImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorFactoryImpl", "createDocument"));
        }
        return documentImpl;
    }

    @NotNull
    public Document createDocument(boolean allowUpdatesWithoutWriteAction) {
        DocumentImpl document = new DocumentImpl("", allowUpdatesWithoutWriteAction);
        this.myEditorEventMulticaster.registerDocument(document);
        DocumentImpl documentImpl = document;
        if (documentImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorFactoryImpl", "createDocument"));
        }
        return documentImpl;
    }

    @NotNull
    public Document createDocument(@NotNull CharSequence text2, boolean acceptsSlashR, boolean allowUpdatesWithoutWriteAction) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/impl/EditorFactoryImpl", "createDocument"));
        }
        DocumentImpl document = new DocumentImpl(text2, acceptsSlashR, allowUpdatesWithoutWriteAction);
        this.myEditorEventMulticaster.registerDocument(document);
        DocumentImpl documentImpl = document;
        if (documentImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorFactoryImpl", "createDocument"));
        }
        return documentImpl;
    }

    public void refreshAllEditors() {
        for (Editor editor : this.myEditors) {
            ((EditorEx)editor).reinitSettings();
        }
    }

    public Editor createEditor(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/EditorFactoryImpl", "createEditor"));
        }
        return this.createEditor(document, false, null);
    }

    public Editor createViewer(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/EditorFactoryImpl", "createViewer"));
        }
        return this.createEditor(document, true, null);
    }

    public Editor createEditor(@NotNull Document document, Project project2) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/EditorFactoryImpl", "createEditor"));
        }
        return this.createEditor(document, false, project2);
    }

    public Editor createViewer(@NotNull Document document, Project project2) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/EditorFactoryImpl", "createViewer"));
        }
        return this.createEditor(document, true, project2);
    }

    public Editor createEditor(@NotNull Document document, Project project2, @NotNull FileType fileType, boolean isViewer) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/EditorFactoryImpl", "createEditor"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/openapi/editor/impl/EditorFactoryImpl", "createEditor"));
        }
        Editor editor = this.createEditor(document, isViewer, project2);
        ((EditorEx)editor).setHighlighter(EditorHighlighterFactory.getInstance().createEditorHighlighter(project2, fileType));
        return editor;
    }

    public Editor createEditor(@NotNull Document document, Project project2, @NotNull VirtualFile file2, boolean isViewer) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/EditorFactoryImpl", "createEditor"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/editor/impl/EditorFactoryImpl", "createEditor"));
        }
        Editor editor = this.createEditor(document, isViewer, project2);
        ((EditorEx)editor).setHighlighter(EditorHighlighterFactory.getInstance().createEditorHighlighter(project2, file2));
        return editor;
    }

    private Editor createEditor(@NotNull Document document, boolean isViewer, Project project2) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/EditorFactoryImpl", "createEditor"));
        }
        Document hostDocument = document instanceof DocumentWindow ? ((DocumentWindow)document).getDelegate() : document;
        EditorImpl editor = new EditorImpl(hostDocument, isViewer, project2);
        this.myEditors.add(editor);
        this.myEditorEventMulticaster.registerEditor(editor);
        ((EditorFactoryListener)this.myEditorFactoryEventDispatcher.getMulticaster()).editorCreated(new EditorFactoryEvent((EditorFactory)this, (Editor)editor));
        if (LOG.isDebugEnabled()) {
            LOG.debug("number of Editors after create: " + this.myEditors.size());
        }
        return editor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseEditor(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/impl/EditorFactoryImpl", "releaseEditor"));
        }
        try {
            ((EditorFactoryListener)this.myEditorFactoryEventDispatcher.getMulticaster()).editorReleased(new EditorFactoryEvent((EditorFactory)this, editor));
        }
        finally {
            try {
                ((EditorImpl)editor).release();
            }
            finally {
                this.myEditors.remove(editor);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("number of Editors after release: " + this.myEditors.size());
                }
            }
        }
    }

    @NotNull
    public Editor[] getEditors(@NotNull Document document, Project project2) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/EditorFactoryImpl", "getEditors"));
        }
        List list2 = null;
        for (Editor editor : this.myEditors) {
            Project project1 = editor.getProject();
            if (!editor.getDocument().equals(document) || project2 != null && project1 != null && !project1.equals(project2)) continue;
            if (list2 == null) {
                list2 = new SmartList();
            }
            list2.add(editor);
        }
        Editor[] editorArray = list2 == null ? Editor.EMPTY_ARRAY : list2.toArray(new Editor[list2.size()]);
        if (editorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorFactoryImpl", "getEditors"));
        }
        return editorArray;
    }

    @NotNull
    public Editor[] getEditors(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/EditorFactoryImpl", "getEditors"));
        }
        Editor[] editorArray = this.getEditors(document, null);
        if (editorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorFactoryImpl", "getEditors"));
        }
        return editorArray;
    }

    @NotNull
    public Editor[] getAllEditors() {
        Editor[] editorArray = (Editor[])ArrayUtil.stripTrailingNulls((Object[])this.myEditors.toArray(new Editor[this.myEditors.size()]));
        if (editorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorFactoryImpl", "getAllEditors"));
        }
        return editorArray;
    }

    @Deprecated
    public void addEditorFactoryListener(@NotNull EditorFactoryListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/EditorFactoryImpl", "addEditorFactoryListener"));
        }
        this.myEditorFactoryEventDispatcher.addListener((EventListener)listener2);
    }

    public void addEditorFactoryListener(@NotNull EditorFactoryListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/EditorFactoryImpl", "addEditorFactoryListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/editor/impl/EditorFactoryImpl", "addEditorFactoryListener"));
        }
        this.myEditorFactoryEventDispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    @Deprecated
    public void removeEditorFactoryListener(@NotNull EditorFactoryListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/EditorFactoryImpl", "removeEditorFactoryListener"));
        }
        this.myEditorFactoryEventDispatcher.removeListener((EventListener)listener2);
    }

    @NotNull
    public EditorEventMulticaster getEventMulticaster() {
        EditorEventMulticasterImpl editorEventMulticasterImpl = this.myEditorEventMulticaster;
        if (editorEventMulticasterImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorFactoryImpl", "getEventMulticaster"));
        }
        return editorEventMulticasterImpl;
    }

    private static class MyTypedHandler
    implements TypedActionHandlerEx {
        private final TypedActionHandler myDelegate;

        private MyTypedHandler(TypedActionHandler delegate2) {
            this.myDelegate = delegate2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(@NotNull Editor editor, char charTyped, @NotNull DataContext dataContext) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/impl/EditorFactoryImpl$MyTypedHandler", "execute"));
            }
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/openapi/editor/impl/EditorFactoryImpl$MyTypedHandler", "execute"));
            }
            editor.putUserData(EditorImpl.DISABLE_CARET_SHIFT_ON_WHITESPACE_INSERTION, (Object)Boolean.TRUE);
            try {
                this.myDelegate.execute(editor, charTyped, dataContext);
            }
            finally {
                editor.putUserData(EditorImpl.DISABLE_CARET_SHIFT_ON_WHITESPACE_INSERTION, null);
            }
        }

        public void beforeExecute(@NotNull Editor editor, char c2, @NotNull DataContext context2, @NotNull ActionPlan plan) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/impl/EditorFactoryImpl$MyTypedHandler", "beforeExecute"));
            }
            if (context2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/editor/impl/EditorFactoryImpl$MyTypedHandler", "beforeExecute"));
            }
            if (plan == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "plan", "com/intellij/openapi/editor/impl/EditorFactoryImpl$MyTypedHandler", "beforeExecute"));
            }
            if (this.myDelegate instanceof TypedActionHandlerEx) {
                ((TypedActionHandlerEx)this.myDelegate).beforeExecute(editor, c2, context2, plan);
            }
        }
    }
}

