/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.MarkupIterator;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.util.Consumer;
import com.intellij.util.FilteringProcessor;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteringIterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorFilteringMarkupModelEx
implements MarkupModelEx {
    @NotNull
    private final EditorImpl myEditor;
    @NotNull
    private final MarkupModelEx myDelegate;
    private final Condition<RangeHighlighter> IS_AVAILABLE;

    public EditorFilteringMarkupModelEx(@NotNull EditorImpl editor, @NotNull MarkupModelEx delegate2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/impl/EditorFilteringMarkupModelEx", "<init>"));
        }
        if (delegate2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/openapi/editor/impl/EditorFilteringMarkupModelEx", "<init>"));
        }
        this.IS_AVAILABLE = highlighter2 -> this.isAvailable((RangeHighlighter)highlighter2);
        this.myEditor = editor;
        this.myDelegate = delegate2;
    }

    @NotNull
    public MarkupModelEx getDelegate() {
        MarkupModelEx markupModelEx = this.myDelegate;
        if (markupModelEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorFilteringMarkupModelEx", "getDelegate"));
        }
        return markupModelEx;
    }

    private boolean isAvailable(@NotNull RangeHighlighter highlighter2) {
        if (highlighter2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/openapi/editor/impl/EditorFilteringMarkupModelEx", "isAvailable"));
        }
        return highlighter2.getEditorFilter().avaliableIn((Editor)this.myEditor) && this.myEditor.isHighlighterAvailable(highlighter2);
    }

    @Override
    public boolean containsHighlighter(@NotNull RangeHighlighter highlighter2) {
        if (highlighter2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/openapi/editor/impl/EditorFilteringMarkupModelEx", "containsHighlighter"));
        }
        return this.isAvailable(highlighter2) && this.myDelegate.containsHighlighter(highlighter2);
    }

    @Override
    public boolean processRangeHighlightersOverlappingWith(int start2, int end, @NotNull Processor<? super RangeHighlighterEx> processor2) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/editor/impl/EditorFilteringMarkupModelEx", "processRangeHighlightersOverlappingWith"));
        }
        FilteringProcessor filteringProcessor = new FilteringProcessor(this.IS_AVAILABLE, processor2);
        return this.myDelegate.processRangeHighlightersOverlappingWith(start2, end, (Processor<? super RangeHighlighterEx>)filteringProcessor);
    }

    @Override
    public boolean processRangeHighlightersOutside(int start2, int end, @NotNull Processor<? super RangeHighlighterEx> processor2) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/editor/impl/EditorFilteringMarkupModelEx", "processRangeHighlightersOutside"));
        }
        FilteringProcessor filteringProcessor = new FilteringProcessor(this.IS_AVAILABLE, processor2);
        return this.myDelegate.processRangeHighlightersOutside(start2, end, (Processor<? super RangeHighlighterEx>)filteringProcessor);
    }

    @Override
    @NotNull
    public MarkupIterator<RangeHighlighterEx> overlappingIterator(int startOffset, int endOffset) {
        MyFilteringIterator myFilteringIterator = new MyFilteringIterator(this.myDelegate.overlappingIterator(startOffset, endOffset));
        if (myFilteringIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorFilteringMarkupModelEx", "overlappingIterator"));
        }
        return myFilteringIterator;
    }

    @NotNull
    public RangeHighlighter[] getAllHighlighters() {
        List list2 = ContainerUtil.filter((Object[])this.myDelegate.getAllHighlighters(), this.IS_AVAILABLE);
        RangeHighlighter[] rangeHighlighterArray = list2.toArray(new RangeHighlighter[list2.size()]);
        if (rangeHighlighterArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorFilteringMarkupModelEx", "getAllHighlighters"));
        }
        return rangeHighlighterArray;
    }

    @Override
    public void dispose() {
    }

    @NotNull
    public Document getDocument() {
        Document document = this.myDelegate.getDocument();
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorFilteringMarkupModelEx", "getDocument"));
        }
        return document;
    }

    @Override
    public void addMarkupModelListener(@NotNull Disposable parentDisposable, @NotNull MarkupModelListener listener2) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/editor/impl/EditorFilteringMarkupModelEx", "addMarkupModelListener"));
        }
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/EditorFilteringMarkupModelEx", "addMarkupModelListener"));
        }
        this.myDelegate.addMarkupModelListener(parentDisposable, listener2);
    }

    @Override
    public void fireAttributesChanged(@NotNull RangeHighlighterEx segmentHighlighter, boolean renderersChanged, boolean fontStyleOrColorChanged) {
        if (segmentHighlighter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "segmentHighlighter", "com/intellij/openapi/editor/impl/EditorFilteringMarkupModelEx", "fireAttributesChanged"));
        }
        this.myDelegate.fireAttributesChanged(segmentHighlighter, renderersChanged, fontStyleOrColorChanged);
    }

    @Override
    public void fireAfterAdded(@NotNull RangeHighlighterEx segmentHighlighter) {
        if (segmentHighlighter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "segmentHighlighter", "com/intellij/openapi/editor/impl/EditorFilteringMarkupModelEx", "fireAfterAdded"));
        }
        this.myDelegate.fireAfterAdded(segmentHighlighter);
    }

    @Override
    public void fireBeforeRemoved(@NotNull RangeHighlighterEx segmentHighlighter) {
        if (segmentHighlighter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "segmentHighlighter", "com/intellij/openapi/editor/impl/EditorFilteringMarkupModelEx", "fireBeforeRemoved"));
        }
        this.myDelegate.fireBeforeRemoved(segmentHighlighter);
    }

    @Override
    @Nullable
    public RangeHighlighterEx addPersistentLineHighlighter(int lineNumber, int layer, TextAttributes textAttributes) {
        return this.myDelegate.addPersistentLineHighlighter(lineNumber, layer, textAttributes);
    }

    @Override
    public void addRangeHighlighter(@NotNull RangeHighlighterEx marker, int start2, int end, boolean greedyToLeft, boolean greedyToRight, int layer) {
        if (marker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "marker", "com/intellij/openapi/editor/impl/EditorFilteringMarkupModelEx", "addRangeHighlighter"));
        }
        this.myDelegate.addRangeHighlighter(marker, start2, end, greedyToLeft, greedyToRight, layer);
    }

    @NotNull
    public RangeHighlighter addRangeHighlighter(int startOffset, int endOffset, int layer, @Nullable TextAttributes textAttributes, @NotNull HighlighterTargetArea targetArea) {
        if (targetArea == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetArea", "com/intellij/openapi/editor/impl/EditorFilteringMarkupModelEx", "addRangeHighlighter"));
        }
        RangeHighlighter rangeHighlighter = this.myDelegate.addRangeHighlighter(startOffset, endOffset, layer, textAttributes, targetArea);
        if (rangeHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorFilteringMarkupModelEx", "addRangeHighlighter"));
        }
        return rangeHighlighter;
    }

    @NotNull
    public RangeHighlighter addLineHighlighter(int line, int layer, @Nullable TextAttributes textAttributes) {
        RangeHighlighter rangeHighlighter = this.myDelegate.addLineHighlighter(line, layer, textAttributes);
        if (rangeHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorFilteringMarkupModelEx", "addLineHighlighter"));
        }
        return rangeHighlighter;
    }

    @Override
    @NotNull
    public RangeHighlighterEx addRangeHighlighterAndChangeAttributes(int startOffset, int endOffset, int layer, TextAttributes textAttributes, @NotNull HighlighterTargetArea targetArea, boolean isPersistent, Consumer<RangeHighlighterEx> changeAttributesAction) {
        if (targetArea == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetArea", "com/intellij/openapi/editor/impl/EditorFilteringMarkupModelEx", "addRangeHighlighterAndChangeAttributes"));
        }
        RangeHighlighterEx rangeHighlighterEx = this.myDelegate.addRangeHighlighterAndChangeAttributes(startOffset, endOffset, layer, textAttributes, targetArea, isPersistent, changeAttributesAction);
        if (rangeHighlighterEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorFilteringMarkupModelEx", "addRangeHighlighterAndChangeAttributes"));
        }
        return rangeHighlighterEx;
    }

    @Override
    public void setRangeHighlighterAttributes(@NotNull RangeHighlighter highlighter2, @NotNull TextAttributes textAttributes) {
        if (highlighter2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/openapi/editor/impl/EditorFilteringMarkupModelEx", "setRangeHighlighterAttributes"));
        }
        if (textAttributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textAttributes", "com/intellij/openapi/editor/impl/EditorFilteringMarkupModelEx", "setRangeHighlighterAttributes"));
        }
        this.myDelegate.setRangeHighlighterAttributes(highlighter2, textAttributes);
    }

    @Override
    public void changeAttributesInBatch(@NotNull RangeHighlighterEx highlighter2, @NotNull Consumer<RangeHighlighterEx> changeAttributesAction) {
        if (highlighter2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/openapi/editor/impl/EditorFilteringMarkupModelEx", "changeAttributesInBatch"));
        }
        if (changeAttributesAction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeAttributesAction", "com/intellij/openapi/editor/impl/EditorFilteringMarkupModelEx", "changeAttributesInBatch"));
        }
        this.myDelegate.changeAttributesInBatch(highlighter2, changeAttributesAction);
    }

    public void removeHighlighter(@NotNull RangeHighlighter rangeHighlighter) {
        if (rangeHighlighter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeHighlighter", "com/intellij/openapi/editor/impl/EditorFilteringMarkupModelEx", "removeHighlighter"));
        }
        this.myDelegate.removeHighlighter(rangeHighlighter);
    }

    public void removeAllHighlighters() {
        this.myDelegate.removeAllHighlighters();
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/editor/impl/EditorFilteringMarkupModelEx", "getUserData"));
        }
        return (T)this.myDelegate.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value2) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/editor/impl/EditorFilteringMarkupModelEx", "putUserData"));
        }
        this.myDelegate.putUserData(key, value2);
    }

    private class MyFilteringIterator
    extends FilteringIterator<RangeHighlighterEx, RangeHighlighterEx>
    implements MarkupIterator<RangeHighlighterEx> {
        private MarkupIterator<RangeHighlighterEx> myDelegate;

        public MyFilteringIterator(MarkupIterator<RangeHighlighterEx> delegate2) {
            if (delegate2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/openapi/editor/impl/EditorFilteringMarkupModelEx$MyFilteringIterator", "<init>"));
            }
            super(delegate2, EditorFilteringMarkupModelEx.this.IS_AVAILABLE);
            this.myDelegate = delegate2;
        }

        @Override
        public void dispose() {
            this.myDelegate.dispose();
        }
    }
}

