/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.codeInsight.hint.TooltipController;
import com.intellij.codeInsight.hint.TooltipGroup;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDImage;
import com.intellij.ide.dnd.DnDNativeTarget;
import com.intellij.ide.dnd.DnDSupport;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.editor.EditorGutterAction;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.editor.GutterMarkPreprocessor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.TextAnnotationGutterProvider;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.ex.MarkupIterator;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.util.EditorUIUtil;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.DisplayedFoldingAnchor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FoldingAnchorsOverlayStrategy;
import com.intellij.openapi.editor.impl.view.IterationState;
import com.intellij.openapi.editor.impl.view.VisualLinesIterator;
import com.intellij.openapi.editor.markup.ActiveGutterRenderer;
import com.intellij.openapi.editor.markup.GutterDraggableObject;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.LineMarkerRendererEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import com.intellij.ui.HintHint;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.BitUtil;
import com.intellij.util.Function;
import com.intellij.util.IconUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntFunction;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ComponentEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class EditorGutterComponentImpl
extends EditorGutterComponentEx
implements MouseListener,
MouseMotionListener,
DataProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.impl.EditorGutterComponentImpl");
    private static final int START_ICON_AREA_WIDTH = JBUI.scale((int)17);
    private static final int FREE_PAINTERS_LEFT_AREA_WIDTH = JBUI.scale((int)8);
    private static final int FREE_PAINTERS_RIGHT_AREA_WIDTH = JBUI.scale((int)5);
    private static final int GAP_BETWEEN_ICONS = JBUI.scale((int)3);
    private static final int GAP_BETWEEN_AREAS = JBUI.scale((int)5);
    private static final int GAP_BETWEEN_ANNOTATIONS = JBUI.scale((int)5);
    private static final TooltipGroup GUTTER_TOOLTIP_GROUP = new TooltipGroup("GUTTER_TOOLTIP_GROUP", 0);
    private final EditorImpl myEditor;
    private final FoldingAnchorsOverlayStrategy myAnchorsDisplayStrategy;
    @Nullable
    private TIntObjectHashMap<List<GutterMark>> myLineToGutterRenderers;
    private int myStartIconAreaWidth;
    private int myIconsAreaWidth;
    private int myLineNumberAreaWidth;
    private int myAdditionalLineNumberAreaWidth;
    private FoldRegion myActiveFoldRegion;
    private int myTextAnnotationGuttersSize;
    private int myTextAnnotationExtraSize;
    private TIntArrayList myTextAnnotationGutterSizes;
    private ArrayList<TextAnnotationGutterProvider> myTextAnnotationGutters;
    private final Map<TextAnnotationGutterProvider, EditorGutterAction> myProviderToListener;
    private String myLastGutterToolTip;
    @NotNull
    private TIntFunction myLineNumberConvertor;
    @Nullable
    private TIntFunction myAdditionalLineNumberConvertor;
    private boolean myShowDefaultGutterPopup;
    @Nullable
    private ActionGroup myCustomGutterPopupGroup;
    private final TIntObjectHashMap<Color> myTextFgColors;
    private boolean myPaintBackground;
    private boolean myLeftFreePaintersAreaShown;
    private boolean myRightFreePaintersAreaShown;
    private boolean myForceLeftFreePaintersAreaShown;
    private boolean myForceRightFreePaintersAreaShown;
    private int myLastNonDumbModeIconAreaWidth;
    boolean myDnDInProgress;

    EditorGutterComponentImpl(@NotNull EditorImpl editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/impl/EditorGutterComponentImpl", "<init>"));
        }
        this.myStartIconAreaWidth = START_ICON_AREA_WIDTH;
        this.myTextAnnotationGutterSizes = new TIntArrayList();
        this.myTextAnnotationGutters = new ArrayList();
        this.myProviderToListener = new HashMap();
        this.myLineNumberConvertor = value2 -> value2;
        this.myShowDefaultGutterPopup = true;
        this.myTextFgColors = new TIntObjectHashMap();
        this.myPaintBackground = true;
        this.myEditor = editor;
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            this.installDnD();
        }
        this.setOpaque(true);
        this.myAnchorsDisplayStrategy = new FoldingAnchorsOverlayStrategy(editor);
        Project project2 = this.myEditor.getProject();
        if (project2 != null) {
            project2.getMessageBus().connect(this.myEditor.getDisposable()).subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

                public void enteredDumbMode() {
                }

                public void exitDumbMode() {
                    EditorGutterComponentImpl.this.updateSize();
                }
            });
        }
    }

    private void installDnD() {
        DnDSupport.createBuilder((JComponent)this).setBeanProvider(info -> {
            GutterMark renderer = this.getGutterRenderer(info.getPoint());
            if (renderer instanceof GutterIconRenderer && ((GutterIconRenderer)renderer).getDraggableObject() != null && (info.isCopy() || info.isMove())) {
                this.myDnDInProgress = true;
                return new DnDDragStartBean((Object)renderer);
            }
            return null;
        }).setDropHandler(e2 -> {
            Transferable transferable;
            Object attachedObject = e2.getAttachedObject();
            if (attachedObject instanceof GutterIconRenderer && this.checkDumbAware(attachedObject)) {
                int line;
                GutterDraggableObject draggableObject = ((GutterIconRenderer)attachedObject).getDraggableObject();
                if (draggableObject != null && (line = this.convertPointToLineNumber(e2.getPoint())) != -1) {
                    draggableObject.copy(line, this.myEditor.getVirtualFile());
                }
            } else if (attachedObject instanceof DnDNativeTarget.EventInfo && this.myEditor.getSettings().isDndEnabled() && (transferable = ((DnDNativeTarget.EventInfo)attachedObject).getTransferable()) != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                EditorImpl.handleDrop(this.myEditor, transferable);
            }
            this.myDnDInProgress = false;
        }).setTargetChecker(e2 -> {
            int line;
            Transferable transferable;
            Object attachedObject = e2.getAttachedObject();
            if (attachedObject instanceof GutterIconRenderer && this.checkDumbAware(attachedObject)) {
                int line2;
                GutterDraggableObject draggableObject = ((GutterIconRenderer)attachedObject).getDraggableObject();
                if (draggableObject != null && (line2 = this.convertPointToLineNumber(e2.getPoint())) != -1) {
                    e2.setDropPossible(true);
                    e2.setCursor(draggableObject.getCursor(line2));
                }
            } else if (attachedObject instanceof DnDNativeTarget.EventInfo && this.myEditor.getSettings().isDndEnabled() && (transferable = ((DnDNativeTarget.EventInfo)attachedObject).getTransferable()) != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor) && (line = this.convertPointToLineNumber(e2.getPoint())) != -1) {
                e2.setDropPossible(true);
                this.myEditor.getCaretModel().moveToOffset(this.myEditor.getDocument().getLineStartOffset(line));
            }
            return true;
        }).setImageProvider((Function)((NullableFunction)info -> {
            boolean inUserScale = SystemInfo.isWindows ? !UIUtil.isJreHiDPI((Component)this.myEditor.getComponent()) : true;
            BufferedImage image = ImageUtil.toBufferedImage((Image)this.getDragImage(this.getGutterRenderer(info.getPoint())), (boolean)inUserScale);
            return new DnDImage((Image)image, new Point(((Image)image).getWidth(null) / 2, ((Image)image).getHeight(null) / 2));
        })).enableAsNativeTarget().install();
    }

    Image getDragImage(GutterMark renderer) {
        return IconUtil.toImage((Icon)this.scaleIcon(renderer.getIcon()));
    }

    private void fireResized() {
        this.processComponentEvent(new ComponentEvent(this, 101));
    }

    @Override
    public Dimension getPreferredSize() {
        int w2 = this.getFoldingAreaOffset() + this.getFoldingAreaWidth();
        Dimension size = new Dimension(w2, this.myEditor.getPreferredHeight());
        JBInsets.addTo((Dimension)size, (Insets)this.getInsets());
        return size;
    }

    @Override
    protected void setUI(ComponentUI newUI) {
        super.setUI(newUI);
        this.reinitSettings();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.reinitSettings();
    }

    public void reinitSettings() {
        this.updateSize(false, true);
        this.repaint();
    }

    @Override
    protected Graphics getComponentGraphics(Graphics graphics) {
        return JBSwingUtilities.runGlobalCGTransform((JComponent)this, (Graphics)super.getComponentGraphics(graphics));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g_) {
        ((ApplicationImpl)ApplicationManager.getApplication()).editorPaintStart();
        try {
            Rectangle clip = g_.getClipBounds();
            if (clip.height < 0) {
                return;
            }
            Graphics2D g2 = (Graphics2D)this.getComponentGraphics(g_);
            AffineTransform old = this.setMirrorTransformIfNeeded(g2, 0, this.getWidth());
            EditorUIUtil.setupAntialiasing(g2);
            Color backgroundColor = this.getBackground();
            if (this.myEditor.isDisposed()) {
                g2.setColor(this.myEditor.getDisposedBackground());
                g2.fillRect(clip.x, clip.y, clip.width, clip.height);
                return;
            }
            int startVisualLine = this.myEditor.yToVisibleLine(clip.y);
            int endVisualLine = this.myEditor.yToVisibleLine(clip.y + clip.height);
            int gutterSeparatorX = this.getWhitespaceSeparatorOffset();
            this.paintBackground(g2, clip, 0, gutterSeparatorX, backgroundColor);
            this.paintBackground(g2, clip, gutterSeparatorX, this.getFoldingAreaWidth(), this.myEditor.getBackgroundColor());
            int firstVisibleOffset = this.myEditor.visualLineStartOffset(startVisualLine);
            int lastVisibleOffset = this.myEditor.visualLineStartOffset(endVisualLine + 1);
            this.paintEditorBackgrounds(g2, firstVisibleOffset, lastVisibleOffset);
            Object hint = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            if (!UIUtil.isJreHiDPI((Graphics2D)g2)) {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
            try {
                this.paintAnnotations(g2, startVisualLine, endVisualLine);
                this.paintLineMarkers(g2, firstVisibleOffset, lastVisibleOffset);
                this.paintFoldingLines(g2, clip);
                this.paintFoldingTree(g2, clip, firstVisibleOffset, lastVisibleOffset);
                this.paintLineNumbers(g2, startVisualLine, endVisualLine);
            }
            finally {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, hint);
            }
            if (old != null) {
                g2.setTransform(old);
            }
        }
        finally {
            ((ApplicationImpl)ApplicationManager.getApplication()).editorPaintFinish();
        }
    }

    private void paintEditorBackgrounds(Graphics g2, int firstVisibleOffset, int lastVisibleOffset) {
        this.myTextFgColors.clear();
        Color defaultBackgroundColor = this.myEditor.getBackgroundColor();
        Color defaultForegroundColor = this.myEditor.getColorsScheme().getDefaultForeground();
        int startX = this.myEditor.isInDistractionFreeMode() ? 0 : this.getWhitespaceSeparatorOffset();
        IterationState state = new IterationState(this.myEditor, firstVisibleOffset, lastVisibleOffset, null, true, false, true, false);
        while (!state.atEnd()) {
            this.drawEditorBackgroundForRange(g2, state.getStartOffset(), state.getEndOffset(), state.getMergedAttributes(), defaultBackgroundColor, defaultForegroundColor, startX);
            state.advance();
        }
    }

    private void drawEditorBackgroundForRange(Graphics g2, int startOffset, int endOffset, TextAttributes attributes, Color defaultBackgroundColor, Color defaultForegroundColor, int startX) {
        VisualPosition visualStart = this.myEditor.offsetToVisualPosition(startOffset, true, false);
        VisualPosition visualEnd = this.myEditor.offsetToVisualPosition(endOffset, false, false);
        for (int line = visualStart.getLine(); line <= visualEnd.getLine(); ++line) {
            if (line == visualStart.getLine()) {
                if (visualStart.getColumn() != 0) continue;
                this.drawEditorLineBackgroundRect(g2, attributes, line, defaultBackgroundColor, defaultForegroundColor, startX, this.myEditor.visibleLineToY(line));
                continue;
            }
            if (line == visualEnd.getLine() && visualEnd.getColumn() == 0) continue;
            this.drawEditorLineBackgroundRect(g2, attributes, line, defaultBackgroundColor, defaultForegroundColor, startX, this.myEditor.visibleLineToY(line));
        }
    }

    private void drawEditorLineBackgroundRect(Graphics g2, TextAttributes attributes, int visualLine, Color defaultBackgroundColor, Color defaultForegroundColor, int startX, int startY) {
        Color color = this.myEditor.getBackgroundColor(attributes);
        if (!Comparing.equal((Object)color, (Object)defaultBackgroundColor)) {
            Color fgColor = attributes.getForegroundColor();
            if (!Comparing.equal((Object)fgColor, (Object)defaultForegroundColor)) {
                this.myTextFgColors.put(visualLine, (Object)fgColor);
            }
            g2.setColor(color);
            g2.fillRect(startX, startY, this.getWidth() - startX, this.myEditor.getLineHeight());
        }
    }

    private void processClose(MouseEvent e2) {
        IdeEventQueue queue2 = IdeEventQueue.getInstance();
        if (this.getGutterRenderer(e2) != null) {
            return;
        }
        if (this.myEditor.getMouseEventArea(e2) == EditorMouseEventArea.ANNOTATIONS_AREA) {
            queue2.blockNextEvents(e2);
            this.closeAllAnnotations();
            e2.consume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintAnnotations(Graphics2D g2, int startVisualLine, int endVisualLine) {
        int x2 = this.getAnnotationsAreaOffset();
        int w2 = this.getAnnotationsAreaWidthEx();
        if (w2 == 0) {
            return;
        }
        AffineTransform old = this.setMirrorTransformIfNeeded(g2, x2, w2);
        try {
            Color color = this.myEditor.getColorsScheme().getColor(EditorColors.ANNOTATIONS_COLOR);
            g2.setColor(color != null ? color : JBColor.blue);
            g2.setFont(this.myEditor.getColorsScheme().getFont(EditorFontType.PLAIN));
            for (int i2 = 0; i2 < this.myTextAnnotationGutters.size(); ++i2) {
                TextAnnotationGutterProvider gutterProvider = this.myTextAnnotationGutters.get(i2);
                int lineHeight = this.myEditor.getLineHeight();
                int lastLine = this.myEditor.logicalToVisualPosition((LogicalPosition)new LogicalPosition((int)this.endLineNumber(), (int)0)).line;
                if (startVisualLine > (endVisualLine = Math.min(endVisualLine, lastLine))) {
                    break;
                }
                int annotationSize = this.myTextAnnotationGutterSizes.get(i2);
                VisualLinesIterator visLinesIterator = new VisualLinesIterator(this.myEditor, startVisualLine);
                while (!visLinesIterator.atEnd() && visLinesIterator.getVisualLine() <= endVisualLine) {
                    int logLine = visLinesIterator.getStartLogicalLine();
                    int y2 = visLinesIterator.getY();
                    String s2 = gutterProvider.getLineText(logLine, (Editor)this.myEditor);
                    EditorFontType style = gutterProvider.getStyle(logLine, (Editor)this.myEditor);
                    Color bg = gutterProvider.getBgColor(logLine, (Editor)this.myEditor);
                    if (bg != null) {
                        g2.setColor(bg);
                        g2.fillRect(x2, y2, annotationSize, lineHeight);
                    }
                    g2.setColor(this.myEditor.getColorsScheme().getColor(gutterProvider.getColor(logLine, (Editor)this.myEditor)));
                    g2.setFont(this.myEditor.getColorsScheme().getFont(style));
                    if (!StringUtil.isEmpty((String)s2)) {
                        g2.drawString(s2, GAP_BETWEEN_ANNOTATIONS / 2 + x2, y2 + this.myEditor.getAscent());
                    }
                    visLinesIterator.advance();
                }
                if (startVisualLine == 0 && endVisualLine == 0) {
                    String s3 = gutterProvider.getLineText(0, (Editor)this.myEditor);
                    EditorFontType style = gutterProvider.getStyle(0, (Editor)this.myEditor);
                    Color bg = gutterProvider.getBgColor(0, (Editor)this.myEditor);
                    if (bg != null) {
                        g2.setColor(bg);
                        g2.fillRect(x2, 0, annotationSize, lineHeight);
                    }
                    g2.setColor(this.myEditor.getColorsScheme().getColor(gutterProvider.getColor(0, (Editor)this.myEditor)));
                    g2.setFont(this.myEditor.getColorsScheme().getFont(style));
                    if (!StringUtil.isEmpty((String)s3)) {
                        g2.drawString(s3, GAP_BETWEEN_ANNOTATIONS / 2 + x2, this.myEditor.getAscent());
                    }
                }
                x2 += annotationSize;
            }
        }
        finally {
            if (old != null) {
                g2.setTransform(old);
            }
        }
    }

    private void paintFoldingTree(Graphics g2, Rectangle clip, int firstVisibleOffset, int lastVisibleOffset) {
        if (this.isFoldingOutlineShown()) {
            this.doPaintFoldingTree((Graphics2D)g2, clip, firstVisibleOffset, lastVisibleOffset);
        }
    }

    private void paintLineMarkers(Graphics2D g2, int firstVisibleOffset, int lastVisibleOffset) {
        if (this.isLineMarkersShown()) {
            this.paintGutterRenderers(g2, firstVisibleOffset, lastVisibleOffset);
        }
    }

    private void paintBackground(Graphics g2, Rectangle clip, int x2, int width, Color background) {
        g2.setColor(background);
        g2.fillRect(x2, clip.y, width, clip.height);
        this.paintCaretRowBackground(g2, x2, width);
    }

    private void paintCaretRowBackground(Graphics g2, int x2, int width) {
        if (!this.myEditor.getSettings().isCaretRowShown()) {
            return;
        }
        VisualPosition visCaret = this.myEditor.getCaretModel().getVisualPosition();
        Color caretRowColor = this.myEditor.getColorsScheme().getColor(EditorColors.CARET_ROW_COLOR);
        if (caretRowColor != null) {
            g2.setColor(caretRowColor);
            Point caretPoint = this.myEditor.visualPositionToXY(visCaret);
            g2.fillRect(x2, caretPoint.y, width, this.myEditor.getLineHeight());
        }
    }

    private void paintLineNumbers(Graphics2D g2, int startVisualLine, int endVisualLine) {
        if (this.isLineNumbersShown()) {
            int offset = this.getLineNumberAreaOffset() + this.myLineNumberAreaWidth;
            this.doPaintLineNumbers(g2, startVisualLine, endVisualLine, offset, this.myLineNumberConvertor);
            if (this.myAdditionalLineNumberConvertor != null) {
                this.doPaintLineNumbers(g2, startVisualLine, endVisualLine, offset + EditorGutterComponentImpl.getAreaWidthWithGap(this.myAdditionalLineNumberAreaWidth), this.myAdditionalLineNumberConvertor);
            }
        }
    }

    @Override
    public Color getBackground() {
        if (this.myEditor.isInDistractionFreeMode() || !this.myPaintBackground) {
            return this.myEditor.getBackgroundColor();
        }
        Color color = this.myEditor.getColorsScheme().getColor(EditorColors.GUTTER_BACKGROUND);
        return color != null ? color : EditorColors.GUTTER_BACKGROUND.getDefaultColor();
    }

    private Font getFontForLineNumbers() {
        Font editorFont = this.myEditor.getColorsScheme().getFont(EditorFontType.PLAIN);
        float editorFontSize = editorFont.getSize2D();
        return editorFont.deriveFont(Math.max(1.0f, editorFontSize - 1.0f));
    }

    private int calcLineNumbersAreaWidth(int maxLineNumber) {
        return this.getFontMetrics(this.getFontForLineNumbers()).stringWidth(Integer.toString(maxLineNumber + 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPaintLineNumbers(Graphics2D g2, int startVisualLine, int endVisualLine, int offset, @NotNull TIntFunction convertor) {
        if (convertor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "convertor", "com/intellij/openapi/editor/impl/EditorGutterComponentImpl", "doPaintLineNumbers"));
        }
        int lastLine = this.myEditor.logicalToVisualPosition((LogicalPosition)new LogicalPosition((int)this.endLineNumber(), (int)0)).line;
        if (startVisualLine > (endVisualLine = Math.min(endVisualLine, lastLine))) {
            return;
        }
        Color color = this.myEditor.getColorsScheme().getColor(EditorColors.LINE_NUMBERS_COLOR);
        g2.setColor(color != null ? color : JBColor.blue);
        Font font = this.getFontForLineNumbers();
        g2.setFont(font);
        AffineTransform old = this.setMirrorTransformIfNeeded(g2, this.getLineNumberAreaOffset(), this.getLineNumberAreaWidth());
        try {
            VisualLinesIterator visLinesIterator = new VisualLinesIterator(this.myEditor, startVisualLine);
            while (!visLinesIterator.atEnd() && visLinesIterator.getVisualLine() <= endVisualLine) {
                int logLine;
                LogicalPosition logicalPosition = this.myEditor.visualToLogicalPosition(new VisualPosition(visLinesIterator.getVisualLine(), 0));
                if (EditorUtil.getSoftWrapCountAfterLineStart(this.myEditor, logicalPosition) <= 0 && (logLine = convertor.execute(visLinesIterator.getStartLogicalLine())) >= 0) {
                    int startY = visLinesIterator.getY();
                    if (this.myEditor.isInDistractionFreeMode()) {
                        Color fgColor = (Color)this.myTextFgColors.get(visLinesIterator.getVisualLine());
                        g2.setColor(fgColor != null ? fgColor : (color != null ? color : JBColor.blue));
                    }
                    String s2 = String.valueOf(logLine + 1);
                    int textOffset = this.isMirrored() ? offset - this.getLineNumberAreaWidth() - 1 : offset - g2.getFontMetrics().stringWidth(s2);
                    g2.drawString(s2, textOffset, startY + this.myEditor.getAscent());
                }
                visLinesIterator.advance();
            }
        }
        finally {
            if (old != null) {
                g2.setTransform(old);
            }
        }
    }

    private int endLineNumber() {
        return Math.max(0, this.myEditor.getDocument().getLineCount() - 1);
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (this.myEditor.isDisposed()) {
            return null;
        }
        if (EditorGutter.KEY.is(dataId)) {
            return this;
        }
        if (CommonDataKeys.EDITOR.is(dataId)) {
            return this.myEditor;
        }
        return null;
    }

    private void processRangeHighlighters(int startOffset, int endOffset, @NotNull RangeHighlighterProcessor processor2) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/editor/impl/EditorGutterComponentImpl", "processRangeHighlighters"));
        }
        DocumentEx document = this.myEditor.getDocument();
        MarkupIterator<RangeHighlighterEx> docHighlighters = this.myEditor.getFilteredDocumentMarkupModel().overlappingIterator(startOffset, endOffset);
        MarkupIterator<RangeHighlighterEx> editorHighlighters = this.myEditor.getMarkupModel().overlappingIterator(startOffset, endOffset);
        try {
            RangeHighlighterEx lastDocHighlighter = null;
            RangeHighlighterEx lastEditorHighlighter = null;
            while (true) {
                int endLineIndex;
                int startLineIndex;
                RangeHighlighterEx lowerHighlighter;
                if (lastDocHighlighter == null && docHighlighters.hasNext()) {
                    lastDocHighlighter = (RangeHighlighterEx)docHighlighters.next();
                    if (!lastDocHighlighter.isValid() || lastDocHighlighter.getAffectedAreaStartOffset() > endOffset) {
                        lastDocHighlighter = null;
                        continue;
                    }
                    if (lastDocHighlighter.getAffectedAreaEndOffset() < startOffset) {
                        lastDocHighlighter = null;
                        continue;
                    }
                }
                if (lastEditorHighlighter == null && editorHighlighters.hasNext()) {
                    lastEditorHighlighter = (RangeHighlighterEx)editorHighlighters.next();
                    if (!lastEditorHighlighter.isValid() || lastEditorHighlighter.getAffectedAreaStartOffset() > endOffset) {
                        lastEditorHighlighter = null;
                        continue;
                    }
                    if (lastEditorHighlighter.getAffectedAreaEndOffset() < startOffset) {
                        lastEditorHighlighter = null;
                        continue;
                    }
                }
                if (lastDocHighlighter == null && lastEditorHighlighter == null) {
                    return;
                }
                if (EditorGutterComponentImpl.less(lastDocHighlighter, lastEditorHighlighter)) {
                    lowerHighlighter = lastDocHighlighter;
                    lastDocHighlighter = null;
                } else {
                    lowerHighlighter = lastEditorHighlighter;
                    lastEditorHighlighter = null;
                }
                if (!lowerHighlighter.isValid() || !EditorGutterComponentImpl.isValidLine(document, startLineIndex = lowerHighlighter.getDocument().getLineNumber(startOffset)) || !EditorGutterComponentImpl.isValidLine(document, endLineIndex = lowerHighlighter.getDocument().getLineNumber(endOffset))) continue;
                processor2.process(lowerHighlighter);
            }
        }
        finally {
            docHighlighters.dispose();
            editorHighlighters.dispose();
        }
    }

    private static boolean isValidLine(@NotNull Document document, int line) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/EditorGutterComponentImpl", "isValidLine"));
        }
        if (line < 0) {
            return false;
        }
        int lineCount = document.getLineCount();
        return lineCount == 0 ? line == 0 : line < lineCount;
    }

    private static boolean less(RangeHighlighter h1, RangeHighlighter h2) {
        return h1 != null && (h2 == null || h1.getStartOffset() < h2.getStartOffset());
    }

    @Override
    public void revalidateMarkup() {
        this.updateSize();
    }

    void updateSizeOnShowNotify() {
        this.updateSize(false, true);
    }

    public void updateSize() {
        this.updateSize(false, false);
    }

    void updateSize(boolean onLayout, boolean canShrink) {
        int prevHash = this.sizeHash();
        if (!onLayout) {
            this.clearLineToGutterRenderersCache();
            this.calcLineNumberAreaWidth();
            this.calcLineMarkerAreaWidth(canShrink);
            this.calcAnnotationsSize();
        }
        this.calcAnnotationExtraSize();
        if (prevHash != this.sizeHash()) {
            this.fireResized();
        }
        this.repaint();
    }

    private int sizeHash() {
        int result2 = this.getLineMarkerAreaWidth();
        result2 = 31 * result2 + this.myTextAnnotationGuttersSize;
        result2 = 31 * result2 + this.myTextAnnotationExtraSize;
        result2 = 31 * result2 + this.getLineNumberAreaWidth();
        return result2;
    }

    private void calcAnnotationsSize() {
        this.myTextAnnotationGuttersSize = 0;
        FontMetrics fontMetrics = this.myEditor.getFontMetrics(0);
        int lineCount = Math.max(this.myEditor.getDocument().getLineCount(), 1);
        for (int j2 = 0; j2 < this.myTextAnnotationGutters.size(); ++j2) {
            TextAnnotationGutterProvider gutterProvider = this.myTextAnnotationGutters.get(j2);
            int gutterSize = 0;
            for (int i2 = 0; i2 < lineCount; ++i2) {
                String lineText = gutterProvider.getLineText(i2, (Editor)this.myEditor);
                if (StringUtil.isEmpty((String)lineText)) continue;
                gutterSize = Math.max(gutterSize, fontMetrics.stringWidth(lineText));
            }
            if (gutterSize > 0) {
                gutterSize += GAP_BETWEEN_ANNOTATIONS;
            }
            this.myTextAnnotationGutterSizes.set(j2, gutterSize);
            this.myTextAnnotationGuttersSize += gutterSize;
        }
    }

    private void calcAnnotationExtraSize() {
        int width;
        this.myTextAnnotationExtraSize = 0;
        if (!this.myEditor.isInDistractionFreeMode() || this.isMirrored()) {
            return;
        }
        Window frame = SwingUtilities.getWindowAncestor(this.myEditor.getComponent());
        if (frame == null) {
            return;
        }
        EditorSettings settings = this.myEditor.getSettings();
        int rightMargin = settings.getRightMargin(this.myEditor.getProject());
        if (rightMargin <= 0) {
            return;
        }
        JComponent editorComponent = this.myEditor.getComponent();
        RelativePoint point = new RelativePoint((Component)editorComponent, new Point(0, 0));
        Point editorLocationInWindow = point.getPoint((Component)frame);
        int editorLocationX = (int)editorLocationInWindow.getX();
        int rightMarginX = rightMargin * EditorUtil.getSpaceWidth(0, this.myEditor) + editorLocationX;
        if (rightMarginX < (width = editorLocationX + editorComponent.getWidth()) && editorLocationX < width - rightMarginX) {
            int centeredSize = (width - rightMarginX - editorLocationX) / 2 - (this.getLineMarkerAreaWidth() + this.getLineNumberAreaWidth() + this.getFoldingAreaWidth() + 2 * GAP_BETWEEN_AREAS);
            this.myTextAnnotationExtraSize = Math.max(0, centeredSize - this.myTextAnnotationGuttersSize);
        }
    }

    void clearLineToGutterRenderersCache() {
        this.myLineToGutterRenderers = null;
    }

    private void buildGutterRenderersCache() {
        this.myLineToGutterRenderers = new TIntObjectHashMap();
        this.processRangeHighlighters(0, this.myEditor.getDocument().getTextLength(), highlighter2 -> {
            GutterIconRenderer renderer = highlighter2.getGutterIconRenderer();
            if (renderer == null) {
                return;
            }
            if (!this.isHighlighterVisible(highlighter2)) {
                return;
            }
            int lineStartOffset = EditorUtil.getNotFoldedLineStartOffset(this.myEditor, highlighter2.getStartOffset());
            int line = this.myEditor.getDocument().getLineNumber(lineStartOffset);
            List renderers = (List)this.myLineToGutterRenderers.get(line);
            if (renderers == null) {
                renderers = new SmartList();
                this.myLineToGutterRenderers.put(line, (Object)renderers);
            }
            renderers.add(renderer);
        });
        this.myLineToGutterRenderers.transformValues(value2 -> {
            List newValue = value2;
            for (GutterMarkPreprocessor preprocessor : (GutterMarkPreprocessor[])GutterMarkPreprocessor.EP_NAME.getExtensions()) {
                newValue = preprocessor.processMarkers((List)value2);
            }
            if (newValue.size() >= 5) {
                newValue = newValue.subList(0, 4);
            }
            return newValue;
        });
    }

    private void calcLineMarkerAreaWidth(boolean canShrink) {
        this.myLeftFreePaintersAreaShown = this.myForceLeftFreePaintersAreaShown;
        this.myRightFreePaintersAreaShown = this.myForceRightFreePaintersAreaShown;
        this.processRangeHighlighters(0, this.myEditor.getDocument().getTextLength(), highlighter2 -> {
            LineMarkerRenderer lineMarkerRenderer = highlighter2.getLineMarkerRenderer();
            if (lineMarkerRenderer != null) {
                LineMarkerRendererEx.Position position = EditorGutterComponentImpl.getLineMarkerPosition(lineMarkerRenderer);
                if (position == LineMarkerRendererEx.Position.LEFT && this.isLineMarkerVisible(highlighter2)) {
                    this.myLeftFreePaintersAreaShown = true;
                }
                if (position == LineMarkerRendererEx.Position.RIGHT && this.isLineMarkerVisible(highlighter2)) {
                    this.myRightFreePaintersAreaShown = true;
                }
            }
        });
        if (!this.areIconsShown()) {
            this.myIconsAreaWidth = 0;
            this.myLastNonDumbModeIconAreaWidth = 0;
            return;
        }
        int minWidth = this.scaleWidth(this.myStartIconAreaWidth);
        this.myIconsAreaWidth = canShrink ? minWidth : Math.max(this.myIconsAreaWidth, minWidth);
        this.processGutterRenderers((TIntObjectProcedure<List<GutterMark>>)((TIntObjectProcedure)(line, renderers) -> {
            int width = 1;
            for (int i2 = 0; i2 < renderers.size(); ++i2) {
                GutterMark renderer = (GutterMark)renderers.get(i2);
                if (!this.checkDumbAware(renderer)) continue;
                width += this.scaleIcon(renderer.getIcon()).getIconWidth();
                if (i2 <= 0) continue;
                width += GAP_BETWEEN_ICONS;
            }
            if (this.myIconsAreaWidth < width) {
                this.myIconsAreaWidth = width + 1;
            }
            return true;
        }));
        if (this.isDumbMode()) {
            this.myIconsAreaWidth = Math.max(this.myIconsAreaWidth, this.myLastNonDumbModeIconAreaWidth);
        } else {
            this.myLastNonDumbModeIconAreaWidth = this.myIconsAreaWidth;
        }
    }

    @Nullable
    private List<GutterMark> getGutterRenderers(int line) {
        if (this.myLineToGutterRenderers == null) {
            this.buildGutterRenderersCache();
        }
        return (List)this.myLineToGutterRenderers.get(line);
    }

    private void processGutterRenderers(@NotNull TIntObjectProcedure<List<GutterMark>> processor2) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/editor/impl/EditorGutterComponentImpl", "processGutterRenderers"));
        }
        if (this.myLineToGutterRenderers == null) {
            this.buildGutterRenderersCache();
        }
        this.myLineToGutterRenderers.forEachEntry(processor2);
    }

    private boolean isHighlighterVisible(RangeHighlighter highlighter2) {
        int startOffset = highlighter2 instanceof RangeHighlighterEx ? ((RangeHighlighterEx)highlighter2).getAffectedAreaStartOffset() : highlighter2.getStartOffset();
        int endOffset = highlighter2 instanceof RangeHighlighterEx ? ((RangeHighlighterEx)highlighter2).getAffectedAreaEndOffset() : highlighter2.getEndOffset();
        FoldRegion foldRegion = this.myEditor.getFoldingModel().getCollapsedRegionAtOffset(startOffset);
        return foldRegion == null || foldRegion.getEndOffset() < endOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintGutterRenderers(Graphics2D g2, int firstVisibleOffset, int lastVisibleOffset) {
        Object hint = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        try {
            ArrayList highlighters = new ArrayList();
            this.processRangeHighlighters(firstVisibleOffset, lastVisibleOffset, highlighter2 -> {
                LineMarkerRenderer renderer = highlighter2.getLineMarkerRenderer();
                if (renderer != null) {
                    highlighters.add(highlighter2);
                }
            });
            ContainerUtil.sort(highlighters, Comparator.comparingInt(RangeHighlighter::getLayer));
            for (RangeHighlighter highlighter3 : highlighters) {
                this.paintLineMarkerRenderer(highlighter3, g2);
            }
        }
        finally {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, hint);
        }
        int firstVisibleLine = this.myEditor.getDocument().getLineNumber(firstVisibleOffset);
        int lastVisibleLine = this.myEditor.getDocument().getLineNumber(lastVisibleOffset);
        this.paintIcons(firstVisibleLine, lastVisibleLine, g2);
    }

    private void paintIcons(int firstVisibleLine, int lastVisibleLine, Graphics2D g2) {
        for (int line = firstVisibleLine; line <= lastVisibleLine; ++line) {
            List<GutterMark> renderers = this.getGutterRenderers(line);
            if (renderers == null) continue;
            this.paintIconRow(line, renderers, g2);
        }
    }

    private void paintIconRow(int line, List<GutterMark> row, Graphics2D g2) {
        this.processIconsRow(line, row, (x2, y2, renderer) -> {
            Icon icon = this.scaleIcon(renderer.getIcon());
            AffineTransform old = this.setMirrorTransformIfNeeded(g2, x2, icon.getIconWidth());
            try {
                icon.paintIcon(this, g2, x2, y2);
            }
            finally {
                if (old != null) {
                    g2.setTransform(old);
                }
            }
        });
    }

    private void paintLineMarkerRenderer(RangeHighlighter highlighter2, Graphics g2) {
        Rectangle rectangle;
        LineMarkerRenderer lineMarkerRenderer = highlighter2.getLineMarkerRenderer();
        if (lineMarkerRenderer != null && (rectangle = this.getLineRendererRectangle(highlighter2)) != null) {
            lineMarkerRenderer.paint((Editor)this.myEditor, g2, rectangle);
        }
    }

    private boolean isLineMarkerVisible(RangeHighlighter highlighter2) {
        int startOffset = highlighter2.getStartOffset();
        int endOffset = highlighter2.getEndOffset();
        FoldRegion startFoldRegion = this.myEditor.getFoldingModel().getCollapsedRegionAtOffset(startOffset);
        FoldRegion endFoldRegion = this.myEditor.getFoldingModel().getCollapsedRegionAtOffset(endOffset);
        return startFoldRegion == null || endFoldRegion == null || !startFoldRegion.equals(endFoldRegion);
    }

    @Nullable
    private Rectangle getLineRendererRectangle(RangeHighlighter highlighter2) {
        int x2;
        int w2;
        if (!this.isLineMarkerVisible(highlighter2)) {
            return null;
        }
        int startOffset = highlighter2.getStartOffset();
        int endOffset = highlighter2.getEndOffset();
        int startY = this.myEditor.visibleLineToY(this.myEditor.offsetToVisualLine(startOffset));
        int endY = this.myEditor.visibleLineToY(this.myEditor.offsetToVisualLine(endOffset));
        DocumentEx document = this.myEditor.getDocument();
        if (document.getLineStartOffset(document.getLineNumber(endOffset)) != endOffset) {
            endY += this.myEditor.getLineHeight();
        }
        LineMarkerRenderer renderer = (LineMarkerRenderer)ObjectUtils.assertNotNull((Object)highlighter2.getLineMarkerRenderer());
        LineMarkerRendererEx.Position position = EditorGutterComponentImpl.getLineMarkerPosition(renderer);
        switch (position) {
            case LEFT: {
                w2 = this.getLeftFreePaintersAreaWidth();
                x2 = this.getLeftFreePaintersAreaOffset();
                break;
            }
            case RIGHT: {
                w2 = this.getRightFreePaintersAreaWidth();
                x2 = this.getLineMarkerFreePaintersAreaOffset();
                break;
            }
            case CUSTOM: {
                w2 = this.getWidth();
                x2 = 0;
                break;
            }
            default: {
                throw new IllegalArgumentException(position.name());
            }
        }
        int height = endY - startY;
        return new Rectangle(x2, startY, w2, height);
    }

    private float getEditorScaleFactor() {
        float scale;
        if (Registry.is((String)"editor.scale.gutter.icons") && Math.abs(1.0f - (scale = this.myEditor.getScale())) > 0.1f) {
            return scale;
        }
        return 1.0f;
    }

    private Icon scaleIcon(Icon icon) {
        float scale = this.getEditorScaleFactor();
        if (icon instanceof ScalableIcon && scale != 1.0f) {
            if (icon instanceof JBUI.JBUIScaleTrackable) {
                ((JBUI.JBUIScaleTrackable)icon).updateJBUIScale(this.getGraphicsConfiguration());
            }
            return ((ScalableIcon)icon).scale(scale);
        }
        return icon;
    }

    private int scaleWidth(int width) {
        return (int)(this.getEditorScaleFactor() * (float)width);
    }

    private void processIconsRow(int line, @NotNull List<GutterMark> row, @NotNull LineGutterIconRendererProcessor processor2) {
        Icon icon;
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/openapi/editor/impl/EditorGutterComponentImpl", "processIconsRow"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/editor/impl/EditorGutterComponentImpl", "processIconsRow"));
        }
        if (!this.areIconsShown()) {
            return;
        }
        int middleCount = 0;
        int middleSize = 0;
        int x2 = this.getIconAreaOffset() + 2;
        int y2 = this.myEditor.logicalPositionToXY((LogicalPosition)new LogicalPosition((int)line, (int)0)).y;
        for (GutterMark gutterMark : row) {
            if (!this.checkDumbAware(gutterMark)) continue;
            GutterIconRenderer.Alignment alignment = ((GutterIconRenderer)gutterMark).getAlignment();
            icon = this.scaleIcon(gutterMark.getIcon());
            if (alignment == GutterIconRenderer.Alignment.LEFT) {
                processor2.process(x2, y2 + this.getTextAlignmentShift(icon), gutterMark);
                x2 += icon.getIconWidth() + GAP_BETWEEN_ICONS;
                continue;
            }
            if (alignment != GutterIconRenderer.Alignment.CENTER) continue;
            ++middleCount;
            middleSize += icon.getIconWidth() + GAP_BETWEEN_ICONS;
        }
        int leftSize = x2 - this.getIconAreaOffset();
        x2 = this.getIconAreaOffset() + this.myIconsAreaWidth;
        for (GutterMark r3 : row) {
            if (!this.checkDumbAware(r3) || ((GutterIconRenderer)r3).getAlignment() != GutterIconRenderer.Alignment.RIGHT) continue;
            icon = this.scaleIcon(r3.getIcon());
            processor2.process(x2 -= icon.getIconWidth(), y2 + this.getTextAlignmentShift(icon), r3);
            x2 -= GAP_BETWEEN_ICONS;
        }
        int n2 = this.myIconsAreaWidth + this.getIconAreaOffset() - x2 + 1;
        if (middleCount > 0) {
            x2 = this.getIconAreaOffset() + leftSize + (this.myIconsAreaWidth - leftSize - n2 - (middleSize -= GAP_BETWEEN_ICONS)) / 2;
            for (GutterMark r4 : row) {
                if (!this.checkDumbAware(r4) || ((GutterIconRenderer)r4).getAlignment() != GutterIconRenderer.Alignment.CENTER) continue;
                Icon icon2 = this.scaleIcon(r4.getIcon());
                processor2.process(x2, y2 + this.getTextAlignmentShift(icon2), r4);
                x2 += icon2.getIconWidth() + GAP_BETWEEN_ICONS;
            }
        }
    }

    private int getTextAlignmentShift(Icon icon) {
        int centerRelative = (this.myEditor.getLineHeight() - icon.getIconHeight()) / 2;
        int baselineRelative = this.myEditor.getAscent() - icon.getIconHeight();
        return Math.max(centerRelative, baselineRelative);
    }

    private Color getOutlineColor(boolean isActive) {
        ColorKey key = isActive ? EditorColors.SELECTED_TEARLINE_COLOR : EditorColors.TEARLINE_COLOR;
        Color color = this.myEditor.getColorsScheme().getColor(key);
        return color != null ? color : JBColor.black;
    }

    public void registerTextAnnotation(@NotNull TextAnnotationGutterProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/openapi/editor/impl/EditorGutterComponentImpl", "registerTextAnnotation"));
        }
        this.myTextAnnotationGutters.add(provider);
        this.myTextAnnotationGutterSizes.add(0);
        this.updateSize();
    }

    public void registerTextAnnotation(@NotNull TextAnnotationGutterProvider provider, @NotNull EditorGutterAction action2) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/openapi/editor/impl/EditorGutterComponentImpl", "registerTextAnnotation"));
        }
        if (action2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/editor/impl/EditorGutterComponentImpl", "registerTextAnnotation"));
        }
        this.myTextAnnotationGutters.add(provider);
        this.myProviderToListener.put(provider, action2);
        this.myTextAnnotationGutterSizes.add(0);
        this.updateSize();
    }

    private void doPaintFoldingTree(Graphics2D g2, Rectangle clip, int firstVisibleOffset, int lastVisibleOffset) {
        int anchorX = this.getFoldingAreaOffset();
        int width = this.getFoldingAnchorWidth();
        Collection<DisplayedFoldingAnchor> anchorsToDisplay = this.myAnchorsDisplayStrategy.getAnchorsToDisplay(firstVisibleOffset, lastVisibleOffset, this.myActiveFoldRegion);
        for (DisplayedFoldingAnchor anchor : anchorsToDisplay) {
            this.drawFoldingAnchor(width, clip, g2, anchorX, anchor.visualLine, anchor.type, anchor.foldRegion == this.myActiveFoldRegion);
        }
    }

    private void paintFoldingLines(Graphics2D g2, Rectangle clip) {
        if (!this.isFoldingOutlineShown()) {
            return;
        }
        if (this.myPaintBackground) {
            g2.setColor(this.getOutlineColor(false));
            int x2 = this.getWhitespaceSeparatorOffset();
            UIUtil.drawLine((Graphics)g2, (int)x2, (int)clip.y, (int)x2, (int)(clip.y + clip.height));
        }
        int anchorX = this.getFoldingAreaOffset();
        int width = this.getFoldingAnchorWidth();
        if (this.myActiveFoldRegion != null && this.myActiveFoldRegion.isExpanded() && this.myActiveFoldRegion.isValid()) {
            int foldStart = this.myEditor.offsetToVisualLine(this.myActiveFoldRegion.getStartOffset());
            int foldEnd = this.myEditor.offsetToVisualLine(this.getEndOffset(this.myActiveFoldRegion));
            int startY = this.getLineCenterY(foldStart);
            int endY = this.getLineCenterY(foldEnd);
            if (startY <= clip.y + clip.height && endY + 1 + this.myEditor.getDescent() >= clip.y) {
                g2.setColor(this.getOutlineColor(true));
                int lineX = anchorX + width / 2;
                UIUtil.drawLine((Graphics)g2, (int)lineX, (int)startY, (int)lineX, (int)endY);
            }
        }
    }

    @Override
    public int getWhitespaceSeparatorOffset() {
        return this.getFoldingAreaOffset() + this.getFoldingAnchorWidth() / 2;
    }

    void setActiveFoldRegion(FoldRegion activeFoldRegion) {
        if (this.myActiveFoldRegion != activeFoldRegion) {
            this.myActiveFoldRegion = activeFoldRegion;
            this.repaint();
        }
    }

    private int getLineCenterY(int line) {
        return this.myEditor.visibleLineToY(line) + this.myEditor.getLineHeight() / 2;
    }

    private int getFoldAnchorY(int line, int width) {
        return this.myEditor.visibleLineToY(line) + this.myEditor.getAscent() - width;
    }

    int getHeadCenterY(FoldRegion foldRange) {
        return this.getLineCenterY(this.myEditor.offsetToVisualLine(foldRange.getStartOffset()));
    }

    private void drawFoldingAnchor(int width, Rectangle clip, Graphics2D g2, int anchorX, int visualLine, DisplayedFoldingAnchor.Type type, boolean active2) {
        int off = (int)((float)width / 4.0f);
        int height = width + off;
        int baseHeight = height - width / 2;
        int y2 = this.getFoldAnchorY(visualLine, width);
        switch (type) {
            case COLLAPSED: {
                if (y2 > clip.y + clip.height || y2 + height < clip.y) break;
                this.drawSquareWithPlus(g2, anchorX, y2, width, active2);
                break;
            }
            case EXPANDED_TOP: {
                if (y2 > clip.y + clip.height || y2 + height < clip.y) break;
                this.drawDirectedBox(g2, anchorX, y2, width, height, baseHeight, active2);
                break;
            }
            case EXPANDED_BOTTOM: {
                if ((y2 += width) - height > clip.y + clip.height || y2 < clip.y) break;
                this.drawDirectedBox(g2, anchorX, y2, width, -height, -baseHeight, active2);
            }
        }
    }

    private int getEndOffset(FoldRegion foldRange) {
        LOG.assertTrue(foldRange.isValid(), (Object)foldRange);
        FoldingGroup group = foldRange.getGroup();
        return group == null ? foldRange.getEndOffset() : this.myEditor.getFoldingModel().getEndOffset(group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawDirectedBox(Graphics2D g2, int anchorX, int y2, int width, int height, int baseHeight, boolean active2) {
        Object antialiasing = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        if (SystemInfo.isMac && SystemInfo.JAVA_VERSION.startsWith("1.4.1") || UIUtil.isJreHiDPI((Graphics2D)g2)) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        try {
            int off = EditorGutterComponentImpl.getSquareInnerOffset(width);
            g2.setColor(this.myEditor.getBackgroundColor());
            int[] xPoints = new int[]{anchorX, anchorX + width, anchorX + width, anchorX + width / 2, anchorX};
            int[] yPoints = new int[]{y2, y2, y2 + baseHeight, y2 + height, y2 + baseHeight};
            g2.fillPolygon(xPoints, yPoints, 5);
            g2.setColor(this.getOutlineColor(active2));
            g2.drawPolygon(xPoints, yPoints, 5);
            int minusHeight = y2 + baseHeight / 2 + (height - baseHeight) / 4;
            UIUtil.drawLine((Graphics)g2, (int)(anchorX + off), (int)minusHeight, (int)(anchorX + width - off), (int)minusHeight);
        }
        finally {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, antialiasing);
        }
    }

    private void drawSquareWithPlus(Graphics2D g2, int anchorX, int y2, int width, boolean active2) {
        this.drawSquareWithMinus(g2, anchorX, y2, width, active2);
        int off = EditorGutterComponentImpl.getSquareInnerOffset(width);
        UIUtil.drawLine((Graphics)g2, (int)(anchorX + width / 2), (int)(y2 + off), (int)(anchorX + width / 2), (int)(y2 + width - off));
    }

    private static int getSquareInnerOffset(int width) {
        return Math.max(width / 5, JBUI.scale((int)2));
    }

    private void drawSquareWithMinus(Graphics2D g2, int anchorX, int y2, int width, boolean active2) {
        g2.setColor(this.myEditor.getBackgroundColor());
        g2.fillRect(anchorX, y2, width, width);
        g2.setColor(this.getOutlineColor(active2));
        g2.drawRect(anchorX, y2, width, width);
        int off = EditorGutterComponentImpl.getSquareInnerOffset(width);
        if (!active2) {
            g2.setColor(this.getOutlineColor(true));
        }
        UIUtil.drawLine((Graphics)g2, (int)(anchorX + off), (int)(y2 + width / 2), (int)(anchorX + width - off), (int)(y2 + width / 2));
    }

    private int getFoldingAnchorWidth() {
        return EditorGutterComponentImpl.roundToEven(Math.min((float)JBUI.scale((int)4) * this.myEditor.getScale(), (float)(this.myEditor.getLineHeight() / 2 - JBUI.scale((int)2))) * 2.0f);
    }

    private static int roundToEven(float f2) {
        int lower = (int)Math.floor(f2);
        int upper = (int)Math.ceil(f2);
        if (lower % 2 == 0) {
            return lower;
        }
        if (upper % 2 == 0) {
            return upper;
        }
        return lower > 0 ? lower - 1 : 0;
    }

    private int getFoldingAreaOffset() {
        return this.getLineMarkerAreaOffset() + this.getLineMarkerAreaWidth();
    }

    private int getFoldingAreaWidth() {
        return this.isFoldingOutlineShown() ? this.getFoldingAnchorWidth() + JBUI.scale((int)2) : (this.isRealEditor() ? this.getFoldingAnchorWidth() : 0);
    }

    private boolean isRealEditor() {
        return EditorUtil.isRealFileEditor(this.myEditor);
    }

    private boolean isLineMarkersShown() {
        return this.myEditor.getSettings().isLineMarkerAreaShown();
    }

    private boolean areIconsShown() {
        return this.myEditor.getSettings().areGutterIconsShown();
    }

    private boolean isLineNumbersShown() {
        return this.myEditor.getSettings().isLineNumbersShown();
    }

    public boolean isAnnotationsShown() {
        return !this.myTextAnnotationGutters.isEmpty();
    }

    private boolean isFoldingOutlineShown() {
        return this.myEditor.getSettings().isFoldingOutlineShown() && this.myEditor.getFoldingModel().isFoldingEnabled() && !this.myEditor.isInPresentationMode();
    }

    private static int getAreaWidthWithGap(int width) {
        if (width > 0) {
            return width + GAP_BETWEEN_AREAS;
        }
        return 0;
    }

    private int getLineNumberAreaWidth() {
        return this.isLineNumbersShown() ? this.myLineNumberAreaWidth + EditorGutterComponentImpl.getAreaWidthWithGap(this.myAdditionalLineNumberAreaWidth) : 0;
    }

    private int getLineMarkerAreaWidth() {
        return this.isLineMarkersShown() ? this.getLeftFreePaintersAreaWidth() + this.myIconsAreaWidth + this.getGapAfterIconsArea() + this.getRightFreePaintersAreaWidth() : 0;
    }

    private void calcLineNumberAreaWidth() {
        if (!this.isLineNumbersShown()) {
            return;
        }
        int maxLineNumber = this.getMaxLineNumber(this.myLineNumberConvertor);
        this.myLineNumberAreaWidth = this.calcLineNumbersAreaWidth(maxLineNumber);
        this.myAdditionalLineNumberAreaWidth = 0;
        if (this.myAdditionalLineNumberConvertor != null) {
            int maxAdditionalLineNumber = this.getMaxLineNumber(this.myAdditionalLineNumberConvertor);
            this.myAdditionalLineNumberAreaWidth = this.calcLineNumbersAreaWidth(maxAdditionalLineNumber);
        }
    }

    private int getMaxLineNumber(@NotNull TIntFunction convertor) {
        if (convertor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "convertor", "com/intellij/openapi/editor/impl/EditorGutterComponentImpl", "getMaxLineNumber"));
        }
        for (int i2 = this.endLineNumber(); i2 >= 0; --i2) {
            int number = convertor.execute(i2);
            if (number < 0) continue;
            return number;
        }
        return 0;
    }

    @Nullable
    EditorMouseEventArea getEditorMouseAreaByOffset(int offset) {
        if (this.isLineNumbersShown() && offset < this.getLineNumberAreaOffset() + this.getLineNumberAreaWidth()) {
            return EditorMouseEventArea.LINE_NUMBERS_AREA;
        }
        if (this.isAnnotationsShown() && offset < this.getAnnotationsAreaOffset() + this.getAnnotationsAreaWidth()) {
            return EditorMouseEventArea.ANNOTATIONS_AREA;
        }
        if (this.isLineMarkersShown() && offset < this.getFoldingAreaOffset()) {
            return EditorMouseEventArea.LINE_MARKERS_AREA;
        }
        if (this.isFoldingOutlineShown() && offset < this.getFoldingAreaOffset() + this.getFoldingAreaWidth()) {
            return EditorMouseEventArea.FOLDING_OUTLINE_AREA;
        }
        return null;
    }

    private int getLineNumberAreaOffset() {
        if (this.getLineNumberAreaWidth() == 0 && this.getAnnotationsAreaWidthEx() == 0 && this.getLineMarkerAreaWidth() == 0) {
            return this.getFoldingAreaWidth() == 0 ? 0 : 1;
        }
        if (this.getLineNumberAreaWidth() == 0 && this.getAnnotationsAreaWidthEx() > 0) {
            return 0;
        }
        return GAP_BETWEEN_AREAS;
    }

    @Override
    public int getAnnotationsAreaOffset() {
        return this.getLineNumberAreaOffset() + EditorGutterComponentImpl.getAreaWidthWithGap(this.getLineNumberAreaWidth());
    }

    @Override
    public int getAnnotationsAreaWidth() {
        return this.myTextAnnotationGuttersSize;
    }

    private int getAnnotationsAreaWidthEx() {
        return this.myTextAnnotationGuttersSize + this.myTextAnnotationExtraSize;
    }

    @Override
    public int getLineMarkerAreaOffset() {
        return this.getAnnotationsAreaOffset() + EditorGutterComponentImpl.getAreaWidthWithGap(this.getAnnotationsAreaWidthEx());
    }

    @Override
    public int getIconAreaOffset() {
        return this.getLineMarkerAreaOffset() + this.getLeftFreePaintersAreaWidth();
    }

    private int getLeftFreePaintersAreaOffset() {
        return this.getLineMarkerAreaOffset();
    }

    @Override
    public int getLineMarkerFreePaintersAreaOffset() {
        return this.getIconAreaOffset() + this.myIconsAreaWidth + this.getGapAfterIconsArea();
    }

    private int getLeftFreePaintersAreaWidth() {
        return this.myLeftFreePaintersAreaShown ? FREE_PAINTERS_LEFT_AREA_WIDTH : 0;
    }

    private int getRightFreePaintersAreaWidth() {
        return this.myRightFreePaintersAreaShown ? FREE_PAINTERS_RIGHT_AREA_WIDTH : 0;
    }

    @Override
    public int getIconsAreaWidth() {
        return this.myIconsAreaWidth;
    }

    private int getGapAfterIconsArea() {
        return this.isRealEditor() && this.areIconsShown() ? GAP_BETWEEN_AREAS : 0;
    }

    private boolean isMirrored() {
        return this.myEditor.getVerticalScrollbarOrientation() != 1;
    }

    @Nullable
    private AffineTransform setMirrorTransformIfNeeded(Graphics2D g2, int offset, int width) {
        if (this.isMirrored()) {
            AffineTransform old = g2.getTransform();
            AffineTransform transform = new AffineTransform(old);
            transform.scale(-1.0, 1.0);
            transform.translate(-offset * 2 - width, 0.0);
            g2.setTransform(transform);
            return old;
        }
        return null;
    }

    @Override
    @Nullable
    public FoldRegion findFoldingAnchorAt(int x2, int y2) {
        if (!this.myEditor.getSettings().isFoldingOutlineShown()) {
            return null;
        }
        int anchorX = this.getFoldingAreaOffset();
        int anchorWidth = this.getFoldingAnchorWidth();
        int visualLine = this.myEditor.yToVisibleLine(y2);
        int neighbourhoodStartOffset = this.myEditor.logicalPositionToOffset(this.myEditor.visualToLogicalPosition(new VisualPosition(visualLine, 0)));
        int neighbourhoodEndOffset = this.myEditor.logicalPositionToOffset(this.myEditor.visualToLogicalPosition(new VisualPosition(visualLine, Integer.MAX_VALUE)));
        Collection<DisplayedFoldingAnchor> displayedAnchors = this.myAnchorsDisplayStrategy.getAnchorsToDisplay(neighbourhoodStartOffset, neighbourhoodEndOffset, null);
        for (DisplayedFoldingAnchor anchor : displayedAnchors) {
            if (!this.rectangleByFoldOffset(anchor.visualLine, anchorWidth, anchorX).contains(this.convertX(x2), y2)) continue;
            return anchor.foldRegion;
        }
        return null;
    }

    private Rectangle rectangleByFoldOffset(int foldStart, int anchorWidth, int anchorX) {
        return new Rectangle(anchorX, this.getFoldAnchorY(foldStart, anchorWidth), anchorWidth, anchorWidth);
    }

    @Override
    public void mouseDragged(MouseEvent e2) {
        TooltipController.getInstance().cancelTooltips();
    }

    @Override
    public void mouseMoved(MouseEvent e2) {
        int line;
        String toolTip = null;
        GutterIconRenderer renderer = this.getGutterRenderer(e2);
        TooltipController controller = TooltipController.getInstance();
        if (renderer != null) {
            toolTip = renderer.getTooltipText();
        } else {
            TextAnnotationGutterProvider provider = this.getProviderAtPoint(e2.getPoint());
            if (provider != null) {
                line = this.getLineNumAtPoint(e2.getPoint());
                toolTip = provider.getToolTip(line, (Editor)this.myEditor);
                if (!Comparing.equal((String)toolTip, (String)this.myLastGutterToolTip)) {
                    controller.cancelTooltip(GUTTER_TOOLTIP_GROUP, e2, true);
                    this.myLastGutterToolTip = toolTip;
                }
            } else {
                ActiveGutterRenderer lineRenderer = this.getActiveRendererByMouseEvent(e2);
                if (lineRenderer != null) {
                    toolTip = lineRenderer.getTooltipText();
                }
            }
        }
        if (toolTip != null && !toolTip.isEmpty()) {
            Ref t2 = new Ref((Object)e2.getPoint());
            line = EditorUtil.yPositionToLogicalLine((Editor)this.myEditor, e2);
            List<GutterMark> row = this.getGutterRenderers(line);
            Balloon.Position ballPosition = Balloon.Position.atRight;
            if (row != null) {
                TreeMap xPos = new TreeMap();
                int[] currentPos = new int[]{0};
                this.processIconsRow(line, row, (x2, y2, r2) -> {
                    xPos.put(x2, r2);
                    if (renderer == r2) {
                        currentPos[0] = x2;
                        Icon icon = this.scaleIcon(r2.getIcon());
                        t2.set((Object)new Point(x2 + icon.getIconWidth() / 2, y2 + icon.getIconHeight() / 2));
                    }
                });
                ArrayList xx = new ArrayList(xPos.keySet());
                int posIndex = xx.indexOf(currentPos[0]);
                if (xPos.size() > 1 && posIndex == 0) {
                    ballPosition = Balloon.Position.below;
                }
            }
            RelativePoint showPoint = new RelativePoint((Component)this, (Point)t2.get());
            controller.showTooltipByMouseMove(this.myEditor, showPoint, ((EditorMarkupModel)((Object)this.myEditor.getMarkupModel())).getErrorStripTooltipRendererProvider().calcTooltipRenderer(toolTip), false, GUTTER_TOOLTIP_GROUP, new HintHint(this, (Point)t2.get()).setAwtTooltip(true).setPreferredPosition(ballPosition));
        } else {
            controller.cancelTooltip(GUTTER_TOOLTIP_GROUP, e2, false);
        }
    }

    void validateMousePointer(@NotNull MouseEvent e2) {
        GutterIconRenderer renderer;
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorGutterComponentImpl", "validateMousePointer"));
        }
        if (IdeGlassPaneImpl.hasPreProcessedCursor(this)) {
            return;
        }
        FoldRegion foldingAtCursor = this.findFoldingAnchorAt(e2.getX(), e2.getY());
        this.setActiveFoldRegion(foldingAtCursor);
        Cursor cursor = Cursor.getPredefinedCursor(0);
        if (foldingAtCursor != null) {
            cursor = Cursor.getPredefinedCursor(12);
        }
        if ((renderer = this.getGutterRenderer(e2)) != null) {
            if (renderer.isNavigateAction()) {
                cursor = Cursor.getPredefinedCursor(12);
            }
        } else {
            ActiveGutterRenderer lineRenderer = this.getActiveRendererByMouseEvent(e2);
            if (lineRenderer != null) {
                cursor = Cursor.getPredefinedCursor(12);
            } else {
                EditorGutterAction action2;
                TextAnnotationGutterProvider provider = this.getProviderAtPoint(e2.getPoint());
                if (provider != null && this.myProviderToListener.containsKey(provider) && (action2 = this.myProviderToListener.get(provider)) != null) {
                    int line = this.getLineNumAtPoint(e2.getPoint());
                    cursor = action2.getCursor(line);
                }
            }
        }
        this.setCursor(cursor);
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
        if (e2.isPopupTrigger()) {
            this.invokePopup(e2);
        }
    }

    private void fireEventToTextAnnotationListeners(MouseEvent e2) {
        if (this.myEditor.getMouseEventArea(e2) == EditorMouseEventArea.ANNOTATIONS_AREA) {
            int line;
            Point clickPoint = e2.getPoint();
            TextAnnotationGutterProvider provider = this.getProviderAtPoint(clickPoint);
            if (provider == null) {
                return;
            }
            if (this.myProviderToListener.containsKey(provider) && (line = this.getLineNumAtPoint(clickPoint)) >= 0 && line < this.myEditor.getDocument().getLineCount() && UIUtil.isActionClick((MouseEvent)e2, (int)502)) {
                this.myProviderToListener.get(provider).doAction(line);
            }
        }
    }

    private int getLineNumAtPoint(Point clickPoint) {
        return EditorUtil.yPositionToLogicalLine((Editor)this.myEditor, clickPoint);
    }

    @Nullable
    private TextAnnotationGutterProvider getProviderAtPoint(Point clickPoint) {
        int current = this.getAnnotationsAreaOffset();
        if (clickPoint.x < current) {
            return null;
        }
        for (int i2 = 0; i2 < this.myTextAnnotationGutterSizes.size(); ++i2) {
            if (clickPoint.x > (current += this.myTextAnnotationGutterSizes.get(i2))) continue;
            return this.myTextAnnotationGutters.get(i2);
        }
        return null;
    }

    @Override
    public void mousePressed(MouseEvent e2) {
        if (e2.isPopupTrigger() || this.isPopupAction(e2)) {
            this.invokePopup(e2);
        } else if (UIUtil.isCloseClick((MouseEvent)e2)) {
            this.processClose(e2);
        }
    }

    private boolean isPopupAction(MouseEvent e2) {
        GutterIconRenderer renderer = this.getGutterRenderer(e2);
        return renderer != null && renderer.getClickAction() == null && renderer.getPopupMenuActions() != null;
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
        if (e2.isPopupTrigger()) {
            this.invokePopup(e2);
            return;
        }
        GutterIconRenderer renderer = this.getGutterRenderer(e2);
        AnAction clickAction = null;
        if (renderer != null && e2.getButton() < 4) {
            AnAction anAction = clickAction = BitUtil.isSet((int)e2.getModifiers(), (int)8) ? renderer.getMiddleButtonClickAction() : renderer.getClickAction();
        }
        if (clickAction != null) {
            this.performAction(clickAction, e2, "ICON_NAVIGATION", this.myEditor.getDataContext());
            this.repaint();
            e2.consume();
        } else {
            ActiveGutterRenderer lineRenderer = this.getActiveRendererByMouseEvent(e2);
            if (lineRenderer != null) {
                lineRenderer.doAction((Editor)this.myEditor, e2);
            } else {
                this.fireEventToTextAnnotationListeners(e2);
            }
        }
    }

    private boolean isDumbMode() {
        Project project2 = this.myEditor.getProject();
        return project2 != null && DumbService.isDumb((Project)project2);
    }

    private boolean checkDumbAware(@NotNull Object possiblyDumbAware) {
        if (possiblyDumbAware == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "possiblyDumbAware", "com/intellij/openapi/editor/impl/EditorGutterComponentImpl", "checkDumbAware"));
        }
        return !this.isDumbMode() || DumbService.isDumbAware((Object)possiblyDumbAware);
    }

    private void notifyNotDumbAware() {
        Project project2 = this.myEditor.getProject();
        if (project2 != null) {
            DumbService.getInstance((Project)project2).showDumbModeNotification("This functionality is not available during indexing");
        }
    }

    private void performAction(@NotNull AnAction action2, @NotNull InputEvent e2, @NotNull String place, @NotNull DataContext context2) {
        if (action2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/editor/impl/EditorGutterComponentImpl", "performAction"));
        }
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorGutterComponentImpl", "performAction"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/openapi/editor/impl/EditorGutterComponentImpl", "performAction"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/editor/impl/EditorGutterComponentImpl", "performAction"));
        }
        if (!this.checkDumbAware(action2)) {
            this.notifyNotDumbAware();
            return;
        }
        AnActionEvent actionEvent = AnActionEvent.createFromAnAction((AnAction)action2, (InputEvent)e2, (String)place, (DataContext)context2);
        action2.update(actionEvent);
        if (actionEvent.getPresentation().isEnabledAndVisible()) {
            ActionUtil.performActionDumbAware((AnAction)action2, (AnActionEvent)actionEvent);
        }
    }

    @Nullable
    private ActiveGutterRenderer getActiveRendererByMouseEvent(MouseEvent e2) {
        if (this.findFoldingAnchorAt(e2.getX(), e2.getY()) != null) {
            return null;
        }
        if (e2.isConsumed() || e2.getX() > this.getWhitespaceSeparatorOffset()) {
            return null;
        }
        ActiveGutterRenderer[] gutterRenderer = new ActiveGutterRenderer[]{null};
        int[] layer = new int[]{-1};
        Rectangle clip = this.myEditor.getScrollingModel().getVisibleArea();
        int firstVisibleOffset = this.myEditor.logicalPositionToOffset(this.myEditor.xyToLogicalPosition(new Point(0, clip.y - this.myEditor.getLineHeight())));
        int lastVisibleOffset = this.myEditor.logicalPositionToOffset(this.myEditor.xyToLogicalPosition(new Point(0, clip.y + clip.height + this.myEditor.getLineHeight())));
        this.processRangeHighlighters(firstVisibleOffset, lastVisibleOffset, highlighter2 -> {
            LineMarkerRenderer renderer = highlighter2.getLineMarkerRenderer();
            if (renderer == null) {
                return;
            }
            if (gutterRenderer[0] != null && layer[0] >= highlighter2.getLayer()) {
                return;
            }
            Rectangle rectangle = this.getLineRendererRectangle(highlighter2);
            if (rectangle == null) {
                return;
            }
            int startY = rectangle.y;
            int endY = startY + rectangle.height;
            if (startY == endY) {
                endY += this.myEditor.getLineHeight();
            }
            if (startY < e2.getY() && e2.getY() <= endY && renderer instanceof ActiveGutterRenderer && ((ActiveGutterRenderer)renderer).canDoAction(e2)) {
                gutterRenderer[0] = (ActiveGutterRenderer)renderer;
                layer[0] = highlighter2.getLayer();
            }
        });
        return gutterRenderer[0];
    }

    public void closeAllAnnotations() {
        for (TextAnnotationGutterProvider provider : this.myTextAnnotationGutters) {
            provider.gutterClosed();
        }
        this.revalidateSizes();
    }

    private void revalidateSizes() {
        this.myTextAnnotationGutters = new ArrayList();
        this.myTextAnnotationGutterSizes = new TIntArrayList();
        this.updateSize();
    }

    @Override
    @Nullable
    public Point getCenterPoint(GutterIconRenderer renderer) {
        Ref result2 = Ref.create();
        if (!this.areIconsShown()) {
            this.processGutterRenderers((TIntObjectProcedure<List<GutterMark>>)((TIntObjectProcedure)(line, renderers) -> {
                if (ContainerUtil.find((Iterable)renderers, (Object)renderer) != null) {
                    result2.set((Object)new Point(this.getIconAreaOffset(), this.getLineCenterY(line)));
                    return false;
                }
                return true;
            }));
        } else {
            this.processGutterRenderers((TIntObjectProcedure<List<GutterMark>>)((TIntObjectProcedure)(line, renderers) -> {
                this.processIconsRow(line, (List<GutterMark>)renderers, (x2, y2, r2) -> {
                    if (result2.isNull() && r2.equals(renderer)) {
                        Icon icon = this.scaleIcon(r2.getIcon());
                        result2.set((Object)new Point(x2 + icon.getIconWidth() / 2, y2 + icon.getIconHeight() / 2));
                    }
                });
                return result2.isNull();
            }));
        }
        return (Point)result2.get();
    }

    @Override
    public void setLineNumberConvertor(@NotNull TIntFunction lineNumberConvertor) {
        if (lineNumberConvertor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineNumberConvertor", "com/intellij/openapi/editor/impl/EditorGutterComponentImpl", "setLineNumberConvertor"));
        }
        this.setLineNumberConvertor(lineNumberConvertor, null);
    }

    @Override
    public void setLineNumberConvertor(@NotNull TIntFunction lineNumberConvertor1, @Nullable TIntFunction lineNumberConvertor2) {
        if (lineNumberConvertor1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineNumberConvertor1", "com/intellij/openapi/editor/impl/EditorGutterComponentImpl", "setLineNumberConvertor"));
        }
        this.myLineNumberConvertor = lineNumberConvertor1;
        this.myAdditionalLineNumberConvertor = lineNumberConvertor2;
    }

    @Override
    public void setShowDefaultGutterPopup(boolean show2) {
        this.myShowDefaultGutterPopup = show2;
    }

    @Override
    public void setGutterPopupGroup(@Nullable ActionGroup group) {
        this.myCustomGutterPopupGroup = group;
    }

    @Override
    public void setPaintBackground(boolean value2) {
        this.myPaintBackground = value2;
    }

    @Override
    public void setForceShowLeftFreePaintersArea(boolean value2) {
        this.myForceLeftFreePaintersAreaShown = value2;
    }

    @Override
    public void setForceShowRightFreePaintersArea(boolean value2) {
        this.myForceRightFreePaintersAreaShown = value2;
    }

    @Override
    public void setInitialIconAreaWidth(int width) {
        this.myStartIconAreaWidth = width;
    }

    private void invokePopup(MouseEvent e2) {
        ActionManager actionManager = ActionManager.getInstance();
        if (this.myEditor.getMouseEventArea(e2) == EditorMouseEventArea.ANNOTATIONS_AREA) {
            DefaultActionGroup actionGroup = new DefaultActionGroup(EditorBundle.message((String)"editor.annotations.action.group.name", (Object[])new Object[0]), true);
            actionGroup.add((AnAction)new CloseAnnotationsAction());
            ArrayList<AnAction> addActions = new ArrayList<AnAction>();
            Point p2 = e2.getPoint();
            int line = EditorUtil.yPositionToLogicalLine((Editor)this.myEditor, p2);
            for (TextAnnotationGutterProvider gutterProvider : this.myTextAnnotationGutters) {
                List list2 = gutterProvider.getPopupActions(line, (Editor)this.myEditor);
                if (list2 == null) continue;
                for (AnAction action2 : list2) {
                    if (addActions.contains(action2)) continue;
                    addActions.add(action2);
                }
            }
            for (AnAction addAction : addActions) {
                actionGroup.add(addAction);
            }
            JPopupMenu menu = actionManager.createActionPopupMenu("", (ActionGroup)actionGroup).getComponent();
            menu.show(this, e2.getX(), e2.getY());
            e2.consume();
        } else {
            GutterIconRenderer renderer = this.getGutterRenderer(e2);
            if (renderer != null) {
                ActionGroup actionGroup = renderer.getPopupMenuActions();
                if (actionGroup != null) {
                    if (this.checkDumbAware(actionGroup)) {
                        ActionPopupMenu popupMenu = actionManager.createActionPopupMenu("unknown", actionGroup);
                        popupMenu.getComponent().show(this, e2.getX(), e2.getY());
                    } else {
                        this.notifyNotDumbAware();
                    }
                    e2.consume();
                } else {
                    AnAction rightButtonAction = renderer.getRightButtonClickAction();
                    if (rightButtonAction != null) {
                        this.performAction(rightButtonAction, e2, "ICON_NAVIGATION_SECONDARY_BUTTON", this.myEditor.getDataContext());
                        e2.consume();
                    }
                }
            } else {
                ActionGroup group = this.myCustomGutterPopupGroup;
                if (group == null && this.myShowDefaultGutterPopup) {
                    group = (ActionGroup)CustomActionsSchema.getInstance().getCorrectedAction("EditorGutterPopupMenu");
                }
                if (group != null) {
                    ActionPopupMenu popupMenu = actionManager.createActionPopupMenu("unknown", group);
                    popupMenu.getComponent().show(this, e2.getX(), e2.getY());
                }
                e2.consume();
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
    }

    @Override
    public void mouseExited(MouseEvent e2) {
        TooltipController.getInstance().cancelTooltip(GUTTER_TOOLTIP_GROUP, e2, false);
    }

    private int convertPointToLineNumber(Point p2) {
        int line;
        DocumentEx document = this.myEditor.getDocument();
        if (!EditorGutterComponentImpl.isValidLine(document, line = EditorUtil.yPositionToLogicalLine((Editor)this.myEditor, p2))) {
            return -1;
        }
        int startOffset = document.getLineStartOffset(line);
        FoldRegion region = this.myEditor.getFoldingModel().getCollapsedRegionAtOffset(startOffset);
        if (region != null) {
            return document.getLineNumber(region.getEndOffset());
        }
        return line;
    }

    @Nullable
    private GutterMark getGutterRenderer(Point p2) {
        int line = this.convertPointToLineNumber(p2);
        if (line == -1) {
            return null;
        }
        List<GutterMark> renderers = this.getGutterRenderers(line);
        if (renderers == null) {
            return null;
        }
        GutterMark[] result2 = new GutterMark[]{null};
        this.processIconsRow(line, renderers, (x2, y2, renderer) -> {
            int ex = this.convertX((int)p2.getX());
            Icon icon = this.scaleIcon(renderer.getIcon());
            if (x2 <= ex && ex <= x2 + icon.getIconWidth()) {
                result2[0] = renderer;
            }
        });
        return result2[0];
    }

    @Nullable
    private GutterIconRenderer getGutterRenderer(MouseEvent e2) {
        return (GutterIconRenderer)this.getGutterRenderer(e2.getPoint());
    }

    @NotNull
    private static LineMarkerRendererEx.Position getLineMarkerPosition(@NotNull LineMarkerRenderer renderer) {
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/openapi/editor/impl/EditorGutterComponentImpl", "getLineMarkerPosition"));
        }
        if (renderer instanceof LineMarkerRendererEx) {
            LineMarkerRendererEx.Position position = ((LineMarkerRendererEx)renderer).getPosition();
            if (position == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorGutterComponentImpl", "getLineMarkerPosition"));
            }
            return position;
        }
        LineMarkerRendererEx.Position position = LineMarkerRendererEx.Position.RIGHT;
        if (position == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorGutterComponentImpl", "getLineMarkerPosition"));
        }
        return position;
    }

    int convertX(int x2) {
        if (!this.isMirrored()) {
            return x2;
        }
        return this.getWidth() - x2;
    }

    public void dispose() {
        for (TextAnnotationGutterProvider gutterProvider : this.myTextAnnotationGutters) {
            gutterProvider.gutterClosed();
        }
        this.myProviderToListener.clear();
    }

    private class CloseAnnotationsAction
    extends DumbAwareAction {
        CloseAnnotationsAction() {
            super(EditorBundle.message((String)"close.editor.annotations.action.name", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorGutterComponentImpl$CloseAnnotationsAction", "actionPerformed"));
            }
            EditorGutterComponentImpl.this.closeAllAnnotations();
        }
    }

    @FunctionalInterface
    private static interface LineGutterIconRendererProcessor {
        public void process(int var1, int var2, @NotNull GutterMark var3);
    }

    @FunctionalInterface
    private static interface RangeHighlighterProcessor {
        public void process(@NotNull RangeHighlighter var1);
    }
}

