/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.impl.FoldRegionImpl;
import com.intellij.openapi.util.Key;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class FoldRegionsTree {
    private static final Key<Boolean> VISIBLE = Key.create((String)"visible.fold.region");
    @NotNull
    private volatile CachedData myCachedData = new CachedData();
    @NotNull
    private List<FoldRegion> myRegions = ContainerUtil.newArrayList();
    private static final Comparator<FoldRegion> BY_END_OFFSET = (r1, r2) -> {
        int end2;
        int end1 = r1.getEndOffset();
        if (end1 < (end2 = r2.getEndOffset())) {
            return -1;
        }
        if (end1 > end2) {
            return 1;
        }
        return 0;
    };
    private static final Comparator<? super FoldRegion> BY_END_OFFSET_REVERSE = Collections.reverseOrder(BY_END_OFFSET);
    private static final TObjectHashingStrategy<FoldRegion> OFFSET_BASED_HASHING_STRATEGY = new TObjectHashingStrategy<FoldRegion>(){

        public int computeHashCode(FoldRegion o2) {
            return o2.getStartOffset() * 31 + o2.getEndOffset();
        }

        public boolean equals(FoldRegion o1, FoldRegion o2) {
            return o1.getStartOffset() == o2.getStartOffset() && o1.getEndOffset() == o2.getEndOffset();
        }
    };

    FoldRegionsTree() {
    }

    void clear() {
        this.clearCachedValues();
        for (FoldRegion region : this.myRegions) {
            region.dispose();
        }
        this.myRegions = new ArrayList<FoldRegion>();
    }

    void clearCachedValues() {
        this.myCachedData = new CachedData();
    }

    protected abstract boolean isFoldingEnabled();

    void rebuild() {
        ArrayList<FoldRegion> topLevels = new ArrayList<FoldRegion>(this.myRegions.size() / 2);
        ArrayList<FoldRegion> visible = new ArrayList<FoldRegion>(this.myRegions.size());
        ArrayList<FoldRegion> allValid = new ArrayList<FoldRegion>(this.myRegions.size());
        THashMap distinctRegions = new THashMap(this.myRegions.size(), OFFSET_BASED_HASHING_STRATEGY);
        for (FoldRegion foldRegion : this.myRegions) {
            if (!foldRegion.isValid()) continue;
            if (distinctRegions.contains((Object)foldRegion)) {
                if (foldRegion.getUserData(VISIBLE) == null) {
                    foldRegion.dispose();
                    continue;
                }
                FoldRegion identicalRegion = (FoldRegion)distinctRegions.remove((Object)foldRegion);
                identicalRegion.dispose();
            }
            distinctRegions.put((Object)foldRegion, (Object)foldRegion);
        }
        for (FoldRegion foldRegion : this.myRegions) {
            if (!foldRegion.isValid()) continue;
            allValid.add(foldRegion);
        }
        if (allValid.size() < this.myRegions.size()) {
            this.myRegions = allValid;
        }
        Collections.sort(this.myRegions, RangeMarker.BY_START_OFFSET);
        FoldRegion currentCollapsed = null;
        for (FoldRegion region : this.myRegions) {
            if (!region.isExpanded()) {
                FoldRegionsTree.removeRegionsWithSameStartOffset(visible, region);
                FoldRegionsTree.removeRegionsWithSameStartOffset(topLevels, region);
            }
            if (currentCollapsed == null || !FoldRegionsTree.contains(currentCollapsed, region)) {
                visible.add(region);
                region.putUserData(VISIBLE, (Object)Boolean.TRUE);
                if (region.isExpanded()) continue;
                currentCollapsed = region;
                topLevels.add(region);
                continue;
            }
            region.putUserData(VISIBLE, null);
        }
        FoldRegion[] foldRegionArray = FoldRegionsTree.toFoldArray(topLevels);
        FoldRegion[] visibleRegions = FoldRegionsTree.toFoldArray(visible);
        Arrays.sort(foldRegionArray, BY_END_OFFSET);
        Arrays.sort(visibleRegions, BY_END_OFFSET_REVERSE);
        this.updateCachedOffsets(visibleRegions, foldRegionArray);
    }

    private static void removeRegionsWithSameStartOffset(List<FoldRegion> regions, FoldRegion region) {
        for (int i2 = regions.size() - 1; i2 >= 0 && regions.get(i2).getStartOffset() == region.getStartOffset(); --i2) {
            regions.remove(i2);
        }
    }

    @NotNull
    private static FoldRegion[] toFoldArray(@NotNull List<FoldRegion> topLevels) {
        if (topLevels == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topLevels", "com/intellij/openapi/editor/impl/FoldRegionsTree", "toFoldArray"));
        }
        FoldRegion[] foldRegionArray = topLevels.isEmpty() ? FoldRegion.EMPTY_ARRAY : topLevels.toArray(new FoldRegion[topLevels.size()]);
        if (foldRegionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/FoldRegionsTree", "toFoldArray"));
        }
        return foldRegionArray;
    }

    void updateCachedOffsets() {
        CachedData cachedData = this.myCachedData;
        this.updateCachedOffsets(cachedData.visibleRegions, cachedData.topLevelRegions);
    }

    private void updateCachedOffsets(FoldRegion[] visibleRegions, FoldRegion[] topLevelRegions) {
        if (!this.isFoldingEnabled()) {
            return;
        }
        if (visibleRegions == null) {
            this.rebuild();
            return;
        }
        THashSet distinctRegions = new THashSet(visibleRegions.length, OFFSET_BASED_HASHING_STRATEGY);
        for (FoldRegion foldRegion : visibleRegions) {
            if (foldRegion.isValid() && distinctRegions.add(foldRegion)) continue;
            this.rebuild();
            return;
        }
        int length = topLevelRegions.length;
        int[] startOffsets = ArrayUtil.newIntArray((int)length);
        int[] endOffsets = ArrayUtil.newIntArray((int)length);
        int[] foldedLines = ArrayUtil.newIntArray((int)length);
        int sum = 0;
        for (int i2 = 0; i2 < length; ++i2) {
            FoldRegion region = topLevelRegions[i2];
            startOffsets[i2] = region.getStartOffset();
            endOffsets[i2] = region.getEndOffset() - 1;
            Document document = region.getDocument();
            foldedLines[i2] = sum += document.getLineNumber(region.getEndOffset()) - document.getLineNumber(region.getStartOffset());
        }
        this.myCachedData = new CachedData(visibleRegions, topLevelRegions, startOffsets, endOffsets, foldedLines);
    }

    boolean addRegion(@NotNull FoldRegion range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/editor/impl/FoldRegionsTree", "addRegion"));
        }
        int start2 = range.getStartOffset();
        int end = range.getEndOffset();
        int insertionIndex = this.myRegions.size();
        for (int i2 = 0; i2 < this.myRegions.size(); ++i2) {
            FoldRegion region = this.myRegions.get(i2);
            int rStart = region.getStartOffset();
            int rEnd = region.getEndOffset();
            if (rStart < start2) {
                if (!region.isValid() || start2 >= rEnd || rEnd >= end) continue;
                return false;
            }
            if (rStart == start2) {
                if (rEnd == end) {
                    return false;
                }
                if (rEnd <= end) continue;
                insertionIndex = Math.min(insertionIndex, i2);
                continue;
            }
            insertionIndex = Math.min(insertionIndex, i2);
            if (rStart > end) break;
            if (!region.isValid() || rStart >= end || end >= rEnd) continue;
            return false;
        }
        this.myRegions.add(insertionIndex, range);
        return true;
    }

    @Nullable
    FoldRegion fetchOutermost(int offset) {
        CachedData cachedData = this.myCachedData;
        if (cachedData.isUnavailable()) {
            return null;
        }
        int[] starts = cachedData.startOffsets;
        int[] ends = cachedData.endOffsets;
        if (starts == null || ends == null) {
            return null;
        }
        int start2 = 0;
        int end = ends.length - 1;
        while (start2 <= end) {
            int i2 = (start2 + end) / 2;
            if (offset < starts[i2]) {
                end = i2 - 1;
                continue;
            }
            if (offset > ends[i2]) {
                start2 = i2 + 1;
                continue;
            }
            return cachedData.topLevelRegions[i2];
        }
        return null;
    }

    FoldRegion[] fetchVisible() {
        CachedData cachedData = this.myCachedData;
        return cachedData.isUnavailable() ? FoldRegion.EMPTY_ARRAY : cachedData.visibleRegions;
    }

    @Nullable
    FoldRegion[] fetchTopLevel() {
        CachedData cachedData = this.myCachedData;
        return cachedData.isUnavailable() ? null : cachedData.topLevelRegions;
    }

    private static boolean contains(FoldRegion outer, FoldRegion inner) {
        return outer.getStartOffset() <= inner.getStartOffset() && outer.getEndOffset() >= inner.getEndOffset();
    }

    static boolean contains(FoldRegion region, int offset) {
        return region.getStartOffset() < offset && region.getEndOffset() > offset;
    }

    @NotNull
    FoldRegion[] fetchCollapsedAt(int offset) {
        if (this.myCachedData.isUnavailable()) {
            if (FoldRegion.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/FoldRegionsTree", "fetchCollapsedAt"));
            }
            return FoldRegion.EMPTY_ARRAY;
        }
        ArrayList<FoldRegion> allCollapsed = new ArrayList<FoldRegion>();
        for (FoldRegion region : this.myRegions) {
            if (region.isExpanded() || !FoldRegionsTree.contains(region, offset)) continue;
            allCollapsed.add(region);
        }
        FoldRegion[] foldRegionArray = FoldRegionsTree.toFoldArray(allCollapsed);
        if (foldRegionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/FoldRegionsTree", "fetchCollapsedAt"));
        }
        return foldRegionArray;
    }

    boolean intersectsRegion(int startOffset, int endOffset) {
        if (!this.isFoldingEnabled()) {
            return true;
        }
        for (FoldRegion region : this.myRegions) {
            boolean contains2;
            boolean contains1 = FoldRegionsTree.contains(region, startOffset);
            if (contains1 == (contains2 = FoldRegionsTree.contains(region, endOffset))) continue;
            return true;
        }
        return false;
    }

    FoldRegion[] fetchAllRegions() {
        if (this.myCachedData.isUnavailable()) {
            return FoldRegion.EMPTY_ARRAY;
        }
        return FoldRegionsTree.toFoldArray(this.myRegions);
    }

    void removeRegion(@NotNull FoldRegion range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/editor/impl/FoldRegionsTree", "removeRegion"));
        }
        this.myRegions.remove(range);
    }

    int getFoldedLinesCountBefore(int offset) {
        CachedData snapshot = this.myCachedData;
        int idx = FoldRegionsTree.getLastTopLevelIndexBefore(snapshot, offset);
        if (idx == -1) {
            return 0;
        }
        return snapshot.foldedLines[idx];
    }

    int getTotalNumberOfFoldedLines() {
        CachedData snapshot = this.myCachedData;
        int[] foldedLines = snapshot.foldedLines;
        if (snapshot.isUnavailable() || foldedLines == null || foldedLines.length == 0) {
            return 0;
        }
        return foldedLines[foldedLines.length - 1];
    }

    int getLastTopLevelIndexBefore(int offset) {
        return FoldRegionsTree.getLastTopLevelIndexBefore(this.myCachedData, offset);
    }

    private static int getLastTopLevelIndexBefore(CachedData snapshot, int offset) {
        int[] endOffsets = snapshot.endOffsets;
        if (snapshot.isUnavailable() || endOffsets == null) {
            return -1;
        }
        --offset;
        int start2 = 0;
        int end = endOffsets.length - 1;
        while (start2 <= end) {
            int i2 = (start2 + end) / 2;
            if (offset < endOffsets[i2]) {
                end = i2 - 1;
                continue;
            }
            if (offset > endOffsets[i2]) {
                start2 = i2 + 1;
                continue;
            }
            return i2;
        }
        return end;
    }

    @Nullable
    FoldRegion getRegionAt(int startOffset, int endOffset) {
        int index = Collections.binarySearch(this.myRegions, new DummyFoldRegion(startOffset, endOffset), RangeMarker.BY_START_OFFSET);
        return index < 0 ? null : this.myRegions.get(index);
    }

    void clearDocumentRangesModificationStatus() {
        for (FoldRegion region : this.myRegions) {
            if (!(region instanceof FoldRegionImpl)) continue;
            ((FoldRegionImpl)region).resetDocumentRegionChanged();
        }
    }

    private static class DummyFoldRegion
    implements FoldRegion {
        private final int myStartOffset;
        private final int myEndOffset;

        private DummyFoldRegion(int startOffset, int endOffset) {
            this.myStartOffset = startOffset;
            this.myEndOffset = endOffset;
        }

        public boolean isExpanded() {
            throw new UnsupportedOperationException();
        }

        public void setExpanded(boolean expanded) {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public String getPlaceholderText() {
            throw new UnsupportedOperationException();
        }

        public Editor getEditor() {
            throw new UnsupportedOperationException();
        }

        @Nullable
        public FoldingGroup getGroup() {
            throw new UnsupportedOperationException();
        }

        public boolean shouldNeverExpand() {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public Document getDocument() {
            throw new UnsupportedOperationException();
        }

        public int getStartOffset() {
            return this.myStartOffset;
        }

        public int getEndOffset() {
            return this.myEndOffset;
        }

        public boolean isValid() {
            throw new UnsupportedOperationException();
        }

        public void setGreedyToLeft(boolean greedy) {
            throw new UnsupportedOperationException();
        }

        public void setGreedyToRight(boolean greedy) {
            throw new UnsupportedOperationException();
        }

        public boolean isGreedyToRight() {
            throw new UnsupportedOperationException();
        }

        public boolean isGreedyToLeft() {
            throw new UnsupportedOperationException();
        }

        public void dispose() {
            throw new UnsupportedOperationException();
        }

        @Nullable
        public <T> T getUserData(@NotNull Key<T> key) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/editor/impl/FoldRegionsTree$DummyFoldRegion", "getUserData"));
            }
            throw new UnsupportedOperationException();
        }

        public <T> void putUserData(@NotNull Key<T> key, @Nullable T value2) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/editor/impl/FoldRegionsTree$DummyFoldRegion", "putUserData"));
            }
            throw new UnsupportedOperationException();
        }
    }

    private class CachedData
    implements Cloneable {
        private final FoldRegion[] visibleRegions;
        private final FoldRegion[] topLevelRegions;
        private final int[] startOffsets;
        private final int[] endOffsets;
        private final int[] foldedLines;

        private CachedData() {
            this.visibleRegions = null;
            this.topLevelRegions = null;
            this.startOffsets = null;
            this.endOffsets = null;
            this.foldedLines = null;
        }

        private CachedData(@NotNull FoldRegion[] visibleRegions, @NotNull FoldRegion[] topLevelRegions, @NotNull int[] startOffsets, @NotNull int[] endOffsets, int[] foldedLines) {
            if (visibleRegions == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibleRegions", "com/intellij/openapi/editor/impl/FoldRegionsTree$CachedData", "<init>"));
            }
            if (topLevelRegions == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topLevelRegions", "com/intellij/openapi/editor/impl/FoldRegionsTree$CachedData", "<init>"));
            }
            if (startOffsets == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startOffsets", "com/intellij/openapi/editor/impl/FoldRegionsTree$CachedData", "<init>"));
            }
            if (endOffsets == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endOffsets", "com/intellij/openapi/editor/impl/FoldRegionsTree$CachedData", "<init>"));
            }
            if (foldedLines == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foldedLines", "com/intellij/openapi/editor/impl/FoldRegionsTree$CachedData", "<init>"));
            }
            this.visibleRegions = visibleRegions;
            this.topLevelRegions = topLevelRegions;
            this.startOffsets = startOffsets;
            this.endOffsets = endOffsets;
            this.foldedLines = foldedLines;
        }

        private boolean isUnavailable() {
            return !FoldRegionsTree.this.isFoldingEnabled() || this.visibleRegions == null;
        }
    }
}

