/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.util.Getter;
import com.intellij.util.DocumentUtil;
import org.jetbrains.annotations.NotNull;

class InlayImpl
extends RangeMarkerImpl
implements Inlay,
Getter<InlayImpl> {
    @NotNull
    private final EditorImpl myEditor;
    final int myOriginalOffset;
    int myOffsetBeforeDisposal;
    private int myWidthInPixels;
    @NotNull
    private final EditorCustomElementRenderer myRenderer;

    InlayImpl(@NotNull EditorImpl editor, int offset, @NotNull EditorCustomElementRenderer renderer) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/impl/InlayImpl", "<init>"));
        }
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/openapi/editor/impl/InlayImpl", "<init>"));
        }
        super(editor.getDocument(), offset, offset, false);
        this.myOffsetBeforeDisposal = -1;
        this.myEditor = editor;
        this.myOriginalOffset = offset;
        this.myRenderer = renderer;
        this.doUpdateSize();
        this.myEditor.getInlayModel().myInlayTree.addInterval(this, offset, offset, false, false, 0);
    }

    public void updateSize() {
        this.doUpdateSize();
        this.myEditor.getInlayModel().notifyChanged(this);
    }

    private void doUpdateSize() {
        this.myWidthInPixels = this.myRenderer.calcWidthInPixels((Editor)this.myEditor);
        if (this.myWidthInPixels <= 0) {
            throw new IllegalArgumentException("Positive width should be defined for an inline element");
        }
    }

    @Override
    protected void changedUpdateImpl(@NotNull DocumentEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/InlayImpl", "changedUpdateImpl"));
        }
        super.changedUpdateImpl(e2);
        if (this.myEditor.getInlayModel().myStickToLargerOffsetsOnUpdate && this.isValid() && e2.getOldLength() == 0 && this.getOffset() == e2.getOffset()) {
            int newOffset = e2.getOffset() + e2.getNewLength();
            this.setIntervalStart(newOffset);
            this.setIntervalEnd(newOffset);
        }
        if (this.isValid() && DocumentUtil.isInsideSurrogatePair(this.getDocument(), this.intervalStart())) {
            this.invalidate(e2);
        }
    }

    @Override
    protected void onReTarget(int startOffset, int endOffset, int destOffset) {
        if (DocumentUtil.isInsideSurrogatePair(this.getDocument(), this.getOffset())) {
            this.invalidate("moved inside surrogate pair on retarget");
        }
    }

    @Override
    public void dispose() {
        if (this.isValid()) {
            this.myOffsetBeforeDisposal = this.getOffset();
            this.myEditor.getInlayModel().myInlayTree.removeInterval(this);
            this.myEditor.getInlayModel().notifyRemoved(this);
        }
    }

    public int getOffset() {
        return this.myOffsetBeforeDisposal == -1 ? this.getStartOffset() : this.myOffsetBeforeDisposal;
    }

    @NotNull
    public EditorCustomElementRenderer getRenderer() {
        EditorCustomElementRenderer editorCustomElementRenderer = this.myRenderer;
        if (editorCustomElementRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/InlayImpl", "getRenderer"));
        }
        return editorCustomElementRenderer;
    }

    public int getWidthInPixels() {
        return this.myWidthInPixels;
    }

    public InlayImpl get() {
        return this;
    }
}

