/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.PersistentRangeMarkerUtil;
import com.intellij.openapi.editor.impl.RangeHighlighterImpl;
import com.intellij.openapi.editor.impl.event.DocumentEventImpl;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.util.DocumentUtil;
import com.intellij.util.diff.FilesTooBigForDiffException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PersistentRangeHighlighterImpl
extends RangeHighlighterImpl
implements RangeHighlighterEx {
    private int myLine;

    static PersistentRangeHighlighterImpl create(@NotNull MarkupModel model2, int offset, int layer, @NotNull HighlighterTargetArea target, @Nullable TextAttributes textAttributes, boolean normalizeStartOffset) {
        if (model2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/openapi/editor/impl/PersistentRangeHighlighterImpl", "create"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/openapi/editor/impl/PersistentRangeHighlighterImpl", "create"));
        }
        int line = model2.getDocument().getLineNumber(offset);
        int startOffset = normalizeStartOffset ? model2.getDocument().getLineStartOffset(line) : offset;
        return new PersistentRangeHighlighterImpl(model2, startOffset, line, layer, target, textAttributes);
    }

    private PersistentRangeHighlighterImpl(@NotNull MarkupModel model2, int startOffset, int line, int layer, @NotNull HighlighterTargetArea target, @Nullable TextAttributes textAttributes) {
        if (model2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/openapi/editor/impl/PersistentRangeHighlighterImpl", "<init>"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/openapi/editor/impl/PersistentRangeHighlighterImpl", "<init>"));
        }
        super(model2, startOffset, model2.getDocument().getLineEndOffset(line), layer, target, textAttributes, false, false);
        this.myLine = line;
    }

    @Override
    protected void changedUpdateImpl(@NotNull DocumentEvent e2) {
        boolean shouldTranslateViaDiff;
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/PersistentRangeHighlighterImpl", "changedUpdateImpl"));
        }
        DocumentEventImpl event = (DocumentEventImpl)e2;
        boolean wasTranslatedViaDiff = shouldTranslateViaDiff = this.isValid() && PersistentRangeMarkerUtil.shouldTranslateViaDiff(event, this.getStartOffset(), this.getEndOffset());
        if (shouldTranslateViaDiff) {
            wasTranslatedViaDiff = this.translatedViaDiff(e2, event);
        }
        if (!wasTranslatedViaDiff) {
            super.changedUpdateImpl(e2);
            if (this.isValid()) {
                this.myLine = this.getDocument().getLineNumber(this.getStartOffset());
                int endLine = this.getDocument().getLineNumber(this.getEndOffset());
                if (endLine != this.myLine) {
                    this.setIntervalEnd(this.getDocument().getLineEndOffset(this.myLine));
                }
            }
        }
        if (this.isValid() && this.getTargetArea() == HighlighterTargetArea.LINES_IN_RANGE) {
            this.setIntervalStart(DocumentUtil.getFirstNonSpaceCharOffset(this.getDocument(), this.myLine));
            this.setIntervalEnd(this.getDocument().getLineEndOffset(this.myLine));
        }
    }

    private boolean translatedViaDiff(DocumentEvent e2, DocumentEventImpl event) {
        try {
            this.myLine = event.translateLineViaDiff(this.myLine);
        }
        catch (FilesTooBigForDiffException ignored) {
            return false;
        }
        if (this.myLine < 0 || this.myLine >= this.getDocument().getLineCount()) {
            this.invalidate(e2);
        } else {
            DocumentEx document = this.getDocument();
            this.setIntervalStart(document.getLineStartOffset(this.myLine));
            this.setIntervalEnd(document.getLineEndOffset(this.myLine));
        }
        return true;
    }

    @Override
    public String toString() {
        return "PersistentRangeHighlighter" + (this.isGreedyToLeft() ? "[" : "(") + (this.isValid() ? "valid" : "invalid") + "," + this.getStartOffset() + "," + this.getEndOffset() + " - " + this.myLine + (this.isGreedyToRight() ? "]" : ")");
    }
}

