/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.event.DocumentEvent;
import org.jetbrains.annotations.NotNull;

class PersistentRangeMarkerUtil {
    PersistentRangeMarkerUtil() {
    }

    static boolean shouldTranslateViaDiff(@NotNull DocumentEvent e2, int rangeStart, int rangeEnd) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/PersistentRangeMarkerUtil", "shouldTranslateViaDiff"));
        }
        if (e2.isWholeTextReplaced()) {
            return true;
        }
        if (e2.getOffset() >= rangeEnd || e2.getOffset() + e2.getOldLength() <= rangeStart) {
            return false;
        }
        return (double)Math.max(e2.getNewLength(), e2.getOldLength()) * 1.0 / (double)e2.getDocument().getTextLength() >= 0.8;
    }
}

