/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.ex.PrioritizedInternalDocumentListener;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.editor.ex.SweepProcessor;
import com.intellij.openapi.editor.impl.IntervalTreeImpl;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.impl.RedBlackTree;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Segment;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RangeMarkerTree<T extends RangeMarkerEx>
extends IntervalTreeImpl<T> {
    private final PrioritizedDocumentListener myListener;
    private final Document myDocument;
    private static final int DUPLICATE_LIMIT = 30;

    protected RangeMarkerTree(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/RangeMarkerTree", "<init>"));
        }
        this.myDocument = document;
        this.myListener = new PrioritizedInternalDocumentListener(){

            @Override
            public int getPriority() {
                return 40;
            }

            public void beforeDocumentChange(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent e2) {
                RangeMarkerTree.this.updateMarkersOnChange(e2);
            }

            @Override
            public void moveTextHappened(int start2, int end, int newBase) {
                RangeMarkerTree.this.reTarget(start2, end, newBase);
            }
        };
        document.addDocumentListener((DocumentListener)this.myListener);
    }

    @Override
    protected int compareEqualStartIntervals(@NotNull IntervalTreeImpl.IntervalNode<T> i1, @NotNull IntervalTreeImpl.IntervalNode<T> i2) {
        boolean greedyR2;
        int o2Length;
        boolean greedyL2;
        if (i1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "i1", "com/intellij/openapi/editor/impl/RangeMarkerTree", "compareEqualStartIntervals"));
        }
        if (i2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "i2", "com/intellij/openapi/editor/impl/RangeMarkerTree", "compareEqualStartIntervals"));
        }
        RMNode o1 = (RMNode)i1;
        RMNode o2 = (RMNode)i2;
        boolean greedyL1 = o1.isGreedyToLeft();
        if (greedyL1 != (greedyL2 = o2.isGreedyToLeft())) {
            return greedyL1 ? -1 : 1;
        }
        int o1Length = o1.intervalEnd() - o1.intervalStart();
        int d2 = o1Length - (o2Length = o2.intervalEnd() - o2.intervalStart());
        if (d2 != 0) {
            return d2;
        }
        boolean greedyR1 = o1.isGreedyToRight();
        if (greedyR1 != (greedyR2 = o2.isGreedyToRight())) {
            return greedyR1 ? -1 : 1;
        }
        return 0;
    }

    void dispose() {
        this.myDocument.removeDocumentListener((DocumentListener)this.myListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public RMNode<T> addInterval(@NotNull T interval, int start2, int end, boolean greedyToLeft, boolean greedyToRight, int layer) {
        if (interval == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interval", "com/intellij/openapi/editor/impl/RangeMarkerTree", "addInterval"));
        }
        interval.setValid(true);
        RMNode node = (RMNode)super.addInterval(interval, start2, end, greedyToLeft, greedyToRight, layer);
        if (DEBUG && node.intervals.size() > 30 && !ApplicationInfoImpl.isInStressTest() && ApplicationManager.getApplication().isUnitTestMode()) {
            this.l.readLock().lock();
            try {
                String msg = this.errMsg(node);
                if (msg != null) {
                    LOG.warn(msg);
                }
            }
            finally {
                this.l.readLock().unlock();
            }
        }
        RMNode rMNode = node;
        if (rMNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/RangeMarkerTree", "addInterval"));
        }
        return rMNode;
    }

    private String errMsg(@NotNull RMNode<T> node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/openapi/editor/impl/RangeMarkerTree", "errMsg"));
        }
        System.gc();
        AtomicInteger alive = new AtomicInteger();
        node.processAliveKeys(t2 -> {
            alive.incrementAndGet();
            return true;
        });
        if (alive.get() > 30) {
            return "Too many range markers (" + alive + ") registered for interval " + node;
        }
        return null;
    }

    @Override
    @NotNull
    protected RMNode<T> createNewNode(@NotNull T key, int start2, int end, boolean greedyToLeft, boolean greedyToRight, int layer) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/editor/impl/RangeMarkerTree", "createNewNode"));
        }
        RMNode<T> rMNode = new RMNode<T>(this, key, start2, end, greedyToLeft, greedyToRight);
        if (rMNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/RangeMarkerTree", "createNewNode"));
        }
        return rMNode;
    }

    @Override
    protected void checkBelongsToTheTree(@NotNull T interval, boolean assertInvalid) {
        if (interval == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interval", "com/intellij/openapi/editor/impl/RangeMarkerTree", "checkBelongsToTheTree"));
        }
        assert (interval.getDocument() == this.myDocument);
        super.checkBelongsToTheTree(interval, assertInvalid);
    }

    @Override
    protected RMNode<T> lookupNode(@NotNull T key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/editor/impl/RangeMarkerTree", "lookupNode"));
        }
        return ((RangeMarkerImpl)key).myNode;
    }

    @Override
    protected void setNode(@NotNull T key, IntervalTreeImpl.IntervalNode<T> intervalNode) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/editor/impl/RangeMarkerTree", "setNode"));
        }
        ((RangeMarkerImpl)key).myNode = (RMNode)intervalNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMarkersOnChange(@NotNull DocumentEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/RangeMarkerTree", "updateMarkersOnChange"));
        }
        try {
            this.l.writeLock().lock();
            if (this.size() == 0) {
                return;
            }
            this.checkMax(true);
            ++this.modCount;
            SmartList affected = new SmartList();
            this.collectAffectedMarkersAndShiftSubtrees(this.getRoot(), e2, (List<IntervalTreeImpl.IntervalNode<T>>)affected);
            this.checkMax(false);
            if (!affected.isEmpty()) {
                for (int i2 = affected.size() - 1; i2 >= 0; --i2) {
                    IntervalTreeImpl.IntervalNode node = (IntervalTreeImpl.IntervalNode)affected.get(i2);
                    int startOffset = node.intervalStart();
                    int endOffset = node.intervalEnd();
                    this.removeNode(node);
                    this.checkMax(false);
                    node.clearDelta();
                    node.setParent(null);
                    node.setLeft(null);
                    node.setRight(null);
                    node.setValid(true);
                    assert (node.intervalStart() == startOffset);
                    assert (node.intervalEnd() == endOffset);
                }
                this.checkMax(true);
                for (IntervalTreeImpl.IntervalNode node : affected) {
                    List keys = node.intervals;
                    if (keys.isEmpty()) continue;
                    RangeMarkerImpl marker = null;
                    for (int i3 = keys.size() - 1; i3 >= 0; --i3) {
                        Getter key = keys.get(i3);
                        marker = (RangeMarkerImpl)key.get();
                        if (marker == null) continue;
                        if (marker.isValid()) break;
                        node.removeIntervalInternal(i3);
                        marker = null;
                    }
                    if (marker == null) continue;
                    marker.documentChanged(e2);
                    if (marker.isValid()) {
                        this.findOrInsertWithIntervals(node);
                        assert (marker.isValid());
                        continue;
                    }
                    node.setValid(false);
                }
            }
            this.checkMax(true);
            IntervalTreeImpl.IntervalNode root = this.getRoot();
            assert (root == null || root.maxEnd + root.delta <= this.myDocument.getTextLength());
        }
        finally {
            this.l.writeLock().unlock();
        }
    }

    private void findOrInsertWithIntervals(IntervalTreeImpl.IntervalNode<T> node) {
        IntervalTreeImpl.IntervalNode<T> insertedNode = this.findOrInsert(node);
        if (insertedNode != node) {
            for (Getter key : node.intervals) {
                RangeMarkerEx interval = (RangeMarkerEx)key.get();
                if (interval == null) continue;
                insertedNode.addInterval(interval);
            }
        }
    }

    private boolean collectAffectedMarkersAndShiftSubtrees(@Nullable IntervalTreeImpl.IntervalNode<T> root, @NotNull DocumentEvent e2, @NotNull List<IntervalTreeImpl.IntervalNode<T>> affected) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/RangeMarkerTree", "collectAffectedMarkersAndShiftSubtrees"));
        }
        if (affected == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "affected", "com/intellij/openapi/editor/impl/RangeMarkerTree", "collectAffectedMarkersAndShiftSubtrees"));
        }
        if (root == null) {
            return true;
        }
        boolean norm = this.pushDelta(root);
        int maxEnd = root.maxEnd;
        assert (root.isValid());
        int offset = e2.getOffset();
        int affectedEndOffset = offset + e2.getOldLength();
        boolean hasAliveKeys = root.hasAliveKey(false);
        if (!hasAliveKeys) {
            affected.add(root);
        }
        if (offset <= maxEnd) {
            if (affectedEndOffset < root.intervalStart()) {
                int lengthDelta = e2.getNewLength() - e2.getOldLength();
                int newD = root.changeDelta(lengthDelta);
                norm &= newD == 0;
                RedBlackTree.Node left = root.getLeft();
                if (left != null) {
                    int newL = ((IntervalTreeImpl.IntervalNode)left).changeDelta(-lengthDelta);
                    norm &= newL == 0;
                }
                norm &= this.pushDelta(root);
                norm &= this.collectAffectedMarkersAndShiftSubtrees((IntervalTreeImpl.IntervalNode<T>)left, e2, affected);
                this.correctMax(root, 0);
            } else {
                if (offset <= root.intervalEnd()) {
                    if (hasAliveKeys) {
                        affected.add(root);
                    }
                    root.setValid(false);
                }
                norm &= this.collectAffectedMarkersAndShiftSubtrees((IntervalTreeImpl.IntervalNode<T>)root.getLeft(), e2, affected);
                norm &= this.collectAffectedMarkersAndShiftSubtrees((IntervalTreeImpl.IntervalNode<T>)root.getRight(), e2, affected);
                this.correctMax(root, 0);
            }
        }
        return norm;
    }

    public boolean sweep(final int start2, final int end, @NotNull SweepProcessor<T> sweepProcessor) {
        if (sweepProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sweepProcessor", "com/intellij/openapi/editor/impl/RangeMarkerTree", "sweep"));
        }
        return RangeMarkerTree.sweep(new Generator<T>(){

            @Override
            public boolean generateInStartOffsetOrder(@NotNull Processor<T> processor2) {
                if (processor2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/editor/impl/RangeMarkerTree$2", "generateInStartOffsetOrder"));
                }
                return RangeMarkerTree.this.processOverlappingWith(start2, end, processor2);
            }
        }, sweepProcessor);
    }

    public static <T extends Segment> boolean sweep(@NotNull Generator<T> generator, @NotNull SweepProcessor<T> sweepProcessor) {
        ArrayList starts;
        if (generator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generator", "com/intellij/openapi/editor/impl/RangeMarkerTree", "sweep"));
        }
        if (sweepProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sweepProcessor", "com/intellij/openapi/editor/impl/RangeMarkerTree", "sweep"));
        }
        PriorityQueue<Segment> ends = new PriorityQueue<Segment>(5, Comparator.comparingInt(Segment::getEndOffset));
        if (!generator.generateInStartOffsetOrder(arg_0 -> RangeMarkerTree.lambda$sweep$1(ends, starts = new ArrayList(), sweepProcessor, arg_0))) {
            return false;
        }
        while (!ends.isEmpty()) {
            assert (ends.size() == starts.size());
            Segment previous = (Segment)ends.remove();
            int prevEnd = previous.getEndOffset();
            if (!sweepProcessor.process(prevEnd, previous, false, ends)) {
                return false;
            }
            boolean removed = starts.remove(previous);
            assert (removed);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reTarget(int start2, int end, int newBase) {
        this.l.writeLock().lock();
        try {
            this.checkMax(true);
            ArrayList<IntervalTreeImpl.IntervalNode<T>> affected = new ArrayList<IntervalTreeImpl.IntervalNode<T>>();
            this.collectNodesToRetarget(this.getRoot(), start2, end, affected);
            if (affected.isEmpty()) {
                return;
            }
            for (IntervalTreeImpl.IntervalNode intervalNode : affected) {
                this.removeNode(intervalNode);
            }
            int shift = newBase - start2;
            for (IntervalTreeImpl.IntervalNode intervalNode : affected) {
                intervalNode.setLeft(null);
                intervalNode.setRight(null);
                intervalNode.setParent(null);
                intervalNode.changeDelta(shift);
                intervalNode.setValid(true);
                this.pushDelta(intervalNode);
                List keys = intervalNode.intervals;
                if (keys.isEmpty()) continue;
                RangeMarkerImpl marker = null;
                for (int i2 = keys.size() - 1; i2 >= 0; --i2) {
                    Getter key = keys.get(i2);
                    marker = (RangeMarkerImpl)key.get();
                    if (marker == null) continue;
                    if (marker.isValid()) break;
                    intervalNode.removeIntervalInternal(i2);
                    marker = null;
                }
                if (marker == null) continue;
                marker.onReTarget(start2, end, newBase);
                if (!marker.isValid()) continue;
                this.findOrInsertWithIntervals(intervalNode);
            }
        }
        finally {
            this.checkMax(true);
            this.l.writeLock().unlock();
        }
    }

    private void collectNodesToRetarget(@Nullable IntervalTreeImpl.IntervalNode<T> root, int start2, int end, @NotNull List<IntervalTreeImpl.IntervalNode<T>> affected) {
        if (affected == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "affected", "com/intellij/openapi/editor/impl/RangeMarkerTree", "collectNodesToRetarget"));
        }
        if (root == null) {
            return;
        }
        this.pushDelta(root);
        int maxEnd = root.maxEnd;
        assert (root.isValid());
        if (start2 > maxEnd) {
            return;
        }
        this.collectNodesToRetarget((IntervalTreeImpl.IntervalNode<T>)root.getLeft(), start2, end, affected);
        if (start2 <= root.intervalStart() && root.intervalEnd() <= end) {
            affected.add(root);
        }
        if (end < root.intervalStart()) {
            return;
        }
        this.collectNodesToRetarget((IntervalTreeImpl.IntervalNode<T>)root.getRight(), start2, end, affected);
    }

    private static /* synthetic */ boolean lambda$sweep$1(Queue ends, List starts, @NotNull SweepProcessor sweepProcessor, Segment marker) {
        int start2;
        block5: {
            boolean removed;
            if (sweepProcessor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sweepProcessor", "com/intellij/openapi/editor/impl/RangeMarkerTree", "lambda$sweep$1"));
            }
            start2 = marker.getStartOffset();
            while (true) {
                int prevEnd;
                assert (ends.size() == starts.size());
                Segment previous = (Segment)ends.peek();
                if (previous == null || (prevEnd = previous.getEndOffset()) > start2) break block5;
                if (!sweepProcessor.process(prevEnd, previous, false, ends)) {
                    return false;
                }
                ends.remove();
                removed = starts.remove(previous);
                assert (removed);
            }
        }
        if (!sweepProcessor.process(start2, marker, true, ends)) {
            return false;
        }
        starts.add(marker);
        ends.offer(marker);
        return true;
    }

    public static interface Generator<T> {
        public boolean generateInStartOffsetOrder(@NotNull Processor<T> var1);
    }

    static class RMNode<T extends RangeMarkerEx>
    extends IntervalTreeImpl.IntervalNode<T> {
        private static final byte EXPAND_TO_LEFT_FLAG = 8;
        private static final byte EXPAND_TO_RIGHT_FLAG = 16;

        RMNode(@NotNull RangeMarkerTree<T> rangeMarkerTree, @NotNull T key, int start2, int end, boolean greedyToLeft, boolean greedyToRight) {
            if (rangeMarkerTree == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeMarkerTree", "com/intellij/openapi/editor/impl/RangeMarkerTree$RMNode", "<init>"));
            }
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/editor/impl/RangeMarkerTree$RMNode", "<init>"));
            }
            super(rangeMarkerTree, key, start2, end);
            this.setFlag((byte)8, greedyToLeft);
            this.setFlag((byte)16, greedyToRight);
        }

        boolean isGreedyToLeft() {
            return this.isFlagSet((byte)8);
        }

        boolean isGreedyToRight() {
            return this.isFlagSet((byte)16);
        }

        @Override
        public String toString() {
            return (this.isGreedyToLeft() ? "[" : "(") + this.intervalStart() + "," + this.intervalEnd() + (this.isGreedyToRight() ? "]" : ")");
        }
    }
}

