/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.TextChange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;

public class TextChangeImpl
implements TextChange {
    private final StringBuilder myText;
    private char[] myChars;
    private int myStart;
    private int myEnd;

    public TextChangeImpl(@NotNull CharSequence text2, int start2) throws IllegalArgumentException {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/impl/TextChangeImpl", "<init>"));
        }
        this(text2, start2, start2);
    }

    public TextChangeImpl(@NotNull CharSequence text2, int start2, int end) throws IllegalArgumentException {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/impl/TextChangeImpl", "<init>"));
        }
        this.myText = new StringBuilder();
        if (start2 < 0) {
            throw new IllegalArgumentException(String.format("Can't construct new %s object. Reason: given start index (%d) is negative. End index: %d, text: '%s'", this.getClass().getName(), start2, end, text2));
        }
        if (end < start2) {
            throw new IllegalArgumentException(String.format("Can't construct new %s object. Reason: given end index (%d) is less than start index (%d). Text: '%s'", this.getClass().getName(), end, start2, text2));
        }
        this.myText.append(text2);
        this.myStart = start2;
        this.myEnd = end;
    }

    public int getStart() {
        return this.myStart;
    }

    public void setStart(int start2) {
        assert (start2 >= 0) : start2;
        this.myStart = start2;
    }

    public int getEnd() {
        return this.myEnd;
    }

    public void setEnd(int end) {
        this.myEnd = end;
    }

    @NotNull
    public CharSequence getText() {
        StringBuilder stringBuilder = this.myText;
        if (stringBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/TextChangeImpl", "getText"));
        }
        return stringBuilder;
    }

    @NotNull
    public char[] getChars() {
        if (this.myChars == null) {
            this.myChars = CharArrayUtil.fromSequence((CharSequence)this.myText);
        }
        if (this.myChars == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/TextChangeImpl", "getChars"));
        }
        return this.myChars;
    }

    public int getDiff() {
        return this.myText.length() - this.myEnd + this.myStart;
    }

    public void advance(int offset) throws IllegalArgumentException {
        if (offset == 0) {
            return;
        }
        int newStart = this.myStart + offset;
        if (newStart < 0) {
            throw new IllegalArgumentException(String.format("Can't apply given offset (%d) to the current text change object (%s). Reason: new start index becomes negative after that (%d)", offset, this, newStart));
        }
        this.setStart(newStart);
        this.setEnd(this.myEnd + offset);
    }

    public boolean isWithinBounds(int length) {
        return this.isWithinBounds(0, length);
    }

    public boolean isWithinBounds(int start2, int end) {
        return this.myStart >= start2 && this.myEnd <= end && this.myStart <= this.myEnd;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        TextChangeImpl that = (TextChangeImpl)o2;
        return this.myStart == that.myStart && this.myEnd == that.myEnd && StringUtil.equals((CharSequence)this.myText, (CharSequence)that.myText);
    }

    public int hashCode() {
        int result2 = StringUtil.hashCode((CharSequence)this.myText);
        result2 = 31 * result2 + this.myStart;
        return 31 * result2 + this.myEnd;
    }

    public String toString() {
        return String.format("%d-%d: '%s'", this.myStart, this.myEnd, this.myText);
    }
}

