/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.softwrap;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.ArrowPainter;
import com.intellij.openapi.editor.impl.ColorProvider;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapDrawingType;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapPainter;
import com.intellij.openapi.util.Computable;
import java.awt.Graphics;
import org.jetbrains.annotations.NotNull;

public class ArrowSoftWrapPainter
implements SoftWrapPainter {
    private final HeightProvider myHeightProvider = new HeightProvider();
    private final Editor myEditor;
    private final ArrowPainter myArrowPainter;
    private int myMinWidth = -1;

    public ArrowSoftWrapPainter(Editor editor) {
        this.myEditor = editor;
        this.myArrowPainter = new ArrowPainter(ColorProvider.byColor(this.myEditor.getColorsScheme().getDefaultForeground()), new WidthProvider(), this.myHeightProvider);
    }

    @Override
    public int paint(@NotNull Graphics g2, @NotNull SoftWrapDrawingType drawingType, int x2, int y2, int lineHeight) {
        int result2;
        int end;
        int start2;
        if (g2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/softwrap/ArrowSoftWrapPainter", "paint"));
        }
        if (drawingType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "drawingType", "com/intellij/openapi/editor/impl/softwrap/ArrowSoftWrapPainter", "paint"));
        }
        this.myHeightProvider.myHeight = lineHeight / 2;
        switch (drawingType) {
            case BEFORE_SOFT_WRAP_LINE_FEED: {
                start2 = x2;
                end = this.myEditor.getScrollingModel().getVisibleArea().width;
                result2 = end - start2;
                break;
            }
            case AFTER_SOFT_WRAP: {
                start2 = 0;
                end = x2;
                result2 = 0;
                break;
            }
            default: {
                throw new IllegalStateException("Soft wrap arrow painting is not set up for drawing type " + (Object)((Object)drawingType));
            }
        }
        this.myArrowPainter.paint(g2, y2 + lineHeight - g2.getFontMetrics().getDescent(), start2, end);
        return result2;
    }

    @Override
    public int getDrawingHorizontalOffset(@NotNull Graphics g2, @NotNull SoftWrapDrawingType drawingType, int x2, int y2, int lineHeight) {
        if (g2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/softwrap/ArrowSoftWrapPainter", "getDrawingHorizontalOffset"));
        }
        if (drawingType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "drawingType", "com/intellij/openapi/editor/impl/softwrap/ArrowSoftWrapPainter", "getDrawingHorizontalOffset"));
        }
        switch (drawingType) {
            case BEFORE_SOFT_WRAP_LINE_FEED: {
                return this.myEditor.getScrollingModel().getVisibleArea().width - x2;
            }
            case AFTER_SOFT_WRAP: {
                return 0;
            }
        }
        throw new IllegalStateException("Soft wrap arrow painting is not set up for drawing type " + (Object)((Object)drawingType));
    }

    @Override
    public int getMinDrawingWidth(@NotNull SoftWrapDrawingType drawingType) {
        if (drawingType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "drawingType", "com/intellij/openapi/editor/impl/softwrap/ArrowSoftWrapPainter", "getMinDrawingWidth"));
        }
        if (this.myMinWidth < 0) {
            this.myMinWidth = EditorUtil.charWidth('a', 0, this.myEditor);
        }
        return this.myMinWidth;
    }

    @Override
    public boolean canUse() {
        return true;
    }

    @Override
    public void reinit() {
        this.myMinWidth = -1;
    }

    private class WidthProvider
    implements Computable<Integer> {
        private WidthProvider() {
        }

        public Integer compute() {
            return EditorUtil.getSpaceWidth(0, ArrowSoftWrapPainter.this.myEditor);
        }
    }

    private static class HeightProvider
    implements Computable<Integer> {
        public int myHeight;

        private HeightProvider() {
        }

        public Integer compute() {
            return this.myHeight;
        }
    }
}

