/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.softwrap.mapping;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.LogicalPosition;
import org.jetbrains.annotations.NotNull;

class EditorPosition
implements Cloneable {
    public int logicalLine;
    public int offset;
    public int x;
    private final Editor myEditor;

    EditorPosition(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/impl/softwrap/mapping/EditorPosition", "<init>"));
        }
        this.myEditor = editor;
    }

    EditorPosition(@NotNull LogicalPosition logical, int offset, @NotNull Editor editor) {
        if (logical == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logical", "com/intellij/openapi/editor/impl/softwrap/mapping/EditorPosition", "<init>"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/impl/softwrap/mapping/EditorPosition", "<init>"));
        }
        this.myEditor = editor;
        this.logicalLine = logical.line;
        this.offset = offset;
    }

    public void onNewLine() {
        ++this.logicalLine;
        this.x = 0;
        ++this.offset;
    }

    public void advance(@NotNull FoldRegion foldRegion) {
        if (foldRegion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foldRegion", "com/intellij/openapi/editor/impl/softwrap/mapping/EditorPosition", "advance"));
        }
        this.offset = foldRegion.getEndOffset();
        Document document = this.myEditor.getDocument();
        int endOffsetLogicalLine = document.getLineNumber(foldRegion.getEndOffset());
        if (this.logicalLine != endOffsetLogicalLine) {
            int linesDiff = endOffsetLogicalLine - this.logicalLine;
            this.logicalLine += linesDiff;
        }
    }

    public void from(@NotNull EditorPosition position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/openapi/editor/impl/softwrap/mapping/EditorPosition", "from"));
        }
        this.logicalLine = position.logicalLine;
        this.offset = position.offset;
        this.x = position.x;
    }

    protected EditorPosition clone() {
        EditorPosition result2 = new EditorPosition(this.myEditor);
        result2.logicalLine = this.logicalLine;
        result2.offset = this.offset;
        result2.x = this.x;
        return result2;
    }

    public String toString() {
        return String.format("logical line: %d; offset: %d", this.logicalLine, this.offset);
    }
}

