/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.editor.impl.view.LineFragment;
import java.awt.Graphics2D;
import org.jetbrains.annotations.NotNull;

class ApproximationFragment
implements LineFragment {
    private final int myLength;
    private final int myColumnCount;
    private final float myWidth;

    ApproximationFragment(int length, int columnCount, float charWidth) {
        this.myLength = length;
        this.myColumnCount = columnCount;
        this.myWidth = charWidth * (float)columnCount;
    }

    @Override
    public int getLength() {
        return this.myLength;
    }

    @Override
    public int getLogicalColumnCount(int startColumn) {
        return this.myColumnCount;
    }

    @Override
    public int getVisualColumnCount(float startX) {
        return this.myColumnCount;
    }

    @Override
    public int logicalToVisualColumn(float startX, int startColumn, int column) {
        return column;
    }

    @Override
    public int visualToLogicalColumn(float startX, int startColumn, int column) {
        return column;
    }

    @Override
    public float visualColumnToX(float startX, int column) {
        return column < this.myColumnCount ? 0.0f : this.myWidth;
    }

    @Override
    public int[] xToVisualColumn(float startX, float x2) {
        float relX = x2 - startX;
        int column = relX < this.myWidth / 2.0f ? 0 : this.myColumnCount;
        return new int[]{column, relX <= this.visualColumnToX(startX, column) ? 0 : 1};
    }

    @Override
    public float offsetToX(float startX, int startOffset, int offset) {
        return startX + (offset < this.myLength ? 0.0f : this.myWidth);
    }

    @Override
    public void draw(Graphics2D g2, float x2, float y2, int startColumn, int endColumn) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public LineFragment subFragment(int startOffset, int endOffset) {
        throw new UnsupportedOperationException();
    }
}

