/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.impl.view.FontLayoutService;
import com.intellij.openapi.editor.impl.view.TextFragment;
import com.intellij.util.BitUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ComplexTextFragment
extends TextFragment {
    private static final Logger LOG = Logger.getInstance(ComplexTextFragment.class);
    private static final double CLIP_MARGIN = 10000.0;
    @NotNull
    private final GlyphVector myGlyphVector;
    @Nullable
    private final short[] myCodePoint2Offset;
    private static ComplexTextFragment lastFragment;
    private static int lastStartColumn;
    private static int lastEndColumn;
    private static Color lastColor;
    private static float lastStartX;
    private static float lastEndX;
    private static float lastY;
    private static long ourDrawingCount;
    private static long ourCharsProcessed;
    private static long ourGlyphsProcessed;

    ComplexTextFragment(@NotNull char[] lineChars, int start2, int end, boolean isRtl, @NotNull FontInfo fontInfo) {
        int codePointCount;
        float lastX;
        float totalWidth;
        if (lineChars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineChars", "com/intellij/openapi/editor/impl/view/ComplexTextFragment", "<init>"));
        }
        if (fontInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontInfo", "com/intellij/openapi/editor/impl/view/ComplexTextFragment", "<init>"));
        }
        super(end - start2);
        assert (start2 >= 0);
        assert (end <= lineChars.length);
        assert (start2 < end);
        this.myGlyphVector = FontLayoutService.getInstance().layoutGlyphVector(fontInfo.getFont(), fontInfo.getFontRenderContext(), lineChars, start2, end, isRtl);
        int numChars = end - start2;
        int numGlyphs = this.myGlyphVector.getNumGlyphs();
        this.myCharPositions[numChars - 1] = totalWidth = (float)this.myGlyphVector.getGlyphPosition(numGlyphs).getX();
        int lastCharIndex = -1;
        float prevX = lastX = isRtl ? totalWidth : 0.0f;
        for (int i2 = 0; i2 < numGlyphs; ++i2) {
            Rectangle2D bounds;
            int visualGlyphIndex = isRtl ? numGlyphs - 1 - i2 : i2;
            int charIndex = this.myGlyphVector.getGlyphCharIndex(visualGlyphIndex);
            if (charIndex <= lastCharIndex || (bounds = this.myGlyphVector.getGlyphLogicalBounds(visualGlyphIndex).getBounds2D()).isEmpty()) continue;
            if (charIndex > lastCharIndex + 1) {
                for (int j2 = Math.max(0, lastCharIndex); j2 < charIndex; ++j2) {
                    this.setCharPosition(j2, prevX + (lastX - prevX) * (float)(j2 - lastCharIndex + 1) / (float)(charIndex - lastCharIndex), isRtl, numChars);
                }
            }
            float newX = isRtl ? Math.min(lastX, (float)bounds.getMinX()) : Math.max(lastX, (float)bounds.getMaxX());
            newX = Math.max(0.0f, Math.min(totalWidth, newX));
            this.setCharPosition(charIndex, newX, isRtl, numChars);
            prevX = lastX;
            lastX = newX;
            lastCharIndex = charIndex;
        }
        if (lastCharIndex < numChars - 1) {
            for (int j3 = Math.max(0, lastCharIndex); j3 < numChars - 1; ++j3) {
                this.setCharPosition(j3, prevX + (lastX - prevX) * (float)(j3 - lastCharIndex + 1) / (float)(numChars - lastCharIndex), isRtl, numChars);
            }
        }
        if ((codePointCount = Character.codePointCount(lineChars, start2, end - start2)) == numChars) {
            this.myCodePoint2Offset = null;
        } else {
            this.myCodePoint2Offset = new short[codePointCount];
            int offset = 0;
            for (int i3 = 0; i3 < codePointCount; ++i3) {
                this.myCodePoint2Offset[i3] = (short)offset++;
                if (offset >= numChars || !Character.isHighSurrogate(lineChars[start2 + offset - 1]) || !Character.isLowSurrogate(lineChars[start2 + offset])) continue;
                ++offset;
            }
        }
    }

    private void setCharPosition(int logicalCharIndex, float x2, boolean isRtl, int numChars) {
        int charPosition;
        int n2 = charPosition = isRtl ? numChars - logicalCharIndex - 2 : logicalCharIndex;
        if (charPosition >= 0 && charPosition < numChars - 1) {
            this.myCharPositions[charPosition] = x2;
        }
    }

    @Override
    boolean isRtl() {
        return BitUtil.isSet((int)this.myGlyphVector.getLayoutFlags(), (int)4);
    }

    @Override
    int offsetToLogicalColumn(int offset) {
        if (this.myCodePoint2Offset == null) {
            return offset;
        }
        if (offset == this.getLength()) {
            return this.myCodePoint2Offset.length;
        }
        int i2 = Arrays.binarySearch(this.myCodePoint2Offset, (short)offset);
        assert (i2 >= 0);
        return i2;
    }

    @Override
    public void draw(Graphics2D g2, float x2, float y2, int startColumn, int endColumn) {
        assert (startColumn >= 0);
        assert (endColumn <= this.myCharPositions.length);
        assert (startColumn < endColumn);
        Color color = g2.getColor();
        assert (color != null);
        float newX = x2 - this.getX(startColumn) + this.getX(endColumn);
        if (lastFragment == this && lastEndColumn == startColumn && lastEndX == x2 && lastY == y2 && color.equals(lastColor)) {
            lastEndColumn = endColumn;
            lastEndX = newX;
            return;
        }
        ComplexTextFragment.flushDrawingCache(g2);
        lastFragment = this;
        lastStartColumn = startColumn;
        lastEndColumn = endColumn;
        lastColor = color;
        lastStartX = x2;
        lastEndX = newX;
        lastY = y2;
    }

    private void doDraw(Graphics2D g2, float x2, float y2, int startColumn, int endColumn) {
        ComplexTextFragment.updateStats(endColumn - startColumn, this.myCharPositions.length);
        if (startColumn == 0 && endColumn == this.myCharPositions.length) {
            g2.drawGlyphVector(this.myGlyphVector, x2, y2);
        } else {
            Shape savedClip = g2.getClip();
            float startX = x2 - this.getX(startColumn);
            double xMin = (double)x2 - (startColumn == 0 ? 10000.0 : 0.0);
            double xMax = (double)(startX + this.getX(endColumn)) + (endColumn == this.myCharPositions.length ? 10000.0 : 0.0);
            double yMin = (double)y2 - 10000.0;
            double yMax = (double)y2 + 10000.0;
            g2.clip(new Rectangle2D.Double(xMin, yMin, xMax - xMin, yMax - yMin));
            g2.drawGlyphVector(this.myGlyphVector, startX, y2);
            g2.setClip(savedClip);
        }
    }

    private int getCodePointCount() {
        return this.myCodePoint2Offset == null ? this.myCharPositions.length : this.myCodePoint2Offset.length;
    }

    private int visualColumnToVisualOffset(int column) {
        if (this.myCodePoint2Offset == null) {
            return column;
        }
        if (column <= 0) {
            return 0;
        }
        if (column >= this.myCodePoint2Offset.length) {
            return this.getLength();
        }
        return this.isRtl() ? this.getLength() - this.myCodePoint2Offset[this.myCodePoint2Offset.length - column] : this.myCodePoint2Offset[column];
    }

    @Override
    public int getLogicalColumnCount(int startColumn) {
        return this.getCodePointCount();
    }

    @Override
    public int getVisualColumnCount(float startX) {
        return this.getCodePointCount();
    }

    @Override
    public int[] xToVisualColumn(float startX, float x2) {
        float relX = x2 - startX;
        float prevPos = 0.0f;
        int columnCount = this.getCodePointCount();
        for (int i2 = 0; i2 < columnCount; ++i2) {
            int visualOffset = this.visualColumnToVisualOffset(i2);
            float newPos = this.myCharPositions[visualOffset];
            if (relX < (newPos + prevPos) / 2.0f) {
                return new int[]{i2, relX <= prevPos ? 0 : 1};
            }
            prevPos = newPos;
        }
        return new int[]{columnCount, relX <= this.myCharPositions[this.myCharPositions.length - 1] ? 0 : 1};
    }

    @Override
    public float visualColumnToX(float startX, int column) {
        return startX + this.getX(this.visualColumnToVisualOffset(column));
    }

    public static void flushDrawingCache(Graphics2D g2) {
        if (lastFragment != null) {
            g2.setColor(lastColor);
            lastFragment.doDraw(g2, lastStartX, lastY, lastStartColumn, lastEndColumn);
            lastFragment = null;
        }
    }

    private static void updateStats(int charCount, int glyphCount) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        ourCharsProcessed += (long)charCount;
        ourGlyphsProcessed += (long)glyphCount;
        if (++ourDrawingCount == 10000L) {
            LOG.debug("Text rendering stats: " + ourCharsProcessed + " chars, " + ourGlyphsProcessed + " glyps, ratio - " + (float)ourGlyphsProcessed / (float)ourCharsProcessed);
            ourDrawingCount = 0L;
            ourCharsProcessed = 0L;
            ourGlyphsProcessed = 0L;
        }
    }
}

