/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ReflectionUtil;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.lang.reflect.Method;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.font.FontDesignMetrics;

public abstract class FontLayoutService {
    private static final Logger LOG = Logger.getInstance(FontLayoutService.class);
    private static final FontLayoutService DEFAULT_INSTANCE;
    private static FontLayoutService INSTANCE;

    public static FontLayoutService getInstance() {
        return INSTANCE;
    }

    @NotNull
    public abstract GlyphVector layoutGlyphVector(@NotNull Font var1, @NotNull FontRenderContext var2, @NotNull char[] var3, int var4, int var5, boolean var6);

    public abstract int charWidth(@NotNull FontMetrics var1, char var2);

    public abstract int charWidth(@NotNull FontMetrics var1, int var2);

    public abstract float charWidth2D(@NotNull FontMetrics var1, int var2);

    public abstract int getHeight(@NotNull FontMetrics var1);

    public abstract int getDescent(@NotNull FontMetrics var1);

    public static void setInstance(@Nullable FontLayoutService fontLayoutService) {
        INSTANCE = fontLayoutService == null ? DEFAULT_INSTANCE : fontLayoutService;
    }

    static {
        INSTANCE = DEFAULT_INSTANCE = new DefaultFontLayoutService();
    }

    private static class DefaultFontLayoutService
    extends FontLayoutService {
        private static final int LAYOUT_NO_PAIRED_CHARS_AT_SCRIPT_SPLIT = 8;
        private final Method myHandleCharWidthMethod = ReflectionUtil.getDeclaredMethod(FontDesignMetrics.class, (String)"handleCharWidth", (Class[])new Class[]{Integer.TYPE});

        private DefaultFontLayoutService() {
            if (this.myHandleCharWidthMethod == null) {
                LOG.warn("Couldn't access FontDesignMetrics.handleCharWidth method");
            }
        }

        @Override
        @NotNull
        public GlyphVector layoutGlyphVector(@NotNull Font font, @NotNull FontRenderContext fontRenderContext, @NotNull char[] chars, int start2, int end, boolean isRtl) {
            if (font == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "font", "com/intellij/openapi/editor/impl/view/FontLayoutService$DefaultFontLayoutService", "layoutGlyphVector"));
            }
            if (fontRenderContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontRenderContext", "com/intellij/openapi/editor/impl/view/FontLayoutService$DefaultFontLayoutService", "layoutGlyphVector"));
            }
            if (chars == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/openapi/editor/impl/view/FontLayoutService$DefaultFontLayoutService", "layoutGlyphVector"));
            }
            GlyphVector glyphVector = font.layoutGlyphVector(fontRenderContext, chars, start2, end, (isRtl ? 1 : 0) | 8);
            if (glyphVector == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/view/FontLayoutService$DefaultFontLayoutService", "layoutGlyphVector"));
            }
            return glyphVector;
        }

        @Override
        public int charWidth(@NotNull FontMetrics fontMetrics, char c2) {
            if (fontMetrics == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontMetrics", "com/intellij/openapi/editor/impl/view/FontLayoutService$DefaultFontLayoutService", "charWidth"));
            }
            return fontMetrics.charWidth(c2);
        }

        @Override
        public int charWidth(@NotNull FontMetrics fontMetrics, int codePoint) {
            if (fontMetrics == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontMetrics", "com/intellij/openapi/editor/impl/view/FontLayoutService$DefaultFontLayoutService", "charWidth"));
            }
            return fontMetrics.charWidth(codePoint);
        }

        @Override
        public float charWidth2D(@NotNull FontMetrics fontMetrics, int codePoint) {
            if (fontMetrics == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontMetrics", "com/intellij/openapi/editor/impl/view/FontLayoutService$DefaultFontLayoutService", "charWidth2D"));
            }
            if (this.myHandleCharWidthMethod != null && fontMetrics instanceof FontDesignMetrics) {
                try {
                    return ((Float)this.myHandleCharWidthMethod.invoke((Object)fontMetrics, codePoint)).floatValue();
                }
                catch (Exception e2) {
                    LOG.debug((Throwable)e2);
                }
            }
            return this.charWidth(fontMetrics, codePoint);
        }

        @Override
        public int getHeight(@NotNull FontMetrics fontMetrics) {
            if (fontMetrics == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontMetrics", "com/intellij/openapi/editor/impl/view/FontLayoutService$DefaultFontLayoutService", "getHeight"));
            }
            return fontMetrics.getHeight();
        }

        @Override
        public int getDescent(@NotNull FontMetrics fontMetrics) {
            if (fontMetrics == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontMetrics", "com/intellij/openapi/editor/impl/view/FontLayoutService$DefaultFontLayoutService", "getDescent"));
            }
            return fontMetrics.getDescent();
        }
    }
}

