/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.impl.view.TextFragment;
import java.awt.Font;
import java.awt.Graphics2D;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

class SimpleTextFragment
extends TextFragment {
    @NotNull
    private final char[] myText;
    @NotNull
    private final Font myFont;

    SimpleTextFragment(@NotNull char[] lineChars, int start2, int end, @NotNull FontInfo fontInfo) {
        if (lineChars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineChars", "com/intellij/openapi/editor/impl/view/SimpleTextFragment", "<init>"));
        }
        if (fontInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontInfo", "com/intellij/openapi/editor/impl/view/SimpleTextFragment", "<init>"));
        }
        super(end - start2);
        this.myText = Arrays.copyOfRange(lineChars, start2, end);
        this.myFont = fontInfo.getFont();
        float x2 = 0.0f;
        for (int i2 = 0; i2 < this.myText.length; ++i2) {
            this.myCharPositions[i2] = x2 += fontInfo.charWidth2D(this.myText[i2]);
        }
    }

    @Override
    boolean isRtl() {
        return false;
    }

    @Override
    int offsetToLogicalColumn(int offset) {
        return offset;
    }

    @Override
    public void draw(Graphics2D g2, float x2, float y2, int startColumn, int endColumn) {
        g2.setFont(this.myFont);
        int xAsInt = (int)x2;
        int yAsInt = (int)y2;
        if (x2 == (float)xAsInt && y2 == (float)yAsInt) {
            g2.drawChars(this.myText, startColumn, endColumn - startColumn, xAsInt, yAsInt);
        } else {
            g2.drawString(new String(this.myText, startColumn, endColumn - startColumn), x2, y2);
        }
    }

    @Override
    public int getLogicalColumnCount(int startColumn) {
        return this.myCharPositions.length;
    }

    @Override
    public int getVisualColumnCount(float startX) {
        return this.myCharPositions.length;
    }

    @Override
    public int[] xToVisualColumn(float startX, float x2) {
        float relX = x2 - startX;
        float prevPos = 0.0f;
        for (int i2 = 0; i2 < this.myCharPositions.length; ++i2) {
            float newPos = this.myCharPositions[i2];
            if (relX < (newPos + prevPos) / 2.0f) {
                return new int[]{i2, relX <= prevPos ? 0 : 1};
            }
            prevPos = newPos;
        }
        return new int[]{this.myCharPositions.length, relX <= this.myCharPositions[this.myCharPositions.length - 1] ? 0 : 1};
    }

    @Override
    public float visualColumnToX(float startX, int column) {
        return startX + this.getX(column);
    }
}

