/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.view.EditorView;
import com.intellij.openapi.editor.impl.view.LineFragment;
import java.awt.Graphics2D;
import org.jetbrains.annotations.NotNull;

class TabFragment
implements LineFragment {
    private final EditorView myView;
    private final Editor myEditor;

    TabFragment(EditorView view2) {
        this.myView = view2;
        this.myEditor = view2.getEditor();
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public int getLogicalColumnCount(int startColumn) {
        int tabSize = this.myView.getTabSize();
        return tabSize - startColumn % tabSize;
    }

    @Override
    public int getVisualColumnCount(float startX) {
        float x2 = this.getNextTabStop(startX);
        return EditorUtil.columnsNumber((int)(x2 - startX), this.myView.getPlainSpaceWidth());
    }

    @Override
    public void draw(Graphics2D g2, float x2, float y2, int startColumn, int endColumn) {
    }

    @Override
    @NotNull
    public LineFragment subFragment(int startOffset, int endOffset) {
        TabFragment tabFragment = this;
        if (tabFragment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/view/TabFragment", "subFragment"));
        }
        return tabFragment;
    }

    @Override
    public float offsetToX(float startX, int startOffset, int offset) {
        return TabFragment.trimOffset(offset) <= TabFragment.trimOffset(startOffset) ? startX : this.getNextTabStop(startX);
    }

    @Override
    public int logicalToVisualColumn(float startX, int startColumn, int column) {
        int visualColumnCount = this.getVisualColumnCount(startX);
        int logicalColumnCount = this.getLogicalColumnCount(startColumn);
        return column == logicalColumnCount ? visualColumnCount : Math.min(column, visualColumnCount - 1);
    }

    @Override
    public int visualToLogicalColumn(float startX, int startColumn, int column) {
        int visualColumnCount = this.getVisualColumnCount(startX);
        int logicalColumnCount = this.getLogicalColumnCount(startColumn);
        return column == visualColumnCount ? logicalColumnCount : Math.min(column, logicalColumnCount - 1);
    }

    @Override
    public int[] xToVisualColumn(float startX, float x2) {
        int columnWithoutRounding;
        int column;
        if (x2 <= startX) {
            return new int[]{0, 0};
        }
        float nextTabStop = this.getNextTabStop(startX);
        if (x2 > nextTabStop) {
            return new int[]{this.getVisualColumnCount(startX), 1};
        }
        if (this.myEditor.getSettings().isCaretInsideTabs()) {
            int plainSpaceWidth = this.myView.getPlainSpaceWidth();
            column = ((int)(x2 - startX) + plainSpaceWidth / 2) / plainSpaceWidth;
            columnWithoutRounding = (int)(x2 - startX - 1.0f) / plainSpaceWidth;
        } else {
            column = x2 > (startX + nextTabStop) / 2.0f ? this.getVisualColumnCount(startX) : 0;
            columnWithoutRounding = 0;
        }
        return new int[]{column, column == columnWithoutRounding ? 1 : 0};
    }

    @Override
    public float visualColumnToX(float startX, int column) {
        if (column <= 0) {
            return startX;
        }
        if (column >= this.getVisualColumnCount(startX)) {
            return this.getNextTabStop(startX);
        }
        return startX + (float)(this.myView.getPlainSpaceWidth() * column);
    }

    private static int trimOffset(int offset) {
        return offset <= 0 ? 0 : 1;
    }

    private float getNextTabStop(float x2) {
        return EditorUtil.nextTabStop((int)x2, this.myView.getPlainSpaceWidth(), this.myView.getTabSize());
    }
}

