/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.impl.view.ComplexTextFragment;
import com.intellij.openapi.editor.impl.view.SimpleTextFragment;
import com.intellij.openapi.editor.impl.view.TextFragment;
import org.jetbrains.annotations.NotNull;
import sun.swing.SwingUtilities2;

class TextFragmentFactory {
    TextFragmentFactory() {
    }

    public static TextFragment createTextFragment(@NotNull char[] lineChars, int start2, int end, boolean isRtl, @NotNull FontInfo fontInfo) {
        if (lineChars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineChars", "com/intellij/openapi/editor/impl/view/TextFragmentFactory", "createTextFragment"));
        }
        if (fontInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontInfo", "com/intellij/openapi/editor/impl/view/TextFragmentFactory", "createTextFragment"));
        }
        if (isRtl || fontInfo.getFont().hasLayoutAttributes() || TextFragmentFactory.isComplexText(lineChars, start2, end)) {
            return new ComplexTextFragment(lineChars, start2, end, isRtl, fontInfo);
        }
        return new SimpleTextFragment(lineChars, start2, end, fontInfo);
    }

    private static boolean isComplexText(char[] chars, int start2, int end) {
        return SwingUtilities2.isComplexLayout(chars, start2, end);
    }
}

