/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.richcopy.model;

import com.intellij.openapi.editor.richcopy.model.ColorRegistry;
import com.intellij.openapi.editor.richcopy.model.FontNameRegistry;
import com.intellij.openapi.editor.richcopy.model.MarkupHandler;
import com.intellij.openapi.editor.richcopy.model.OutputInfoSerializer;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class SyntaxInfo {
    private final int myOutputInfoCount;
    private final byte[] myOutputInfosSerialized;
    @NotNull
    private final ColorRegistry myColorRegistry;
    @NotNull
    private final FontNameRegistry myFontNameRegistry;
    private final int myDefaultForeground;
    private final int myDefaultBackground;
    private final float myFontSize;

    private SyntaxInfo(int outputInfoCount, byte[] outputInfosSerialized, int defaultForeground, int defaultBackground, float fontSize, @NotNull FontNameRegistry fontNameRegistry, @NotNull ColorRegistry colorRegistry) {
        if (fontNameRegistry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontNameRegistry", "com/intellij/openapi/editor/richcopy/model/SyntaxInfo", "<init>"));
        }
        if (colorRegistry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorRegistry", "com/intellij/openapi/editor/richcopy/model/SyntaxInfo", "<init>"));
        }
        this.myOutputInfoCount = outputInfoCount;
        this.myOutputInfosSerialized = outputInfosSerialized;
        this.myDefaultForeground = defaultForeground;
        this.myDefaultBackground = defaultBackground;
        this.myFontSize = fontSize;
        this.myFontNameRegistry = fontNameRegistry;
        this.myColorRegistry = colorRegistry;
    }

    @NotNull
    public ColorRegistry getColorRegistry() {
        ColorRegistry colorRegistry = this.myColorRegistry;
        if (colorRegistry == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/richcopy/model/SyntaxInfo", "getColorRegistry"));
        }
        return colorRegistry;
    }

    @NotNull
    public FontNameRegistry getFontNameRegistry() {
        FontNameRegistry fontNameRegistry = this.myFontNameRegistry;
        if (fontNameRegistry == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/richcopy/model/SyntaxInfo", "getFontNameRegistry"));
        }
        return fontNameRegistry;
    }

    public int getDefaultForeground() {
        return this.myDefaultForeground;
    }

    public int getDefaultBackground() {
        return this.myDefaultBackground;
    }

    public float getFontSize() {
        return this.myFontSize;
    }

    public void processOutputInfo(MarkupHandler handler2) {
        MarkupIterator it = new MarkupIterator();
        try {
            while (it.hasNext()) {
                it.processNext(handler2);
                if (handler2.canHandleMore()) continue;
                break;
            }
        }
        finally {
            it.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        final StringBuilder b2 = new StringBuilder();
        b2.append("default colors: foreground=").append(this.myDefaultForeground).append(", background=").append(this.myDefaultBackground).append("; output infos: ");
        boolean first = true;
        MarkupIterator it = new MarkupIterator();
        try {
            while (it.hasNext()) {
                if (first) {
                    b2.append(',');
                }
                it.processNext(new MarkupHandler(){

                    @Override
                    public void handleText(int startOffset, int endOffset) throws Exception {
                        b2.append("text(").append(startOffset).append(",").append(endOffset).append(")");
                    }

                    @Override
                    public void handleForeground(int foregroundId) throws Exception {
                        b2.append("foreground(").append(foregroundId).append(")");
                    }

                    @Override
                    public void handleBackground(int backgroundId) throws Exception {
                        b2.append("background(").append(backgroundId).append(")");
                    }

                    @Override
                    public void handleFont(int fontNameId) throws Exception {
                        b2.append("font(").append(fontNameId).append(")");
                    }

                    @Override
                    public void handleStyle(int style) throws Exception {
                        b2.append("style(").append(style).append(")");
                    }

                    @Override
                    public boolean canHandleMore() {
                        return true;
                    }
                });
                first = false;
            }
            String string2 = b2.toString();
            return string2;
        }
        finally {
            it.dispose();
        }
    }

    public class MarkupIterator {
        private int pos;
        private final OutputInfoSerializer.InputStream myOutputInfoStream;

        public MarkupIterator() {
            try {
                this.myOutputInfoStream = new OutputInfoSerializer.InputStream(new ByteArrayInputStream(SyntaxInfo.this.myOutputInfosSerialized));
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        }

        public boolean hasNext() {
            return this.pos < SyntaxInfo.this.myOutputInfoCount;
        }

        public void processNext(MarkupHandler handler2) {
            if (!this.hasNext()) {
                throw new IllegalStateException();
            }
            ++this.pos;
            try {
                this.myOutputInfoStream.read(handler2);
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }

        public void dispose() {
            try {
                this.myOutputInfoStream.close();
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        }
    }

    public static class Builder {
        private final ColorRegistry myColorRegistry = new ColorRegistry();
        private final FontNameRegistry myFontNameRegistry = new FontNameRegistry();
        private final int myDefaultForeground;
        private final int myDefaultBackground;
        private final float myFontSize;
        private final ByteArrayOutputStream myStream = new ByteArrayOutputStream();
        private final OutputInfoSerializer.OutputStream myOutputInfoStream;
        private int myOutputInfoCount;

        public Builder(Color defaultForeground, Color defaultBackground, float fontSize) {
            this.myDefaultForeground = this.myColorRegistry.getId(defaultForeground);
            this.myDefaultBackground = this.myColorRegistry.getId(defaultBackground);
            this.myFontSize = fontSize;
            try {
                this.myOutputInfoStream = new OutputInfoSerializer.OutputStream(this.myStream);
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        }

        public void addFontStyle(int fontStyle) {
            try {
                this.myOutputInfoStream.handleStyle(fontStyle);
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
            ++this.myOutputInfoCount;
        }

        public void addFontFamilyName(String fontFamilyName) {
            try {
                this.myOutputInfoStream.handleFont(this.myFontNameRegistry.getId(fontFamilyName));
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
            ++this.myOutputInfoCount;
        }

        public void addForeground(Color foreground) {
            try {
                this.myOutputInfoStream.handleForeground(this.myColorRegistry.getId(foreground));
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
            ++this.myOutputInfoCount;
        }

        public void addBackground(Color background) {
            try {
                this.myOutputInfoStream.handleBackground(this.myColorRegistry.getId(background));
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
            ++this.myOutputInfoCount;
        }

        public void addText(int startOffset, int endOffset) {
            try {
                this.myOutputInfoStream.handleText(startOffset, endOffset);
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
            ++this.myOutputInfoCount;
        }

        public SyntaxInfo build() {
            this.myColorRegistry.seal();
            this.myFontNameRegistry.seal();
            try {
                this.myOutputInfoStream.close();
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
            return new SyntaxInfo(this.myOutputInfoCount, this.myStream.toByteArray(), this.myDefaultForeground, this.myDefaultBackground, this.myFontSize, this.myFontNameRegistry, this.myColorRegistry);
        }
    }
}

