/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.textarea;

import com.intellij.openapi.editor.textarea.TextComponentDocument;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;

public class TextAreaDocument
extends TextComponentDocument {
    private final JTextArea myTextArea;

    public TextAreaDocument(JTextArea textComponent) {
        super(textComponent);
        this.myTextArea = textComponent;
    }

    @Override
    public int getLineCount() {
        return this.myTextArea.getLineCount();
    }

    @Override
    public int getLineNumber(int offset) {
        try {
            return this.myTextArea.getLineOfOffset(offset);
        }
        catch (BadLocationException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public int getLineStartOffset(int line) {
        try {
            return this.myTextArea.getLineStartOffset(line);
        }
        catch (BadLocationException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public int getLineEndOffset(int line) {
        try {
            return this.myTextArea.getLineEndOffset(line) - this.getLineSeparatorLength(line);
        }
        catch (BadLocationException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public int getLineSeparatorLength(int line) {
        if (line == this.myTextArea.getLineCount() - 1) {
            return 0;
        }
        try {
            int l2 = 0;
            String text2 = this.getText();
            for (int pos = this.myTextArea.getLineEndOffset(line) - 1; pos >= this.myTextArea.getLineStartOffset(line) && (text2.charAt(pos) == '\r' || text2.charAt(pos) == '\n'); --pos) {
                ++l2;
            }
            return l2;
        }
        catch (BadLocationException e2) {
            throw new RuntimeException(e2);
        }
    }
}

