/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.textarea;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderBase;
import java.beans.PropertyChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextComponentDocument
extends UserDataHolderBase
implements Document {
    private final JTextComponent myTextComponent;

    public TextComponentDocument(JTextComponent textComponent) {
        this.myTextComponent = textComponent;
    }

    @NotNull
    public String getText() {
        String string2;
        try {
            javax.swing.text.Document document = this.myTextComponent.getDocument();
            string2 = document.getText(0, document.getLength());
        }
        catch (BadLocationException e2) {
            throw new RuntimeException(e2);
        }
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/textarea/TextComponentDocument", "getText"));
        }
        return string2;
    }

    @NotNull
    public String getText(@NotNull TextRange range) {
        String string2;
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/editor/textarea/TextComponentDocument", "getText"));
        }
        try {
            javax.swing.text.Document document = this.myTextComponent.getDocument();
            string2 = document.getText(range.getStartOffset(), range.getLength());
        }
        catch (BadLocationException e2) {
            throw new RuntimeException(e2);
        }
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/textarea/TextComponentDocument", "getText"));
        }
        return string2;
    }

    @NotNull
    public CharSequence getCharsSequence() {
        String string2 = this.getText();
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/textarea/TextComponentDocument", "getCharsSequence"));
        }
        return string2;
    }

    @NotNull
    public CharSequence getImmutableCharSequence() {
        String string2 = this.getText();
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/textarea/TextComponentDocument", "getImmutableCharSequence"));
        }
        return string2;
    }

    @NotNull
    public char[] getChars() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public int getTextLength() {
        return this.myTextComponent.getDocument().getLength();
    }

    public int getLineCount() {
        return 1;
    }

    public int getLineNumber(int offset) {
        return 0;
    }

    public int getLineStartOffset(int line) {
        return 0;
    }

    public int getLineEndOffset(int line) {
        return this.getTextLength();
    }

    public void insertString(int offset, @NotNull CharSequence s2) {
        if (s2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/editor/textarea/TextComponentDocument", "insertString"));
        }
        try {
            this.myTextComponent.getDocument().insertString(offset, s2.toString(), null);
        }
        catch (BadLocationException e2) {
            throw new RuntimeException(e2);
        }
    }

    public void deleteString(int startOffset, int endOffset) {
        try {
            this.myTextComponent.getDocument().remove(startOffset, endOffset - startOffset);
        }
        catch (BadLocationException e2) {
            throw new RuntimeException(e2);
        }
    }

    public void replaceString(int startOffset, int endOffset, @NotNull CharSequence s2) {
        if (s2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/editor/textarea/TextComponentDocument", "replaceString"));
        }
        javax.swing.text.Document document = this.myTextComponent.getDocument();
        try {
            document.remove(startOffset, endOffset - startOffset);
            document.insertString(startOffset, s2.toString(), null);
        }
        catch (BadLocationException e2) {
            throw new RuntimeException(e2);
        }
    }

    public boolean isWritable() {
        return true;
    }

    public long getModificationStamp() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void fireReadOnlyModificationAttempt() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void addDocumentListener(@NotNull DocumentListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/textarea/TextComponentDocument", "addDocumentListener"));
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    public void addDocumentListener(@NotNull DocumentListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/textarea/TextComponentDocument", "addDocumentListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/editor/textarea/TextComponentDocument", "addDocumentListener"));
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    public void removeDocumentListener(@NotNull DocumentListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/textarea/TextComponentDocument", "removeDocumentListener"));
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    @NotNull
    public RangeMarker createRangeMarker(int startOffset, int endOffset) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @NotNull
    public RangeMarker createRangeMarker(int startOffset, int endOffset, boolean surviveOnExternalChange) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/textarea/TextComponentDocument", "addPropertyChangeListener"));
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/textarea/TextComponentDocument", "removePropertyChangeListener"));
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    public void setReadOnly(boolean isReadOnly) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @NotNull
    public RangeMarker createGuardedBlock(int startOffset, int endOffset) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void removeGuardedBlock(@NotNull RangeMarker block) {
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/openapi/editor/textarea/TextComponentDocument", "removeGuardedBlock"));
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    @Nullable
    public RangeMarker getOffsetGuard(int offset) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Nullable
    public RangeMarker getRangeGuard(int start2, int end) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void startGuardedBlockChecking() {
    }

    public void stopGuardedBlockChecking() {
    }

    public void setCyclicBufferSize(int bufferSize) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void setText(@NotNull CharSequence text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/textarea/TextComponentDocument", "setText"));
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    @NotNull
    public RangeMarker createRangeMarker(@NotNull TextRange textRange) {
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/openapi/editor/textarea/TextComponentDocument", "createRangeMarker"));
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    public int getLineSeparatorLength(int line) {
        return 0;
    }
}

