/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.file.exclude.ui;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.file.exclude.EnforcedPlainTextFileTypeFactory;
import com.intellij.openapi.file.exclude.EnforcedPlainTextFileTypeManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import javax.swing.Icon;

public class MarkAsPlainTextAction
extends DumbAwareAction {
    public void actionPerformed(AnActionEvent e2) {
        Project project2 = e2.getProject();
        EnforcedPlainTextFileTypeManager typeManager = EnforcedPlainTextFileTypeManager.getInstance();
        if (project2 == null || typeManager == null) {
            return;
        }
        JBIterable selectedFiles = JBIterable.of((Object[])((Object[])e2.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY))).filter(file2 -> EnforcedPlainTextFileTypeManager.isApplicableFor(file2) && !typeManager.isMarkedAsPlainText((VirtualFile)file2));
        typeManager.markAsPlainText(project2, VfsUtilCore.toVirtualFileArray((Collection)selectedFiles.toList()));
    }

    public void update(AnActionEvent e2) {
        EnforcedPlainTextFileTypeManager typeManager = EnforcedPlainTextFileTypeManager.getInstance();
        JBIterable selectedFiles = typeManager == null ? JBIterable.empty() : JBIterable.of((Object[])((Object[])e2.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY))).filter(file2 -> EnforcedPlainTextFileTypeManager.isApplicableFor(file2) && !typeManager.isMarkedAsPlainText((VirtualFile)file2));
        boolean enabled = e2.getProject() != null && !selectedFiles.isEmpty();
        e2.getPresentation().setEnabledAndVisible(enabled);
        e2.getPresentation().setIcon((Icon)EnforcedPlainTextFileTypeFactory.ENFORCED_PLAIN_TEXT_ICON);
    }
}

