/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.actions;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileChooser.FileSystemTree;
import com.intellij.openapi.fileChooser.actions.FileChooserAction;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SystemProperties;
import java.io.File;
import org.jetbrains.annotations.Nullable;

public class GotoDesktopDirAction
extends FileChooserAction {
    private final NullableLazyValue<VirtualFile> myDesktopDirectory = new NullableLazyValue<VirtualFile>(){

        @Nullable
        protected VirtualFile compute() {
            return GotoDesktopDirAction.getDesktopDirectory();
        }
    };

    @Override
    protected void actionPerformed(FileSystemTree tree2, AnActionEvent e2) {
        VirtualFile dir = (VirtualFile)this.myDesktopDirectory.getValue();
        if (dir != null) {
            tree2.select(dir, () -> tree2.expand(dir, null));
        }
    }

    @Override
    protected void update(FileSystemTree tree2, AnActionEvent e2) {
        VirtualFile dir = (VirtualFile)this.myDesktopDirectory.getValue();
        e2.getPresentation().setEnabled(dir != null && tree2.isUnderRoots(dir));
    }

    @Nullable
    private static VirtualFile getDesktopDirectory() {
        String path;
        File desktop = new File(SystemProperties.getUserHome(), "Desktop");
        if (!desktop.isDirectory() && SystemInfo.hasXdgOpen() && (path = ExecUtil.execAndReadLine((GeneralCommandLine)new GeneralCommandLine(new String[]{"xdg-user-dir", "DESKTOP"}))) != null) {
            desktop = new File(path);
        }
        return desktop.isDirectory() ? LocalFileSystem.getInstance().refreshAndFindFileByIoFile(desktop) : null;
    }
}

