/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileChooser.FileSystemTree;
import com.intellij.openapi.fileChooser.actions.FileChooserAction;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;

public final class GotoHomeAction
extends FileChooserAction {
    @Override
    protected void actionPerformed(FileSystemTree fileSystemTree, AnActionEvent e2) {
        VirtualFile userHomeDir = VfsUtil.getUserHomeDir();
        if (userHomeDir != null) {
            fileSystemTree.select(userHomeDir, () -> fileSystemTree.expand(userHomeDir, null));
        }
    }

    @Override
    protected void update(FileSystemTree fileSystemTree, AnActionEvent e2) {
        Presentation presentation = e2.getPresentation();
        if (!presentation.isEnabled()) {
            return;
        }
        VirtualFile userHomeDir = VfsUtil.getUserHomeDir();
        presentation.setEnabled(userHomeDir != null && fileSystemTree.isUnderRoots(userHomeDir));
    }
}

