/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.fileChooser.FileTextField;
import com.intellij.openapi.fileChooser.PathChooserDialog;
import com.intellij.openapi.fileChooser.ex.FileChooserDialogImpl;
import com.intellij.openapi.fileChooser.ex.FileSaverDialogImpl;
import com.intellij.openapi.fileChooser.ex.FileTextFieldImpl;
import com.intellij.openapi.fileChooser.ex.LocalFsFinder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.mac.MacFileSaverDialog;
import com.intellij.ui.mac.MacPathChooserDialog;
import com.intellij.util.SystemProperties;
import gnu.trove.THashMap;
import java.awt.Component;
import java.util.Map;
import java.util.Set;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileChooserFactoryImpl
extends FileChooserFactory {
    @NotNull
    public FileChooserDialog createFileChooser(@NotNull FileChooserDescriptor descriptor2, @Nullable Project project2, @Nullable Component parent) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/openapi/fileChooser/impl/FileChooserFactoryImpl", "createFileChooser"));
        }
        if (FileChooserFactoryImpl.useNativeMacChooser(descriptor2)) {
            MacPathChooserDialog macPathChooserDialog = new MacPathChooserDialog(descriptor2, parent, project2);
            if (macPathChooserDialog == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileChooser/impl/FileChooserFactoryImpl", "createFileChooser"));
            }
            return macPathChooserDialog;
        }
        if (parent != null) {
            FileChooserDialogImpl fileChooserDialogImpl = new FileChooserDialogImpl(descriptor2, parent, project2);
            if (fileChooserDialogImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileChooser/impl/FileChooserFactoryImpl", "createFileChooser"));
            }
            return fileChooserDialogImpl;
        }
        FileChooserDialogImpl fileChooserDialogImpl = new FileChooserDialogImpl(descriptor2, project2);
        if (fileChooserDialogImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileChooser/impl/FileChooserFactoryImpl", "createFileChooser"));
        }
        return fileChooserDialogImpl;
    }

    @NotNull
    public PathChooserDialog createPathChooser(@NotNull FileChooserDescriptor descriptor2, @Nullable Project project2, @Nullable Component parent) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/openapi/fileChooser/impl/FileChooserFactoryImpl", "createPathChooser"));
        }
        if (FileChooserFactoryImpl.useNativeMacChooser(descriptor2)) {
            MacPathChooserDialog macPathChooserDialog = new MacPathChooserDialog(descriptor2, parent, project2);
            if (macPathChooserDialog == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileChooser/impl/FileChooserFactoryImpl", "createPathChooser"));
            }
            return macPathChooserDialog;
        }
        if (parent != null) {
            FileChooserDialogImpl fileChooserDialogImpl = new FileChooserDialogImpl(descriptor2, parent, project2);
            if (fileChooserDialogImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileChooser/impl/FileChooserFactoryImpl", "createPathChooser"));
            }
            return fileChooserDialogImpl;
        }
        FileChooserDialogImpl fileChooserDialogImpl = new FileChooserDialogImpl(descriptor2, project2);
        if (fileChooserDialogImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileChooser/impl/FileChooserFactoryImpl", "createPathChooser"));
        }
        return fileChooserDialogImpl;
    }

    private static boolean useNativeMacChooser(FileChooserDescriptor descriptor2) {
        return SystemInfo.isMac && !descriptor2.isForcedToUseIdeaFileChooser() && SystemProperties.getBooleanProperty((String)"native.mac.file.chooser.enabled", (boolean)true) && Registry.is((String)"ide.mac.file.chooser.native") && SystemInfo.isJetbrainsJvm;
    }

    @NotNull
    public FileTextField createFileTextField(@NotNull FileChooserDescriptor descriptor2, boolean showHidden, @Nullable Disposable parent) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/openapi/fileChooser/impl/FileChooserFactoryImpl", "createFileTextField"));
        }
        FileTextFieldImpl.Vfs vfs = new FileTextFieldImpl.Vfs(new JTextField(), FileChooserFactoryImpl.getMacroMap(), parent, new LocalFsFinder.FileChooserFilter(descriptor2, showHidden));
        if (vfs == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileChooser/impl/FileChooserFactoryImpl", "createFileTextField"));
        }
        return vfs;
    }

    public void installFileCompletion(@NotNull JTextField field, @NotNull FileChooserDescriptor descriptor2, boolean showHidden, @Nullable Disposable parent) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/openapi/fileChooser/impl/FileChooserFactoryImpl", "installFileCompletion"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/openapi/fileChooser/impl/FileChooserFactoryImpl", "installFileCompletion"));
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && !ApplicationManager.getApplication().isHeadlessEnvironment()) {
            new FileTextFieldImpl.Vfs(field, FileChooserFactoryImpl.getMacroMap(), parent, new LocalFsFinder.FileChooserFilter(descriptor2, showHidden));
        }
    }

    public static Map<String, String> getMacroMap() {
        PathMacros macros = PathMacros.getInstance();
        Set allNames = macros.getAllMacroNames();
        THashMap map2 = new THashMap(allNames.size());
        for (String eachMacroName : allNames) {
            map2.put("$" + eachMacroName + "$", macros.getValue(eachMacroName));
        }
        return map2;
    }

    @NotNull
    public FileSaverDialog createSaveFileDialog(@NotNull FileSaverDescriptor descriptor2, @Nullable Project project2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/openapi/fileChooser/impl/FileChooserFactoryImpl", "createSaveFileDialog"));
        }
        Object object = SystemInfo.isMac && Registry.is((String)"ide.mac.native.save.dialog") ? new MacFileSaverDialog(descriptor2, project2) : new FileSaverDialogImpl(descriptor2, project2);
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileChooser/impl/FileChooserFactoryImpl", "createSaveFileDialog"));
        }
        return object;
    }

    @NotNull
    public FileSaverDialog createSaveFileDialog(@NotNull FileSaverDescriptor descriptor2, @NotNull Component parent) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/openapi/fileChooser/impl/FileChooserFactoryImpl", "createSaveFileDialog"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/fileChooser/impl/FileChooserFactoryImpl", "createSaveFileDialog"));
        }
        Object object = SystemInfo.isMac && Registry.is((String)"ide.mac.native.save.dialog") ? new MacFileSaverDialog(descriptor2, parent) : new FileSaverDialogImpl(descriptor2, parent);
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileChooser/impl/FileChooserFactoryImpl", "createSaveFileDialog"));
        }
        return object;
    }
}

