/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.tree;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.RefreshSession;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

public class FileRefresher
implements Disposable {
    private final ScheduledExecutorService executor = AppExecutorUtil.createBoundedScheduledExecutorService((String)"FileRefresher", (int)1);
    private final boolean recursive;
    private final long delay;
    private final AtomicReference<RefreshSession> session = new AtomicReference();
    private final AtomicReference<List<Object>> watchers = new AtomicReference();
    private volatile List<VirtualFile> files;
    private volatile boolean disposed;
    private volatile boolean paused;

    public FileRefresher(boolean recursive, long delay) {
        if (delay <= 0L) {
            throw new IllegalArgumentException("delay");
        }
        this.recursive = recursive;
        this.delay = delay;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    protected Object watch(VirtualFile file2, boolean recursive) {
        VirtualFileSystem fs = file2.getFileSystem();
        if (fs instanceof LocalFileSystem) {
            return LocalFileSystem.getInstance().addRootToWatch(file2.getPath(), recursive);
        }
        return null;
    }

    protected void unwatch(Object watcher) {
        if (watcher instanceof LocalFileSystem.WatchRequest) {
            LocalFileSystem.getInstance().removeWatchedRoot((LocalFileSystem.WatchRequest)watcher);
        }
    }

    public final void setFiles(List<VirtualFile> files2) {
        if (!this.disposed) {
            this.unwatch();
            if (files2 != null && (files2 = files2.stream().filter(Objects::nonNull).collect(Collectors.toList())).isEmpty()) {
                files2 = null;
            }
            this.files = files2;
            if (files2 != null) {
                this.watchers.set(files2.stream().map(file2 -> this.watch((VirtualFile)file2, this.recursive)).filter(Objects::nonNull).collect(Collectors.toList()));
                this.start();
            }
        }
    }

    public final void pause() {
        this.paused = true;
    }

    public final void start() {
        this.paused = false;
        if (!this.disposed) {
            this.executor.schedule(this::launch, this.delay, TimeUnit.SECONDS);
        }
    }

    private void launch() {
        RefreshSession session2;
        List<VirtualFile> files2 = this.files;
        if (!this.disposed && !this.paused && files2 != null && this.session.compareAndSet(null, session2 = RefreshQueue.getInstance().createSession(true, this.recursive, this::finish))) {
            session2.addAllFiles(files2);
            session2.launch();
        }
    }

    private void finish() {
        this.session.set(null);
        if (!this.disposed && !this.paused) {
            this.start();
        }
    }

    private void unwatch() {
        List watchers = this.watchers.getAndSet(null);
        if (watchers != null) {
            watchers.forEach(this::unwatch);
        }
    }

    public void dispose() {
        this.disposed = true;
        this.unwatch();
        RefreshSession session2 = this.session.getAndSet(null);
        if (session2 != null) {
            RefreshQueue.getInstance().cancelSession(session2.getId());
        }
    }
}

