/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.ex;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.EditorDataProvider;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.BusyObject;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileEditorManagerEx
extends FileEditorManager
implements BusyObject {
    protected final List<EditorDataProvider> myDataProviders = new ArrayList<EditorDataProvider>();

    public static FileEditorManagerEx getInstanceEx(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/ex/FileEditorManagerEx", "getInstanceEx"));
        }
        return (FileEditorManagerEx)FileEditorManagerEx.getInstance((Project)project2);
    }

    public abstract JComponent getComponent();

    @Nullable
    public abstract JComponent getPreferredFocusedComponent();

    @NotNull
    public abstract Pair<FileEditor[], FileEditorProvider[]> getEditorsWithProviders(@NotNull VirtualFile var1);

    @Nullable
    public abstract VirtualFile getFile(@NotNull FileEditor var1);

    public abstract void updateFilePresentation(@NotNull VirtualFile var1);

    public abstract EditorWindow getCurrentWindow();

    @NotNull
    public abstract AsyncResult<EditorWindow> getActiveWindow();

    public abstract void setCurrentWindow(EditorWindow var1);

    public abstract void closeFile(@NotNull VirtualFile var1, @NotNull EditorWindow var2);

    public abstract void unsplitWindow();

    public abstract void unsplitAllWindow();

    public abstract int getWindowSplitCount();

    public abstract boolean hasSplitOrUndockedWindows();

    @NotNull
    public abstract EditorWindow[] getWindows();

    @NotNull
    public abstract VirtualFile[] getSiblings(@NotNull VirtualFile var1);

    public abstract void createSplitter(int var1, @Nullable EditorWindow var2);

    public abstract void changeSplitterOrientation();

    public abstract void flipTabs();

    public abstract boolean tabsMode();

    public abstract boolean isInSplitter();

    public abstract boolean hasOpenedFile();

    @Nullable
    public abstract VirtualFile getCurrentFile();

    @Nullable
    public abstract Pair<FileEditor, FileEditorProvider> getSelectedEditorWithProvider(@NotNull VirtualFile var1);

    public abstract void closeAllFiles();

    @NotNull
    public abstract EditorsSplitters getSplitters();

    @NotNull
    public FileEditor[] openFile(@NotNull VirtualFile file2, boolean focusEditor) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/ex/FileEditorManagerEx", "openFile"));
        }
        FileEditor[] fileEditorArray = (FileEditor[])this.openFileWithProviders(file2, focusEditor, false).getFirst();
        if (fileEditorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/ex/FileEditorManagerEx", "openFile"));
        }
        return fileEditorArray;
    }

    @NotNull
    public FileEditor[] openFile(@NotNull VirtualFile file2, boolean focusEditor, boolean searchForOpen) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/ex/FileEditorManagerEx", "openFile"));
        }
        FileEditor[] fileEditorArray = (FileEditor[])this.openFileWithProviders(file2, focusEditor, searchForOpen).getFirst();
        if (fileEditorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/ex/FileEditorManagerEx", "openFile"));
        }
        return fileEditorArray;
    }

    @NotNull
    public abstract Pair<FileEditor[], FileEditorProvider[]> openFileWithProviders(@NotNull VirtualFile var1, boolean var2, boolean var3);

    @NotNull
    public abstract Pair<FileEditor[], FileEditorProvider[]> openFileWithProviders(@NotNull VirtualFile var1, boolean var2, @NotNull EditorWindow var3);

    public abstract boolean isChanged(@NotNull EditorComposite var1);

    public abstract EditorWindow getNextWindow(@NotNull EditorWindow var1);

    public abstract EditorWindow getPrevWindow(@NotNull EditorWindow var1);

    public abstract boolean isInsideChange();

    @Nullable
    public final Object getData(@NotNull String dataId, @NotNull Editor editor, @NotNull Caret caret) {
        if (dataId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/openapi/fileEditor/ex/FileEditorManagerEx", "getData"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/fileEditor/ex/FileEditorManagerEx", "getData"));
        }
        if (caret == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caret", "com/intellij/openapi/fileEditor/ex/FileEditorManagerEx", "getData"));
        }
        for (EditorDataProvider dataProvider : this.myDataProviders) {
            Object o2 = dataProvider.getData(dataId, editor, caret);
            if (o2 == null) continue;
            return o2;
        }
        return null;
    }

    public void registerExtraEditorDataProvider(final @NotNull EditorDataProvider provider, Disposable parentDisposable) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/openapi/fileEditor/ex/FileEditorManagerEx", "registerExtraEditorDataProvider"));
        }
        this.myDataProviders.add(provider);
        if (parentDisposable != null) {
            Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

                public void dispose() {
                    FileEditorManagerEx.this.myDataProviders.remove(provider);
                }
            });
        }
    }

    public void refreshIcons() {
        if (this instanceof FileEditorManagerImpl) {
            FileEditorManagerImpl mgr = (FileEditorManagerImpl)this;
            Set<EditorsSplitters> splitters = mgr.getAllSplitters();
            for (EditorsSplitters each : splitters) {
                for (VirtualFile file2 : mgr.getOpenFiles()) {
                    each.updateFileIcon(file2);
                }
            }
        }
    }

    public abstract EditorsSplitters getSplittersFor(Component var1);

    @NotNull
    public abstract ActionCallback notifyPublisher(@NotNull Runnable var1);
}

