/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.impl.DockableEditorTabbedContainer;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.ui.docking.DockContainer;
import com.intellij.ui.docking.DockContainerFactory;
import com.intellij.ui.docking.DockManager;
import com.intellij.ui.docking.DockableContent;
import org.jdom.Element;

public class DockableEditorContainerFactory
implements DockContainerFactory.Persistent {
    public static final String TYPE = "file-editors";
    private Project myProject;
    private FileEditorManagerImpl myFileEditorManager;
    private DockManager myDockManager;

    public DockableEditorContainerFactory(Project project2, FileEditorManagerImpl fileEditorManager, DockManager dockManager) {
        this.myProject = project2;
        this.myFileEditorManager = fileEditorManager;
        this.myDockManager = dockManager;
    }

    public DockContainer createContainer(DockableContent content2) {
        return this.createContainer(false);
    }

    private DockContainer createContainer(boolean loadingState) {
        final Ref containerRef = new Ref();
        EditorsSplitters splitters = new EditorsSplitters(this.myFileEditorManager, this.myDockManager, false){

            @Override
            protected void afterFileClosed(VirtualFile file2) {
                ((DockableEditorTabbedContainer)containerRef.get()).fireContentClosed(file2);
            }

            @Override
            protected void afterFileOpen(VirtualFile file2) {
                ((DockableEditorTabbedContainer)containerRef.get()).fireContentOpen(file2);
            }

            @Override
            protected IdeFrame getFrame(Project project2) {
                return DockManager.getInstance((Project)project2).getIdeFrame((DockContainer)containerRef.get());
            }

            @Override
            public boolean isFloating() {
                return true;
            }
        };
        if (!loadingState) {
            splitters.createCurrentWindow();
        }
        DockableEditorTabbedContainer container = new DockableEditorTabbedContainer(this.myProject, splitters, true);
        Disposer.register((Disposable)container, (Disposable)splitters);
        containerRef.set((Object)container);
        container.getSplitters().startListeningFocus();
        return container;
    }

    public DockContainer loadContainerFrom(Element element) {
        DockableEditorTabbedContainer container = (DockableEditorTabbedContainer)this.createContainer(true);
        container.getSplitters().readExternal(element.getChild("state"));
        return container;
    }

    public void dispose() {
    }
}

