/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.AppTopics;
import com.intellij.CommonBundle;
import com.intellij.codeStyle.CodeStyleFacade;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.impl.EditorFactoryImpl;
import com.intellij.openapi.editor.impl.TrailingSpacesStripper;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.fileEditor.FileDocumentSynchronizationVetoer;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileEditor.impl.MemoryDiskConflictResolver;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImpl;
import com.intellij.openapi.fileTypes.BinaryFileTypeDecompilers;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.SafeWriteRequestor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.pom.core.impl.PomModelImpl;
import com.intellij.psi.ExternalChangeAction;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileDocumentManagerImpl
extends FileDocumentManager
implements VirtualFileListener,
ProjectManagerListener,
SafeWriteRequestor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl");
    public static final Key<Document> HARD_REF_TO_DOCUMENT_KEY = Key.create((String)"HARD_REF_TO_DOCUMENT_KEY");
    private static final Key<String> LINE_SEPARATOR_KEY = Key.create((String)"LINE_SEPARATOR_KEY");
    private static final Key<VirtualFile> FILE_KEY = Key.create((String)"FILE_KEY");
    private static final Key<Boolean> MUST_RECOMPUTE_FILE_TYPE = Key.create((String)"Must recompute file type");
    private final Set<Document> myUnsavedDocuments;
    private final MessageBus myBus;
    private static final Object lock = new Object();
    private final FileDocumentManagerListener myMultiCaster;
    private final TrailingSpacesStripper myTrailingSpacesStripper;
    private boolean myOnClose;
    private volatile MemoryDiskConflictResolver myConflictResolver;
    private final PrioritizedDocumentListener myPhysicalDocumentChangeTracker;
    private final Map<VirtualFile, Document> myDocumentCache;
    public static boolean ourConflictsSolverEnabled = true;

    public FileDocumentManagerImpl(@NotNull VirtualFileManager virtualFileManager, @NotNull ProjectManager projectManager) {
        if (virtualFileManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFileManager", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "<init>"));
        }
        if (projectManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectManager", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "<init>"));
        }
        this.myUnsavedDocuments = ContainerUtil.newConcurrentSet();
        this.myTrailingSpacesStripper = new TrailingSpacesStripper();
        this.myConflictResolver = new MemoryDiskConflictResolver();
        this.myPhysicalDocumentChangeTracker = new PrioritizedDocumentListener(){

            public void beforeDocumentChange(DocumentEvent event) {
            }

            @Override
            public int getPriority() {
                return Integer.MIN_VALUE;
            }

            public void documentChanged(DocumentEvent e2) {
                Runnable currentCommand;
                Document document = e2.getDocument();
                if (!ApplicationManager.getApplication().hasWriteAction(ExternalChangeAction.ExternalDocumentChange.class)) {
                    FileDocumentManagerImpl.this.myUnsavedDocuments.add(document);
                }
                Project project2 = (currentCommand = CommandProcessor.getInstance().getCurrentCommand()) == null ? null : CommandProcessor.getInstance().getCurrentCommandProject();
                String lineSeparator = CodeStyleFacade.getInstance((Project)project2).getLineSeparator();
                document.putUserData(LINE_SEPARATOR_KEY, (Object)lineSeparator);
                if (FileDocumentManagerImpl.areTooManyDocumentsInTheQueue(FileDocumentManagerImpl.this.myUnsavedDocuments)) {
                    FileDocumentManagerImpl.this.saveAllDocumentsLater();
                }
            }
        };
        this.myDocumentCache = ContainerUtil.createConcurrentWeakValueMap();
        virtualFileManager.addVirtualFileListener((VirtualFileListener)this);
        projectManager.addProjectManagerListener((ProjectManagerListener)this);
        this.myBus = ApplicationManager.getApplication().getMessageBus();
        InvocationHandler handler2 = (proxy, method2, args) -> {
            this.multiCast(method2, args);
            return null;
        };
        ClassLoader loader = FileDocumentManagerListener.class.getClassLoader();
        this.myMultiCaster = (FileDocumentManagerListener)Proxy.newProxyInstance(loader, new Class[]{FileDocumentManagerListener.class}, handler2);
    }

    private static void unwrapAndRethrow(Exception e2) {
        Exception unwrapped = e2;
        if (e2 instanceof InvocationTargetException) {
            Throwable throwable = unwrapped = e2.getCause() == null ? e2 : e2.getCause();
        }
        if (unwrapped instanceof Error) {
            throw (Error)((Object)unwrapped);
        }
        if (unwrapped instanceof RuntimeException) {
            throw (RuntimeException)unwrapped;
        }
        LOG.error((Throwable)unwrapped);
    }

    private void multiCast(@NotNull Method method2, Object[] args) {
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "multiCast"));
        }
        try {
            method2.invoke(this.myBus.syncPublisher(AppTopics.FILE_DOCUMENT_SYNC), args);
        }
        catch (ClassCastException e2) {
            LOG.error("Arguments: " + Arrays.toString(args), (Throwable)e2);
        }
        catch (Exception e3) {
            FileDocumentManagerImpl.unwrapAndRethrow(e3);
        }
        for (FileDocumentManagerListener listener2 : FileDocumentManagerImpl.getListeners()) {
            try {
                method2.invoke((Object)listener2, args);
            }
            catch (Exception e4) {
                FileDocumentManagerImpl.unwrapAndRethrow(e4);
            }
        }
        try {
            method2.invoke((Object)this.myTrailingSpacesStripper, args);
        }
        catch (Exception e5) {
            FileDocumentManagerImpl.unwrapAndRethrow(e5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Document getDocument(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "getDocument"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        DocumentEx document = (DocumentEx)this.getCachedDocument(file2);
        if (document == null) {
            if (!file2.isValid() || file2.isDirectory() || FileDocumentManagerImpl.isBinaryWithoutDecompiler(file2)) {
                return null;
            }
            boolean tooLarge = FileUtilRt.isTooLarge((long)file2.getLength());
            if (file2.getFileType().isBinary() && tooLarge) {
                return null;
            }
            CharSequence text2 = tooLarge ? LoadTextUtil.loadText(file2, FileDocumentManagerImpl.getPreviewCharCount(file2)) : LoadTextUtil.loadText(file2);
            Object object = lock;
            synchronized (object) {
                document = (DocumentEx)this.getCachedDocument(file2);
                if (document != null) {
                    return document;
                }
                document = (DocumentEx)FileDocumentManagerImpl.createDocument(text2, file2);
                document.setModificationStamp(file2.getModificationStamp());
                FileType fileType = file2.getFileType();
                document.setReadOnly(tooLarge || !file2.isWritable() || fileType.isBinary());
                if (!(file2 instanceof LightVirtualFile) && !(file2.getFileSystem() instanceof NonPhysicalFileSystem)) {
                    document.addDocumentListener(this.myPhysicalDocumentChangeTracker);
                }
                if (file2 instanceof LightVirtualFile) {
                    FileDocumentManagerImpl.registerDocument(document, file2);
                } else {
                    document.putUserData(FILE_KEY, file2);
                    this.cacheDocument(file2, document);
                }
            }
            this.myMultiCaster.fileContentLoaded(file2, (Document)document);
        }
        return document;
    }

    public static boolean areTooManyDocumentsInTheQueue(Collection<Document> documents) {
        if (documents.size() > 100) {
            return true;
        }
        int totalSize = 0;
        for (Document document : documents) {
            if ((totalSize += document.getTextLength()) <= FileUtilRt.LARGE_FOR_CONTENT_LOADING) continue;
            return true;
        }
        return false;
    }

    private static Document createDocument(CharSequence text2, VirtualFile file2) {
        boolean acceptSlashR = file2 instanceof LightVirtualFile && StringUtil.indexOf((CharSequence)text2, (char)'\r') >= 0;
        boolean freeThreaded = Boolean.TRUE.equals(file2.getUserData(SingleRootFileViewProvider.FREE_THREADED));
        return ((EditorFactoryImpl)EditorFactory.getInstance()).createDocument(text2, acceptSlashR, freeThreaded);
    }

    @Nullable
    public Document getCachedDocument(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "getCachedDocument"));
        }
        Document hard = (Document)file2.getUserData(HARD_REF_TO_DOCUMENT_KEY);
        return hard != null ? hard : this.getDocumentFromCache(file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerDocument(@NotNull Document document, @NotNull VirtualFile virtualFile) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "registerDocument"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "registerDocument"));
        }
        Object object = lock;
        synchronized (object) {
            document.putUserData(FILE_KEY, (Object)virtualFile);
            virtualFile.putUserData(HARD_REF_TO_DOCUMENT_KEY, (Object)document);
        }
    }

    @Nullable
    public VirtualFile getFile(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "getFile"));
        }
        return (VirtualFile)document.getUserData(FILE_KEY);
    }

    public void dropAllUnsavedDocuments() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            throw new RuntimeException("This method is only for test mode!");
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (!this.myUnsavedDocuments.isEmpty()) {
            this.myUnsavedDocuments.clear();
            this.fireUnsavedDocumentsDropped();
        }
    }

    private void saveAllDocumentsLater() {
        ApplicationManager.getApplication().invokeLater(() -> {
            Document[] unsavedDocuments;
            if (ApplicationManager.getApplication().isDisposed()) {
                return;
            }
            for (Document document : unsavedDocuments = this.getUnsavedDocuments()) {
                Project project2;
                VirtualFile file2 = this.getFile(document);
                if (file2 == null || (project2 = ProjectUtil.guessProjectForFile((VirtualFile)file2)) == null || PsiDocumentManager.getInstance((Project)project2).isDocumentBlockedByPsi(document)) continue;
                this.saveDocument(document);
            }
        });
    }

    public void saveAllDocuments() {
        this.saveAllDocuments(true);
    }

    public void saveAllDocuments(boolean isExplicit) {
        int count;
        ApplicationManager.getApplication().assertIsDispatchThread();
        ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
        this.myMultiCaster.beforeAllDocumentsSaving();
        if (this.myUnsavedDocuments.isEmpty()) {
            return;
        }
        HashMap<Document, IOException> failedToSave = new HashMap<Document, IOException>();
        HashSet<Document> vetoed = new HashSet<Document>();
        do {
            count = 0;
            for (Document document : this.myUnsavedDocuments) {
                if (failedToSave.containsKey(document) || vetoed.contains(document)) continue;
                try {
                    this.doSaveDocument(document, isExplicit);
                }
                catch (IOException e2) {
                    failedToSave.put(document, e2);
                }
                catch (SaveVetoException e3) {
                    vetoed.add(document);
                }
                ++count;
            }
        } while (count != 0);
        if (!failedToSave.isEmpty()) {
            this.handleErrorsOnSave(failedToSave);
        }
    }

    public void saveDocument(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "saveDocument"));
        }
        this.saveDocument(document, true);
    }

    public void saveDocument(@NotNull Document document, boolean explicit) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "saveDocument"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
        if (!this.myUnsavedDocuments.contains(document)) {
            return;
        }
        try {
            this.doSaveDocument(document, explicit);
        }
        catch (IOException e2) {
            this.handleErrorsOnSave(Collections.singletonMap(document, e2));
        }
        catch (SaveVetoException saveVetoException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDocumentAsIs(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "saveDocumentAsIs"));
        }
        VirtualFile file2 = this.getFile(document);
        boolean spaceStrippingEnabled = true;
        if (file2 != null) {
            spaceStrippingEnabled = TrailingSpacesStripper.isEnabled(file2);
            TrailingSpacesStripper.setEnabled(file2, false);
        }
        try {
            this.saveDocument(document);
        }
        finally {
            if (file2 != null) {
                TrailingSpacesStripper.setEnabled(file2, spaceStrippingEnabled);
            }
        }
    }

    private void doSaveDocument(@NotNull Document document, boolean isExplicit) throws IOException, SaveVetoException {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "doSaveDocument"));
        }
        VirtualFile file2 = this.getFile(document);
        if (file2 == null || file2 instanceof LightVirtualFile || file2.isValid() && !this.isFileModified(file2)) {
            this.removeFromUnsaved(document);
            return;
        }
        if (file2.isValid() && FileDocumentManagerImpl.needsRefresh(file2)) {
            file2.refresh(false, false);
            if (!this.myUnsavedDocuments.contains(document)) {
                return;
            }
        }
        if (!this.maySaveDocument(file2, document, isExplicit)) {
            throw new SaveVetoException();
        }
        WriteAction.run(() -> {
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "lambda$doSaveDocument$2"));
            }
            this.doSaveDocumentInWriteAction(document, file2);
        });
    }

    private boolean maySaveDocument(VirtualFile file2, Document document, boolean isExplicit) {
        return !this.myConflictResolver.hasConflict(file2) && Arrays.stream(Extensions.getExtensions((ExtensionPointName)FileDocumentSynchronizationVetoer.EP_NAME)).allMatch(vetoer -> vetoer.maySaveDocument(document, isExplicit));
    }

    private void doSaveDocumentInWriteAction(@NotNull Document document, @NotNull VirtualFile file2) throws IOException {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "doSaveDocumentInWriteAction"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "doSaveDocumentInWriteAction"));
        }
        if (!file2.isValid()) {
            this.removeFromUnsaved(document);
            return;
        }
        if (!file2.equals(this.getFile(document))) {
            FileDocumentManagerImpl.registerDocument(document, file2);
        }
        if (!FileDocumentManagerImpl.isSaveNeeded(document, file2)) {
            if (document instanceof DocumentEx) {
                ((DocumentEx)document).setModificationStamp(file2.getModificationStamp());
            }
            this.removeFromUnsaved(document);
            FileDocumentManagerImpl.updateModifiedProperty(file2);
            return;
        }
        PomModelImpl.guardPsiModificationsIn(() -> {
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "lambda$doSaveDocumentInWriteAction$4"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "lambda$doSaveDocumentInWriteAction$4"));
            }
            this.myMultiCaster.beforeDocumentSaving(document);
            LOG.assertTrue(file2.isValid());
            String text2 = document.getText();
            String lineSeparator = FileDocumentManagerImpl.getLineSeparator(document, file2);
            if (!lineSeparator.equals("\n")) {
                text2 = StringUtil.convertLineSeparators((String)text2, (String)lineSeparator);
            }
            Project project2 = ProjectLocator.getInstance().guessProjectForFile(file2);
            LoadTextUtil.write(project2, file2, (Object)this, text2, document.getModificationStamp());
            this.myUnsavedDocuments.remove(document);
            LOG.assertTrue(!this.myUnsavedDocuments.contains(document));
            this.myTrailingSpacesStripper.clearLineModificationFlags(document);
        });
    }

    private static void updateModifiedProperty(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "updateModifiedProperty"));
        }
        for (Project project2 : ProjectManager.getInstance().getOpenProjects()) {
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project2);
            for (FileEditor editor : fileEditorManager.getAllEditors(file2)) {
                if (!(editor instanceof TextEditorImpl)) continue;
                ((TextEditorImpl)editor).updateModifiedProperty();
            }
        }
    }

    private void removeFromUnsaved(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "removeFromUnsaved"));
        }
        this.myUnsavedDocuments.remove(document);
        this.fireUnsavedDocumentsDropped();
        LOG.assertTrue(!this.myUnsavedDocuments.contains(document));
    }

    private static boolean isSaveNeeded(@NotNull Document document, @NotNull VirtualFile file2) throws IOException {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "isSaveNeeded"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "isSaveNeeded"));
        }
        if (file2.getFileType().isBinary() || document.getTextLength() > 1000000) {
            return true;
        }
        byte[] bytes = file2.contentsToByteArray();
        CharSequence loaded = LoadTextUtil.getTextByBinaryPresentation(bytes, file2, false, false);
        return !Comparing.equal((CharSequence)document.getCharsSequence(), (CharSequence)loaded);
    }

    private static boolean needsRefresh(VirtualFile file2) {
        VirtualFileSystem fs = file2.getFileSystem();
        return fs instanceof NewVirtualFileSystem && file2.getTimeStamp() != ((NewVirtualFileSystem)fs).getTimeStamp(file2);
    }

    @NotNull
    public static String getLineSeparator(@NotNull Document document, @NotNull VirtualFile file2) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "getLineSeparator"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "getLineSeparator"));
        }
        String lineSeparator = LoadTextUtil.getDetectedLineSeparator(file2);
        if (lineSeparator == null) {
            lineSeparator = (String)document.getUserData(LINE_SEPARATOR_KEY);
            assert (lineSeparator != null) : document;
        }
        String string2 = lineSeparator;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "getLineSeparator"));
        }
        return string2;
    }

    @NotNull
    public String getLineSeparator(@Nullable VirtualFile file2, @Nullable Project project2) {
        String lineSeparator;
        String string2 = lineSeparator = file2 == null ? null : LoadTextUtil.getDetectedLineSeparator(file2);
        if (lineSeparator == null) {
            CodeStyleFacade settingsManager = project2 == null ? CodeStyleFacade.getInstance() : CodeStyleFacade.getInstance((Project)project2);
            lineSeparator = settingsManager.getLineSeparator();
        }
        String string3 = lineSeparator;
        if (string3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "getLineSeparator"));
        }
        return string3;
    }

    public boolean requestWriting(@NotNull Document document, Project project2) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "requestWriting"));
        }
        VirtualFile file2 = FileDocumentManagerImpl.getInstance().getFile(document);
        if (project2 != null && file2 != null && file2.isValid()) {
            return !file2.getFileType().isBinary() && ReadonlyStatusHandler.ensureFilesWritable((Project)project2, (VirtualFile[])new VirtualFile[]{file2});
        }
        if (document.isWritable()) {
            return true;
        }
        document.fireReadOnlyModificationAttempt();
        return false;
    }

    public void reloadFiles(VirtualFile ... files2) {
        if (files2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "reloadFiles"));
        }
        for (VirtualFile file2 : files2) {
            Document doc;
            if (!file2.exists() || (doc = this.getCachedDocument(file2)) == null) continue;
            this.reloadFromDisk(doc);
        }
    }

    @NotNull
    public Document[] getUnsavedDocuments() {
        if (this.myUnsavedDocuments.isEmpty()) {
            if (Document.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "getUnsavedDocuments"));
            }
            return Document.EMPTY_ARRAY;
        }
        ArrayList<Document> list2 = new ArrayList<Document>(this.myUnsavedDocuments);
        Document[] documentArray = list2.toArray(new Document[list2.size()]);
        if (documentArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "getUnsavedDocuments"));
        }
        return documentArray;
    }

    public boolean isDocumentUnsaved(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "isDocumentUnsaved"));
        }
        return this.myUnsavedDocuments.contains(document);
    }

    public boolean isFileModified(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "isFileModified"));
        }
        Document doc = this.getCachedDocument(file2);
        return doc != null && this.isDocumentUnsaved(doc) && doc.getModificationStamp() != file2.getModificationStamp();
    }

    public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
        Document document;
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "propertyChanged"));
        }
        VirtualFile file2 = event.getFile();
        if ("writable".equals(event.getPropertyName())) {
            Document document2 = this.getCachedDocument(file2);
            if (document2 != null) {
                ApplicationManager.getApplication().runWriteAction(() -> document2.setReadOnly(!file2.isWritable()));
            }
        } else if ("name".equals(event.getPropertyName()) && (document = this.getCachedDocument(file2)) != null && FileDocumentManagerImpl.isBinaryWithoutDecompiler(file2)) {
            this.unbindFileFromDocument(file2, document);
        }
    }

    private void unbindFileFromDocument(@NotNull VirtualFile file2, @NotNull Document document) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "unbindFileFromDocument"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "unbindFileFromDocument"));
        }
        this.removeDocumentFromCache(file2);
        file2.putUserData(HARD_REF_TO_DOCUMENT_KEY, null);
        document.putUserData(FILE_KEY, null);
    }

    private static boolean isBinaryWithDecompiler(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "isBinaryWithDecompiler"));
        }
        FileType ft = file2.getFileType();
        return ft.isBinary() && BinaryFileTypeDecompilers.INSTANCE.forFileType(ft) != null;
    }

    private static boolean isBinaryWithoutDecompiler(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "isBinaryWithoutDecompiler"));
        }
        FileType fileType = file2.getFileType();
        return fileType.isBinary() && BinaryFileTypeDecompilers.INSTANCE.forFileType(fileType) == null;
    }

    public void contentsChanged(@NotNull VirtualFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "contentsChanged"));
        }
        if (event.isFromSave()) {
            return;
        }
        VirtualFile file2 = event.getFile();
        Document document = this.getCachedDocument(file2);
        if (document == null) {
            this.myMultiCaster.fileWithNoDocumentChanged(file2);
            return;
        }
        if (FileDocumentManagerImpl.isBinaryWithDecompiler(file2)) {
            this.myMultiCaster.fileWithNoDocumentChanged(file2);
        }
        if (document.getModificationStamp() == event.getOldModificationStamp() || !this.isDocumentUnsaved(document)) {
            this.reloadFromDisk(document);
        }
    }

    public void reloadFromDisk(final @NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "reloadFromDisk"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        final VirtualFile file2 = this.getFile(document);
        assert (file2 != null);
        if (!this.fireBeforeFileContentReload(file2, document)) {
            return;
        }
        final Project project2 = ProjectLocator.getInstance().guessProjectForFile(file2);
        final boolean[] isReloadable = new boolean[]{FileDocumentManagerImpl.isReloadable(file2, document, project2)};
        if (isReloadable[0]) {
            CommandProcessor.getInstance().executeCommand(project2, () -> {
                if (document == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "lambda$reloadFromDisk$6"));
                }
                ApplicationManager.getApplication().runWriteAction((Runnable)new ExternalChangeAction.ExternalDocumentChange(document, project2){

                    @Override
                    public void run() {
                        if (!FileDocumentManagerImpl.isBinaryWithoutDecompiler(file2)) {
                            LoadTextUtil.setCharsetWasDetectedFromBytes(file2, null);
                            file2.setBOM(null);
                            file2.setCharset(null, null, false);
                            boolean wasWritable = document.isWritable();
                            document.setReadOnly(false);
                            boolean tooLarge = FileUtilRt.isTooLarge((long)file2.getLength());
                            CharSequence reloaded2 = tooLarge ? LoadTextUtil.loadText(file2, FileDocumentManagerImpl.getPreviewCharCount(file2)) : LoadTextUtil.loadText(file2);
                            isReloadable[0] = FileDocumentManagerImpl.isReloadable(file2, document, project2);
                            boolean differsOnlyBySeparators = StringUtil.convertLineSeparators((String)document.getText()).equals(reloaded2);
                            if (isReloadable[0] && !differsOnlyBySeparators) {
                                DocumentEx documentEx = (DocumentEx)document;
                                documentEx.replaceText(reloaded2, file2.getModificationStamp());
                            }
                            document.setReadOnly(!wasWritable);
                        }
                    }
                });
            }, UIBundle.message((String)"file.cache.conflict.action", (Object[])new Object[0]), null, UndoConfirmationPolicy.REQUEST_CONFIRMATION);
        }
        if (isReloadable[0]) {
            this.myMultiCaster.fileContentReloaded(file2, document);
        } else {
            this.unbindFileFromDocument(file2, document);
            this.myMultiCaster.fileWithNoDocumentChanged(file2);
        }
        this.myUnsavedDocuments.remove(document);
    }

    private static boolean isReloadable(@NotNull VirtualFile file2, @NotNull Document document, @Nullable Project project2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "isReloadable"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "isReloadable"));
        }
        PsiFile cachedPsiFile = project2 == null ? null : PsiDocumentManager.getInstance((Project)project2).getCachedPsiFile(document);
        return !(FileUtilRt.isTooLarge((long)file2.getLength()) && file2.getFileType().isBinary() || cachedPsiFile != null && !(cachedPsiFile instanceof PsiFileImpl) && !FileDocumentManagerImpl.isBinaryWithDecompiler(file2));
    }

    void setAskReloadFromDisk(@NotNull Disposable disposable, @NotNull MemoryDiskConflictResolver newProcessor) {
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "setAskReloadFromDisk"));
        }
        if (newProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newProcessor", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "setAskReloadFromDisk"));
        }
        MemoryDiskConflictResolver old = this.myConflictResolver;
        this.myConflictResolver = newProcessor;
        Disposer.register((Disposable)disposable, () -> {
            this.myConflictResolver = old;
        });
    }

    public void fileCreated(@NotNull VirtualFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "fileCreated"));
        }
    }

    public void fileDeleted(@NotNull VirtualFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "fileDeleted"));
        }
        Document doc = this.getCachedDocument(event.getFile());
        if (doc != null) {
            this.myTrailingSpacesStripper.documentDeleted(doc);
        }
    }

    public void fileMoved(@NotNull VirtualFileMoveEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "fileMoved"));
        }
    }

    public void fileCopied(@NotNull VirtualFileCopyEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "fileCopied"));
        }
        this.fileCreated((VirtualFileEvent)event);
    }

    public void beforePropertyChange(@NotNull VirtualFilePropertyEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "beforePropertyChange"));
        }
    }

    public void beforeContentsChange(@NotNull VirtualFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "beforeContentsChange"));
        }
        VirtualFile virtualFile = event.getFile();
        if (virtualFile.getLength() == 0L && virtualFile.getFileType() == UnknownFileType.INSTANCE) {
            virtualFile.putUserData(MUST_RECOMPUTE_FILE_TYPE, (Object)Boolean.TRUE);
        }
        if (ourConflictsSolverEnabled) {
            this.myConflictResolver.beforeContentChange(event);
        }
    }

    public static boolean recomputeFileTypeIfNecessary(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "recomputeFileTypeIfNecessary"));
        }
        if (virtualFile.getUserData(MUST_RECOMPUTE_FILE_TYPE) != null) {
            virtualFile.getFileType();
            virtualFile.putUserData(MUST_RECOMPUTE_FILE_TYPE, null);
            return true;
        }
        return false;
    }

    public void beforeFileDeletion(@NotNull VirtualFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "beforeFileDeletion"));
        }
    }

    public void beforeFileMovement(@NotNull VirtualFileMoveEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "beforeFileMovement"));
        }
    }

    public boolean canCloseProject(Project project2) {
        if (!this.myUnsavedDocuments.isEmpty()) {
            this.myOnClose = true;
            try {
                this.saveAllDocuments();
            }
            finally {
                this.myOnClose = false;
            }
        }
        return this.myUnsavedDocuments.isEmpty();
    }

    private void fireUnsavedDocumentsDropped() {
        this.myMultiCaster.unsavedDocumentsDropped();
    }

    private boolean fireBeforeFileContentReload(VirtualFile file2, @NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "fireBeforeFileContentReload"));
        }
        for (FileDocumentSynchronizationVetoer vetoer : (FileDocumentSynchronizationVetoer[])Extensions.getExtensions((ExtensionPointName)FileDocumentSynchronizationVetoer.EP_NAME)) {
            try {
                if (vetoer.mayReloadFileContent(file2, document)) continue;
                return false;
            }
            catch (Exception e2) {
                LOG.error((Throwable)e2);
            }
        }
        this.myMultiCaster.beforeFileContentReload(file2, document);
        return true;
    }

    @NotNull
    private static FileDocumentManagerListener[] getListeners() {
        FileDocumentManagerListener[] fileDocumentManagerListenerArray = (FileDocumentManagerListener[])FileDocumentManagerListener.EP_NAME.getExtensions();
        if (fileDocumentManagerListenerArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "getListeners"));
        }
        return fileDocumentManagerListenerArray;
    }

    private static int getPreviewCharCount(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "getPreviewCharCount"));
        }
        Charset charset = EncodingManager.getInstance().getEncoding(file2, false);
        float bytesPerChar = charset == null ? 2.0f : charset.newEncoder().averageBytesPerChar();
        return (int)((float)FileUtilRt.LARGE_FILE_PREVIEW_SIZE / bytesPerChar);
    }

    private void handleErrorsOnSave(@NotNull Map<Document, IOException> failures) {
        if (failures == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "failures", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "handleErrorsOnSave"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            IOException ioException = (IOException)ContainerUtil.getFirstItem(failures.values());
            if (ioException != null) {
                throw new RuntimeException(ioException);
            }
            return;
        }
        for (IOException exception : failures.values()) {
            LOG.warn((Throwable)exception);
        }
        final String text2 = StringUtil.join(failures.values(), Throwable::getMessage, (String)"\n");
        DialogWrapper dialog2 = new DialogWrapper(null){
            {
                super(arg0);
                this.init();
                this.setTitle(UIBundle.message((String)"cannot.save.files.dialog.title", (Object[])new Object[0]));
            }

            protected void createDefaultActions() {
                super.createDefaultActions();
                this.myOKAction.putValue("Name", UIBundle.message((String)(FileDocumentManagerImpl.this.myOnClose ? "cannot.save.files.dialog.ignore.changes" : "cannot.save.files.dialog.revert.changes"), (Object[])new Object[0]));
                this.myOKAction.putValue("DefaultAction", null);
                if (!FileDocumentManagerImpl.this.myOnClose) {
                    this.myCancelAction.putValue("Name", CommonBundle.getCloseButtonText());
                }
            }

            protected JComponent createCenterPanel() {
                JPanel panel2 = new JPanel(new BorderLayout(0, 5));
                panel2.add((Component)new JLabel(UIBundle.message((String)"cannot.save.files.dialog.message", (Object[])new Object[0])), "North");
                JTextPane area = new JTextPane();
                area.setText(text2);
                area.setEditable(false);
                area.setMinimumSize(new Dimension(area.getMinimumSize().width, 50));
                panel2.add((Component)new JBScrollPane((Component)area, 22, 31), "Center");
                return panel2;
            }
        };
        if (dialog2.showAndGet()) {
            for (Document document : failures.keySet()) {
                this.reloadFromDisk(document);
            }
        }
    }

    protected void cacheDocument(@NotNull VirtualFile file2, @NotNull Document document) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "cacheDocument"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "cacheDocument"));
        }
        this.myDocumentCache.put(file2, document);
    }

    protected void removeDocumentFromCache(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "removeDocumentFromCache"));
        }
        this.myDocumentCache.remove(file2);
    }

    protected Document getDocumentFromCache(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "getDocumentFromCache"));
        }
        return this.myDocumentCache.get(file2);
    }

    private static class SaveVetoException
    extends Exception {
        private SaveVetoException() {
        }
    }
}

