/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffManager;
import com.intellij.diff.DiffRequestPanel;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.ui.UIBundle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;

class MemoryDiskConflictResolver {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.fileEditor.impl.MemoryDiskConflictResolver");
    private final Set<VirtualFile> myConflicts = new LinkedHashSet<VirtualFile>();

    MemoryDiskConflictResolver() {
    }

    void beforeContentChange(@NotNull VirtualFileEvent event) {
        long oldFileStamp;
        long documentStamp;
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileEditor/impl/MemoryDiskConflictResolver", "beforeContentChange"));
        }
        if (event.isFromSave()) {
            return;
        }
        VirtualFile file2 = event.getFile();
        if (!file2.isValid() || this.hasConflict(file2)) {
            return;
        }
        Document document = FileDocumentManager.getInstance().getCachedDocument(file2);
        if (document == null || !FileDocumentManager.getInstance().isDocumentUnsaved(document)) {
            return;
        }
        boolean tooLarge = FileUtilRt.isTooLarge((long)file2.getLength());
        if (!tooLarge) {
            String convertedDiskText = LoadTextUtil.loadText(file2).toString();
            String convertedDocumentText = StringUtil.convertLineSeparators((String)document.getText());
            if (convertedDocumentText.equals(convertedDiskText)) {
                return;
            }
        }
        if ((documentStamp = document.getModificationStamp()) != (oldFileStamp = event.getOldModificationStamp())) {
            LOG.info("reload " + file2.getName() + " from disk?");
            LOG.info("  documentStamp:" + documentStamp);
            LOG.info("  oldFileStamp:" + oldFileStamp);
            if (this.myConflicts.isEmpty()) {
                ApplicationManager.getApplication().invokeLater(this::processConflicts);
            }
            this.myConflicts.add(file2);
        }
    }

    boolean hasConflict(VirtualFile file2) {
        return this.myConflicts.contains(file2);
    }

    private void processConflicts() {
        ArrayList<VirtualFile> conflicts = new ArrayList<VirtualFile>(this.myConflicts);
        this.myConflicts.clear();
        for (VirtualFile file2 : conflicts) {
            Document document = FileDocumentManager.getInstance().getCachedDocument(file2);
            if (document == null || !this.askReloadFromDisk(file2, document)) continue;
            FileDocumentManager.getInstance().reloadFromDisk(document);
        }
    }

    boolean askReloadFromDisk(final VirtualFile file2, final Document document) {
        String message2 = UIBundle.message((String)"file.cache.conflict.message.text", (Object[])new Object[]{file2.getPresentableUrl()});
        final DialogBuilder builder = new DialogBuilder();
        builder.setCenterPanel((JComponent)new JLabel(message2, Messages.getQuestionIcon(), 0));
        builder.addOkAction().setText(UIBundle.message((String)"file.cache.conflict.load.fs.changes.button", (Object[])new Object[0]));
        builder.addCancelAction().setText(UIBundle.message((String)"file.cache.conflict.keep.memory.changes.button", (Object[])new Object[0]));
        builder.addAction((Action)new AbstractAction(UIBundle.message((String)"file.cache.conflict.show.difference.button", (Object[])new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ProjectEx project2 = (ProjectEx)ProjectLocator.getInstance().guessProjectForFile(file2);
                FileType fileType = file2.getFileType();
                String fsContent = LoadTextUtil.loadText(file2).toString();
                DocumentContent content1 = DiffContentFactory.getInstance().create((Project)project2, fsContent, fileType);
                DocumentContent content2 = DiffContentFactory.getInstance().create((Project)project2, document, file2);
                String title = UIBundle.message((String)"file.cache.conflict.for.file.dialog.title", (Object[])new Object[]{file2.getPresentableUrl()});
                String title1 = UIBundle.message((String)"file.cache.conflict.diff.content.file.system.content", (Object[])new Object[0]);
                String title2 = UIBundle.message((String)"file.cache.conflict.diff.content.memory.content", (Object[])new Object[0]);
                SimpleDiffRequest request2 = new SimpleDiffRequest(title, (DiffContent)content1, (DiffContent)content2, title1, title2);
                request2.putUserData(DiffUserDataKeys.GO_TO_SOURCE_DISABLE, (Object)true);
                DialogBuilder diffBuilder = new DialogBuilder((Project)project2);
                DiffRequestPanel diffPanel = DiffManager.getInstance().createRequestPanel((Project)project2, (Disposable)diffBuilder, diffBuilder.getWindow());
                diffPanel.setRequest((DiffRequest)request2);
                diffBuilder.setCenterPanel(diffPanel.getComponent());
                diffBuilder.setDimensionServiceKey("FileDocumentManager.FileCacheConflict");
                diffBuilder.addOkAction().setText(UIBundle.message((String)"file.cache.conflict.save.changes.button", (Object[])new Object[0]));
                diffBuilder.addCancelAction();
                diffBuilder.setTitle(title);
                if (diffBuilder.show() == 0) {
                    builder.getDialogWrapper().close(1);
                }
            }
        });
        builder.setTitle(UIBundle.message((String)"file.cache.conflict.dialog.title", (Object[])new Object[0]));
        builder.setButtonsAlignment(0);
        builder.setHelpId("reference.dialogs.fileCacheConflict");
        return builder.show() == 0;
    }
}

