/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import org.jetbrains.annotations.Nullable;

public class ReopenClosedTabAction
extends AnAction {
    public ReopenClosedTabAction() {
        super("Reopen Closed Tab");
    }

    public void actionPerformed(AnActionEvent e2) {
        EditorWindow window = ReopenClosedTabAction.getEditorWindow(e2);
        if (window != null) {
            window.restoreClosedTab();
        }
    }

    @Nullable
    private static EditorWindow getEditorWindow(AnActionEvent e2) {
        EditorsSplitters splitters;
        Component component = (Component)e2.getData(PlatformDataKeys.CONTEXT_COMPONENT);
        if (component != null && (splitters = (EditorsSplitters)((Object)UIUtil.getParentOfType(EditorsSplitters.class, (Component)component))) != null) {
            return splitters.getCurrentWindow();
        }
        return null;
    }

    public void update(AnActionEvent e2) {
        EditorWindow window = ReopenClosedTabAction.getEditorWindow(e2);
        e2.getPresentation().setEnabled(window != null && window.hasClosedTabs());
    }
}

