/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.text;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.LargeFileEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LargeFileNotificationProvider
extends EditorNotifications.Provider {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"large.file.editor.notification");
    private static final Key<String> HIDDEN_KEY = Key.create((String)"large.file.editor.notification.hidden");
    private static final String DISABLE_KEY = "large.file.editor.notification.disabled";

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/text/LargeFileNotificationProvider", "getKey"));
        }
        return key;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file2, @NotNull FileEditor fileEditor) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/text/LargeFileNotificationProvider", "createNotificationPanel"));
        }
        if (fileEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditor", "com/intellij/openapi/fileEditor/impl/text/LargeFileNotificationProvider", "createNotificationPanel"));
        }
        if (!(fileEditor instanceof LargeFileEditorProvider.LargeTextFileEditor)) {
            return null;
        }
        Editor editor = ((TextEditor)fileEditor).getEditor();
        Project project2 = editor.getProject();
        if (project2 == null || editor.getUserData(HIDDEN_KEY) != null || PropertiesComponent.getInstance().isTrueValue(DISABLE_KEY)) {
            return null;
        }
        EditorNotificationPanel panel2 = new EditorNotificationPanel();
        panel2.createActionLabel("Hide notification", () -> {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/text/LargeFileNotificationProvider", "lambda$createNotificationPanel$0"));
            }
            editor.putUserData(HIDDEN_KEY, (Object)"true");
            LargeFileNotificationProvider.update(file2, project2);
        });
        panel2.createActionLabel("Don't show again", () -> {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/text/LargeFileNotificationProvider", "lambda$createNotificationPanel$1"));
            }
            PropertiesComponent.getInstance().setValue(DISABLE_KEY, "true");
            LargeFileNotificationProvider.update(file2, project2);
        });
        return panel2.text(String.format("The file is too large: %s. Showing a read-only preview of the first %s.", StringUtil.formatFileSize((long)file2.getLength()), StringUtil.formatFileSize((long)FileUtilRt.LARGE_FILE_PREVIEW_SIZE)));
    }

    private static void update(@NotNull VirtualFile file2, @NotNull Project project2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/text/LargeFileNotificationProvider", "update"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/text/LargeFileNotificationProvider", "update"));
        }
        EditorNotifications.getInstance((Project)project2).updateNotifications(file2);
    }
}

