/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.intellij.ide.highlighter.FileTypeRegistrator;
import com.intellij.ide.highlighter.custom.SyntaxTable;
import com.intellij.ide.highlighter.custom.impl.CustomFileTypeEditor;
import com.intellij.lang.Commenter;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.ExactFileNameMatcher;
import com.intellij.openapi.fileTypes.ExtensionFileNameMatcher;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.UserFileType;
import com.intellij.openapi.fileTypes.WildcardFileNameMatcher;
import com.intellij.openapi.fileTypes.ex.ExternalizableFileType;
import com.intellij.openapi.fileTypes.impl.CustomSyntaxTableFileType;
import com.intellij.openapi.options.ExternalizableScheme;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.text.StringTokenizer;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractFileType
extends UserFileType<AbstractFileType>
implements ExternalizableFileType,
ExternalizableScheme,
CustomSyntaxTableFileType {
    private static final String SEMICOLON = ";";
    protected SyntaxTable mySyntaxTable;
    private SyntaxTable myDefaultSyntaxTable;
    protected Commenter myCommenter = null;
    @NonNls
    public static final String ELEMENT_HIGHLIGHTING = "highlighting";
    @NonNls
    private static final String ELEMENT_OPTIONS = "options";
    @NonNls
    private static final String ELEMENT_OPTION = "option";
    @NonNls
    private static final String ATTRIBUTE_VALUE = "value";
    @NonNls
    private static final String VALUE_LINE_COMMENT = "LINE_COMMENT";
    @NonNls
    private static final String VALUE_COMMENT_START = "COMMENT_START";
    @NonNls
    private static final String VALUE_COMMENT_END = "COMMENT_END";
    @NonNls
    private static final String VALUE_HEX_PREFIX = "HEX_PREFIX";
    @NonNls
    private static final String VALUE_NUM_POSTFIXES = "NUM_POSTFIXES";
    @NonNls
    private static final String VALUE_HAS_BRACES = "HAS_BRACES";
    @NonNls
    private static final String VALUE_HAS_BRACKETS = "HAS_BRACKETS";
    @NonNls
    private static final String VALUE_HAS_PARENS = "HAS_PARENS";
    @NonNls
    private static final String VALUE_HAS_STRING_ESCAPES = "HAS_STRING_ESCAPES";
    @NonNls
    private static final String VALUE_LINE_COMMENT_AT_START = "LINE_COMMENT_AT_START";
    @NonNls
    private static final String ELEMENT_KEYWORDS = "keywords";
    @NonNls
    private static final String ATTRIBUTE_IGNORE_CASE = "ignore_case";
    @NonNls
    private static final String ELEMENT_KEYWORD = "keyword";
    @NonNls
    private static final String ELEMENT_KEYWORDS2 = "keywords2";
    @NonNls
    private static final String ELEMENT_KEYWORDS3 = "keywords3";
    @NonNls
    private static final String ELEMENT_KEYWORDS4 = "keywords4";
    @NonNls
    private static final String ATTRIBUTE_NAME = "name";
    @NonNls
    public static final String ELEMENT_EXTENSION_MAP = "extensionMap";
    @NonNls
    private static final String ELEMENT_MAPPING = "mapping";
    @NonNls
    private static final String ATTRIBUTE_EXT = "ext";
    @NonNls
    private static final String ATTRIBUTE_PATTERN = "pattern";
    @NonNls
    private static final String ATTRIBUTE_APPROVED = "approved";
    @NonNls
    private static final String ELEMENT_REMOVED_MAPPING = "removed_mapping";
    @NonNls
    private static final String ATTRIBUTE_TYPE = "type";

    public AbstractFileType(SyntaxTable syntaxTable) {
        this.mySyntaxTable = syntaxTable;
    }

    public void initSupport() {
        for (FileTypeRegistrator registrator : (FileTypeRegistrator[])Extensions.getRootArea().getExtensionPoint(FileTypeRegistrator.EP_NAME).getExtensions()) {
            registrator.initFileType((FileType)this);
        }
    }

    @Override
    public SyntaxTable getSyntaxTable() {
        return this.mySyntaxTable;
    }

    public Commenter getCommenter() {
        return this.myCommenter;
    }

    public void setSyntaxTable(SyntaxTable syntaxTable) {
        this.mySyntaxTable = syntaxTable;
    }

    public AbstractFileType clone() {
        return (AbstractFileType)super.clone();
    }

    public void copyFrom(@NotNull UserFileType newType) {
        if (newType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newType", "com/intellij/openapi/fileTypes/impl/AbstractFileType", "copyFrom"));
        }
        super.copyFrom(newType);
        if (newType instanceof AbstractFileType) {
            this.mySyntaxTable = ((CustomSyntaxTableFileType)newType).getSyntaxTable();
        }
    }

    public boolean isBinary() {
        return false;
    }

    public void readExternal(@NotNull Element typeElement) throws InvalidDataException {
        if (typeElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeElement", "com/intellij/openapi/fileTypes/impl/AbstractFileType", "readExternal"));
        }
        Element element = typeElement.getChild(ELEMENT_HIGHLIGHTING);
        if (element != null) {
            this.setSyntaxTable(AbstractFileType.readSyntaxTable(element));
        }
    }

    @NotNull
    public static SyntaxTable readSyntaxTable(@NotNull Element root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/openapi/fileTypes/impl/AbstractFileType", "readSyntaxTable"));
        }
        SyntaxTable table2 = new SyntaxTable();
        for (Element element : root.getChildren()) {
            if (ELEMENT_OPTIONS.equals(element.getName())) {
                for (Object o1 : element.getChildren(ELEMENT_OPTION)) {
                    Element e2 = (Element)o1;
                    String name = e2.getAttributeValue(ATTRIBUTE_NAME);
                    String value2 = e2.getAttributeValue(ATTRIBUTE_VALUE);
                    if (VALUE_LINE_COMMENT.equals(name)) {
                        table2.setLineComment(value2);
                        continue;
                    }
                    if (VALUE_COMMENT_START.equals(name)) {
                        table2.setStartComment(value2);
                        continue;
                    }
                    if (VALUE_COMMENT_END.equals(name)) {
                        table2.setEndComment(value2);
                        continue;
                    }
                    if (VALUE_HEX_PREFIX.equals(name)) {
                        table2.setHexPrefix(value2);
                        continue;
                    }
                    if (VALUE_NUM_POSTFIXES.equals(name)) {
                        table2.setNumPostfixChars(value2);
                        continue;
                    }
                    if (VALUE_LINE_COMMENT_AT_START.equals(name)) {
                        table2.lineCommentOnlyAtStart = Boolean.valueOf(value2);
                        continue;
                    }
                    if (VALUE_HAS_BRACES.equals(name)) {
                        table2.setHasBraces(Boolean.valueOf(value2));
                        continue;
                    }
                    if (VALUE_HAS_BRACKETS.equals(name)) {
                        table2.setHasBrackets(Boolean.valueOf(value2));
                        continue;
                    }
                    if (VALUE_HAS_PARENS.equals(name)) {
                        table2.setHasParens(Boolean.valueOf(value2));
                        continue;
                    }
                    if (!VALUE_HAS_STRING_ESCAPES.equals(name)) continue;
                    table2.setHasStringEscapes(Boolean.valueOf(value2));
                }
                continue;
            }
            if (ELEMENT_KEYWORDS.equals(element.getName())) {
                boolean ignoreCase = Boolean.valueOf(element.getAttributeValue(ATTRIBUTE_IGNORE_CASE));
                table2.setIgnoreCase(ignoreCase);
                AbstractFileType.loadKeywords(element, table2.getKeywords1());
                continue;
            }
            if (ELEMENT_KEYWORDS2.equals(element.getName())) {
                AbstractFileType.loadKeywords(element, table2.getKeywords2());
                continue;
            }
            if (ELEMENT_KEYWORDS3.equals(element.getName())) {
                AbstractFileType.loadKeywords(element, table2.getKeywords3());
                continue;
            }
            if (!ELEMENT_KEYWORDS4.equals(element.getName())) continue;
            AbstractFileType.loadKeywords(element, table2.getKeywords4());
        }
        boolean DUMP_TABLE = false;
        if (DUMP_TABLE) {
            Element element;
            element = new Element("temp");
            AbstractFileType.writeTable(element, table2);
            XMLOutputter outputter = JDOMUtil.createOutputter((String)"\n");
            try {
                outputter.output((Element)element.getContent().get(0), (OutputStream)System.out);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        SyntaxTable syntaxTable = table2;
        if (syntaxTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/AbstractFileType", "readSyntaxTable"));
        }
        return syntaxTable;
    }

    private static void loadKeywords(Element element, Set<String> keywords) {
        String value2 = element.getAttributeValue(ELEMENT_KEYWORDS);
        if (value2 != null) {
            StringTokenizer tokenizer = new StringTokenizer(value2, SEMICOLON);
            while (tokenizer.hasMoreElements()) {
                String keyword = tokenizer.nextToken().trim();
                if (keyword.length() == 0) continue;
                keywords.add(keyword);
            }
        }
        for (Object o1 : element.getChildren(ELEMENT_KEYWORD)) {
            keywords.add(((Element)o1).getAttributeValue(ATTRIBUTE_NAME));
        }
    }

    public void writeExternal(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/fileTypes/impl/AbstractFileType", "writeExternal"));
        }
        AbstractFileType.writeTable(element, this.getSyntaxTable());
    }

    private static void writeTable(@NotNull Element element, @NotNull SyntaxTable table2) {
        String chars;
        String prefix;
        String endComment;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/fileTypes/impl/AbstractFileType", "writeTable"));
        }
        if (table2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/openapi/fileTypes/impl/AbstractFileType", "writeTable"));
        }
        Element highlightingElement = new Element(ELEMENT_HIGHLIGHTING);
        Element optionsElement = new Element(ELEMENT_OPTIONS);
        Element lineComment = new Element(ELEMENT_OPTION);
        lineComment.setAttribute(ATTRIBUTE_NAME, VALUE_LINE_COMMENT);
        lineComment.setAttribute(ATTRIBUTE_VALUE, table2.getLineComment());
        optionsElement.addContent(lineComment);
        String commentStart = table2.getStartComment();
        if (commentStart != null) {
            Element commentStartElement = new Element(ELEMENT_OPTION);
            commentStartElement.setAttribute(ATTRIBUTE_NAME, VALUE_COMMENT_START);
            commentStartElement.setAttribute(ATTRIBUTE_VALUE, commentStart);
            optionsElement.addContent(commentStartElement);
        }
        if ((endComment = table2.getEndComment()) != null) {
            Element commentEndElement = new Element(ELEMENT_OPTION);
            commentEndElement.setAttribute(ATTRIBUTE_NAME, VALUE_COMMENT_END);
            commentEndElement.setAttribute(ATTRIBUTE_VALUE, endComment);
            optionsElement.addContent(commentEndElement);
        }
        if ((prefix = table2.getHexPrefix()) != null) {
            Element hexPrefix = new Element(ELEMENT_OPTION);
            hexPrefix.setAttribute(ATTRIBUTE_NAME, VALUE_HEX_PREFIX);
            hexPrefix.setAttribute(ATTRIBUTE_VALUE, prefix);
            optionsElement.addContent(hexPrefix);
        }
        if ((chars = table2.getNumPostfixChars()) != null) {
            Element numPostfixes = new Element(ELEMENT_OPTION);
            numPostfixes.setAttribute(ATTRIBUTE_NAME, VALUE_NUM_POSTFIXES);
            numPostfixes.setAttribute(ATTRIBUTE_VALUE, chars);
            optionsElement.addContent(numPostfixes);
        }
        AbstractFileType.addElementOption(optionsElement, VALUE_HAS_BRACES, table2.isHasBraces());
        AbstractFileType.addElementOption(optionsElement, VALUE_HAS_BRACKETS, table2.isHasBrackets());
        AbstractFileType.addElementOption(optionsElement, VALUE_HAS_PARENS, table2.isHasParens());
        AbstractFileType.addElementOption(optionsElement, VALUE_HAS_STRING_ESCAPES, table2.isHasStringEscapes());
        AbstractFileType.addElementOption(optionsElement, VALUE_LINE_COMMENT_AT_START, table2.lineCommentOnlyAtStart);
        highlightingElement.addContent(optionsElement);
        AbstractFileType.writeKeywords(table2.getKeywords1(), ELEMENT_KEYWORDS, highlightingElement).setAttribute(ATTRIBUTE_IGNORE_CASE, String.valueOf(table2.isIgnoreCase()));
        AbstractFileType.writeKeywords(table2.getKeywords2(), ELEMENT_KEYWORDS2, highlightingElement);
        AbstractFileType.writeKeywords(table2.getKeywords3(), ELEMENT_KEYWORDS3, highlightingElement);
        AbstractFileType.writeKeywords(table2.getKeywords4(), ELEMENT_KEYWORDS4, highlightingElement);
        element.addContent(highlightingElement);
    }

    private static void addElementOption(Element optionsElement, String valueHasParens, boolean hasParens) {
        if (!hasParens) {
            return;
        }
        Element supportParens = new Element(ELEMENT_OPTION);
        supportParens.setAttribute(ATTRIBUTE_NAME, valueHasParens);
        supportParens.setAttribute(ATTRIBUTE_VALUE, String.valueOf(true));
        optionsElement.addContent(supportParens);
    }

    private static Element writeKeywords(Set<String> keywords, String tagName2, Element highlightingElement) {
        if (keywords.size() == 0 && !ELEMENT_KEYWORDS.equals(tagName2)) {
            return null;
        }
        Element keywordsElement = new Element(tagName2);
        Object[] strings = ArrayUtil.toStringArray(keywords);
        Arrays.sort(strings);
        StringBuilder keywordsAttribute = new StringBuilder();
        for (Object keyword : strings) {
            if (!((String)keyword).contains(SEMICOLON)) {
                if (keywordsAttribute.length() != 0) {
                    keywordsAttribute.append(SEMICOLON);
                }
                keywordsAttribute.append((String)keyword);
                continue;
            }
            Element e2 = new Element(ELEMENT_KEYWORD);
            e2.setAttribute(ATTRIBUTE_NAME, (String)keyword);
            keywordsElement.addContent(e2);
        }
        if (keywordsAttribute.length() != 0) {
            keywordsElement.setAttribute(ELEMENT_KEYWORDS, keywordsAttribute.toString());
        }
        highlightingElement.addContent(keywordsElement);
        return keywordsElement;
    }

    @Override
    public void markDefaultSettings() {
        this.myDefaultSyntaxTable = this.mySyntaxTable;
    }

    @Override
    public boolean isModified() {
        return !Comparing.equal((Object)this.myDefaultSyntaxTable, (Object)this.getSyntaxTable());
    }

    @NotNull
    public static List<Pair<FileNameMatcher, String>> readAssociations(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/fileTypes/impl/AbstractFileType", "readAssociations"));
        }
        List children2 = element.getChildren(ELEMENT_MAPPING);
        if (children2.isEmpty()) {
            List<Pair<FileNameMatcher, String>> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/AbstractFileType", "readAssociations"));
            }
            return list2;
        }
        SmartList result2 = new SmartList();
        for (Element mapping : children2) {
            String ext = mapping.getAttributeValue(ATTRIBUTE_EXT);
            String pattern = mapping.getAttributeValue(ATTRIBUTE_PATTERN);
            ExtensionFileNameMatcher matcher = ext != null ? new ExtensionFileNameMatcher(ext) : FileTypeManager.parseFromString((String)pattern);
            result2.add(Pair.create((Object)matcher, (Object)mapping.getAttributeValue(ATTRIBUTE_TYPE)));
        }
        SmartList smartList = result2;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/AbstractFileType", "readAssociations"));
        }
        return smartList;
    }

    @NotNull
    public static List<Trinity<FileNameMatcher, String, Boolean>> readRemovedAssociations(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/fileTypes/impl/AbstractFileType", "readRemovedAssociations"));
        }
        SmartList result2 = new SmartList();
        List children2 = element.getChildren(ELEMENT_REMOVED_MAPPING);
        if (children2.isEmpty()) {
            List<Trinity<FileNameMatcher, String, Boolean>> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/AbstractFileType", "readRemovedAssociations"));
            }
            return list2;
        }
        for (Element mapping : children2) {
            String ext = mapping.getAttributeValue(ATTRIBUTE_EXT);
            ExtensionFileNameMatcher matcher = ext == null ? FileTypeManager.parseFromString((String)mapping.getAttributeValue(ATTRIBUTE_PATTERN)) : new ExtensionFileNameMatcher(ext);
            result2.add(Trinity.create((Object)matcher, (Object)mapping.getAttributeValue(ATTRIBUTE_TYPE), (Object)Boolean.parseBoolean(mapping.getAttributeValue(ATTRIBUTE_APPROVED))));
        }
        SmartList smartList = result2;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/AbstractFileType", "readRemovedAssociations"));
        }
        return smartList;
    }

    @Nullable
    public static Element writeMapping(String typeName, @NotNull FileNameMatcher matcher, boolean specifyTypeName) {
        if (matcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matcher", "com/intellij/openapi/fileTypes/impl/AbstractFileType", "writeMapping"));
        }
        Element mapping = new Element(ELEMENT_MAPPING);
        if (matcher instanceof ExtensionFileNameMatcher) {
            mapping.setAttribute(ATTRIBUTE_EXT, ((ExtensionFileNameMatcher)matcher).getExtension());
        } else if (matcher instanceof WildcardFileNameMatcher) {
            mapping.setAttribute(ATTRIBUTE_PATTERN, ((WildcardFileNameMatcher)matcher).getPattern());
        } else if (matcher instanceof ExactFileNameMatcher) {
            mapping.setAttribute(ATTRIBUTE_PATTERN, ((ExactFileNameMatcher)matcher).getFileName());
        } else {
            return null;
        }
        if (specifyTypeName) {
            mapping.setAttribute(ATTRIBUTE_TYPE, typeName);
        }
        return mapping;
    }

    static Element writeRemovedMapping(FileType type, FileNameMatcher matcher, boolean specifyTypeName, boolean approved) {
        Element mapping = new Element(ELEMENT_REMOVED_MAPPING);
        if (matcher instanceof ExtensionFileNameMatcher) {
            mapping.setAttribute(ATTRIBUTE_EXT, ((ExtensionFileNameMatcher)matcher).getExtension());
            if (approved) {
                mapping.setAttribute(ATTRIBUTE_APPROVED, "true");
            }
        } else if (matcher instanceof WildcardFileNameMatcher) {
            mapping.setAttribute(ATTRIBUTE_PATTERN, ((WildcardFileNameMatcher)matcher).getPattern());
        } else if (matcher instanceof ExactFileNameMatcher) {
            mapping.setAttribute(ATTRIBUTE_PATTERN, ((ExactFileNameMatcher)matcher).getFileName());
        } else {
            return null;
        }
        if (specifyTypeName) {
            mapping.setAttribute(ATTRIBUTE_TYPE, type.getName());
        }
        return mapping;
    }

    public SettingsEditor<AbstractFileType> getEditor() {
        return new CustomFileTypeEditor();
    }

    public void setCommenter(Commenter commenter) {
        this.myCommenter = commenter;
    }
}

