/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.highlighter.custom.SyntaxTable;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ApplicationComponentAdapter;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.ExactFileNameMatcher;
import com.intellij.openapi.fileTypes.ExtensionFileNameMatcher;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeConsumer;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeFactory;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.fileTypes.UserBinaryFileType;
import com.intellij.openapi.fileTypes.UserFileType;
import com.intellij.openapi.fileTypes.ex.CustomFileTypeFactory;
import com.intellij.openapi.fileTypes.ex.ExternalizableFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeChooser;
import com.intellij.openapi.fileTypes.ex.FileTypeIdentifiableByVirtualFile;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.fileTypes.impl.AbstractFileType;
import com.intellij.openapi.fileTypes.impl.FileTypeAssocTable;
import com.intellij.openapi.fileTypes.impl.IgnoredFileCache;
import com.intellij.openapi.fileTypes.impl.IgnoredPatternSet;
import com.intellij.openapi.options.NonLazySchemeProcessor;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.options.SchemeState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.JDOMExternalizer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.ByteSequence;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.FileSystemInterface;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.impl.StubVirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.GuiUtils;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.JdomKt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformUtils;
import com.intellij.util.Processor;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import com.intellij.util.containers.ConcurrentPackedBitsArray;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.URLUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

@State(name="FileTypeManager", storages={@Storage(value="filetypes.xml")}, additionalExportFile="filetypes")
public class FileTypeManagerImpl
extends FileTypeManagerEx
implements PersistentStateComponent<Element>,
ApplicationComponentAdapter,
Disposable {
    private static final Logger LOG = Logger.getInstance(FileTypeManagerImpl.class);
    private static final int VERSION = 17;
    private static final ThreadLocal<Pair<VirtualFile, FileType>> FILE_TYPE_FIXED_TEMPORARILY = new ThreadLocal();
    static final Key<FileType> DETECTED_FROM_CONTENT_FILE_TYPE_KEY = Key.create((String)"DETECTED_FROM_CONTENT_FILE_TYPE_KEY");
    private static final int DETECT_BUFFER_SIZE = 8192;
    private static final String DEFAULT_IGNORED = "*.hprof;*.pyc;*.pyo;*.rbc;*.yarb;*~;.DS_Store;.git;.hg;.svn;CVS;__pycache__;_svn;vssver.scc;vssver2.scc;";
    private static boolean RE_DETECT_ASYNC;
    private final Set<FileType> myDefaultTypes = new THashSet();
    private FileTypeIdentifiableByVirtualFile[] mySpecialFileTypes = FileTypeIdentifiableByVirtualFile.EMPTY_ARRAY;
    private FileTypeAssocTable<FileType> myPatternsTable = new FileTypeAssocTable();
    private final IgnoredPatternSet myIgnoredPatterns = new IgnoredPatternSet();
    private final IgnoredFileCache myIgnoredFileCache = new IgnoredFileCache(this.myIgnoredPatterns);
    private final FileTypeAssocTable<FileType> myInitialAssociations = new FileTypeAssocTable();
    private final Map<FileNameMatcher, String> myUnresolvedMappings = new THashMap();
    private final Map<FileNameMatcher, Trinity<String, String, Boolean>> myUnresolvedRemovedMappings = new THashMap();
    private final Map<FileNameMatcher, Pair<FileType, Boolean>> myRemovedMappings = new THashMap();
    @NonNls
    private static final String ELEMENT_FILETYPE = "filetype";
    @NonNls
    private static final String ELEMENT_IGNORE_FILES = "ignoreFiles";
    @NonNls
    private static final String ATTRIBUTE_LIST = "list";
    @NonNls
    private static final String ATTRIBUTE_VERSION = "version";
    @NonNls
    private static final String ATTRIBUTE_NAME = "name";
    @NonNls
    private static final String ATTRIBUTE_DESCRIPTION = "description";
    private final MessageBus myMessageBus;
    private final Map<String, StandardFileType> myStandardFileTypes = new LinkedHashMap<String, StandardFileType>();
    @NonNls
    private static final String[] FILE_TYPES_WITH_PREDEFINED_EXTENSIONS;
    private final SchemeManager<FileType> mySchemeManager;
    @NonNls
    static final String FILE_SPEC = "filetypes";
    private static final byte AUTO_DETECTED_AS_TEXT_MASK = 1;
    private static final byte AUTO_DETECTED_AS_BINARY_MASK = 2;
    private static final byte AUTO_DETECT_WAS_RUN_MASK = 4;
    private static final byte ATTRIBUTES_WERE_LOADED_MASK = 8;
    private final ConcurrentPackedBitsArray packedFlags = new ConcurrentPackedBitsArray(4);
    private final AtomicInteger counterAutoDetect = new AtomicInteger();
    private final AtomicLong elapsedAutoDetect = new AtomicLong();
    boolean toLog;
    private final BoundedTaskExecutor reDetectExecutor = new BoundedTaskExecutor("FileTypeManager redetect pool", (Executor)PooledThreadExecutor.INSTANCE, 1, (Disposable)this);
    private final BlockingQueue<VirtualFile> filesToRedetect = new LinkedBlockingDeque<VirtualFile>();
    private volatile FileAttribute autoDetectedAttribute;
    private static final Key<Boolean> IO_EXCEPTION_HAPPENED;
    private final AtomicInteger fileTypeChangedCount;
    private final Map<FileTypeListener, MessageBusConnection> myAdapters = new HashMap<FileTypeListener, MessageBusConnection>();

    public FileTypeManagerImpl(MessageBus bus, SchemeManagerFactory schemeManagerFactory, PropertiesComponent propertiesComponent) {
        int fileTypeChangedCounter = StringUtilRt.parseInt((String)propertiesComponent.getValue("fileTypeChangedCounter"), (int)0);
        this.fileTypeChangedCount = new AtomicInteger(fileTypeChangedCounter);
        this.autoDetectedAttribute = new FileAttribute("AUTO_DETECTION_CACHE_ATTRIBUTE", fileTypeChangedCounter, true);
        this.myMessageBus = bus;
        this.mySchemeManager = schemeManagerFactory.create(FILE_SPEC, new NonLazySchemeProcessor<FileType, AbstractFileType>(){

            @Override
            @NotNull
            public AbstractFileType readScheme(@NotNull Element element, boolean duringLoad) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$1", "readScheme"));
                }
                if (!duringLoad) {
                    FileTypeManagerImpl.this.fireBeforeFileTypesChanged();
                }
                AbstractFileType type = (AbstractFileType)FileTypeManagerImpl.this.loadFileType(element, false);
                if (!duringLoad) {
                    FileTypeManagerImpl.this.fireFileTypesChanged();
                }
                AbstractFileType abstractFileType = type;
                if (abstractFileType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$1", "readScheme"));
                }
                return abstractFileType;
            }

            @Override
            @NotNull
            public SchemeState getState(@NotNull FileType fileType) {
                if (fileType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$1", "getState"));
                }
                if (!(fileType instanceof AbstractFileType) || !FileTypeManagerImpl.shouldSave(fileType)) {
                    SchemeState schemeState = SchemeState.NON_PERSISTENT;
                    if (schemeState == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$1", "getState"));
                    }
                    return schemeState;
                }
                if (!FileTypeManagerImpl.this.myDefaultTypes.contains(fileType)) {
                    SchemeState schemeState = SchemeState.POSSIBLY_CHANGED;
                    if (schemeState == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$1", "getState"));
                    }
                    return schemeState;
                }
                SchemeState schemeState = ((AbstractFileType)fileType).isModified() ? SchemeState.POSSIBLY_CHANGED : SchemeState.NON_PERSISTENT;
                if (schemeState == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$1", "getState"));
                }
                return schemeState;
            }

            @NotNull
            public Element writeScheme(@NotNull AbstractFileType fileType) {
                if (fileType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$1", "writeScheme"));
                }
                Element root = new Element(FileTypeManagerImpl.ELEMENT_FILETYPE);
                root.setAttribute("binary", String.valueOf(fileType.isBinary()));
                if (!StringUtil.isEmpty((String)fileType.getDefaultExtension())) {
                    root.setAttribute("default_extension", fileType.getDefaultExtension());
                }
                root.setAttribute(FileTypeManagerImpl.ATTRIBUTE_DESCRIPTION, fileType.getDescription());
                root.setAttribute(FileTypeManagerImpl.ATTRIBUTE_NAME, fileType.getName());
                fileType.writeExternal(root);
                Element map2 = new Element("extensionMap");
                FileTypeManagerImpl.this.writeExtensionsMap(map2, fileType, false);
                if (!map2.getChildren().isEmpty()) {
                    root.addContent(map2);
                }
                Element element = root;
                if (element == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$1", "writeScheme"));
                }
                return element;
            }

            @Override
            public void onSchemeDeleted(@NotNull AbstractFileType scheme2) {
                if (scheme2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$1", "onSchemeDeleted"));
                }
                GuiUtils.invokeLaterIfNeeded(() -> {
                    if (scheme2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$1", "lambda$onSchemeDeleted$2"));
                    }
                    Application app = ApplicationManager.getApplication();
                    app.runWriteAction(() -> FileTypeManagerImpl.this.fireBeforeFileTypesChanged());
                    FileTypeManagerImpl.this.myPatternsTable.removeAllAssociations(scheme2);
                    app.runWriteAction(() -> FileTypeManagerImpl.this.fireFileTypesChanged());
                }, (ModalityState)ModalityState.NON_MODAL);
            }
        });
        bus.connect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener.Adapter(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$2", "after"));
                }
                Set files2 = ContainerUtil.map2Set(events, event -> {
                    VirtualFile filtered;
                    VirtualFile file2 = event instanceof VFileCreateEvent ? null : event.getFile();
                    VirtualFile virtualFile = filtered = file2 != null && FileTypeManagerImpl.this.wasAutoDetectedBefore(file2) && FileTypeManagerImpl.isDetectable(file2) ? file2 : null;
                    if (FileTypeManagerImpl.this.toLog()) {
                        FileTypeManagerImpl.log("F: after() VFS event " + event + "; filtered file: " + filtered + " (file: " + file2 + "; wasAutoDetectedBefore(file): " + (file2 == null ? null : Boolean.valueOf(FileTypeManagerImpl.this.wasAutoDetectedBefore(file2))) + "; isDetectable(file): " + (file2 == null ? null : Boolean.valueOf(FileTypeManagerImpl.isDetectable(file2))) + "; file.getLength(): " + (file2 == null ? null : Long.valueOf(file2.getLength())) + "; file.isValid(): " + (file2 == null ? null : Boolean.valueOf(file2.isValid())) + "; file.is(VFileProperty.SPECIAL): " + (file2 == null ? null : Boolean.valueOf(file2.is(VFileProperty.SPECIAL))) + "; packedFlags.get(id): " + (file2 instanceof VirtualFileWithId ? FileTypeManagerImpl.readableFlags(FileTypeManagerImpl.this.packedFlags.get(((VirtualFileWithId)file2).getId())) : null) + "; file.getFileSystem():" + (file2 == null ? null : file2.getFileSystem()) + ")");
                    }
                    return filtered;
                });
                files2.remove(null);
                if (FileTypeManagerImpl.this.toLog()) {
                    FileTypeManagerImpl.log("F: after() VFS events: " + events + "; files: " + files2);
                }
                if (!files2.isEmpty() && RE_DETECT_ASYNC) {
                    if (FileTypeManagerImpl.this.toLog()) {
                        FileTypeManagerImpl.log("F: after() queued to redetect: " + files2);
                    }
                    if (FileTypeManagerImpl.this.filesToRedetect.addAll(files2)) {
                        FileTypeManagerImpl.this.awakeReDetectExecutor();
                    }
                }
            }
        });
        this.myIgnoredPatterns.setIgnoreMasks(DEFAULT_IGNORED);
        this.initStandardFileTypes();
    }

    @VisibleForTesting
    void initStandardFileTypes() {
        block10: {
            FileTypeConsumer consumer2 = new FileTypeConsumer(){

                public void consume(@NotNull FileType fileType) {
                    if (fileType == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$3", "consume"));
                    }
                    this.register(fileType, FileTypeManagerImpl.parse(fileType.getDefaultExtension()));
                }

                public void consume(@NotNull FileType fileType, String extensions) {
                    if (fileType == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$3", "consume"));
                    }
                    this.register(fileType, FileTypeManagerImpl.parse(extensions));
                }

                public void consume(@NotNull FileType fileType, FileNameMatcher ... matchers2) {
                    if (fileType == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$3", "consume"));
                    }
                    if (matchers2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matchers", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$3", "consume"));
                    }
                    this.register(fileType, new ArrayList<FileNameMatcher>(Arrays.asList(matchers2)));
                }

                public FileType getStandardFileTypeByName(@NotNull String name) {
                    if (name == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", FileTypeManagerImpl.ATTRIBUTE_NAME, "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$3", "getStandardFileTypeByName"));
                    }
                    StandardFileType type = (StandardFileType)FileTypeManagerImpl.this.myStandardFileTypes.get(name);
                    return type != null ? type.fileType : null;
                }

                private void register(@NotNull FileType fileType, @NotNull List<FileNameMatcher> fileNameMatchers) {
                    if (fileType == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$3", "register"));
                    }
                    if (fileNameMatchers == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileNameMatchers", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$3", "register"));
                    }
                    StandardFileType type = (StandardFileType)FileTypeManagerImpl.this.myStandardFileTypes.get(fileType.getName());
                    if (type != null) {
                        type.matchers.addAll(fileNameMatchers);
                    } else {
                        FileTypeManagerImpl.this.myStandardFileTypes.put(fileType.getName(), new StandardFileType(fileType, fileNameMatchers));
                    }
                }
            };
            for (FileTypeFactory factory2 : (FileTypeFactory[])FileTypeFactory.FILE_TYPE_FACTORY_EP.getExtensions()) {
                try {
                    factory2.createFileTypes(consumer2);
                }
                catch (Throwable e2) {
                    PluginManager.handleComponentError(e2, factory2.getClass().getName(), null);
                }
            }
            for (StandardFileType pair : this.myStandardFileTypes.values()) {
                this.registerFileTypeWithoutNotification(pair.fileType, pair.matchers, true);
            }
            if (PlatformUtils.isDatabaseIDE() || PlatformUtils.isCidr()) {
                return;
            }
            try {
                URL defaultFileTypesUrl = FileTypeManagerImpl.class.getResource("/defaultFileTypes.xml");
                if (defaultFileTypesUrl == null) break block10;
                Element defaultFileTypesElement = JdomKt.loadElement((InputStream)URLUtil.openStream((URL)defaultFileTypesUrl));
                for (Element e3 : defaultFileTypesElement.getChildren()) {
                    if (FILE_SPEC.equals(e3.getName())) {
                        for (Element element : e3.getChildren(ELEMENT_FILETYPE)) {
                            this.loadFileType(element, true);
                        }
                        continue;
                    }
                    if (!"extensionMap".equals(e3.getName())) continue;
                    this.readGlobalMappings(e3);
                }
            }
            catch (Exception e4) {
                LOG.error((Throwable)e4);
            }
        }
    }

    private boolean toLog() {
        return this.toLog;
    }

    private static void log(String message2) {
        LOG.debug(message2 + " - " + Thread.currentThread());
    }

    private void awakeReDetectExecutor() {
        this.reDetectExecutor.submit(new Runnable(){
            private static final int CHUNK = 10;

            @Override
            public void run() {
                ArrayList files2 = new ArrayList();
                int drained = FileTypeManagerImpl.this.filesToRedetect.drainTo(files2, 10);
                FileTypeManagerImpl.this.reDetect(files2);
                if (drained == 10) {
                    FileTypeManagerImpl.this.awakeReDetectExecutor();
                }
            }
        });
    }

    public void drainReDetectQueue() {
        try {
            this.reDetectExecutor.waitAllTasksExecuted(1L, TimeUnit.MINUTES);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    @NotNull
    Collection<VirtualFile> dumpReDetectQueue() {
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>(this.filesToRedetect);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "dumpReDetectQueue"));
        }
        return arrayList;
    }

    static void reDetectAsync(boolean enable) {
        RE_DETECT_ASYNC = enable;
    }

    private void reDetect(@NotNull Collection<VirtualFile> files2) {
        if (files2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "reDetect"));
        }
        ArrayList<VirtualFile> changed = new ArrayList<VirtualFile>();
        ArrayList<VirtualFile> crashed = new ArrayList<VirtualFile>();
        for (VirtualFile file2 : files2) {
            FileType after2;
            FileType before;
            block10: {
                boolean shouldRedetect;
                boolean bl = shouldRedetect = this.wasAutoDetectedBefore(file2) && FileTypeManagerImpl.isDetectable(file2);
                if (this.toLog()) {
                    FileTypeManagerImpl.log("F: reDetect(" + file2.getName() + ") " + file2.getName() + "; shouldRedetect: " + shouldRedetect);
                }
                if (!shouldRedetect) continue;
                int id = ((VirtualFileWithId)file2).getId();
                long flags = this.packedFlags.get(id);
                before = (FileType)ObjectUtils.notNull((Object)FileTypeManagerImpl.textOrBinaryFromCachedFlags(flags), (Object)ObjectUtils.notNull((Object)file2.getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY), (Object)((Object)PlainTextFileType.INSTANCE)));
                after2 = this.getOrDetectByFile(file2);
                if (this.toLog()) {
                    FileTypeManagerImpl.log("F: reDetect(" + file2.getName() + ") prepare to redetect. flags: " + FileTypeManagerImpl.readableFlags(flags) + "; beforeType: " + before.getName() + "; afterByFileType: " + (after2 == null ? null : after2.getName()));
                }
                if (after2 == null) {
                    try {
                        after2 = this.detectFromContentAndCache(file2);
                        break block10;
                    }
                    catch (IOException e2) {
                        crashed.add(file2);
                        if (!this.toLog()) continue;
                        FileTypeManagerImpl.log("F: reDetect(" + file2.getName() + ") before: " + before.getName() + "; after: crashed with " + e2.getMessage() + "; now getFileType()=" + file2.getFileType().getName() + "; getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY): " + file2.getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY));
                        continue;
                    }
                }
                file2.putUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY, null);
                flags = 0L;
                this.packedFlags.set(id, flags);
            }
            if (this.toLog()) {
                FileTypeManagerImpl.log("F: reDetect(" + file2.getName() + ") before: " + before.getName() + "; after: " + after2.getName() + "; now getFileType()=" + file2.getFileType().getName() + "; getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY): " + file2.getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY));
            }
            if (before == after2) continue;
            changed.add(file2);
        }
        if (!changed.isEmpty()) {
            FileTypeManagerImpl.reparseLater(changed);
        }
        if (!crashed.isEmpty()) {
            AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> FileTypeManagerImpl.reparseLater(crashed), 10L, TimeUnit.SECONDS);
        }
    }

    private static void reparseLater(@NotNull List<VirtualFile> changed) {
        if (changed == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changed", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "reparseLater"));
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (changed == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changed", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "lambda$reparseLater$1"));
            }
            FileContentUtilCore.reparseFiles((Collection)changed);
        }, ApplicationManager.getApplication().getDisposed());
    }

    private boolean wasAutoDetectedBefore(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "wasAutoDetectedBefore"));
        }
        if (file2.getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY) != null) {
            return true;
        }
        if (file2 instanceof VirtualFileWithId) {
            int id = Math.abs(((VirtualFileWithId)file2).getId());
            return (this.packedFlags.get(id) & 6L) == 4L;
        }
        return false;
    }

    @NotNull
    public FileType getStdFileType(@NotNull @NonNls String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ATTRIBUTE_NAME, "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getStdFileType"));
        }
        StandardFileType stdFileType = this.myStandardFileTypes.get(name);
        PlainTextFileType plainTextFileType = stdFileType != null ? stdFileType.fileType : PlainTextFileType.INSTANCE;
        if (plainTextFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getStdFileType"));
        }
        return plainTextFileType;
    }

    public void initComponent() {
        if (!this.myUnresolvedMappings.isEmpty()) {
            for (StandardFileType pair : this.myStandardFileTypes.values()) {
                this.registerReDetectedMappings(pair);
            }
        }
        for (StandardFileType pair : this.myStandardFileTypes.values()) {
            this.bindUnresolvedMappings(pair.fileType);
        }
        boolean isAtLeastOneStandardFileTypeHasBeenRead = false;
        for (FileType fileType : this.mySchemeManager.loadSchemes()) {
            isAtLeastOneStandardFileTypeHasBeenRead |= this.myInitialAssociations.hasAssociationsFor(fileType);
        }
        if (isAtLeastOneStandardFileTypeHasBeenRead) {
            this.restoreStandardFileExtensions();
        }
    }

    @NotNull
    public FileType getFileTypeByFileName(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getFileTypeByFileName"));
        }
        FileType fileType = this.getFileTypeByFileName((CharSequence)fileName);
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getFileTypeByFileName"));
        }
        return fileType;
    }

    @NotNull
    private FileType getFileTypeByFileName(@NotNull CharSequence fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getFileTypeByFileName"));
        }
        FileType type = this.myPatternsTable.findAssociatedFileType(fileName);
        FileType fileType = (FileType)ObjectUtils.notNull((Object)type, (Object)UnknownFileType.INSTANCE);
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getFileTypeByFileName"));
        }
        return fileType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freezeFileTypeTemporarilyIn(@NotNull VirtualFile file2, @NotNull Runnable runnable2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "freezeFileTypeTemporarilyIn"));
        }
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "freezeFileTypeTemporarilyIn"));
        }
        FileType fileType = file2.getFileType();
        Pair<VirtualFile, FileType> old = FILE_TYPE_FIXED_TEMPORARILY.get();
        FILE_TYPE_FIXED_TEMPORARILY.set((Pair<VirtualFile, FileType>)Pair.create((Object)file2, (Object)fileType));
        if (this.toLog()) {
            FileTypeManagerImpl.log("F: freezeFileTypeTemporarilyIn(" + file2.getName() + ") to " + fileType.getName() + " in " + Thread.currentThread());
        }
        try {
            runnable2.run();
        }
        finally {
            if (old == null) {
                FILE_TYPE_FIXED_TEMPORARILY.remove();
            } else {
                FILE_TYPE_FIXED_TEMPORARILY.set(old);
            }
            if (this.toLog()) {
                FileTypeManagerImpl.log("F: unfreezeFileType(" + file2.getName() + ") in " + Thread.currentThread());
            }
        }
    }

    @NotNull
    public FileType getFileTypeByFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getFileTypeByFile"));
        }
        FileType fileType = this.getOrDetectByFile(file2);
        if (fileType == null) {
            fileType = file2 instanceof StubVirtualFile ? UnknownFileType.INSTANCE : this.getOrDetectFromContent(file2);
        }
        FileType fileType2 = fileType;
        if (fileType2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getFileTypeByFile"));
        }
        return fileType2;
    }

    @Nullable
    private FileType getOrDetectByFile(@NotNull VirtualFile file2) {
        FileType fileType;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getOrDetectByFile"));
        }
        Pair<VirtualFile, FileType> fixedType = FILE_TYPE_FIXED_TEMPORARILY.get();
        if (fixedType != null && ((VirtualFile)fixedType.getFirst()).equals(file2)) {
            FileType fileType2 = (FileType)fixedType.getSecond();
            if (this.toLog()) {
                FileTypeManagerImpl.log("F: getOrDetectByFile(" + file2.getName() + ") was frozen to " + fileType2.getName() + " in " + Thread.currentThread());
            }
            return fileType2;
        }
        if (file2 instanceof LightVirtualFile && (fileType = ((LightVirtualFile)file2).getAssignedFileType()) != null) {
            return fileType;
        }
        for (FileType type : this.mySpecialFileTypes) {
            if (!type.isMyFileType(file2)) continue;
            if (this.toLog()) {
                FileTypeManagerImpl.log("F: getOrDetectByFile(" + file2.getName() + "): Special file type: " + type.getName());
            }
            return type;
        }
        fileType = this.getFileTypeByFileName(file2.getNameSequence());
        if (fileType == UnknownFileType.INSTANCE) {
            fileType = null;
        }
        if (this.toLog()) {
            FileTypeManagerImpl.log("F: getOrDetectByFile(" + file2.getName() + ") By name file type: " + (fileType == null ? null : fileType.getName()));
        }
        return fileType;
    }

    @NotNull
    private FileType getOrDetectFromContent(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getOrDetectFromContent"));
        }
        if (!FileTypeManagerImpl.isDetectable(file2)) {
            FileType fileType = UnknownFileType.INSTANCE;
            if (fileType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getOrDetectFromContent"));
            }
            return fileType;
        }
        if (file2 instanceof VirtualFileWithId) {
            boolean autoDetectWasRun;
            int id = ((VirtualFileWithId)file2).getId();
            if (id < 0) {
                FileType fileType = UnknownFileType.INSTANCE;
                if (fileType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getOrDetectFromContent"));
                }
                return fileType;
            }
            long flags = this.packedFlags.get(id);
            if (!BitUtil.isSet((long)flags, (long)8L)) {
                flags = this.readFlagsFromCache(file2);
                flags = BitUtil.set((long)flags, (long)8L, (boolean)true);
                this.packedFlags.set(id, flags);
                if (this.toLog()) {
                    FileTypeManagerImpl.log("F: getOrDetectFromContent(" + file2.getName() + "): readFlagsFromCache() = " + FileTypeManagerImpl.readableFlags(flags));
                }
            }
            if (autoDetectWasRun = BitUtil.isSet((long)flags, (long)4L)) {
                FileType type = FileTypeManagerImpl.textOrBinaryFromCachedFlags(flags);
                if (this.toLog()) {
                    FileTypeManagerImpl.log("F: getOrDetectFromContent(" + file2.getName() + "): cached type = " + (type == null ? null : type.getName()) + "; packedFlags.get(id):" + FileTypeManagerImpl.readableFlags(flags) + "; getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY): " + file2.getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY));
                }
                if (type != null) {
                    FileType fileType = type;
                    if (fileType == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getOrDetectFromContent"));
                    }
                    return fileType;
                }
            }
        }
        FileType fileType = (FileType)file2.getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY);
        if (this.toLog()) {
            FileTypeManagerImpl.log("F: getOrDetectFromContent(" + file2.getName() + "): getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY) = " + (fileType == null ? null : fileType.getName()));
        }
        if (fileType == null) {
            try {
                fileType = this.detectFromContentAndCache(file2);
            }
            catch (IOException e2) {
                fileType = UnknownFileType.INSTANCE;
            }
        }
        if (this.toLog()) {
            FileTypeManagerImpl.log("F: getOrDetectFromContent(" + file2.getName() + "): getFileType after detect run = " + fileType.getName());
        }
        FileType fileType2 = fileType;
        if (fileType2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getOrDetectFromContent"));
        }
        return fileType2;
    }

    private static String readableFlags(long flags) {
        String result2 = "";
        if (BitUtil.isSet((long)flags, (long)8L)) {
            result2 = result2 + (result2.isEmpty() ? "" : " | ") + "ATTRIBUTES_WERE_LOADED_MASK";
        }
        if (BitUtil.isSet((long)flags, (long)4L)) {
            result2 = result2 + (result2.isEmpty() ? "" : " | ") + "AUTO_DETECT_WAS_RUN_MASK";
        }
        if (BitUtil.isSet((long)flags, (long)2L)) {
            result2 = result2 + (result2.isEmpty() ? "" : " | ") + "AUTO_DETECTED_AS_BINARY_MASK";
        }
        if (BitUtil.isSet((long)flags, (long)1L)) {
            result2 = result2 + (result2.isEmpty() ? "" : " | ") + "AUTO_DETECTED_AS_TEXT_MASK";
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte readFlagsFromCache(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "readFlagsFromCache"));
        }
        DataInputStream stream = this.autoDetectedAttribute.readAttribute(file2);
        boolean wasAutoDetectRun = false;
        byte status = 0;
        try {
            try {
                status = stream == null ? (byte)0 : stream.readByte();
                wasAutoDetectRun = stream != null;
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        status = BitUtil.set((byte)status, (byte)4, (boolean)wasAutoDetectRun);
        return (byte)(status & 7);
    }

    protected void writeFlagsToCache(@NotNull VirtualFile file2, int flags) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "writeFlagsToCache"));
        }
        try (DataOutputStream stream = this.autoDetectedAttribute.writeAttribute(file2);){
            stream.writeByte(flags & 3);
        }
        catch (IOException e2) {
            LOG.error((Throwable)e2);
        }
    }

    void clearCaches() {
        this.packedFlags.clear();
        if (this.toLog()) {
            FileTypeManagerImpl.log("F: clearCaches()");
        }
    }

    private void clearPersistentAttributes() {
        int count = this.fileTypeChangedCount.incrementAndGet();
        this.autoDetectedAttribute = this.autoDetectedAttribute.newVersion(count);
        PropertiesComponent.getInstance().setValue("fileTypeChangedCounter", Integer.toString(count));
        if (this.toLog()) {
            FileTypeManagerImpl.log("F: clearPersistentAttributes()");
        }
    }

    @Nullable
    private static FileType textOrBinaryFromCachedFlags(long flags) {
        return BitUtil.isSet((long)flags, (long)1L) ? PlainTextFileType.INSTANCE : (BitUtil.isSet((long)flags, (long)2L) ? UnknownFileType.INSTANCE : null);
    }

    @Deprecated
    @NotNull
    public FileType detectFileTypeFromContent(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "detectFileTypeFromContent"));
        }
        FileType fileType = file2.getFileType();
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "detectFileTypeFromContent"));
        }
        return fileType;
    }

    private void cacheAutoDetectedFileType(@NotNull VirtualFile file2, @NotNull FileType fileType) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "cacheAutoDetectedFileType"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "cacheAutoDetectedFileType"));
        }
        boolean wasAutodetectedAsText = fileType == PlainTextFileType.INSTANCE;
        boolean wasAutodetectedAsBinary = fileType == UnknownFileType.INSTANCE;
        int flags = BitUtil.set((int)0, (int)1, (boolean)wasAutodetectedAsText);
        flags = BitUtil.set((int)flags, (int)2, (boolean)wasAutodetectedAsBinary);
        this.writeFlagsToCache(file2, flags);
        if (file2 instanceof VirtualFileWithId) {
            int id = Math.abs(((VirtualFileWithId)file2).getId());
            flags = BitUtil.set((int)flags, (int)4, (boolean)true);
            flags = BitUtil.set((int)flags, (int)8, (boolean)true);
            this.packedFlags.set(id, (long)flags);
            if (wasAutodetectedAsText || wasAutodetectedAsBinary) {
                file2.putUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY, null);
                if (this.toLog()) {
                    FileTypeManagerImpl.log("F: cacheAutoDetectedFileType(" + file2.getName() + ") cached to " + fileType.getName() + " flags = " + FileTypeManagerImpl.readableFlags(flags) + "; getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY): " + file2.getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY));
                }
                return;
            }
        }
        file2.putUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY, (Object)fileType);
        if (this.toLog()) {
            FileTypeManagerImpl.log("F: cacheAutoDetectedFileType(" + file2.getName() + ") cached to " + fileType.getName() + " flags = " + FileTypeManagerImpl.readableFlags(flags) + "; getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY): " + file2.getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY));
        }
    }

    public FileType findFileTypeByName(@NotNull String fileTypeName) {
        if (fileTypeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileTypeName", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "findFileTypeByName"));
        }
        FileType type = this.getStdFileType(fileTypeName);
        if (type == PlainTextFileType.INSTANCE && !fileTypeName.equals(type.getName())) {
            for (FileType fileType : this.mySchemeManager.getAllSchemes()) {
                if (!fileTypeName.equals(fileType.getName())) continue;
                return fileType;
            }
        }
        return type;
    }

    private static boolean isDetectable(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "isDetectable"));
        }
        if (file2.isDirectory() || !file2.isValid() || file2.is(VFileProperty.SPECIAL) || file2.getLength() == 0L) {
            return false;
        }
        return file2.getFileSystem() instanceof FileSystemInterface;
    }

    private boolean processFirstBytes(@NotNull InputStream stream, int length, @NotNull Processor<ByteSequence> processor2) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "processFirstBytes"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "processFirstBytes"));
        }
        byte[] bytes = FileUtilRt.getThreadLocalBuffer();
        assert (bytes.length >= length) : "Cannot process more than " + bytes.length + " in one call, requested:" + length;
        int n2 = stream.read(bytes, 0, length);
        if (n2 <= 0) {
            if (this.toLog()) {
                FileTypeManagerImpl.log("F: processFirstBytes(): inputStream.read() returned " + n2 + "; retrying with read action. stream=" + FileTypeManagerImpl.streamInfo(stream));
            }
            n2 = (Integer)ApplicationManager.getApplication().runReadAction(() -> {
                if (stream == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "lambda$processFirstBytes$2"));
                }
                return stream.read(bytes, 0, length);
            });
            if (this.toLog()) {
                FileTypeManagerImpl.log("F: processFirstBytes(): under read action inputStream.read() returned " + n2 + "; stream=" + FileTypeManagerImpl.streamInfo(stream));
            }
            if (n2 <= 0) {
                return false;
            }
        }
        return processor2.process((Object)new ByteSequence(bytes, 0, n2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private FileType detectFromContentAndCache(@NotNull VirtualFile file2) throws IOException {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "detectFromContentAndCache"));
        }
        long start2 = System.currentTimeMillis();
        Ref result2 = new Ref((Object)UnknownFileType.INSTANCE);
        boolean r2 = false;
        InputStream inputStream = ((FileSystemInterface)file2.getFileSystem()).getInputStream(file2);
        try {
            if (this.toLog()) {
                FileTypeManagerImpl.log("F: detectFromContentAndCache(" + file2.getName() + "): inputStream=" + FileTypeManagerImpl.streamInfo(inputStream));
            }
            file2.putUserData(IO_EXCEPTION_HAPPENED, null);
            r2 = this.processFirstBytes(inputStream, 8192, (Processor<ByteSequence>)((Processor)byteSequence -> {
                CharSequence text2;
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "lambda$detectFromContentAndCache$3"));
                }
                boolean isText = FileTypeManagerImpl.guessIfText(file2, byteSequence);
                if (isText) {
                    byte[] bytes = Arrays.copyOf(byteSequence.getBytes(), byteSequence.getLength());
                    CharSequence text3 = LoadTextUtil.getTextByBinaryPresentation(bytes, file2, true, true, UnknownFileType.INSTANCE);
                } else {
                    text2 = null;
                }
                Object[] detectors = (FileTypeRegistry.FileTypeDetector[])Extensions.getExtensions((ExtensionPointName)FileTypeRegistry.FileTypeDetector.EP_NAME);
                if (this.toLog()) {
                    FileTypeManagerImpl.log("F: detectFromContentAndCache.processFirstBytes(" + file2.getName() + "): byteSequence.length=" + byteSequence.getLength() + "; isText=" + isText + "; text='" + (text2 == null ? null : StringUtil.first(text2, (int)100, (boolean)true)) + "', detectors=" + Arrays.toString(detectors));
                }
                PlainTextFileType detected = null;
                for (FileTypeRegistry.FileTypeDetector fileTypeDetector : detectors) {
                    try {
                        detected = fileTypeDetector.detect(file2, byteSequence, text2);
                    }
                    catch (Exception e2) {
                        LOG.error("Detector " + fileTypeDetector + " (" + fileTypeDetector.getClass() + ") exception occurred:", (Throwable)e2);
                    }
                    if (detected == null) continue;
                    if (!this.toLog()) break;
                    FileTypeManagerImpl.log("F: detectFromContentAndCache.processFirstBytes(" + file2.getName() + "): detector " + fileTypeDetector + " type as " + detected.getName());
                    break;
                }
                if (detected == null) {
                    PlainTextFileType plainTextFileType = detected = isText ? PlainTextFileType.INSTANCE : UnknownFileType.INSTANCE;
                    if (this.toLog()) {
                        FileTypeManagerImpl.log("F: detectFromContentAndCache.processFirstBytes(" + file2.getName() + "): no detector was able to detect. assigned " + detected.getName());
                    }
                }
                result2.set(detected);
                return true;
            }));
        }
        finally {
            block33: {
                try {
                    if (!this.toLog()) break block33;
                    try (InputStream newStream = ((FileSystemInterface)file2.getFileSystem()).getInputStream(file2);){
                        byte[] buffer = new byte[50];
                        int n2 = newStream.read(buffer, 0, buffer.length);
                        FileTypeManagerImpl.log("F: detectFromContentAndCache(" + file2.getName() + "): result: " + ((FileType)result2.get()).getName() + "; processor ret: " + r2 + "; stream: " + FileTypeManagerImpl.streamInfo(inputStream) + "; newStream: " + FileTypeManagerImpl.streamInfo(newStream) + "; read: " + n2 + "; buffer: " + Arrays.toString(buffer));
                    }
                }
                finally {
                    inputStream.close();
                }
            }
        }
        FileType fileType = (FileType)result2.get();
        if (LOG.isDebugEnabled()) {
            LOG.debug(file2 + "; type=" + fileType.getDescription() + "; " + this.counterAutoDetect);
        }
        this.cacheAutoDetectedFileType(file2, fileType);
        this.counterAutoDetect.incrementAndGet();
        long elapsed = System.currentTimeMillis() - start2;
        this.elapsedAutoDetect.addAndGet(elapsed);
        FileType fileType2 = fileType;
        if (fileType2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "detectFromContentAndCache"));
        }
        return fileType2;
    }

    private static Object streamInfo(InputStream stream) throws IOException {
        if (stream instanceof BufferedInputStream) {
            InputStream in = (InputStream)ReflectionUtil.getField(stream.getClass(), (Object)stream, InputStream.class, (String)"in");
            byte[] buf = (byte[])ReflectionUtil.getField(stream.getClass(), (Object)stream, byte[].class, (String)"buf");
            int count = (Integer)ReflectionUtil.getField(stream.getClass(), (Object)stream, Integer.TYPE, (String)"count");
            int pos = (Integer)ReflectionUtil.getField(stream.getClass(), (Object)stream, Integer.TYPE, (String)"pos");
            return "BufferedInputStream(buf=" + (buf == null ? null : Arrays.toString(Arrays.copyOf(buf, count))) + ", count=" + count + ", pos=" + pos + ", in=" + FileTypeManagerImpl.streamInfo(in) + ")";
        }
        if (stream instanceof FileInputStream) {
            String path = (String)ReflectionUtil.getField(stream.getClass(), (Object)stream, String.class, (String)"path");
            FileChannel channel = (FileChannel)ReflectionUtil.getField(stream.getClass(), (Object)stream, FileChannel.class, (String)"channel");
            boolean closed = (Boolean)ReflectionUtil.getField(stream.getClass(), (Object)stream, Boolean.TYPE, (String)"closed");
            int available = stream.available();
            File file2 = new File(path);
            return "FileInputStream(path=" + path + ", available=" + available + ", closed=" + closed + ", channel=" + channel + ", channel.size=" + (channel == null ? null : Long.valueOf(channel.size())) + ", file.exists=" + file2.exists() + ", file.content='" + FileUtil.loadFile((File)file2) + "')";
        }
        return stream;
    }

    private static boolean guessIfText(@NotNull VirtualFile file2, @NotNull ByteSequence byteSequence) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "guessIfText"));
        }
        if (byteSequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "byteSequence", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "guessIfText"));
        }
        byte[] bytes = byteSequence.getBytes();
        Trinity<Charset, CharsetToolkit.GuessedEncoding, byte[]> guessed = LoadTextUtil.guessFromContent(file2, bytes, byteSequence.getLength());
        if (guessed == null) {
            return false;
        }
        file2.setBOM((byte[])guessed.third);
        if (guessed.first != null) {
            return true;
        }
        CharsetToolkit.GuessedEncoding guess = (CharsetToolkit.GuessedEncoding)guessed.second;
        return guess != null && (guess == CharsetToolkit.GuessedEncoding.VALID_UTF8 || guess == CharsetToolkit.GuessedEncoding.SEVEN_BIT);
    }

    public boolean isFileOfType(@NotNull VirtualFile file2, @NotNull FileType type) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "isFileOfType"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "isFileOfType"));
        }
        if (type instanceof FileTypeIdentifiableByVirtualFile) {
            return ((FileTypeIdentifiableByVirtualFile)type).isMyFileType(file2);
        }
        return this.getFileTypeByFileName(file2.getNameSequence()) == type;
    }

    @NotNull
    public FileType getFileTypeByExtension(@NotNull String extension) {
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getFileTypeByExtension"));
        }
        FileType fileType = this.getFileTypeByFileName("IntelliJ_IDEA_RULES." + extension);
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getFileTypeByExtension"));
        }
        return fileType;
    }

    @Override
    public void registerFileType(@NotNull FileType fileType) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "registerFileType"));
        }
        this.registerFileType(fileType, ArrayUtil.EMPTY_STRING_ARRAY);
    }

    public void registerFileType(@NotNull FileType type, @NotNull List<FileNameMatcher> defaultAssociations) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "registerFileType"));
        }
        if (defaultAssociations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultAssociations", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "registerFileType"));
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "lambda$registerFileType$4"));
            }
            if (defaultAssociations == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultAssociations", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "lambda$registerFileType$4"));
            }
            this.fireBeforeFileTypesChanged();
            this.registerFileTypeWithoutNotification(type, defaultAssociations, true);
            this.fireFileTypesChanged();
        });
    }

    @Override
    public void unregisterFileType(@NotNull FileType fileType) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "unregisterFileType"));
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (fileType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "lambda$unregisterFileType$5"));
            }
            this.fireBeforeFileTypesChanged();
            this.unregisterFileTypeWithoutNotification(fileType);
            this.fireFileTypesChanged();
        });
    }

    private void unregisterFileTypeWithoutNotification(@NotNull FileType fileType) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "unregisterFileTypeWithoutNotification"));
        }
        this.myPatternsTable.removeAllAssociations(fileType);
        this.mySchemeManager.removeScheme(fileType);
        if (fileType instanceof FileTypeIdentifiableByVirtualFile) {
            FileTypeIdentifiableByVirtualFile fakeFileType = (FileTypeIdentifiableByVirtualFile)fileType;
            this.mySpecialFileTypes = (FileTypeIdentifiableByVirtualFile[])ArrayUtil.remove((Object[])this.mySpecialFileTypes, (Object)fakeFileType, FileTypeIdentifiableByVirtualFile.ARRAY_FACTORY);
        }
    }

    @NotNull
    public FileType[] getRegisteredFileTypes() {
        List<FileType> fileTypes = this.mySchemeManager.getAllSchemes();
        FileType[] fileTypeArray = fileTypes.toArray(new FileType[fileTypes.size()]);
        if (fileTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getRegisteredFileTypes"));
        }
        return fileTypeArray;
    }

    @Override
    @NotNull
    public String getExtension(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getExtension"));
        }
        int index = fileName.lastIndexOf(46);
        if (index < 0) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getExtension"));
            }
            return "";
        }
        String string2 = fileName.substring(index + 1);
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getExtension"));
        }
        return string2;
    }

    @NotNull
    public String getIgnoredFilesList() {
        Set<String> masks = this.myIgnoredPatterns.getIgnoreMasks();
        String string2 = masks.isEmpty() ? "" : StringUtil.join(masks, (String)";") + ";";
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getIgnoredFilesList"));
        }
        return string2;
    }

    public void setIgnoredFilesList(@NotNull String list2) {
        if (list2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ATTRIBUTE_LIST, "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "setIgnoredFilesList"));
        }
        this.fireBeforeFileTypesChanged();
        this.myIgnoredFileCache.clearCache();
        this.myIgnoredPatterns.setIgnoreMasks(list2);
        this.fireFileTypesChanged();
    }

    @Override
    public boolean isIgnoredFilesListEqualToCurrent(@NotNull String list2) {
        if (list2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ATTRIBUTE_LIST, "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "isIgnoredFilesListEqualToCurrent"));
        }
        THashSet tempSet = new THashSet();
        StringTokenizer tokenizer = new StringTokenizer(list2, ";");
        while (tokenizer.hasMoreTokens()) {
            tempSet.add(tokenizer.nextToken());
        }
        return tempSet.equals(this.myIgnoredPatterns.getIgnoreMasks());
    }

    public boolean isFileIgnored(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ATTRIBUTE_NAME, "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "isFileIgnored"));
        }
        return this.myIgnoredPatterns.isIgnored(name);
    }

    public boolean isFileIgnored(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "isFileIgnored"));
        }
        return this.myIgnoredFileCache.isFileIgnored(file2);
    }

    @NotNull
    public String[] getAssociatedExtensions(@NotNull FileType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getAssociatedExtensions"));
        }
        String[] stringArray = this.myPatternsTable.getAssociatedExtensions(type);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getAssociatedExtensions"));
        }
        return stringArray;
    }

    @NotNull
    public List<FileNameMatcher> getAssociations(@NotNull FileType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getAssociations"));
        }
        List<FileNameMatcher> list2 = this.myPatternsTable.getAssociations(type);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getAssociations"));
        }
        return list2;
    }

    public void associate(@NotNull FileType type, @NotNull FileNameMatcher matcher) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "associate"));
        }
        if (matcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matcher", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "associate"));
        }
        this.associate(type, matcher, true);
    }

    public void removeAssociation(@NotNull FileType type, @NotNull FileNameMatcher matcher) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "removeAssociation"));
        }
        if (matcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matcher", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "removeAssociation"));
        }
        this.removeAssociation(type, matcher, true);
    }

    @Override
    public void fireBeforeFileTypesChanged() {
        FileTypeEvent event = new FileTypeEvent((Object)this);
        ((FileTypeListener)this.myMessageBus.syncPublisher(TOPIC)).beforeFileTypesChanged(event);
    }

    @Override
    public void fireFileTypesChanged() {
        this.clearCaches();
        this.clearPersistentAttributes();
        ((FileTypeListener)this.myMessageBus.syncPublisher(TOPIC)).fileTypesChanged(new FileTypeEvent((Object)this));
    }

    public void addFileTypeListener(@NotNull FileTypeListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "addFileTypeListener"));
        }
        MessageBusConnection connection = this.myMessageBus.connect();
        connection.subscribe(TOPIC, (Object)listener2);
        this.myAdapters.put(listener2, connection);
    }

    public void removeFileTypeListener(@NotNull FileTypeListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "removeFileTypeListener"));
        }
        MessageBusConnection connection = this.myAdapters.remove(listener2);
        if (connection != null) {
            connection.disconnect();
        }
    }

    public void loadState(Element state) {
        int savedVersion = StringUtilRt.parseInt((String)state.getAttributeValue(ATTRIBUTE_VERSION), (int)0);
        for (Element element : state.getChildren()) {
            if (element.getName().equals(ELEMENT_IGNORE_FILES)) {
                this.myIgnoredPatterns.setIgnoreMasks(element.getAttributeValue(ATTRIBUTE_LIST));
                continue;
            }
            if (!"extensionMap".equals(element.getName())) continue;
            this.readGlobalMappings(element);
        }
        if (savedVersion < 4) {
            if (savedVersion == 0) {
                this.addIgnore(".svn");
            }
            if (savedVersion < 2) {
                this.restoreStandardFileExtensions();
            }
            this.addIgnore("*.pyc");
            this.addIgnore("*.pyo");
            this.addIgnore(".git");
        }
        if (savedVersion < 5) {
            this.addIgnore("*.hprof");
        }
        if (savedVersion < 6) {
            this.addIgnore("_svn");
        }
        if (savedVersion < 7) {
            this.addIgnore(".hg");
        }
        if (savedVersion < 8) {
            this.addIgnore("*~");
        }
        if (savedVersion < 9) {
            this.addIgnore("__pycache__");
        }
        if (savedVersion < 11) {
            this.addIgnore("*.rbc");
        }
        if (savedVersion < 13) {
            this.unignoreMask("*.lib");
        }
        if (savedVersion < 15) {
            this.unignoreMask(".bundle");
        }
        if (savedVersion < 16) {
            this.unignoreMask(".tox");
        }
        if (savedVersion < 17) {
            this.addIgnore("*.rbc");
        }
        this.myIgnoredFileCache.clearCache();
        String counter = JDOMExternalizer.readString((Element)state, (String)"fileTypeChangedCounter");
        if (counter != null) {
            this.fileTypeChangedCount.set(StringUtilRt.parseInt((String)counter, (int)0));
            this.autoDetectedAttribute = this.autoDetectedAttribute.newVersion(this.fileTypeChangedCount.get());
        }
    }

    private void unignoreMask(@NotNull String maskToRemove) {
        if (maskToRemove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "maskToRemove", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "unignoreMask"));
        }
        LinkedHashSet<String> masks = new LinkedHashSet<String>(this.myIgnoredPatterns.getIgnoreMasks());
        masks.remove(maskToRemove);
        this.myIgnoredPatterns.clearPatterns();
        for (String each : masks) {
            this.myIgnoredPatterns.addIgnoreMask(each);
        }
    }

    private void readGlobalMappings(@NotNull Element e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "readGlobalMappings"));
        }
        for (Pair<FileNameMatcher, String> association : AbstractFileType.readAssociations(e2)) {
            FileType type = this.getFileTypeByName((String)association.getSecond());
            FileNameMatcher matcher = (FileNameMatcher)association.getFirst();
            if (type != null) {
                FileType newFileType;
                if (PlainTextFileType.INSTANCE == type && (newFileType = this.myPatternsTable.findAssociatedFileType(matcher)) != null && newFileType != PlainTextFileType.INSTANCE && newFileType != UnknownFileType.INSTANCE) {
                    this.myRemovedMappings.put(matcher, (Pair<FileType, Boolean>)Pair.create((Object)newFileType, (Object)false));
                }
                this.associate(type, matcher, false);
                continue;
            }
            this.myUnresolvedMappings.put(matcher, (String)association.getSecond());
        }
        List<Trinity<FileNameMatcher, String, Boolean>> removedAssociations = AbstractFileType.readRemovedAssociations(e2);
        for (Trinity<FileNameMatcher, String, Boolean> trinity : removedAssociations) {
            FileType type = this.getFileTypeByName((String)trinity.getSecond());
            FileNameMatcher matcher = (FileNameMatcher)trinity.getFirst();
            if (type != null) {
                this.removeAssociation(type, matcher, false);
                continue;
            }
            this.myUnresolvedRemovedMappings.put(matcher, (Trinity<String, String, Boolean>)Trinity.create((Object)trinity.getSecond(), (Object)this.myUnresolvedMappings.get(matcher), (Object)trinity.getThird()));
        }
    }

    private void addIgnore(@NonNls @NotNull String ignoreMask) {
        if (ignoreMask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignoreMask", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "addIgnore"));
        }
        this.myIgnoredPatterns.addIgnoreMask(ignoreMask);
    }

    private void restoreStandardFileExtensions() {
        for (String name : FILE_TYPES_WITH_PREDEFINED_EXTENSIONS) {
            StandardFileType stdFileType = this.myStandardFileTypes.get(name);
            if (stdFileType == null) continue;
            FileType fileType = stdFileType.fileType;
            for (FileNameMatcher matcher : this.myPatternsTable.getAssociations(fileType)) {
                FileType defaultFileType = this.myInitialAssociations.findAssociatedFileType(matcher);
                if (defaultFileType == null || defaultFileType == fileType) continue;
                this.removeAssociation(fileType, matcher, false);
                this.associate(defaultFileType, matcher, false);
            }
            for (FileNameMatcher matcher : this.myInitialAssociations.getAssociations(fileType)) {
                this.associate(fileType, matcher, false);
            }
        }
    }

    @NotNull
    public Element getState() {
        String ignoreFiles;
        Element state = new Element("state");
        Set<String> masks = this.myIgnoredPatterns.getIgnoreMasks();
        if (masks.isEmpty()) {
            ignoreFiles = "";
        } else {
            Object[] strings = ArrayUtil.toStringArray(masks);
            Arrays.sort(strings);
            ignoreFiles = StringUtil.join((String[])strings, (String)";") + ";";
        }
        if (!ignoreFiles.equalsIgnoreCase(DEFAULT_IGNORED)) {
            state.addContent(new Element(ELEMENT_IGNORE_FILES).setAttribute(ATTRIBUTE_LIST, ignoreFiles));
        }
        Element map2 = new Element("extensionMap");
        ArrayList<FileType> notExternalizableFileTypes = new ArrayList<FileType>();
        for (FileType type : this.mySchemeManager.getAllSchemes()) {
            if (type instanceof AbstractFileType && !this.myDefaultTypes.contains(type)) continue;
            notExternalizableFileTypes.add(type);
        }
        if (!notExternalizableFileTypes.isEmpty()) {
            Collections.sort(notExternalizableFileTypes, Comparator.comparing(FileType::getName));
            for (FileType type : notExternalizableFileTypes) {
                this.writeExtensionsMap(map2, type, true);
            }
        }
        if (!this.myUnresolvedMappings.isEmpty()) {
            FileNameMatcher[] unresolvedMappingKeys = this.myUnresolvedMappings.keySet().toArray(new FileNameMatcher[this.myUnresolvedMappings.size()]);
            Arrays.sort(unresolvedMappingKeys, Comparator.comparing(FileNameMatcher::getPresentableString));
            for (FileNameMatcher fileNameMatcher : unresolvedMappingKeys) {
                Element content2 = AbstractFileType.writeMapping(this.myUnresolvedMappings.get(fileNameMatcher), fileNameMatcher, true);
                if (content2 == null) continue;
                map2.addContent(content2);
            }
        }
        if (!map2.getChildren().isEmpty()) {
            state.addContent(map2);
        }
        if (!state.getChildren().isEmpty()) {
            state.setAttribute(ATTRIBUTE_VERSION, String.valueOf(17));
        }
        Element element = state;
        if (element == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getState"));
        }
        return element;
    }

    private void writeExtensionsMap(@NotNull Element map2, @NotNull FileType type, boolean specifyTypeName) {
        Element content2;
        if (map2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "writeExtensionsMap"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "writeExtensionsMap"));
        }
        List<FileNameMatcher> associations = this.myPatternsTable.getAssociations(type);
        THashSet defaultAssociations = new THashSet(this.myInitialAssociations.getAssociations(type));
        for (FileNameMatcher matcher : associations) {
            if (defaultAssociations.contains(matcher)) {
                defaultAssociations.remove(matcher);
                continue;
            }
            if (!FileTypeManagerImpl.shouldSave(type) || (content2 = AbstractFileType.writeMapping(type.getName(), matcher, specifyTypeName)) == null) continue;
            map2.addContent(content2);
        }
        for (FileNameMatcher matcher : defaultAssociations) {
            content2 = AbstractFileType.writeRemovedMapping(type, matcher, specifyTypeName, this.isApproved(matcher));
            if (content2 == null) continue;
            map2.addContent(content2);
        }
    }

    private boolean isApproved(@NotNull FileNameMatcher matcher) {
        if (matcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matcher", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "isApproved"));
        }
        Pair<FileType, Boolean> pair = this.myRemovedMappings.get(matcher);
        return pair != null && (Boolean)pair.getSecond() != false;
    }

    @Nullable
    private FileType getFileTypeByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ATTRIBUTE_NAME, "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getFileTypeByName"));
        }
        return this.mySchemeManager.findSchemeByName(name);
    }

    @NotNull
    private static List<FileNameMatcher> parse(@Nullable String semicolonDelimited) {
        if (semicolonDelimited == null) {
            List<FileNameMatcher> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "parse"));
            }
            return list2;
        }
        StringTokenizer tokenizer = new StringTokenizer(semicolonDelimited, ";", false);
        ArrayList<FileNameMatcher> list3 = new ArrayList<FileNameMatcher>();
        while (tokenizer.hasMoreTokens()) {
            list3.add((FileNameMatcher)new ExtensionFileNameMatcher(tokenizer.nextToken().trim()));
        }
        ArrayList<FileNameMatcher> arrayList = list3;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "parse"));
        }
        return arrayList;
    }

    private void registerFileTypeWithoutNotification(@NotNull FileType fileType, @NotNull List<FileNameMatcher> matchers2, boolean addScheme) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "registerFileTypeWithoutNotification"));
        }
        if (matchers2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matchers", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "registerFileTypeWithoutNotification"));
        }
        if (addScheme) {
            this.mySchemeManager.addScheme(fileType);
        }
        for (FileNameMatcher matcher : matchers2) {
            this.myPatternsTable.addAssociation(matcher, fileType);
            this.myInitialAssociations.addAssociation(matcher, fileType);
        }
        if (fileType instanceof FileTypeIdentifiableByVirtualFile) {
            this.mySpecialFileTypes = (FileTypeIdentifiableByVirtualFile[])ArrayUtil.append((Object[])this.mySpecialFileTypes, (Object)((FileTypeIdentifiableByVirtualFile)fileType), FileTypeIdentifiableByVirtualFile.ARRAY_FACTORY);
        }
    }

    private void bindUnresolvedMappings(@NotNull FileType fileType) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "bindUnresolvedMappings"));
        }
        for (FileNameMatcher matcher : new THashSet(this.myUnresolvedMappings.keySet())) {
            String name = this.myUnresolvedMappings.get(matcher);
            if (!Comparing.equal((String)name, (String)fileType.getName())) continue;
            this.myPatternsTable.addAssociation(matcher, fileType);
            this.myUnresolvedMappings.remove(matcher);
        }
        for (FileNameMatcher matcher : new THashSet(this.myUnresolvedRemovedMappings.keySet())) {
            Trinity<String, String, Boolean> trinity = this.myUnresolvedRemovedMappings.get(matcher);
            if (!Comparing.equal((String)((String)trinity.getFirst()), (String)fileType.getName())) continue;
            this.removeAssociation(fileType, matcher, false);
            this.myUnresolvedRemovedMappings.remove(matcher);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private FileType loadFileType(@NotNull Element typeElement, boolean isDefault) {
        FileType type;
        if (typeElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeElement", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "loadFileType"));
        }
        String fileTypeName = typeElement.getAttributeValue(ATTRIBUTE_NAME);
        String fileTypeDescr = typeElement.getAttributeValue(ATTRIBUTE_DESCRIPTION);
        String iconPath = typeElement.getAttributeValue("icon");
        String extensionsStr = StringUtil.nullize((String)typeElement.getAttributeValue("extensions"));
        if (isDefault && extensionsStr != null) {
            extensionsStr = this.filterAlreadyRegisteredExtensions(extensionsStr);
        }
        FileType fileType = type = isDefault ? this.getFileTypeByName(fileTypeName) : null;
        if (type != null) {
            FileType fileType2 = type;
            if (fileType2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "loadFileType"));
            }
            return fileType2;
        }
        Element element = typeElement.getChild("highlighting");
        if (element == null) {
            CustomFileTypeFactory factory2;
            void var11_13;
            CustomFileTypeFactory[] customFileTypeFactoryArray = (CustomFileTypeFactory[])CustomFileTypeFactory.EP_NAME.getExtensions();
            int n2 = customFileTypeFactoryArray.length;
            boolean i2 = false;
            while (var11_13 < n2 && (type = (factory2 = customFileTypeFactoryArray[var11_13]).createFileType(typeElement)) == null) {
                ++var11_13;
            }
            if (type == null) {
                type = new UserBinaryFileType();
            }
        } else {
            SyntaxTable table2 = AbstractFileType.readSyntaxTable(element);
            type = new AbstractFileType(table2);
            ((AbstractFileType)type).initSupport();
        }
        FileTypeManagerImpl.setFileTypeAttributes((UserFileType)type, fileTypeName, fileTypeDescr, iconPath);
        this.registerFileTypeWithoutNotification(type, FileTypeManagerImpl.parse(extensionsStr), isDefault);
        if (isDefault) {
            this.myDefaultTypes.add(type);
            if (type instanceof ExternalizableFileType) {
                ((ExternalizableFileType)type).markDefaultSettings();
            }
        } else {
            Element extensions = typeElement.getChild("extensionMap");
            if (extensions != null) {
                for (Pair<FileNameMatcher, String> pair : AbstractFileType.readAssociations(extensions)) {
                    this.associate(type, (FileNameMatcher)pair.getFirst(), false);
                }
                for (Trinity trinity : AbstractFileType.readRemovedAssociations(extensions)) {
                    this.removeAssociation(type, (FileNameMatcher)trinity.getFirst(), false);
                }
            }
        }
        FileType fileType3 = type;
        if (fileType3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "loadFileType"));
        }
        return fileType3;
    }

    @Nullable
    private String filterAlreadyRegisteredExtensions(@NotNull String semicolonDelimited) {
        if (semicolonDelimited == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "semicolonDelimited", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "filterAlreadyRegisteredExtensions"));
        }
        StringTokenizer tokenizer = new StringTokenizer(semicolonDelimited, ";", false);
        StringBuilder builder = null;
        while (tokenizer.hasMoreTokens()) {
            String extension = tokenizer.nextToken().trim();
            if (this.getFileTypeByExtension(extension) != UnknownFileType.INSTANCE) continue;
            if (builder == null) {
                builder = new StringBuilder();
            } else if (builder.length() > 0) {
                builder.append(";");
            }
            builder.append(extension);
        }
        return builder == null ? null : builder.toString();
    }

    private static void setFileTypeAttributes(@NotNull UserFileType fileType, @Nullable String name, @Nullable String description, @Nullable String iconPath) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "setFileTypeAttributes"));
        }
        if (!StringUtil.isEmptyOrSpaces((String)iconPath)) {
            fileType.setIcon(IconLoader.getIcon((String)iconPath));
        }
        if (description != null) {
            fileType.setDescription(description);
        }
        if (name != null) {
            fileType.setName(name);
        }
    }

    private static boolean shouldSave(@NotNull FileType fileType) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "shouldSave"));
        }
        return fileType != UnknownFileType.INSTANCE && !fileType.isReadOnly();
    }

    @NotNull
    public static String getFileTypeComponentName() {
        String string2 = PlatformUtils.isIdeaCommunity() ? "CommunityFileTypes" : "FileTypeManager";
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getFileTypeComponentName"));
        }
        return string2;
    }

    @NotNull
    FileTypeAssocTable getExtensionMap() {
        FileTypeAssocTable<FileType> fileTypeAssocTable = this.myPatternsTable;
        if (fileTypeAssocTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getExtensionMap"));
        }
        return fileTypeAssocTable;
    }

    void setPatternsTable(@NotNull Set<FileType> fileTypes, @NotNull FileTypeAssocTable<FileType> assocTable) {
        if (fileTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileTypes", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "setPatternsTable"));
        }
        if (assocTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assocTable", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "setPatternsTable"));
        }
        this.fireBeforeFileTypesChanged();
        for (FileType existing : this.getRegisteredFileTypes()) {
            if (fileTypes.contains(existing)) continue;
            this.mySchemeManager.removeScheme(existing);
        }
        for (FileType fileType : fileTypes) {
            this.mySchemeManager.addScheme(fileType);
            if (!(fileType instanceof AbstractFileType)) continue;
            ((AbstractFileType)fileType).initSupport();
        }
        this.myPatternsTable = assocTable.copy();
        this.fireFileTypesChanged();
    }

    public void associate(@NotNull FileType fileType, @NotNull FileNameMatcher matcher, boolean fireChange) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "associate"));
        }
        if (matcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matcher", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "associate"));
        }
        if (!this.myPatternsTable.isAssociatedWith(fileType, matcher)) {
            if (fireChange) {
                this.fireBeforeFileTypesChanged();
            }
            this.myPatternsTable.addAssociation(matcher, fileType);
            if (fireChange) {
                this.fireFileTypesChanged();
            }
        }
    }

    public void removeAssociation(@NotNull FileType fileType, @NotNull FileNameMatcher matcher, boolean fireChange) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "removeAssociation"));
        }
        if (matcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matcher", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "removeAssociation"));
        }
        if (this.myPatternsTable.isAssociatedWith(fileType, matcher)) {
            if (fireChange) {
                this.fireBeforeFileTypesChanged();
            }
            this.myPatternsTable.removeAssociation(matcher, fileType);
            if (fireChange) {
                this.fireFileTypesChanged();
            }
        }
    }

    @Nullable
    public FileType getKnownFileTypeOrAssociate(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getKnownFileTypeOrAssociate"));
        }
        FileType type = file2.getFileType();
        if (type == UnknownFileType.INSTANCE) {
            type = FileTypeChooser.associateFileType(file2.getName());
        }
        return type;
    }

    public FileType getKnownFileTypeOrAssociate(@NotNull VirtualFile file2, @NotNull Project project2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getKnownFileTypeOrAssociate"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getKnownFileTypeOrAssociate"));
        }
        return FileTypeChooser.getKnownFileTypeOrAssociate(file2, project2);
    }

    private void registerReDetectedMappings(@NotNull StandardFileType pair) {
        if (pair == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pair", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "registerReDetectedMappings"));
        }
        FileType fileType = pair.fileType;
        if (fileType == PlainTextFileType.INSTANCE) {
            return;
        }
        for (FileNameMatcher matcher : pair.matchers) {
            this.registerReDetectedMapping(fileType, matcher);
            if (!(matcher instanceof ExtensionFileNameMatcher)) continue;
            ExtensionFileNameMatcher extMatcher = (ExtensionFileNameMatcher)matcher;
            this.registerReDetectedMapping(fileType, (FileNameMatcher)new ExactFileNameMatcher("." + extMatcher.getExtension()));
        }
    }

    private void registerReDetectedMapping(@NotNull FileType fileType, @NotNull FileNameMatcher matcher) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "registerReDetectedMapping"));
        }
        if (matcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matcher", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "registerReDetectedMapping"));
        }
        String typeName = this.myUnresolvedMappings.get(matcher);
        if (typeName != null && !typeName.equals(fileType.getName())) {
            Trinity<String, String, Boolean> trinity = this.myUnresolvedRemovedMappings.get(matcher);
            this.myRemovedMappings.put(matcher, (Pair<FileType, Boolean>)Pair.create((Object)fileType, (Object)(trinity != null && (Boolean)trinity.third != false ? 1 : 0)));
            this.myUnresolvedMappings.remove(matcher);
        }
    }

    @NotNull
    Map<FileNameMatcher, Pair<FileType, Boolean>> getRemovedMappings() {
        Map<FileNameMatcher, Pair<FileType, Boolean>> map2 = this.myRemovedMappings;
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getRemovedMappings"));
        }
        return map2;
    }

    void clearForTests() {
        for (StandardFileType fileType : this.myStandardFileTypes.values()) {
            this.myPatternsTable.removeAllAssociations(fileType.fileType);
        }
        this.myStandardFileTypes.clear();
        this.myUnresolvedMappings.clear();
        this.mySchemeManager.clearAllSchemes();
    }

    public void dispose() {
        LOG.info("FileTypeManager: " + this.counterAutoDetect + " auto-detected files\nElapsed time on auto-detect: " + this.elapsedAutoDetect + " ms");
    }

    static {
        List strings = StringUtil.split((String)DEFAULT_IGNORED, (String)";");
        for (int i2 = 0; i2 < strings.size(); ++i2) {
            String prev;
            String string2 = (String)strings.get(i2);
            String string3 = prev = i2 == 0 ? "" : (String)strings.get(i2 - 1);
            assert (prev.compareTo(string2) < 0) : "DEFAULT_IGNORED must be sorted, but got: '" + prev + "' >= '" + string2 + "'";
        }
        RE_DETECT_ASYNC = !ApplicationManager.getApplication().isUnitTestMode();
        FILE_TYPES_WITH_PREDEFINED_EXTENSIONS = new String[]{"JSP", "JSPX", "DTD", "HTML", "Properties", "XHTML"};
        IO_EXCEPTION_HAPPENED = Key.create((String)"IO_EXCEPTION_HAPPENED");
    }

    private static class StandardFileType {
        @NotNull
        private final FileType fileType;
        @NotNull
        private final List<FileNameMatcher> matchers;

        private StandardFileType(@NotNull FileType fileType, @NotNull List<FileNameMatcher> matchers2) {
            if (fileType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$StandardFileType", "<init>"));
            }
            if (matchers2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matchers", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$StandardFileType", "<init>"));
            }
            this.fileType = fileType;
            this.matchers = matchers2;
        }
    }
}

