/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.impl.IgnoredPatternSet;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.containers.ConcurrentBitSet;
import com.intellij.util.messages.MessageBusConnection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class IgnoredFileCache {
    private final ConcurrentBitSet myNonIgnoredIds;
    private final IgnoredPatternSet myIgnoredPatterns;
    private int myVfsEventNesting;

    IgnoredFileCache(@NotNull IgnoredPatternSet ignoredPatterns) {
        if (ignoredPatterns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignoredPatterns", "com/intellij/openapi/fileTypes/impl/IgnoredFileCache", "<init>"));
        }
        this.myNonIgnoredIds = new ConcurrentBitSet();
        this.myIgnoredPatterns = ignoredPatterns;
        MessageBusConnection connect = ApplicationManager.getApplication().getMessageBus().connect();
        connect.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void before(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/fileTypes/impl/IgnoredFileCache$1", "before"));
                }
                IgnoredFileCache.this.myVfsEventNesting++;
                this.clearCacheForChangedFiles(events);
            }

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/fileTypes/impl/IgnoredFileCache$1", "after"));
                }
                this.clearCacheForChangedFiles(events);
                IgnoredFileCache.this.myVfsEventNesting--;
            }

            private void clearCacheForChangedFiles(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/fileTypes/impl/IgnoredFileCache$1", "clearCacheForChangedFiles"));
                }
                for (VFileEvent vFileEvent : events) {
                    int id;
                    VirtualFile file2 = vFileEvent.getFile();
                    if (!(file2 instanceof NewVirtualFile) || !(vFileEvent instanceof VFilePropertyChangeEvent) || (id = ((NewVirtualFile)file2).getId()) < 0) continue;
                    IgnoredFileCache.this.myNonIgnoredIds.clear(id);
                }
            }
        });
    }

    void clearCache() {
        this.myNonIgnoredIds.clear();
    }

    boolean isFileIgnored(VirtualFile file2) {
        int id;
        int n2 = id = this.myVfsEventNesting == 0 && file2 instanceof NewVirtualFile ? ((NewVirtualFile)file2).getId() : -1;
        if (id > 0 && this.myNonIgnoredIds.get(id)) {
            return false;
        }
        boolean result2 = this.myIgnoredPatterns.isIgnored(file2.getNameSequence());
        if (!result2 && id > 0) {
            this.myNonIgnoredIds.set(id);
        }
        return result2;
    }
}

