/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.impl;

import com.intellij.openapi.graph.PeerWrapper;
import com.intellij.openapi.graph.base.DataProvider;
import com.intellij.openapi.graph.base.GraphEvent;
import com.intellij.openapi.graph.impl.GraphManagerImpl;
import com.intellij.openapi.graph.impl.builder.YBundlesInitializer;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.view.Graph2DEvent;
import com.intellij.openapi.graph.view.Graph2DSelectionEvent;
import com.intellij.openapi.graph.view.Graph2DSelectionListener;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.NodeCellRenderer;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.EventObject;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.CellEditorListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import y.base.GraphListener;
import y.layout.LayoutGraph;
import y.view.Drawable;
import y.view.Graph2DListener;
import y.view.NodeCellEditor;
import y.view.NodeRealizer;
import y.view.View;
import y.view.ViewChangeListener;

public class GraphBase {
    public static Object _currentPeer;
    private final Object _delegee;
    @NonNls
    private static final String GRAPH_OPENAPI_PACKAGE = "com.intellij.openapi.graph";
    @NonNls
    private static final String GRAPH_IMPL_PACKAGE = "com.intellij.openapi.graph.impl";
    @NonNls
    private static final String JAVA_LANG = "java.lang";
    @NonNls
    private static final String IMPL_SUFFIX = "Impl";

    public GraphBase(Object _delegee) {
        this._delegee = _delegee;
    }

    @Nullable
    public static Object wrap(Object yObject, Class newClass) {
        if (yObject == null) {
            return null;
        }
        return GraphBase._wrap(yObject, newClass);
    }

    private static Object _wrap(Object yObject, Class newClass) {
        if (newClass.equals(Map.class)) {
            return new WrappingMap((Map)yObject);
        }
        if (yObject instanceof PeerWrapper) {
            PeerWrapper peerWrapper = (PeerWrapper)yObject;
            return peerWrapper._getPeer();
        }
        if (yObject.getClass().getName().startsWith(JAVA_LANG)) {
            return yObject;
        }
        try {
            Class c2 = GraphBase.getImplClass(yObject.getClass(), newClass);
            if (c2 == null && newClass.equals(Object.class)) {
                return yObject;
            }
            assert (c2 != null) : "can't wrap " + yObject;
            Constructor<?> constructor = c2.getConstructors()[0];
            assert (constructor.getParameterTypes().length == 1) : "Wrong number of arguments in : " + constructor;
            return constructor.newInstance(yObject);
        }
        catch (Exception e2) {
            assert (false) : "Error while wrapping: " + yObject.getClass() + " into: " + newClass;
            throw new IllegalArgumentException("Error while wrapping: " + yObject.getClass() + " into: " + newClass, e2);
        }
    }

    @Nullable
    private static Class getImplClass(Class<? extends Object> yClass, Class newClass) throws ClassNotFoundException {
        Class interfaceImplClass;
        String yname = yClass.getName();
        String name = newClass.getName();
        if (yname.equals("java.lang.Object")) {
            return null;
        }
        Class iClass = GraphManagerImpl.Y2I_CLASSES.get(yClass);
        if (iClass != null) {
            String n2 = iClass.getName();
            assert (n2.startsWith(GRAPH_OPENAPI_PACKAGE));
            n2 = n2.substring(GRAPH_OPENAPI_PACKAGE.length());
            n2 = GRAPH_IMPL_PACKAGE + n2 + IMPL_SUFFIX;
            try {
                return Class.forName(n2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        Class<?>[] interfaces = yClass.getInterfaces();
        assert (interfaces.length <= 1) : "Wrong class: " + yClass;
        if (interfaces.length > 0 && (interfaceImplClass = GraphBase.getImplClass(interfaces[0], newClass)) != null) {
            return interfaceImplClass;
        }
        Class<? extends Object> superclass = yClass.getSuperclass();
        Class superImplClass = GraphBase.getImplClass(superclass, newClass);
        if (superImplClass != null) {
            return superImplClass;
        }
        if (!name.startsWith(GRAPH_OPENAPI_PACKAGE)) {
            return null;
        }
        name = name.substring(GRAPH_OPENAPI_PACKAGE.length() + 1);
        name = "com.intellij.openapi.graph.impl." + name;
        String[] subClasses = name.split("\\$");
        name = StringUtil.join((String[])StringUtil.surround((String[])subClasses, (String)"", (String)IMPL_SUFFIX), (String)"$");
        return Class.forName(name);
    }

    public static Object[] wrap(Object[] yObjects, Class expectedArrayClass) {
        Class<?> componentType = expectedArrayClass.getComponentType();
        Object[] result2 = (Object[])Array.newInstance(componentType, yObjects.length);
        for (int i2 = 0; i2 < yObjects.length; ++i2) {
            Object yObject = yObjects[i2];
            result2[i2] = GraphBase.wrap(yObject, componentType);
        }
        return result2;
    }

    @Nullable
    public static Object unwrap(@Nullable Object iObject, Class exceptedClass) {
        if (iObject == null) {
            return null;
        }
        return GraphBase._unwrap(iObject);
    }

    private static Object _unwrap(Object iObject) {
        if (iObject instanceof PeerWrapper) {
            PeerWrapper peerWrapper = (PeerWrapper)iObject;
            return peerWrapper._getPeer();
        }
        if (iObject instanceof GraphBase) {
            GraphBase graphBase = (GraphBase)iObject;
            return graphBase._delegee;
        }
        if (iObject instanceof Class) {
            Class aClass = (Class)iObject;
            Class c2 = GraphManagerImpl.I2Y_CLASSES.get(aClass);
            if (c2 == null) {
                assert (false) : "Can't unwrap: " + iObject;
                throw new IllegalArgumentException("Can't unwrap: " + iObject);
            }
            return c2;
        }
        if (iObject instanceof WrappingMap) {
            WrappingMap wrappingMap = (WrappingMap)iObject;
            return wrappingMap.myDelegee;
        }
        return GraphBase.unwrapClass(iObject.getClass(), iObject);
    }

    private static Object unwrapClass(Class aClass, Object iObject) {
        Class<?>[] interfaces;
        if (aClass == iObject.getClass() && aClass.getName().endsWith("UmlGraphBuilder")) {
            return iObject;
        }
        for (Class<?> anInterface : interfaces = aClass.getInterfaces()) {
            if (!anInterface.getName().startsWith(GRAPH_OPENAPI_PACKAGE)) continue;
            return GraphBase.unwrapToInterface(anInterface, iObject);
        }
        Class superclass = aClass.getSuperclass();
        if (superclass != null) {
            return GraphBase.unwrapClass(superclass, iObject);
        }
        return iObject;
    }

    private static Object unwrapToInterface(Class anInterface, Object iObject) {
        Class yClass = GraphBase.unwrapClass(anInterface);
        assert (yClass.isInterface()) : "Not an interface: " + yClass;
        if (yClass.equals(y.base.DataProvider.class)) {
            return new DataProviderProxy((DataProvider)iObject);
        }
        if (yClass.equals(y.view.NodeCellRenderer.class)) {
            return new NodeCellRendererProxy((NodeCellRenderer)iObject);
        }
        if (yClass.equals(NodeCellEditor.class)) {
            return new NodeCellEditorProxy((com.intellij.openapi.graph.view.NodeCellEditor)iObject);
        }
        if (yClass.equals(y.view.Graph2DSelectionListener.class)) {
            return new Graph2DSelectionListenerProxy((Graph2DSelectionListener)iObject);
        }
        if (yClass.equals(GraphListener.class)) {
            return new GraphListenerProxy((com.intellij.openapi.graph.base.GraphListener)iObject);
        }
        if (yClass.equals(Graph2DListener.class)) {
            return new Graph2DListenerProxy((com.intellij.openapi.graph.view.Graph2DListener)iObject);
        }
        if (yClass.equals(ViewChangeListener.class)) {
            return new ViewChangeListenerProxy((com.intellij.openapi.graph.view.ViewChangeListener)iObject);
        }
        if (yClass.equals(Drawable.class)) {
            return new DrawableProxy((com.intellij.openapi.graph.view.Drawable)iObject);
        }
        if (yClass.equals(y.layout.Layouter.class)) {
            return new LayouterProxy((Layouter)iObject);
        }
        assert (false) : "Can't unwrap interface: " + yClass;
        throw new IllegalArgumentException("Can't unwrap interface: " + yClass);
    }

    private static Class unwrapClass(Class iClass) {
        return GraphManagerImpl.I2Y_CLASSES.get(iClass);
    }

    public static Object[] unwrap(Object[] iObjects) {
        Object[] result2 = new Object[iObjects.length];
        for (int i2 = 0; i2 < result2.length; ++i2) {
            result2[i2] = GraphBase.unwrap(iObjects[i2], null);
        }
        return result2;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof GraphBase)) {
            return false;
        }
        GraphBase base = (GraphBase)o2;
        return this._delegee.equals(base._delegee);
    }

    public int hashCode() {
        return this._delegee.hashCode();
    }

    static {
        YBundlesInitializer.init();
    }

    private static class ViewChangeListenerProxy
    implements PeerWrapper,
    ViewChangeListener {
        private final com.intellij.openapi.graph.view.ViewChangeListener myViewChangeListener;

        public ViewChangeListenerProxy(com.intellij.openapi.graph.view.ViewChangeListener viewChangeListener) {
            this.myViewChangeListener = viewChangeListener;
        }

        public Object _getPeer() {
            return this.myViewChangeListener;
        }

        @Override
        public void currentViewChanged(View view2) {
            this.myViewChangeListener.currentViewChanged((com.intellij.openapi.graph.view.View)GraphBase.wrap(view2, com.intellij.openapi.graph.view.View.class));
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            ViewChangeListenerProxy proxy = (ViewChangeListenerProxy)o2;
            return !(this.myViewChangeListener != null ? !this.myViewChangeListener.equals(proxy.myViewChangeListener) : proxy.myViewChangeListener != null);
        }

        public int hashCode() {
            return this.myViewChangeListener != null ? this.myViewChangeListener.hashCode() : 0;
        }
    }

    private static class Graph2DListenerProxy
    implements PeerWrapper,
    Graph2DListener {
        private final com.intellij.openapi.graph.view.Graph2DListener myGraph2DListener;

        public Graph2DListenerProxy(com.intellij.openapi.graph.view.Graph2DListener nodeCellEditor) {
            this.myGraph2DListener = nodeCellEditor;
        }

        @Override
        public void onGraph2DEvent(y.view.Graph2DEvent event) {
            this.myGraph2DListener.onGraph2DEvent((Graph2DEvent)GraphBase.wrap(event, Graph2DSelectionEvent.class));
        }

        public Object _getPeer() {
            return this.myGraph2DListener;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            Graph2DSelectionListenerProxy that = (Graph2DSelectionListenerProxy)o2;
            return this.myGraph2DListener.equals(that.mySelectionListener);
        }

        public int hashCode() {
            return this.myGraph2DListener.hashCode();
        }
    }

    private static class GraphListenerProxy
    implements PeerWrapper,
    GraphListener {
        private final com.intellij.openapi.graph.base.GraphListener myListener;

        public GraphListenerProxy(com.intellij.openapi.graph.base.GraphListener listener2) {
            this.myListener = listener2;
        }

        public Object _getPeer() {
            return this.myListener;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            Graph2DSelectionListenerProxy that = (Graph2DSelectionListenerProxy)o2;
            return this.myListener.equals(that.mySelectionListener);
        }

        public int hashCode() {
            return this.myListener.hashCode();
        }

        @Override
        public void onGraphEvent(y.base.GraphEvent event) {
            this.myListener.onGraphEvent((GraphEvent)GraphBase.wrap(event, GraphEvent.class));
        }
    }

    private static class LayouterProxy
    implements PeerWrapper,
    y.layout.Layouter {
        private final Layouter myLayouter;

        public LayouterProxy(Layouter layouter) {
            this.myLayouter = layouter;
        }

        @Override
        public boolean canLayout(LayoutGraph layoutGraph) {
            return this.myLayouter.canLayout((com.intellij.openapi.graph.layout.LayoutGraph)GraphBase.wrap(layoutGraph, LayoutGraph.class));
        }

        @Override
        public void doLayout(LayoutGraph layoutGraph) {
            this.myLayouter.doLayout((com.intellij.openapi.graph.layout.LayoutGraph)GraphBase.wrap(layoutGraph, LayoutGraph.class));
        }

        public Object _getPeer() {
            return null;
        }
    }

    private static class DrawableProxy
    implements PeerWrapper,
    Drawable {
        private final com.intellij.openapi.graph.view.Drawable myDrawable;

        public DrawableProxy(com.intellij.openapi.graph.view.Drawable drawable) {
            this.myDrawable = drawable;
        }

        public Object _getPeer() {
            return this.myDrawable;
        }

        @Override
        public void paint(Graphics2D graphics2D) {
            this.myDrawable.paint(graphics2D);
        }

        @Override
        public Rectangle getBounds() {
            return this.myDrawable.getBounds();
        }
    }

    private static class Graph2DSelectionListenerProxy
    implements PeerWrapper,
    y.view.Graph2DSelectionListener {
        private final Graph2DSelectionListener mySelectionListener;

        public Graph2DSelectionListenerProxy(Graph2DSelectionListener nodeCellEditor) {
            this.mySelectionListener = nodeCellEditor;
        }

        public Object _getPeer() {
            return this.mySelectionListener;
        }

        @Override
        public void onGraph2DSelectionEvent(y.view.Graph2DSelectionEvent graph2DSelectionEvent) {
            this.mySelectionListener.onGraph2DSelectionEvent((Graph2DSelectionEvent)GraphBase.wrap(graph2DSelectionEvent, Graph2DSelectionEvent.class));
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            Graph2DSelectionListenerProxy that = (Graph2DSelectionListenerProxy)o2;
            return this.mySelectionListener.equals(that.mySelectionListener);
        }

        public int hashCode() {
            return this.mySelectionListener.hashCode();
        }
    }

    private static class NodeCellEditorProxy
    implements PeerWrapper,
    NodeCellEditor {
        private final com.intellij.openapi.graph.view.NodeCellEditor myNodeCellEditor;

        public NodeCellEditorProxy(com.intellij.openapi.graph.view.NodeCellEditor nodeCellEditor) {
            this.myNodeCellEditor = nodeCellEditor;
        }

        public Object _getPeer() {
            return this.myNodeCellEditor;
        }

        @Override
        public JComponent getNodeCellEditorComponent(y.view.Graph2DView graph2DView, NodeRealizer nodeRealizer, Object object, boolean b2) {
            return this.myNodeCellEditor.getNodeCellEditorComponent((Graph2DView)GraphBase.wrap(graph2DView, Graph2DView.class), (com.intellij.openapi.graph.view.NodeRealizer)GraphBase.wrap(nodeRealizer, com.intellij.openapi.graph.view.NodeRealizer.class), GraphBase.wrap(object, Object.class), b2);
        }

        @Override
        @Nullable
        public Object getCellEditorValue() {
            return GraphBase.unwrap(this.myNodeCellEditor.getCellEditorValue(), Object.class);
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return this.myNodeCellEditor.isCellEditable(anEvent);
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return this.myNodeCellEditor.shouldSelectCell(anEvent);
        }

        @Override
        public boolean stopCellEditing() {
            return this.myNodeCellEditor.stopCellEditing();
        }

        @Override
        public void cancelCellEditing() {
            this.myNodeCellEditor.cancelCellEditing();
        }

        @Override
        public void addCellEditorListener(CellEditorListener l2) {
            this.myNodeCellEditor.addCellEditorListener(l2);
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l2) {
            this.myNodeCellEditor.removeCellEditorListener(l2);
        }
    }

    private static class NodeCellRendererProxy
    implements PeerWrapper,
    y.view.NodeCellRenderer {
        private final NodeCellRenderer myNodeCellEditor;

        public NodeCellRendererProxy(NodeCellRenderer nodeCellEditor) {
            this.myNodeCellEditor = nodeCellEditor;
        }

        public Object _getPeer() {
            return this.myNodeCellEditor;
        }

        @Override
        public JComponent getNodeCellRendererComponent(y.view.Graph2DView graph2DView, NodeRealizer nodeRealizer, Object object, boolean b2) {
            return this.myNodeCellEditor.getNodeCellRendererComponent((Graph2DView)GraphBase.wrap(graph2DView, Graph2DView.class), (com.intellij.openapi.graph.view.NodeRealizer)GraphBase.wrap(nodeRealizer, com.intellij.openapi.graph.view.NodeRealizer.class), GraphBase.wrap(object, Object.class), b2);
        }
    }

    private static class DataProviderProxy
    implements PeerWrapper,
    y.base.DataProvider {
        @NotNull
        private final DataProvider myDataProvider;

        public DataProviderProxy(@NotNull DataProvider dataProvider) {
            if (dataProvider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataProvider", "com/intellij/openapi/graph/impl/GraphBase$DataProviderProxy", "<init>"));
            }
            this.myDataProvider = dataProvider;
        }

        public Object _getPeer() {
            return this.myDataProvider;
        }

        @Override
        @Nullable
        public Object get(Object object) {
            return GraphBase.unwrap(this.myDataProvider.get(GraphBase.wrap(object, Object.class)), Object.class);
        }

        @Override
        public int getInt(Object object) {
            return this.myDataProvider.getInt(GraphBase.wrap(object, Object.class));
        }

        @Override
        public double getDouble(Object object) {
            return this.myDataProvider.getDouble(GraphBase.wrap(object, Object.class));
        }

        @Override
        public boolean getBool(Object object) {
            return this.myDataProvider.getBool(GraphBase.wrap(object, Object.class));
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            DataProviderProxy that = (DataProviderProxy)o2;
            return !(this.myDataProvider != null ? !this.myDataProvider.equals(that.myDataProvider) : that.myDataProvider != null);
        }

        public int hashCode() {
            return this.myDataProvider != null ? this.myDataProvider.hashCode() : 0;
        }
    }

    private static class WrappingMap
    implements Map {
        private final Map myDelegee;

        public WrappingMap(Map m2) {
            this.myDelegee = m2;
        }

        @Override
        public int size() {
            return this.myDelegee.size();
        }

        @Override
        public boolean isEmpty() {
            return this.myDelegee.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.myDelegee.containsKey(GraphBase.unwrap(key, null));
        }

        @Override
        public boolean containsValue(Object value2) {
            return this.myDelegee.containsValue(GraphBase.unwrap(value2, null));
        }

        @Nullable
        public Object get(Object key) {
            return GraphBase.wrap(this.myDelegee.get(GraphBase.unwrap(key, null)), Object.class);
        }

        @Nullable
        public Object put(Object key, Object value2) {
            return GraphBase.wrap(this.myDelegee.put(GraphBase.unwrap(key, null), GraphBase.unwrap(value2, null)), Object.class);
        }

        @Nullable
        public Object remove(Object key) {
            return GraphBase.wrap(this.myDelegee.remove(GraphBase.unwrap(key, null)), Object.class);
        }

        public void putAll(Map t2) {
            throw new UnsupportedOperationException("putAll is not implemented in : " + this.getClass());
        }

        @Override
        public void clear() {
            this.myDelegee.clear();
        }

        public Set keySet() {
            throw new UnsupportedOperationException("keySet is not implemented in : " + this.getClass());
        }

        public Collection values() {
            throw new UnsupportedOperationException("values is not implemented in : " + this.getClass());
        }

        public Set entrySet() {
            throw new UnsupportedOperationException("entrySet is not implemented in : " + this.getClass());
        }
    }
}

