/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.impl.builder;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.GraphPresentationModel;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.PopupMode;
import javax.swing.JPopupMenu;

public abstract class BasicPopupMode
extends PopupMode {
    private Graph2DView myView;
    private GraphPresentationModel myPresentationModel;

    public BasicPopupMode(Graph2DView view2) {
        this(view2, null);
    }

    public BasicPopupMode(Graph2DView view2, GraphPresentationModel presentationModel) {
        this.myView = view2;
        this.myPresentationModel = presentationModel;
    }

    public JPopupMenu getNodePopup(Node node) {
        return BasicPopupMode.createJPopup(this.getNodeActions(node), this.getActionPlace());
    }

    private String getActionPlace() {
        return this.myPresentationModel != null ? this.myPresentationModel.getActionPlace() : "unknown";
    }

    protected abstract DefaultActionGroup getNodeActions(Node var1);

    protected abstract DefaultActionGroup getEdgeActions(Edge var1);

    protected abstract DefaultActionGroup getPaperPopupActions();

    public JPopupMenu getEdgePopup(Edge edge) {
        return BasicPopupMode.createJPopup(this.getEdgeActions(edge), this.getActionPlace());
    }

    public JPopupMenu getPaperPopup(double x2, double y2) {
        return BasicPopupMode.createJPopup(this.getPaperPopupActions(), this.getActionPlace());
    }

    public JPopupMenu getSelectionPopup(double x2, double y2) {
        return this.getPaperPopup(x2, y2);
    }

    private static JPopupMenu createJPopup(DefaultActionGroup actionGroup, String place) {
        JPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu(place, (ActionGroup)actionGroup).getComponent();
        popupMenu.add(new JPopupMenu.Separator());
        return popupMenu;
    }
}

