/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.impl.builder;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.ui.update.ComparableObject;
import com.intellij.util.ui.update.ComparableObjectCheck;
import org.jetbrains.annotations.NotNull;

abstract class ComparableGraphObject
implements ComparableObject {
    private final String myName;
    private final Object[] myEqualityObjects;

    public ComparableGraphObject(@NotNull String name, Object ... equalityObjects) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/graph/impl/builder/ComparableGraphObject", "<init>"));
        }
        this.myEqualityObjects = equalityObjects;
        this.myName = name;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        ComparableGraphObject that = (ComparableGraphObject)o2;
        return Comparing.equal((String)this.myName, (String)that.myName) && (this.myEqualityObjects.length == 0 ? that.myEqualityObjects.length == 0 : ComparableObjectCheck.equals((ComparableObject)this, (Object)that));
    }

    public int hashCode() {
        int result2 = this.myName.hashCode() + super.hashCode() * 239;
        result2 = 31 * result2 + (this.myEqualityObjects.length > 0 ? ComparableObjectCheck.hashCode((ComparableObject)this, (int)this.myName.hashCode()) : 0);
        return result2;
    }

    @NotNull
    public Object[] getEqualityObjects() {
        if (this.myEqualityObjects == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/graph/impl/builder/ComparableGraphObject", "getEqualityObjects"));
        }
        return this.myEqualityObjects;
    }
}

