/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.impl.builder;

import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.EdgeCreationPolicy;
import com.intellij.openapi.graph.impl.builder.GraphBuilderImpl;
import com.intellij.openapi.graph.view.CreateEdgeMode;
import com.intellij.openapi.graph.view.EdgeRealizer;
import com.intellij.openapi.graph.view.Graph2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class EdgeCreationPolicyAdapter<N, E>
extends CreateEdgeMode {
    @Nullable
    private final EdgeCreationPolicy<N> myPolicy;
    @NotNull
    private final GraphBuilderImpl<N, E> myBuilder;

    EdgeCreationPolicyAdapter(EdgeCreationPolicy<N> policy, @NotNull GraphBuilderImpl<N, E> builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/openapi/graph/impl/builder/EdgeCreationPolicyAdapter", "<init>"));
        }
        this.myPolicy = policy;
        this.myBuilder = builder;
    }

    @Nullable
    public Edge createEdge(Graph2D graph2D, Node from, Node to, EdgeRealizer edgeRealizer) {
        N n1 = this.myBuilder.getNodeObject(from);
        N n2 = this.myBuilder.getNodeObject(to);
        if (n1 != null && n2 != null) {
            try {
                this.myBuilder.getGraphDataModel().createEdge(n1, n2);
            }
            catch (Exception e2) {
                GraphBuilderImpl.LOG.error((Throwable)e2);
            }
        }
        return null;
    }

    public boolean acceptSourceNode(Node source, double x2, double y2) {
        if (this.myPolicy == null) {
            return true;
        }
        N n2 = this.myBuilder.getNodeObject(source);
        return n2 != null && this.myPolicy.acceptSource(n2);
    }

    public void targetNodeDeclined(Node target, double x2, double y2) {
    }

    public boolean acceptTargetNode(Node target, double x2, double y2) {
        if (this.myPolicy == null) {
            return true;
        }
        N n2 = this.myBuilder.getNodeObject(target);
        return n2 != null && this.myPolicy.acceptTarget(n2);
    }

    public void sourceNodeDeclined(Node target, double x2, double y2) {
        this.cancelEdgeCreation();
    }
}

